/// Header for the class
#include <PhysLiteToOpenData/PhysLiteToOpenData.h>

/// Initialize all our truth branches and variables (called in initialize)
void PhysLiteToOpenData::initTruthInfo(TTree * mytree){

  // Global truth variables: Truth MET
  m_truth_met = 0.;
  m_truth_met_phi = 0.;

  // Truth variables (see header for details)
  m_truth_jet_n = 0;
  m_truthJet_pt = new std::vector<float>();
  m_truthJet_eta = new std::vector<float>();
  m_truthJet_phi = new std::vector<float>();
  m_truthJet_m = new std::vector<float>();
  m_truth_elec_n = 0;
  m_truthElec_pt = new std::vector<float>();
  m_truthElec_eta = new std::vector<float>();
  m_truthElec_phi = new std::vector<float>();
  m_truth_muon_n = 0;
  m_truthMuon_pt = new std::vector<float>();
  m_truthMuon_eta = new std::vector<float>();
  m_truthMuon_phi = new std::vector<float>();
  m_truth_tau_n = 0;
  m_truthTau_pt = new std::vector<float>();
  m_truthTau_eta = new std::vector<float>();
  m_truthTau_phi = new std::vector<float>();
  m_truth_photon_n = 0;
  m_truthPhot_pt = new std::vector<float>();
  m_truthPhot_eta = new std::vector<float>();
  m_truthPhot_phi = new std::vector<float>();

  mytree->Branch("truth_jet_n",&m_truth_jet_n);
  mytree->Branch("truth_jet_pt",&m_truthJet_pt);
  mytree->Branch("truth_jet_eta",&m_truthJet_eta);
  mytree->Branch("truth_jet_phi",&m_truthJet_phi);
  mytree->Branch("truth_jet_m",&m_truthJet_m);
  mytree->Branch("truth_elec_n",&m_truth_elec_n);
  mytree->Branch("truth_elec_pt",&m_truthElec_pt);
  mytree->Branch("truth_elec_eta",&m_truthElec_eta);
  mytree->Branch("truth_elec_phi",&m_truthElec_phi);
  mytree->Branch("truth_muon_n",&m_truth_muon_n);
  mytree->Branch("truth_muon_pt",&m_truthMuon_pt);
  mytree->Branch("truth_muon_eta",&m_truthMuon_eta);
  mytree->Branch("truth_muon_phi",&m_truthMuon_phi);
  mytree->Branch("truth_tau_n",&m_truth_tau_n);
  mytree->Branch("truth_tau_pt",&m_truthTau_pt);
  mytree->Branch("truth_tau_eta",&m_truthTau_eta);
  mytree->Branch("truth_tau_phi",&m_truthTau_phi);
  mytree->Branch("truth_photon_n",&m_truth_photon_n);
  mytree->Branch("truth_photon_pt",&m_truthPhot_pt);
  mytree->Branch("truth_photon_eta",&m_truthPhot_eta);
  mytree->Branch("truth_photon_phi",&m_truthPhot_phi);
  mytree->Branch("truth_met",&m_truth_met);
  mytree->Branch("truth_met_phi",&m_truth_met_phi);

}

/// Reset all branch variables for truth objects (called in execute)
void PhysLiteToOpenData::resetTruthInfo(){

  m_truth_met = 0.;
  m_truth_met_phi = 0.;

  m_truth_jet_n = 0;
  m_truthJet_pt->clear();
  m_truthJet_eta->clear();
  m_truthJet_phi->clear();
  m_truthJet_m->clear();
  m_truth_elec_n = 0;
  m_truthElec_pt->clear();
  m_truthElec_eta->clear();
  m_truthElec_phi->clear();
  m_truth_muon_n = 0;
  m_truthMuon_pt->clear();
  m_truthMuon_eta->clear();
  m_truthMuon_phi->clear();
  m_truth_tau_n = 0;
  m_truthTau_pt->clear();
  m_truthTau_eta->clear();
  m_truthTau_phi->clear();
  m_truth_photon_n = 0;
  m_truthPhot_pt->clear();
  m_truthPhot_eta->clear();
  m_truthPhot_phi->clear();

}

/// Fill event information into photon variables and branches (called in execute)
StatusCode PhysLiteToOpenData::fillTruthInfo(){

  // Save truth electrons
  for (const xAOD::TruthParticle* e : *m_event->truthElec ) {
    if (e->pt()<10000.) continue; // Don't bother with truth electrons below 10 GeV of pT
    m_truthElec_pt->push_back(e->pt()*0.001); // Convert to GeV
    m_truthElec_eta->push_back(e->eta());
    m_truthElec_phi->push_back(e->phi());
    m_truth_elec_n++;
  }

  // Save truth muons
  for (const xAOD::TruthParticle* m : *m_event->truthMuon ) {
    if (m->pt()<10000.) continue; // Don't bother with truth muons below 10 GeV of pT
    m_truthMuon_pt->push_back(m->pt()*0.001); // Convert to GeV
    m_truthMuon_eta->push_back(m->eta());
    m_truthMuon_phi->push_back(m->phi());
    m_truth_muon_n++;
  }

  // Save truth taus
  for (const xAOD::TruthParticle* t : *m_event->truthTaus ) {
    if (t->pt()<10000.) continue; // Don't bother with truth taus below 10 GeV of pT
    m_truthTau_pt->push_back(t->pt()*0.001); // Convert to GeV
    m_truthTau_eta->push_back(t->eta());
    m_truthTau_phi->push_back(t->phi());
    m_truth_tau_n++;
  }

  // Save truth photons
  for (const xAOD::TruthParticle* y : *m_event->truthPhot ) {
    if (y->pt()<10000.) continue; // Don't bother with truth photons below 10 GeV of pT
    m_truthPhot_pt->push_back(y->pt()*0.001); // Convert to GeV
    m_truthPhot_eta->push_back(y->eta());
    m_truthPhot_phi->push_back(y->phi());
    m_truth_photon_n++;
  }

  // Save truth jets
  for (const xAOD::Jet* j : *m_event->truthJets ) {
    if (j->pt()<20000.) continue; // Don't bother with truth photons below 10 GeV of pT
    m_truthJet_pt->push_back(j->pt()*0.001); // Convert to GeV
    m_truthJet_eta->push_back(j->eta());
    m_truthJet_phi->push_back(j->phi());
    m_truthJet_m->push_back(j->m()*0.001); // Convert to GeV
    m_truth_jet_n++;
  }

  // Get the truth MET and store the scalar and phi direction - Convert to GeV as we go
  const xAOD::MissingET* met = (*m_event->truthMET)["NonInt"];
  m_truth_met = met->met()*0.001;
  m_truth_met_phi = met->phi();

  return StatusCode::SUCCESS;
}

/// Cleanup function - delete all our vector branches (called in destructor)
void PhysLiteToOpenData::cleanupTruthInfo(){

  delete m_truthJet_pt;
  delete m_truthJet_eta;
  delete m_truthJet_phi;
  delete m_truthJet_m;
  delete m_truthElec_pt;
  delete m_truthElec_eta;
  delete m_truthElec_phi;
  delete m_truthMuon_pt;
  delete m_truthMuon_eta;
  delete m_truthMuon_phi;
  delete m_truthTau_pt;
  delete m_truthTau_eta;
  delete m_truthTau_phi;
  delete m_truthPhot_pt;
  delete m_truthPhot_eta;
  delete m_truthPhot_phi;

}
