# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add names to datastream linking

Revision ID: 0ab9f982e07c
Revises: 87b366f51740
Create Date: 2023-03-10 10:51:39.671139

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "0ab9f982e07c"
down_revision = "87b366f51740"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("datastream_link", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("datasource_name", sa.String(length=256), nullable=True)
        )
        batch_op.add_column(
            sa.Column("thing_name", sa.String(length=256), nullable=True)
        )
        batch_op.add_column(
            sa.Column("datastream_name", sa.String(length=256), nullable=True)
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("datastream_link", schema=None) as batch_op:
        batch_op.drop_column("datastream_name")
        batch_op.drop_column("thing_name")
        batch_op.drop_column("datasource_name")
    # ### end Alembic commands ###
