# SPDX-FileCopyrightText: 2024
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add field to save if a user is part of the export control.

Revision ID: 57a2cf393a6b
Revises: 0a0a316932e7
Create Date: 2024-03-04 12:58:36.206584

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "57a2cf393a6b"
down_revision = "0a0a316932e7"
branch_labels = None
depends_on = None


def upgrade():
    """Run the database structure changes."""
    with op.batch_alter_table("user", schema=None) as batch_op:
        batch_op.add_column(sa.Column("is_export_control", sa.Boolean(), nullable=True))

    conn = op.get_bind()
    conn.execute(
        'update "user" set is_export_control = false where is_export_control is null'
    )


def downgrade():
    """Undo the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("user", schema=None) as batch_op:
        batch_op.drop_column("is_export_control")
    # ### end Alembic commands ###
