# SPDX-FileCopyrightText: 2024
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add labels to the mount actions.

Revision ID: 609c600e4c0f
Revises: f23da62d05a9
Create Date: 2024-06-25 06:50:08.868312

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "609c600e4c0f"
down_revision = "7a49c09c83e3"
branch_labels = None
depends_on = None


def upgrade():
    """Apply the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("device_mount_action", schema=None) as batch_op:
        batch_op.add_column(sa.Column("label", sa.String(length=256), nullable=True))

    with op.batch_alter_table("platform_mount_action", schema=None) as batch_op:
        batch_op.add_column(sa.Column("label", sa.String(length=256), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    """Undo the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("platform_mount_action", schema=None) as batch_op:
        batch_op.drop_column("label")

    with op.batch_alter_table("device_mount_action", schema=None) as batch_op:
        batch_op.drop_column("label")
    # ### end Alembic commands ###
