# SPDX-FileCopyrightText: 2022
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""empty message

Revision ID: 6ecf48d843a6
Revises: 9ca7661afcfc
Create Date: 2022-10-28 07:39:29.660873

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "6ecf48d843a6"
down_revision = "9ca7661afcfc"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "site", sa.Column("created_at", sa.DateTime(timezone=True), nullable=True)
    )
    op.add_column(
        "site", sa.Column("updated_at", sa.DateTime(timezone=True), nullable=True)
    )
    op.add_column("site", sa.Column("archived", sa.Boolean(), nullable=True))
    op.add_column("site", sa.Column("description", sa.Text(), nullable=True))
    op.add_column("site", sa.Column("epsg_code", sa.String(length=256), nullable=True))
    op.add_column("site", sa.Column("is_internal", sa.Boolean(), nullable=True))
    op.add_column("site", sa.Column("is_public", sa.Boolean(), nullable=True))
    op.add_column("site", sa.Column("group_ids", sa.ARRAY(sa.String()), nullable=True))
    op.add_column("site", sa.Column("street", sa.String(length=256), nullable=True))
    op.add_column(
        "site", sa.Column("street_number", sa.String(length=256), nullable=True)
    )
    op.add_column("site", sa.Column("city", sa.String(length=256), nullable=True))
    op.add_column("site", sa.Column("zip_code", sa.String(length=256), nullable=True))
    op.add_column("site", sa.Column("country", sa.String(length=256), nullable=True))
    op.add_column("site", sa.Column("building", sa.String(length=256), nullable=True))
    op.add_column("site", sa.Column("room", sa.String(length=256), nullable=True))
    op.add_column("site", sa.Column("created_by_id", sa.Integer(), nullable=True))
    op.add_column("site", sa.Column("updated_by_id", sa.Integer(), nullable=True))
    op.add_column(
        "site", sa.Column("update_description", sa.String(length=256), nullable=True)
    )
    op.create_foreign_key(
        "fk_Site_created_by_id",
        "site",
        "user",
        ["created_by_id"],
        ["id"],
        use_alter=True,
    )
    op.create_foreign_key(
        "fk_Site_updated_by_id",
        "site",
        "user",
        ["updated_by_id"],
        ["id"],
        use_alter=True,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("fk_Site_updated_by_id", "site", type_="foreignkey")
    op.drop_constraint("fk_Site_created_by_id", "site", type_="foreignkey")
    op.drop_column("site", "updated_by_id")
    op.drop_column("site", "created_by_id")
    op.drop_column("site", "update_description")
    op.drop_column("site", "room")
    op.drop_column("site", "building")
    op.drop_column("site", "country")
    op.drop_column("site", "zip_code")
    op.drop_column("site", "city")
    op.drop_column("site", "street_number")
    op.drop_column("site", "street")
    op.drop_column("site", "group_ids")
    op.drop_column("site", "is_public")
    op.drop_column("site", "is_internal")
    op.drop_column("site", "epsg_code")
    op.drop_column("site", "description")
    op.drop_column("site", "archived")
    op.drop_column("site", "updated_at")
    op.drop_column("site", "created_at")
    # ### end Alembic commands ###
