# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add persistent identifier field to configurations.

Revision ID: 968d0a1e0f0f
Revises: b4d5bc6eab86
Create Date: 2023-04-06 07:34:33.416616

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "968d0a1e0f0f"
down_revision = "b4d5bc6eab86"
branch_labels = None
depends_on = None


def upgrade():
    """Do the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("configuration", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("persistent_identifier", sa.String(length=256), nullable=True)
        )
        batch_op.create_unique_constraint(None, ["persistent_identifier"])
    # ### end Alembic commands ###


def downgrade():
    """Undo the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("configuration", schema=None) as batch_op:
        batch_op.drop_constraint(None, type_="unique")
        batch_op.drop_column("persistent_identifier")
    # ### end Alembic commands ###
