# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add description and project fields to configuration.

Revision ID: b4d5bc6eab86
Revises: aa0dc5b7060d
Create Date: 2023-04-05 13:06:09.013697

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "b4d5bc6eab86"
down_revision = "aa0dc5b7060d"
branch_labels = None
depends_on = None


def upgrade():
    """Do the structure changes on the db."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("configuration", schema=None) as batch_op:
        batch_op.add_column(sa.Column("project", sa.String(length=256), nullable=True))
        batch_op.add_column(sa.Column("description", sa.Text(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    """Undo the structure changes on the db."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("configuration", schema=None) as batch_op:
        batch_op.drop_column("description")
        batch_op.drop_column("project")
    # ### end Alembic commands ###
