# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2
"""Add tsm_endpoint table.

Revision ID: b720c8572051
Revises: 0410c9cbc6cf
Create Date: 2023-05-04 11:56:50.132066

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "b720c8572051"
down_revision = "5505aacc0cea"
branch_labels = None
depends_on = None


def upgrade():
    """Run the commands to do the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "tsm_endpoint",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("name", sa.String(length=256), nullable=False),
        sa.Column("url", sa.String(length=256), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("datastream_link", schema=None) as batch_op:
        batch_op.add_column(sa.Column("tsm_endpoint_id", sa.Integer(), nullable=True))
        batch_op.create_foreign_key(None, "tsm_endpoint", ["tsm_endpoint_id"], ["id"])
        batch_op.create_foreign_key(
            "fk_DatastreamLink_created_by_id",
            "user",
            ["created_by_id"],
            ["id"],
            use_alter=True,
        )
        batch_op.create_foreign_key(
            "fk_DatastreamLink_updated_by_id",
            "user",
            ["updated_by_id"],
            ["id"],
            use_alter=True,
        )
        batch_op.drop_column("tsm_endpoint")
    # ### end Alembic commands ###


def downgrade():
    """Undo the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("datastream_link", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "tsm_endpoint",
                sa.VARCHAR(length=256),
                autoincrement=False,
                nullable=True,
            )
        )
        batch_op.drop_constraint("fk_DatastreamLink_updated_by_id", type_="foreignkey")
        batch_op.drop_constraint("fk_DatastreamLink_created_by_id", type_="foreignkey")
        batch_op.drop_constraint(None, type_="foreignkey")
        batch_op.drop_column("tsm_endpoint_id")

    op.drop_table("tsm_endpoint")
    # ### end Alembic commands ###
