# SPDX-FileCopyrightText: 2024
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add the option to set absolute coordinates for the mounts.

Revision ID: bf0c63bffe19
Revises: eedd99942a24
Create Date: 2024-02-05 10:21:28.898725

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "bf0c63bffe19"
down_revision = "eedd99942a24"
branch_labels = None
depends_on = None


def upgrade():
    """Run the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("device_mount_action", schema=None) as batch_op:
        batch_op.add_column(sa.Column("x", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("y", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("z", sa.Float(), nullable=True))
        batch_op.add_column(
            sa.Column("epsg_code", sa.String(length=256), nullable=True)
        )
        batch_op.add_column(
            sa.Column("elevation_datum_name", sa.String(length=256), nullable=True)
        )
        batch_op.add_column(
            sa.Column("elevation_datum_uri", sa.String(length=256), nullable=True)
        )

    with op.batch_alter_table("platform_mount_action", schema=None) as batch_op:
        batch_op.add_column(sa.Column("x", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("y", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("z", sa.Float(), nullable=True))
        batch_op.add_column(
            sa.Column("epsg_code", sa.String(length=256), nullable=True)
        )
        batch_op.add_column(
            sa.Column("elevation_datum_name", sa.String(length=256), nullable=True)
        )
        batch_op.add_column(
            sa.Column("elevation_datum_uri", sa.String(length=256), nullable=True)
        )
    # ### end Alembic commands ###


def downgrade():
    """Undo the structure changes on the database."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("platform_mount_action", schema=None) as batch_op:
        batch_op.drop_column("elevation_datum_uri")
        batch_op.drop_column("elevation_datum_name")
        batch_op.drop_column("epsg_code")
        batch_op.drop_column("z")
        batch_op.drop_column("y")
        batch_op.drop_column("x")

    with op.batch_alter_table("device_mount_action", schema=None) as batch_op:
        batch_op.drop_column("elevation_datum_uri")
        batch_op.drop_column("elevation_datum_name")
        batch_op.drop_column("epsg_code")
        batch_op.drop_column("z")
        batch_op.drop_column("y")
        batch_op.drop_column("x")

    # ### end Alembic commands ###
