# SPDX-FileCopyrightText: 2022
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""empty message

Revision ID: e1cac965237f
Revises: db0151dc70c3
Create Date: 2022-09-06 14:11:44.664983

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "e1cac965237f"
down_revision = "55af0d7cff03"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("configuration", sa.Column("archived", sa.Boolean(), nullable=True))
    op.add_column("device", sa.Column("archived", sa.Boolean(), nullable=True))
    op.add_column("platform", sa.Column("archived", sa.Boolean(), nullable=True))
    conn = op.get_bind()
    for table in ["configuration", "device", "platform"]:
        update = sa.text(f"update {table} set archived=false where archived is null")
        conn.execute(update)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("platform", "archived")
    op.drop_column("device", "archived")
    op.drop_column("configuration", "archived")
    # ### end Alembic commands ###
