# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add audit fields to attachment models

Revision ID: f2dd1caad2bd
Revises: 08268f612083
Create Date: 2023-03-14 07:35:20.525165

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "f2dd1caad2bd"
down_revision = "1a5dc65c2896"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("configuration_attachment", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("created_at", sa.DateTime(timezone=True), nullable=True)
        )
        batch_op.add_column(
            sa.Column("updated_at", sa.DateTime(timezone=True), nullable=True)
        )
        batch_op.add_column(sa.Column("created_by_id", sa.Integer(), nullable=True))
        batch_op.add_column(sa.Column("updated_by_id", sa.Integer(), nullable=True))
        batch_op.create_foreign_key(
            "fk_ConfigurationAttachment_created_by_id",
            "user",
            ["created_by_id"],
            ["id"],
            use_alter=True,
        )
        batch_op.create_foreign_key(
            "fk_ConfigurationAttachment_updated_by_id",
            "user",
            ["updated_by_id"],
            ["id"],
            use_alter=True,
        )

    with op.batch_alter_table("device_attachment", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("created_at", sa.DateTime(timezone=True), nullable=True)
        )
        batch_op.add_column(
            sa.Column("updated_at", sa.DateTime(timezone=True), nullable=True)
        )
        batch_op.add_column(sa.Column("created_by_id", sa.Integer(), nullable=True))
        batch_op.add_column(sa.Column("updated_by_id", sa.Integer(), nullable=True))
        batch_op.create_foreign_key(
            "fk_DeviceAttachment_updated_by_id",
            "user",
            ["updated_by_id"],
            ["id"],
            use_alter=True,
        )
        batch_op.create_foreign_key(
            "fk_DeviceAttachment_created_by_id",
            "user",
            ["created_by_id"],
            ["id"],
            use_alter=True,
        )

    with op.batch_alter_table("platform_attachment", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("created_at", sa.DateTime(timezone=True), nullable=True)
        )
        batch_op.add_column(
            sa.Column("updated_at", sa.DateTime(timezone=True), nullable=True)
        )
        batch_op.add_column(sa.Column("created_by_id", sa.Integer(), nullable=True))
        batch_op.add_column(sa.Column("updated_by_id", sa.Integer(), nullable=True))
        batch_op.create_foreign_key(
            "fk_PlatformAttachment_created_by_id",
            "user",
            ["created_by_id"],
            ["id"],
            use_alter=True,
        )
        batch_op.create_foreign_key(
            "fk_PlatformAttachment_updated_by_id",
            "user",
            ["updated_by_id"],
            ["id"],
            use_alter=True,
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("platform_attachment", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_PlatformAttachment_updated_by_id", type_="foreignkey"
        )
        batch_op.drop_constraint(
            "fk_PlatformAttachment_created_by_id", type_="foreignkey"
        )
        batch_op.drop_column("updated_by_id")
        batch_op.drop_column("created_by_id")
        batch_op.drop_column("updated_at")
        batch_op.drop_column("created_at")

    with op.batch_alter_table("device_attachment", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_DeviceAttachment_created_by_id", type_="foreignkey"
        )
        batch_op.drop_constraint(
            "fk_DeviceAttachment_updated_by_id", type_="foreignkey"
        )
        batch_op.drop_column("updated_by_id")
        batch_op.drop_column("created_by_id")
        batch_op.drop_column("updated_at")
        batch_op.drop_column("created_at")

    with op.batch_alter_table("configuration_attachment", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_ConfigurationAttachment_updated_by_id", type_="foreignkey"
        )
        batch_op.drop_constraint(
            "fk_ConfigurationAttachment_created_by_id", type_="foreignkey"
        )
        batch_op.drop_column("updated_by_id")
        batch_op.drop_column("created_by_id")
        batch_op.drop_column("updated_at")
        batch_op.drop_column("created_at")
    # ### end Alembic commands ###
