<!--
SPDX-FileCopyrightText: 2024
- Tobias Kuhnert <tobias.kuhnert@ufz.de>
- Helmholtz Centre for Environmental Research GmbH - UFZ (UFZ, https://www.ufz.de)

SPDX-License-Identifier: EUPL-1.2
-->
# Overview of the SMS Frontend Environment Variables
## Environment Variables Definition and Usage
- All environment variables are defined in `frontend/nuxt.config.js`
- any new environment variable should be added there as a constant with the actual access to that environment variable using `process.env.<NEW_ENV_VAR>` and a palceholder value using the `_ENV_PLACEHOLDER` suffix if that env is empty or null `NEW_ENV_VAR_ENV_PLACEHOLDER`
  - e.g. `const NEW_ENV_VAR =  process.env.<NEW_ENV_VAR> || 'NEW_ENV_VAR_ENV_PLACEHOLDER'`
  - the `process.env.<NEW_ENV_VAR>` part is used to access the environment variable during development
  - if no value is provided during build time the placeholder string assiged to the variable
  - that placeholder string gets replaced during runtime using the generic frontend image (`frontend/docker/generic-image/Dockerfile`) and it's entrypoint script (`frontend/docker/generic-image/entrypoint.sh`) 
- any new environment variable should be added to the `frontend` service in the `docker-compose.yml`
- any new environment variable should be added to the `entrypoint` script `frontend/docker/generic-image/entrypoint.sh`
- If an environment variable must be used in a vue component or other js/ts file, it must also be added to `env: {...` in `frontend/nuxt.config.js`
  - Afterwards in can be access in the component via `process.env.<key in env{...}>`
## List of SMS Frontend Environment Variables

| name                                | placeholder_name                                    | description                                                                                                                                                                                                                                                               |type                           |
|-------------------------------------|-----------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------|
| NUXT_ENV_OIDC_REFRESH_TOKEN         | NUXT_ENV_OIDC_REFRESH_TOKEN_ENV_PLACEHOLDER         | Used for OpenID Connect settings. Used to specify which field of the response JSON to be used for value. See https://auth.nuxtjs.org/schemes/refresh#refreshtoken “property"                                                                                              |string                         |
| NUXT_ENV_OIDC_REFRESH_EXPIRE        | NUXT_ENV_OIDC_REFRESH_EXPIRE_ENV_PLACEHOLDER        | Used for OpenID Connect settings. Used to  set the expiration time of the refresh token, in seconds. This time will be used if for some reason we couldn't decode the token to get the expiration date. See https://auth.nuxtjs.org/schemes/refresh#refreshtoken “maxAge" |number                         |
| NUXT_ENV_OIDC_RESPONSE_TYPE         | NUXT_ENV_OIDC_RESPONSE_TYPE_ENV_PLACEHOLDER         | Used for OpenID Connect settings. See https://auth.nuxtjs.org/schemes/openIDConnect#responsetype                                                                                                                                                                          |string                         |
| NUXT_ENV_OIDC_GRANT_TYPE            | NUXT_ENV_OIDC_GRANT_TYPE_ENV_PLACEHOLDER            | Used for OpenID Connect settings. See https://auth.nuxtjs.org/schemes/openIDConnect#granttype                                                                                                                                                                             |string                         |
| NUXT_ENV_CLIENT_ID                  | NUXT_ENV_CLIENT_ID_ENV_PLACEHOLDER                  | Used for OpenID Connect settings. OpenID Connect client id of your registered client at your identity provider. See https://auth.nuxtjs.org/schemes/openIDConnect#clientid                                                                                                |string                         |
| NUXT_ENV_SCOPE                      | NUXT_ENV_SCOPE_ENV_PLACEHOLDER                      | Used for OpenID Connect settings. Space separated list for  OpenID Connect access scopes. See https://auth.nuxtjs.org/schemes/openIDConnect#scope token                                                                                                                   |space separated list of strings|
| NUXT_ENV_OIDC_CHALLANGE             | NUXT_ENV_OIDC_CHALLANGE_ENV_PLACEHOLDER             | Used for OpenID Connect settings. See https://auth.nuxtjs.org/schemes/openIDConnect#codechallengemethod                                                                                                                                                                   |string                         |
| NUXT_ENV_OIDC_WELL_KNOWN            | NUXT_ENV_OIDC_WELL_KNOWN_ENV_PLACEHOLDER            | Used for OpenID Connect settings. Endpoint to request the provider's metadata document to automatically set the endpoints. See https://auth.nuxtjs.org/schemes/openIDConnect#endpoints “configuration”                                                                    |string                         |
| NUXT_ENV_OIDC_REFRESH_INTERVAL_TIME | NUXT_ENV_OIDC_REFRESH_INTERVAL_TIME_ENV_PLACEHOLDER | Time in milliseconds when to start the token refresh, defaults to 1800000 (half an hour)                                                                                                                                                                                  |number                         |
|                                     |                                                     |                                                                                                                                                                                                                                                                           |                               |
| BASE_URL                            | BASE_URL_ENV_PLACEHOLDER                            | Path under which the frontend and it’s assets will be accessed. Do not provide this env if  you want to access the frontend at root path e.g. https:fancy-sms.de. Otherwise set it without trailing slash, e.g. “/sms” results in https:my-fancy-institute.de/sms         |string                         |
| SMS_BACKEND_URL                     | SMS_BACKEND_URL_ENV_PLACEHOLDER                     | URL where the sms backend can be accessed and make request to.                                                                                                                                                                                                            |string                         |
| SMS_FRONTEND_URL                    | SMS_FRONTEND_URL_ENV_PLACEHOLDER                    | URL where the sms frontend can be accessed.                                                                                                                                                                                                                               |string                         |
| CV_BACKEND_URL                      | CV_BACKEND_URL_ENV_PLACEHOLDER                      | URL where the sms controlled vocabulary can be accessed and make request to.                                                                                                                                                                                              |string                         |
| IDL_SYNC_URL                        | IDL_SYNC_URL_ENV_PLACEHOLDER                        | URL where the institute decoupling layer service can be accessed and make request to. For more information see https://codebase.helmholtz.cloud/hub-terra/institute-decoupling-layer/idl-api                                                                              |string                         |
| INSTITUTE                           | INSTITUTE_ENV_PLACEHOLDER                           | Abbreviation of your institute. Used to display the different legal documents of the different institutes. Also used to sync the user groups for some institutes that use the gfz-idl service.                                                                            |string                         |
| NUXT_ENV_PID_BASE_URL               | NUXT_ENV_PID_BASE_URL_ENV_PLACEHOLDER               | URL where the persistent identifier service can be accessed and make request to.                                                                                                                                                                                          |string                         |
|                                     |                                                     |                                                                                                                                                                                                                                                                           |                               |
| NUXT_ENV_MATOMO_SITE_ID             | NUXT_ENV_MATOMO_SITE_ID_ENV_PLACEHOLDER             | Used for Matomo Settings. Website ID of the website registered in your matomo service. See https://nuxt.com/modules/matomo#siteid-required                                                                                                                                |                               |
| NUXT_ENV_MATOMO_URL                 | NUXT_ENV_MATOMO_URL_ENV_PLACEHOLDER                 | Used for Matomo Settings. Url of your matomo service. See https://nuxt.com/modules/matomo#matomourl                                                                                                                                                                       |string                         |
| NUXT_ENV_MATOMO_TRACKER_URL         | NUXT_ENV_MATOMO_TRACKER_URL_ENV_PLACEHOLDER         | Used for Matomo Settings. See https://nuxt.com/modules/matomo#trackerurl                                                                                                                                                                                                  |string                         |
| NUXT_ENV_MATOMO_SCRIPT_URL          | NUXT_ENV_MATOMO_SCRIPT_URL_ENV_PLACEHOLDER          | Used for Matomo Settings. See https://nuxt.com/modules/matomo#scripturl                                                                                                                                                                                                   |string                         |
|                                     |                                                     |                                                                                                                                                                                                                                                                           |                               |
| NUXT_ENV_ALLOWED_MIMETYPES          | NUXT_ENV_ALLOWED_MIMETYPES_ENV_PLACEHOLDER          | Comma separated list of allowed mime types for files that can be uploaded to the sms.                                                                                                                                                                                     |comma separated list of strings|
| SHOW_RELEASE_NOTES                  | SHOW_RELEASE_NOTES_ENV_PLACEHOLDER                  | Whether to show release notes on the landing page, shown if set to 'true'.                                                                                                                                                                                                |string ('true' or 'false')     |
