# SPDX-FileCopyrightText: 2021
# - Jannes Breier <jannes.breier@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

# Generated by Django 3.0.14 on 2021-05-17 20:30

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('app', '0003_auto_20210224_1219'),
    ]

    operations = [
        migrations.CreateModel(
            name='ActionCategoryCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
            ],
            options={
                'verbose_name_plural': 'action categories communities',
                'db_table': 'action_category_community',
            },
        ),
        migrations.CreateModel(
            name='ActionTypeCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
            ],
            options={
                'verbose_name_plural': 'action types communities',
                'db_table': 'action_type_community',
            },
        ),
        migrations.CreateModel(
            name='AggregationTypeCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
            ],
            options={
                'verbose_name_plural': 'aggregation types communities',
                'db_table': 'aggregation_type_community',
            },
        ),
        migrations.CreateModel(
            name='Community',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='communitys', to='app.GlobalProvenance')),
            ],
            options={
                'verbose_name_plural': 'communities',
                'db_table': 'community',
                'ordering': ['term'],
            },
        ),
        migrations.CreateModel(
            name='CompartmentCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('community', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.Community')),
                ('root', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='compartments_communities', to='app.Compartment')),
            ],
            options={
                'verbose_name_plural': 'compartments communities',
                'db_table': 'compartment_community',
                'unique_together': {('root', 'community')},
            },
        ),
        migrations.CreateModel(
            name='EquipmentStatusCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('community', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.Community')),
                ('root', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='equipment_status_communities', to='app.EquipmentStatus')),
            ],
            options={
                'verbose_name_plural': 'equipment status communities',
                'db_table': 'equipment_status_community',
                'unique_together': {('root', 'community')},
            },
        ),
        migrations.CreateModel(
            name='EquipmentTypeCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('community', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.Community')),
                ('root', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='equipment_types_communities', to='app.EquipmentType')),
            ],
            options={
                'verbose_name_plural': 'equipment types communities',
                'db_table': 'equipment_type_community',
                'unique_together': {('root', 'community')},
            },
        ),
        migrations.CreateModel(
            name='ManufacturerCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('community', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.Community')),
                ('root', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='manufacturers_communities', to='app.Manufacturer')),
            ],
            options={
                'db_table': 'manufacturer_community',
                'unique_together': {('root', 'community')},
            },
        ),
        migrations.CreateModel(
            name='MeasuredQuantityCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('aggregation_type', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='measured_quantities_communities', to='app.AggregationType')),
                ('community', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.Community')),
                ('root', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='measured_quantities_communities', to='app.MeasuredQuantity')),
                ('sampling_media', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='measured_quantities_communities', to='app.SamplingMedium')),
            ],
            options={
                'db_table': 'measured_quantity_community',
                'unique_together': {('root', 'community')},
            },
        ),
        migrations.CreateModel(
            name='PlatformTypeCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('community', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.Community')),
                ('root', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='platform_types_communities', to='app.PlatformType')),
            ],
            options={
                'verbose_name_plural': 'platform types communities',
                'db_table': 'platform_type_community',
                'unique_together': {('root', 'community')},
            },
        ),
        migrations.CreateModel(
            name='SamplingMediumCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('community', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.Community')),
                ('compartment', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='sampling_media_communities', to='app.Compartment')),
                ('root', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='sampling_media_communities', to='app.SamplingMedium')),
            ],
            options={
                'verbose_name_plural': 'sampling media communities',
                'db_table': 'sampling_medium_community',
                'unique_together': {('root', 'community'), ('term', 'compartment')},
            },
        ),
        migrations.CreateModel(
            name='UnitCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('community', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.Community')),
                ('root', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='units_communities', to='app.Unit')),
            ],
            options={
                'verbose_name_plural': 'units communities',
                'db_table': 'unit_community',
                'unique_together': {('root', 'community')},
            },
        ),
        migrations.AlterModelOptions(
            name='actioncategory',
            options={'ordering': ['term'], 'verbose_name_plural': 'action categories'},
        ),
        migrations.AlterModelOptions(
            name='actiontype',
            options={'ordering': ['term']},
        ),
        migrations.DeleteModel(
            name='Mapping',
        ),
        migrations.AddField(
            model_name='aggregationtypecommunity',
            name='community',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.Community'),
        ),
        migrations.AddField(
            model_name='aggregationtypecommunity',
            name='root',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='aggregation_types_communities', to='app.AggregationType'),
        ),
        migrations.AddField(
            model_name='actiontypecommunity',
            name='action_category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='action_types_communities', to='app.ActionCategory'),
        ),
        migrations.AddField(
            model_name='actiontypecommunity',
            name='community',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.Community'),
        ),
        migrations.AddField(
            model_name='actiontypecommunity',
            name='root',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='action_types_communities', to='app.ActionType'),
        ),
        migrations.AddField(
            model_name='actioncategorycommunity',
            name='community',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.Community'),
        ),
        migrations.AddField(
            model_name='actioncategorycommunity',
            name='root',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='action_categories_communities', to='app.ActionCategory'),
        ),
        migrations.AlterUniqueTogether(
            name='aggregationtypecommunity',
            unique_together={('root', 'community')},
        ),
        migrations.AlterUniqueTogether(
            name='actiontypecommunity',
            unique_together={('root', 'community'), ('term', 'action_category')},
        ),
        migrations.AlterUniqueTogether(
            name='actioncategorycommunity',
            unique_together={('root', 'community')},
        ),
    ]
