# SPDX-FileCopyrightText: 2022
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

# Generated by Django 3.2.10 on 2022-01-11 08:30

from django.db import migrations, models
import django.db.models.deletion
import django.db.models.expressions


class Migration(migrations.Migration):

    dependencies = [
        ('app', '0009_remove_deprecated_manufacturers_20220207_0736'),
    ]

    operations = [
        migrations.CreateModel(
            name='ContactRoles',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('PENDING', 'Pending'), ('REJECTED', 'Rejected'), ('ACCEPTED', 'Accepted'), ('ARCHIVED', 'Archived'), ('UPDATED', 'Updated')], default='PENDING', max_length=255)),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contactroless', to='app.globalprovenance')),
                ('successor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.contactroles')),
            ],
            options={
                'verbose_name': 'contact role',
                'verbose_name_plural': 'contact roles communities',
                'db_table': 'contact_role',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContactRolesCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('community', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.community')),
                ('root', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='contacts_roles_communities', to='app.contactroles')),
            ],
            options={
                'verbose_name_plural': 'contact roles communities',
                'db_table': 'contact_roles_community',
                'ordering': ['root__term', 'term'],
                'abstract': False,
                'unique_together': {('root', 'community')},
            },
        ),
        migrations.AddConstraint(
            model_name='contactroles',
            constraint=models.CheckConstraint(check=models.Q(('successor_id', django.db.models.expressions.F('id')), _negated=True), name='contactroles_successor_not_a_reference_to_self'),
        ),
    ]
