# SPDX-FileCopyrightText: 2022
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

# Generated by Django 4.0.1 on 2022-03-03 07:07

import django.db.models.deletion
import django.db.models.expressions
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("app", "0012_rename_contactrolescommunity_contactrolecommunity_and_more"),
    ]

    operations = [
        migrations.RenameModel(
            old_name="ContactRoles",
            new_name="ContactRole",
        ),
        migrations.RemoveConstraint(
            model_name="contactrole",
            name="contactroles_successor_not_a_reference_to_self",
        ),
        migrations.AlterField(
            model_name="contactrolecommunity",
            name="root",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="contact_role_communities",
                to="app.contactrole",
            ),
        ),
        migrations.AddConstraint(
            model_name="contactrole",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("successor_id", django.db.models.expressions.F("id")),
                    _negated=True,
                ),
                name="contactrole_successor_not_a_reference_to_self",
            ),
        ),
    ]
