# SPDX-FileCopyrightText: 2022
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

# Generated by Django 4.0.3 on 2022-05-30 14:09

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('app', '0014_alter_contactrolecommunity_root'),
    ]

    operations = [
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('PENDING', 'Pending'), ('REJECTED', 'Rejected'), ('ACCEPTED', 'Accepted'), ('ARCHIVED', 'Archived'), ('UPDATED', 'Updated')], default='PENDING', max_length=255)),
                ('iso_code', models.CharField(max_length=3)),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='%(class)ss', to='app.globalprovenance')),
                ('successor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.country')),
            ],
            options={
                'verbose_name_plural': 'Countries',
                'db_table': 'country',
            },
        ),
    ]
