# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

# Generated by Django 4.1.3 on 2022-12-15 14:44

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('app', '0018_alter_measuredquantityunit_id'),
    ]

    operations = [
        migrations.CreateModel(
            name='SiteType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('PENDING', 'Pending'), ('REJECTED', 'Rejected'), ('ACCEPTED', 'Accepted'), ('ARCHIVED', 'Archived'), ('UPDATED', 'Updated')], default='PENDING', max_length=255)),
                ('requested_by_email', models.CharField(blank=True, max_length=512, null=True, verbose_name='Requested by')),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='%(class)ss', to='app.globalprovenance')),
            ],
            options={
                'db_table': 'site_type',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SiteUsage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('PENDING', 'Pending'), ('REJECTED', 'Rejected'), ('ACCEPTED', 'Accepted'), ('ARCHIVED', 'Archived'), ('UPDATED', 'Updated')], default='PENDING', max_length=255)),
                ('requested_by_email', models.CharField(blank=True, max_length=512, null=True, verbose_name='Requested by')),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='%(class)ss', to='app.globalprovenance')),
                ('successor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.siteusage')),
            ],
            options={
                'db_table': 'site_usage',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SiteTypeCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('community', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.community')),
                ('root', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='site_types_communities', to='app.sitetype')),
            ],
            options={
                'verbose_name_plural': 'site types communities',
                'db_table': 'site_type_community',
                'ordering': ['root__term', 'term'],
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='sitetype',
            name='site_usage',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='site_types', to='app.siteusage'),
        ),
        migrations.AddField(
            model_name='sitetype',
            name='successor',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.sitetype'),
        ),
        migrations.CreateModel(
            name='SiteUsageCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=255, null=True)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('community', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='app.community')),
                ('root', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='site_usages_communities', to='app.siteusage')),
            ],
            options={
                'verbose_name_plural': 'site usage communities',
                'db_table': 'site_usage_community',
                'ordering': ['root__term', 'term'],
                'abstract': False,
                'unique_together': {('root', 'community')},
            },
        ),
        migrations.AddConstraint(
            model_name='siteusage',
            constraint=models.CheckConstraint(check=models.Q(('successor_id', models.F('id')), _negated=True), name='siteusage_successor_not_a_reference_to_self'),
        ),
        migrations.AlterUniqueTogether(
            name='sitetypecommunity',
            unique_together={('root', 'community')},
        ),
        migrations.AddConstraint(
            model_name='sitetype',
            constraint=models.CheckConstraint(check=models.Q(('successor_id', models.F('id')), _negated=True), name='sitetype_successor_not_a_reference_to_self'),
        ),
        migrations.AlterUniqueTogether(
            name='sitetype',
            unique_together={('term', 'site_usage')},
        ),
    ]
