# SPDX-FileCopyrightText: 2020 - 2024
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2
# Generated by Django 5.0.8 on 2024-10-07 08:05

"""Migration to add a column for the provenance term to the units."""

from django.db import migrations, models


class Migration(migrations.Migration):
    """Add a column for the provenance term."""

    dependencies = [
        ("app", "0024_actioncategory_discussion_url_and_more"),
    ]

    operations = [
        migrations.AddField(
            model_name="historicalunit",
            name="provenance_term",
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.AddField(
            model_name="unit",
            name="provenance_term",
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
    ]
