# SPDX-FileCopyrightText: 2021 - 2022
# - Kotyba Alhaj Taha <kotyba.alhaj-taha@ufz.de>
# - Jannes Breier <jannes.breier@gfz-potsdam.de>
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
# - Helmholtz Centre for Environmental Research GmbH - UFZ (UFZ, https://www.ufz.de)
#
# SPDX-License-Identifier: EUPL-1.2

from rest_framework_json_api.relations import ResourceRelatedField

from app.models import Community, EquipmentStatus, EquipmentStatusCommunity
from app.serializers.Base_serializer import CommunityBaseSerializer


class EquipmentStatusCommunitySerializer(CommunityBaseSerializer):
    class Meta(CommunityBaseSerializer.Meta):
        model = EquipmentStatusCommunity

    root = ResourceRelatedField(
        model=EquipmentStatus,
        many=False,
        read_only=False,
        allow_null=False,
        required=True,
        queryset=EquipmentStatus.objects.all(),
        self_link_view_name="equipment_status_community-relationships",
        related_link_view_name="equipment_status_community-related",
    )
    community = ResourceRelatedField(
        model=Community,
        many=False,
        read_only=False,
        allow_null=False,
        required=True,
        queryset=Community.objects.all(),
        self_link_view_name="equipment_status_community-relationships",
        related_link_view_name="equipment_status_community-related",
    )
    included_serializers = {
        "root": "app.serializers.EquipmentStatusSerializer",
        "community": "app.serializers.CommunitySerializer",
    }
