# SPDX-FileCopyrightText: 2021 - 2022
# - Kotyba Alhaj Taha <kotyba.alhaj-taha@ufz.de>
# - Jannes Breier <jannes.breier@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
# - Helmholtz Centre for Environmental Research GmbH - UFZ (UFZ, https://www.ufz.de)
#
# SPDX-License-Identifier: EUPL-1.2

from rest_framework_json_api.views import RelationshipView

from app.models import CompartmentCommunity
from app.serializers.compartment_community_serializer import (
    CompartmentCommunitySerializer,
)
from app.views.Base_viewset import CommunityFilterViewSet


class CompartmentCommunityViewSet(CommunityFilterViewSet):
    """
    API endpoint that allows Compartment to be viewed or edited.
    """

    queryset = CompartmentCommunity.objects.all()
    serializer_class = CompartmentCommunitySerializer


class CompartmentCommunityRelationshipView(RelationshipView):
    """
    view for relationships.compartment_community
    """

    queryset = CompartmentCommunity.objects
    self_link_view_name = "compartment_community-relationships"
    http_method_names = ["get"]
