# SPDX-FileCopyrightText: 2022
# - Kotyba Alhaj Taha <kotyba.alhaj-taha@ufz.de>
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
# - Helmholtz Centre for Environmental Research GmbH - UFZ (UFZ, https://www.ufz.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""empty message

Revision ID: 0740d341ea8e
Revises: 13e35f226a7c
Create Date: 2022-05-12 13:47:30.463096

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.sql import text

# revision identifiers, used by Alembic.
revision = "0740d341ea8e"
down_revision = "6c3bd924ad64"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "device_mount_action", "description", new_column_name="begin_description"
    )
    op.drop_constraint(
        "device_mount_action_contact_id_fkey", "device_mount_action", type_="foreignkey"
    )
    op.alter_column(
        "device_mount_action", "contact_id", new_column_name="begin_contact_id"
    )

    op.add_column(
        "device_mount_action", sa.Column("end_date", sa.DateTime(), nullable=True)
    )
    op.add_column(
        "device_mount_action", sa.Column("end_description", sa.Text(), nullable=True)
    )
    op.add_column(
        "device_mount_action", sa.Column("end_contact_id", sa.Integer(), nullable=True)
    )
    op.create_foreign_key(
        None, "device_mount_action", "contact", ["end_contact_id"], ["id"]
    )
    op.create_foreign_key(
        None, "device_mount_action", "contact", ["begin_contact_id"], ["id"]
    )

    op.alter_column(
        "platform_mount_action", "description", new_column_name="begin_description"
    )
    op.drop_constraint(
        "platform_mount_action_contact_id_fkey",
        "platform_mount_action",
        type_="foreignkey",
    )
    op.alter_column(
        "platform_mount_action", "contact_id", new_column_name="begin_contact_id"
    )
    op.add_column(
        "platform_mount_action", sa.Column("end_date", sa.DateTime(), nullable=True)
    )
    op.add_column(
        "platform_mount_action", sa.Column("end_description", sa.Text(), nullable=True)
    )
    op.add_column(
        "platform_mount_action",
        sa.Column("end_contact_id", sa.Integer(), nullable=True),
    )
    op.create_foreign_key(
        None, "platform_mount_action", "contact", ["begin_contact_id"], ["id"]
    )
    op.create_foreign_key(
        None, "platform_mount_action", "contact", ["end_contact_id"], ["id"]
    )

    # And now we migrate our existing unmount data to the mount entries
    conn = op.get_bind()

    platform_mount_data_lookup = {}
    platform_mount_actions = conn.execute(
        text(
            "select id, configuration_id, platform_id, begin_date from platform_mount_action"
        )
    )
    for row in platform_mount_actions:
        key = (row["configuration_id"], row["platform_id"])
        platform_mount_data_lookup.setdefault(key, [])
        platform_mount_data_lookup[key].append(row)
    platform_unmount_actions = conn.execute(
        text(
            "select configuration_id, platform_id, end_date, contact_id, description from platform_unmount_action"
        )
    )
    for row in platform_unmount_actions:
        key = (row["configuration_id"], row["platform_id"])
        mount_actions = platform_mount_data_lookup[key]
        mount_actions = [a for a in mount_actions if a["begin_date"] <= row["end_date"]]
        mount_actions.sort(key=lambda x: x["begin_date"])
        mount_action = mount_actions[-1]
        update_query = text(
            """
        update platform_mount_action
        set end_date = :end_date,
            end_contact_id = :contact_id,
            end_description = :description
        where id = :id
        """
        )
        conn.execute(
            update_query,
            {
                "id": mount_action["id"],
                "end_date": row["end_date"],
                "contact_id": row["contact_id"],
                "description": row["description"],
            },
        )

    device_mount_data_lookup = {}
    device_mount_actions = conn.execute(
        text(
            "select id, configuration_id, device_id, begin_date from device_mount_action"
        )
    )
    for row in device_mount_actions:
        key = (row["configuration_id"], row["device_id"])
        device_mount_data_lookup.setdefault(key, [])
        device_mount_data_lookup[key].append(row)

    device_unmount_actions = conn.execute(
        text(
            "select configuration_id, device_id, end_date, contact_id, description from device_unmount_action"
        )
    )
    for row in device_unmount_actions:
        key = (row["configuration_id"], row["device_id"])
        mount_actions = device_mount_data_lookup.get(key)
        if mount_actions:
            mount_actions = [
                a for a in mount_actions if a["begin_date"] <= row["end_date"]
            ]
            mount_actions.sort(key=lambda x: x["begin_date"])
            mount_action = mount_actions[-1]
            update_query = text(
                """
            update device_mount_action
            set end_date = :end_date,
                end_contact_id = :contact_id,
                end_description = :description
            where id = :id
            """
            )
            conn.execute(
                update_query,
                {
                    "id": mount_action["id"],
                    "end_date": row["end_date"],
                    "contact_id": row["contact_id"],
                    "description": row["description"],
                },
            )
    # ### end Alembic commands ###


def downgrade():
    conn = op.get_bind()
    insert_query = text(
        """
    insert into device_unmount_action (
        configuration_id, device_id, end_date,
        contact_id, description
    )
    select configuration_id, device_id, end_date, end_contact_id, end_description
    from device_mount_action
    where end_date is not null
    """
    )
    conn.execute(insert_query)

    insert_query = text(
        """
    insert into platform_unmount_action (
        configuration_id, platform_id, end_date,
        contact_id, description
    )
    select configuration_id, platform_id, end_date, end_contact_id, end_description
    from platform_mount_actions
    where end_date is not null
    """
    )
    conn.execute(insert_query)
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "platform_mount_action", type_="foreignkey")
    op.drop_constraint(None, "platform_mount_action", type_="foreignkey")
    op.drop_constraint(None, "device_mount_action", type_="foreignkey")
    op.drop_constraint(None, "device_mount_action", type_="foreignkey")
    op.alter_column(
        "platform_mount_action", "begin_contact_id", new_column_name="contact_id"
    )
    op.alter_column(
        "device_mount_action", "begin_contact_id", new_column_name="contact_id"
    )
    op.alter_column(
        "platform_mount_action", "begin_description", new_column_name="description"
    )
    op.alter_column(
        "device_mount_action", "begin_description", new_column_name="description"
    )

    op.create_foreign_key(
        "platform_mount_action_contact_id_fkey",
        "platform_mount_action",
        "contact",
        ["contact_id"],
        ["id"],
    )
    op.drop_column("platform_mount_action", "end_contact_id")
    op.drop_column("platform_mount_action", "end_description")
    op.drop_column("platform_mount_action", "end_date")

    op.create_foreign_key(
        "device_mount_action_contact_id_fkey",
        "device_mount_action",
        "contact",
        ["contact_id"],
        ["id"],
    )
    op.drop_column("device_mount_action", "end_contact_id")
    op.drop_column("device_mount_action", "end_description")
    op.drop_column("device_mount_action", "end_date")

    # ### end Alembic commands ###
