# SPDX-FileCopyrightText: 2025
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
# - Helmholtz Centre for Environmental Research GmbH - UFZ (UFZ, https://www.ufz.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add a label field to the datastream links.

Revision ID: 158e84e3bc41
Revises: 05f3123adb4f
Create Date: 2025-03-28 12:56:02.823814

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "158e84e3bc41"
down_revision = "05f3123adb4f"
branch_labels = None
depends_on = None


def upgrade():
    """Run the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("datastream_link", schema=None) as batch_op:
        batch_op.add_column(sa.Column("label", sa.String(length=256), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    "Undo the database structure changes." ""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("datastream_link", schema=None) as batch_op:
        batch_op.drop_column("label")
    # ### end Alembic commands ###
