# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add aggregation type fields to device properties.

Revision ID: 3134edb80140
Revises: 4b0f4516b818
Create Date: 2023-04-14 07:39:26.641231

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "3134edb80140"
down_revision = "4b0f4516b818"
branch_labels = None
depends_on = None


def upgrade():
    """Run the database structure change commands."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("device_property", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("aggregation_type_uri", sa.String(length=256), nullable=True)
        )
        batch_op.add_column(
            sa.Column("aggregation_type_name", sa.String(length=256), nullable=True)
        )
    # ### end Alembic commands ###


def downgrade():
    """Undo the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("device_property", schema=None) as batch_op:
        batch_op.drop_column("aggregation_type_name")
        batch_op.drop_column("aggregation_type_uri")
    # ### end Alembic commands ###
