# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add the website field to the sites.

Revision ID: 393a55ad59db
Revises: b720c8572051
Create Date: 2023-05-31 12:51:21.365797

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "393a55ad59db"
down_revision = "b720c8572051"
branch_labels = None
depends_on = None


def upgrade():
    """Do the structural changes on the database."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("site", schema=None) as batch_op:
        batch_op.add_column(sa.Column("website", sa.String(length=1024), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    """Undo the structural changes on the database."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("site", schema=None) as batch_op:
        batch_op.drop_column("website")
    # ### end Alembic commands ###
