# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2
"""Fix the encoding in the organization names.

Revision ID: 3ba235b20231
Revises: 393a55ad59db
Create Date: 2023-06-28 14:17:09.253065

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "3ba235b20231"
down_revision = "393a55ad59db"
branch_labels = None
depends_on = None


def upgrade():
    """Fix the names of the organizations."""
    mappings = {
        "FUPL F\u00c3\u00a9d\u00c3\u00a9ration Universitaire et Polytechnique de Lille": "FUPL F\u00e9d\u00e9ration Universitaire et Polytechnique de Lille",
        "Agence Bibliographique de l'Enseignement Sup\u00c3\u00a9rieur": "Agence Bibliographique de l'Enseignement Sup\u00e9rieur",
        "\u00c3\u0085bo Akademi University": "\u00c5bo Akademi University",
        "Acad\u00c3\u00a9mie de la Martinique": "Acad\u00e9mie de la Martinique",
        "Acad\u00c3\u00a9mie de Strasbourg": "Acad\u00e9mie de Strasbourg",
        "Academia das Ci\u00c3\u00aancias de Lisboa": "Academia das Ci\u00eancias de Lisboa",
        "ACADEMIA,d.o.o., Vi\u00c5\u00a1ja strokovna \u00c5\u00a1ola za komercialiste, Maribor": "ACADEMIA,d.o.o., Vi\u0161ja strokovna \u0161ola za komercialiste, Maribor",
        "Universit\u00c3\u00a9 de Lyon - COMUE": "Universit\u00e9 de Lyon - COMUE",
        "Minist\u00c3\u00a8re de l'Education Nationale, de l'Enseignement Sup\u00c3\u00a9rieur et de la Recherche": "Minist\u00e8re de l'Education Nationale, de l'Enseignement Sup\u00e9rieur et de la Recherche",
        "Instituto Polit\u00c3\u00a9cnico de Lisboa": "Instituto Polit\u00e9cnico de Lisboa",
        "Hochschule fuer den \u00c3\u00b6ffentlichen Dienst in Bayern - Fachbereich Allgemeine Innere Verwaltung": "Hochschule fuer den \u00f6ffentlichen Dienst in Bayern - Fachbereich Allgemeine Innere Verwaltung",
        "Agence de Mutualisation des Universit\u00c3\u00a9s et Etablissements": "Agence de Mutualisation des Universit\u00e9s et Etablissements",
        "Andr\u00c3\u00a1ssy University Budapest": "Andr\u00e1ssy University Budapest",
        "Ankara \u00c3\u009cniversitesi": "Ankara \u00dcniversitesi",
        "Armed Forces Academy of General Milan Rastislav \u00c5\u00a0tef\u00c3\u00a1nik": "Armed Forces Academy of General Milan Rastislav \u0160tef\u00e1nik",
        "Ag\u00c3\u00aancia Portuguesa do Ambiente": "Ag\u00eancia Portuguesa do Ambiente",
        "Pomeranian University in S\u00c5\u0082upsk": "Pomeranian University in S\u0142upsk",
        "Ag\u00c3\u00aancia Regional para o Desenvolvimento da Investiga\u00c3\u00a7\u00c3\u00a3o, Tecnologia e Inova\u00c3\u00a7\u00c3\u00a3o": "Ag\u00eancia Regional para o Desenvolvimento da Investiga\u00e7\u00e3o, Tecnologia e Inova\u00e7\u00e3o",
        "\u00c3\u0093buda University": "\u00d3buda University",
        "Universit\u00c3\u00a4t Heidelberg (Ruprecht-Karls-Universit\u00c3\u00a4t)": "Universit\u00e4t Heidelberg (Ruprecht-Karls-Universit\u00e4t)",
        "A\u00e2\u0080\u0099Sharqiyah University": "A\u2019Sharqiyah University",
        "University of Bielsko-Bia\u00c5\u0082a": "University of Bielsko-Bia\u0142a",
        "Adana Alparslan T\u00c3\u00bcrke\u00c5\u009f Science and Technology University": "Adana Alparslan T\u00fcrke\u015f Science and Technology University",
        "University School of Physical Education in Wroc\u00c5\u0082aw": "University School of Physical Education in Wroc\u0142aw",
        "Bah\u00c3\u00a7e\u00c5\u009fehir University": "Bah\u00e7e\u015fehir University",
        "\u00c4\u00b0zmir Bak\u00c4\u00b1r\u00c3\u00a7ay University": "\u0130zmir Bak\u0131r\u00e7ay University",
        "Universit\u00c3\u00a4tsklinik Balgrist": "Universit\u00e4tsklinik Balgrist",
        "Bal\u00c4\u00b1kesir University": "Bal\u0131kesir University",
        "Bart\u00c4\u00b1n University": "Bart\u0131n University",
        "Ecole Sup\u00c3\u00a9rieure des Beaux-Arts de Nantes M\u00c3\u00a9tropole": "Ecole Sup\u00e9rieure des Beaux-Arts de Nantes M\u00e9tropole",
        "Zonguldak B\u00c3\u00bclent Ecevit University": "Zonguldak B\u00fclent Ecevit University",
        "Bildungszentrum f\u00c3\u00bcr informationsverarbeitende Berufe e.V.": "Bildungszentrum f\u00fcr informationsverarbeitende Berufe e.V.",
        "Municipal Library in Kostelec nad Orlic\u00c3\u00ad": "Municipal Library in Kostelec nad Orlic\u00ed",
        "Universit\u00c3\u00a9 d'Evry-Val-d'Essonne": "Universit\u00e9 d'Evry-Val-d'Essonne",
        "Bifr\u00c3\u00b6st University": "Bifr\u00f6st University",
        "Bilecik \u00c5\u009eeyh Edebali University": "Bilecik \u015eeyh Edebali University",
        "Biblioth\u00c3\u00a8que Nationale et Universitaire Strasbourg": "Biblioth\u00e8que Nationale et Universitaire Strasbourg",
        "Universit\u00c3\u00a9 de Bretagne Occidentale": "Universit\u00e9 de Bretagne Occidentale",
        "Consejo de Aseguramiento de la Calidad de la Educaci\u00c3\u00b3n Superior - caces": "Consejo de Aseguramiento de la Calidad de la Educaci\u00f3n Superior - caces",
        "Duale Hochschule Baden-W\u00c3\u00bcrttemberg - Center for Advanced Studies": "Duale Hochschule Baden-W\u00fcrttemberg - Center for Advanced Studies",
        "Centro Cient\u00c3\u00adfico e Cultural de Macau": "Centro Cient\u00edfico e Cultural de Macau",
        "CEA - Commissariat \u00c3\u00a0 l'Energie Atomique": "CEA - Commissariat \u00e0 l'Energie Atomique",
        "Corporaci\u00c3\u00b3n Ecuatoriana para el Desarrollo de la investigaci\u00c3\u00b3n y la academia - cedia": "Corporaci\u00f3n Ecuatoriana para el Desarrollo de la investigaci\u00f3n y la academia - cedia",
        "CentraleSup\u00c3\u00a9lec": "CentraleSup\u00e9lec",
        "Centro de Supercomputaci\u00c3\u00b3n de Galicia": "Centro de Supercomputaci\u00f3n de Galicia",
        "CESPU - Cooperativa de Ensino Superior Polit\u00c3\u00a9cnico e Universit\u00c3\u00a1rio": "CESPU - Cooperativa de Ensino Superior Polit\u00e9cnico e Universit\u00e1rio",
        "Charit\u00c3\u00a9 \u00e2\u0080\u0093 Universit\u00c3\u00a4tsmedizin Berlin": "Charit\u00e9 \u2013 Universit\u00e4tsmedizin Berlin",
        "Ecole Nationale Sup\u00c3\u00a9rieure de Chimie de Paris": "Ecole Nationale Sup\u00e9rieure de Chimie de Paris",
        "Centro Inform\u00c3\u00a1tico Cient\u00c3\u00adfico de Andaluc\u00c3\u00ada": "Centro Inform\u00e1tico Cient\u00edfico de Andaluc\u00eda",
        "Centro de Investigaciones Energ\u00c3\u00a9ticas, Medioambientales y Tecnol\u00c3\u00b3gicas": "Centro de Investigaciones Energ\u00e9ticas, Medioambientales y Tecnol\u00f3gicas",
        "Ci\u00c3\u00aancia Viva": "Ci\u00eancia Viva",
        "France Education International de S\u00c3\u00a8vres": "France Education International de S\u00e8vres",
        "CISPA \u00e2\u0080\u0093 Helmholtz-Zentrum f\u00c3\u00bcr Informationssicherheit gGmbH": "CISPA \u2013 Helmholtz-Zentrum f\u00fcr Informationssicherheit gGmbH",
        "Centro de Investigaci\u00c3\u00b3n y Tecnolog\u00c3\u00ada Agroalimentaria de Arag\u00c3\u00b3n": "Centro de Investigaci\u00f3n y Tecnolog\u00eda Agroalimentaria de Arag\u00f3n",
        "Coll\u00c3\u00a8ge de Maisonneuve": "Coll\u00e8ge de Maisonneuve",
        "Coll\u00c3\u00a8ge de France": "Coll\u00e8ge de France",
        "Coll\u00c3\u00a8ge Bor\u00c3\u00a9al": "Coll\u00e8ge Bor\u00e9al",
        "La Cit\u00c3\u00a9": "La Cit\u00e9",
        "Universit\u00c3\u00a9 de la Nouvelle-Cal\u00c3\u00a9donie": "Universit\u00e9 de la Nouvelle-Cal\u00e9donie",
        "Unidad Educativa Salesiana Crist\u00c3\u00b3bal Col\u00c3\u00b3n - cristobalcolon": "Unidad Educativa Salesiana Crist\u00f3bal Col\u00f3n - cristobalcolon",
        "CROUS Bourgogne Franche-Comt\u00c3\u00a9": "CROUS Bourgogne Franche-Comt\u00e9",
        "Centre R\u00c3\u00a9gional des Oeuvres Universitaires et Scolaires de Clermont-Ferrand": "Centre R\u00e9gional des Oeuvres Universitaires et Scolaires de Clermont-Ferrand",
        "Centre R\u00c3\u00a9gional des Oeuvres Universitaires et Scolaires de l'Acad\u00c3\u00a9mie de Limoges": "Centre R\u00e9gional des Oeuvres Universitaires et Scolaires de l'Acad\u00e9mie de Limoges",
        "Centre R\u00c3\u00a9gional des Oeuvres Universitaires et Scolaires  de Paris": "Centre R\u00e9gional des Oeuvres Universitaires et Scolaires  de Paris",
        "CROUS de l'acad\u00c3\u00a9mie de Versailles": "CROUS de l'acad\u00e9mie de Versailles",
        "\u00c3\u0087ukurova University": "\u00c7ukurova University",
        "G\u00c3\u0089ANT": "G\u00c9ANT",
        "Gesellschaft f\u00c3\u00bcr wissenschaftliche Datenverarbeitung mbH": "Gesellschaft f\u00fcr wissenschaftliche Datenverarbeitung mbH",
        "Universit\u00c3\u00a9 Paris-Dauphine": "Universit\u00e9 Paris-Dauphine",
        "DeiC \u00e2\u0080\u0093 Danish e-Infrastructure Cooperation": "DeiC \u2013 Danish e-Infrastructure Cooperation",
        "Dire\u00c3\u00a7\u00c3\u00a3o Geral do Ensino Superior": "Dire\u00e7\u00e3o Geral do Ensino Superior",
        "Dire\u00c3\u00a7\u00c3\u00a3o-Geral do Territ\u00c3\u00b3rio": "Dire\u00e7\u00e3o-Geral do Territ\u00f3rio",
        "Duale Hochschule Baden-W\u00c3\u00bcrttemberg Heidenheim": "Duale Hochschule Baden-W\u00fcrttemberg Heidenheim",
        "DHBW L\u00c3\u00b6rrach": "DHBW L\u00f6rrach",
        "Duale Hochschule Baden-W\u00c3\u00bcrttemberg Ravensburg": "Duale Hochschule Baden-W\u00fcrttemberg Ravensburg",
        "Baden-W\u00c3\u00bcrttemberg Cooperative State University (DHBW) Stuttgart": "Baden-W\u00fcrttemberg Cooperative State University (DHBW) Stuttgart",
        "Duale Hochschule Baden-W\u00c3\u00bcrttemberg, Villingen-Schwennigen": "Duale Hochschule Baden-W\u00fcrttemberg, Villingen-Schwennigen",
        "Deutsches Krebsforschungszentrum - Stiftung des \u00c3\u00b6ffentlichen Rechts": "Deutsches Krebsforschungszentrum - Stiftung des \u00f6ffentlichen Rechts",
        "Deutsches Zentrum f\u00c3\u00bcr Luft- und Raumfahrt e.V.": "Deutsches Zentrum f\u00fcr Luft- und Raumfahrt e.V.",
        "Kutahya Dumlup\u00c4\u00b1nar University": "Kutahya Dumlup\u0131nar University",
        "University of Duna\u00c3\u00bajv\u00c3\u00a1ros": "University of Duna\u00fajv\u00e1ros",
        "Deutsches Zentrum f\u00c3\u00bcr Neurodegenerative Erkrankungen e. V. (DZNE)": "Deutsches Zentrum f\u00fcr Neurodegenerative Erkrankungen e. V. (DZNE)",
        "HESAM Universit\u00c3\u00a9": "HESAM Universit\u00e9",
        "Ecole Nationale Sup\u00c3\u00a9rieure du Paysage de Versailles-Marseille": "Ecole Nationale Sup\u00e9rieure du Paysage de Versailles-Marseille",
        "Ruhr-Universit\u00c3\u00a4t Bochum": "Ruhr-Universit\u00e4t Bochum",
        "Universit\u00c3\u00a9 Gustave Eiffel": "Universit\u00e9 Gustave Eiffel",
        "Educaci\u00c3\u00b3n de Navarra": "Educaci\u00f3n de Navarra",
        "Institut Sup\u00c3\u00a9rieur de Communication et Publicit\u00c3\u00a9": "Institut Sup\u00e9rieur de Communication et Publicit\u00e9",
        "Ecole des Hautes Etudes en Sant\u00c3\u00a9 Publique": "Ecole des Hautes Etudes en Sant\u00e9 Publique",
        "Universit\u00c3\u00a9 du Littoral C\u00c3\u00b4te d'Opale": "Universit\u00e9 du Littoral C\u00f4te d'Opale",
        "E\u00c3\u00b6tv\u00c3\u00b6s J\u00c3\u00b3zsef College": "E\u00f6tv\u00f6s J\u00f3zsef College",
        "E\u00c3\u00b6tv\u00c3\u00b6s Lor\u00c3\u00a1nd Research Network": "E\u00f6tv\u00f6s Lor\u00e1nd Research Network",
        "Ecole nationale sup\u00c3\u00a9rieure Mines-T\u00c3\u00a9l\u00c3\u00a9com Atlantique Bretagne Pays de la Loire": "Ecole nationale sup\u00e9rieure Mines-T\u00e9l\u00e9com Atlantique Bretagne Pays de la Loire",
        "\u00c3\u0089cole nationale d'administration publique": "\u00c9cole nationale d'administration publique",
        "Escola Superior N\u00c3\u00a1utica Infante D. Henrique": "Escola Superior N\u00e1utica Infante D. Henrique",
        "Ecole Nationale d'Ing\u00c3\u00a9nieurs de Brest": "Ecole Nationale d'Ing\u00e9nieurs de Brest",
        "Ecole Nationale d'Ing\u00c3\u00a9nieurs de Saint-Etienne": "Ecole Nationale d'Ing\u00e9nieurs de Saint-Etienne",
        "Ecole Nationale d'Ing\u00c3\u00a9nieurs de Tarbes": "Ecole Nationale d'Ing\u00e9nieurs de Tarbes",
        "Ecole Nationale des Ponts et Chauss\u00c3\u00a9es": "Ecole Nationale des Ponts et Chauss\u00e9es",
        "Ecole Normale Sup\u00c3\u00a9rieure Paris-Saclay": "Ecole Normale Sup\u00e9rieure Paris-Saclay",
        "Ecole Normale Sup\u00c3\u00a9rieure de Lyon": "Ecole Normale Sup\u00e9rieure de Lyon",
        "Ecole Normale Sup\u00c3\u00a9rieure de Rennes": "Ecole Normale Sup\u00e9rieure de Rennes",
        "Ecole Normale Sup\u00c3\u00a9rieure de Paris": "Ecole Normale Sup\u00e9rieure de Paris",
        "Ecole nationale sup\u00c3\u00a9rieure des Arts D\u00c3\u00a9coratifs": "Ecole nationale sup\u00e9rieure des Arts D\u00e9coratifs",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Arts et M\u00c3\u00a9tiers de Paris": "Ecole Nationale Sup\u00e9rieure d'Arts et M\u00e9tiers de Paris",
        "Ecole Nationale Sup\u00c3\u00a9rieure de Chimie de Rennes": "Ecole Nationale Sup\u00e9rieure de Chimie de Rennes",
        "Ecole Nationale Sup\u00c3\u00a9rieure de Chimie de Montpellier": "Ecole Nationale Sup\u00e9rieure de Chimie de Montpellier",
        "Ecole Nationale Sup\u00c3\u00a9rieure de l'Electronique et de ses Applications": "Ecole Nationale Sup\u00e9rieure de l'Electronique et de ses Applications",
        "Ecole Nationale Sup\u00c3\u00a9rieure  d'Architecture de Nantes": "Ecole Nationale Sup\u00e9rieure  d'Architecture de Nantes",
        "Ecole Nationale Sup\u00c3\u00a9rieure de Formation de l'Enseignement Agricole - ENSFEA": "Ecole Nationale Sup\u00e9rieure de Formation de l'Enseignement Agricole - ENSFEA",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Ing\u00c3\u00a9nieurs de Caen": "Ecole Nationale Sup\u00e9rieure d'Ing\u00e9nieurs de Caen",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Informatique pour l'Industrie et l'Entreprise": "Ecole Nationale Sup\u00e9rieure d'Informatique pour l'Industrie et l'Entreprise",
        "Ecole Nationale Sup\u00c3\u00a9rieure de M\u00c3\u00a9canique et d'A\u00c3\u00a9rotechnique": "Ecole Nationale Sup\u00e9rieure de M\u00e9canique et d'A\u00e9rotechnique",
        "UNL - Escola Nacional de Sa\u00c3\u00bade P\u00c3\u00bablica": "UNL - Escola Nacional de Sa\u00fade P\u00fablica",
        "ENSTA Paristech - Ecole Nationale Sup\u00c3\u00a9rieure de Techniques Avanc\u00c3\u00a9es": "ENSTA Paristech - Ecole Nationale Sup\u00e9rieure de Techniques Avanc\u00e9es",
        "Ecole Nationale V\u00c3\u00a9t\u00c3\u00a9rinaire de Toulouse": "Ecole Nationale V\u00e9t\u00e9rinaire de Toulouse",
        "Sein\u00c3\u00a4joki University of Applied Sciences": "Sein\u00e4joki University of Applied Sciences",
        "Escuela Polit\u00c3\u00a9cnica Nacional - epn": "Escuela Polit\u00e9cnica Nacional - epn",
        "Escuela Superior de Administraci\u00c3\u00b3n y Direcci\u00c3\u00b3n de Empresas": "Escuela Superior de Administraci\u00f3n y Direcci\u00f3n de Empresas",
        "Ecole d'Ing\u00c3\u00a9nieur La Salle - ESAIP": "Ecole d'Ing\u00e9nieur La Salle - ESAIP",
        "Escola Superior Agr\u00c3\u00a1ria de Viseu": "Escola Superior Agr\u00e1ria de Viseu",
        "Groupe ESC Pau - Etablissement d'Enseignement Sup\u00c3\u00a9rieur de la CCI Pau B\u00c3\u00a9arn": "Groupe ESC Pau - Etablissement d'Enseignement Sup\u00e9rieur de la CCI Pau B\u00e9arn",
        "Escola Superior de Educa\u00c3\u00a7\u00c3\u00a3o de Viseu": "Escola Superior de Educa\u00e7\u00e3o de Viseu",
        "Marie Cederschi\u00c3\u00b6ld University College": "Marie Cederschi\u00f6ld University College",
        "\u00c3\u0089cole sup\u00c3\u00a9rieure d'informatique \u00c3\u00a9lectronique automatique": "\u00c9cole sup\u00e9rieure d'informatique \u00e9lectronique automatique",
        "Ecole Sup\u00c3\u00a9rieure d'Ing\u00c3\u00a9nieurs en G\u00c3\u00a9nie Electrique": "Ecole Sup\u00e9rieure d'Ing\u00e9nieurs en G\u00e9nie Electrique",
        "Ecole Sup\u00c3\u00a9rieure de Physique et de Chimie Industrielles de la Ville de Paris": "Ecole Sup\u00e9rieure de Physique et de Chimie Industrielles de la Ville de Paris",
        "Escola Superior de Tecnologia e Gest\u00c3\u00a3o de Lamego": "Escola Superior de Tecnologia e Gest\u00e3o de Lamego",
        "IPC - Escola Superior de Tecnologia e Gest\u00c3\u00a3o de Oliveira do Hospital": "IPC - Escola Superior de Tecnologia e Gest\u00e3o de Oliveira do Hospital",
        "Escola Superior de Tecnologia e Gest\u00c3\u00a3o de Viseu": "Escola Superior de Tecnologia e Gest\u00e3o de Viseu",
        "\u00c3\u0089cole de technologie sup\u00c3\u00a9rieure": "\u00c9cole de technologie sup\u00e9rieure",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Architecture de Nancy": "Ecole Nationale Sup\u00e9rieure d'Architecture de Nancy",
        "Universit\u00c3\u00a9 Toulouse II Le Mirail": "Universit\u00e9 Toulouse II Le Mirail",
        "Universit\u00c3\u00a9 de la Polyn\u00c3\u00a9sie Fran\u00c3\u00a7aise": "Universit\u00e9 de la Polyn\u00e9sie Fran\u00e7aise",
        "Universit\u00c3\u00a9 Panth\u00c3\u00a9on Assas Paris II": "Universit\u00e9 Panth\u00e9on Assas Paris II",
        "Europa-Universit\u00c3\u00a4t Viadrina": "Europa-Universit\u00e4t Viadrina",
        "Friedrich-Alexander-Universit\u00c3\u00a4t Erlangen-N\u00c3\u00bcrnberg": "Friedrich-Alexander-Universit\u00e4t Erlangen-N\u00fcrnberg",
        "Fundaci\u00c3\u00b3n Colegio Americano Quito - fcaq": "Fundaci\u00f3n Colegio Americano Quito - fcaq",
        "UNL - Faculdade de Ci\u00c3\u00aancias M\u00c3\u00a9dicas": "UNL - Faculdade de Ci\u00eancias M\u00e9dicas",
        "SCAYLE: Supercomputaci\u00c3\u00b3n  Castilla y Le\u00c3\u00b3n": "SCAYLE: Supercomputaci\u00f3n  Castilla y Le\u00f3n",
        "UNL - Faculdade de Ci\u00c3\u00aancias Sociais e Humanas": "UNL - Faculdade de Ci\u00eancias Sociais e Humanas",
        "FCT - Funda\u00c3\u00a7\u00c3\u00a3o para a Ci\u00c3\u00aancia e a Tecnologia": "FCT - Funda\u00e7\u00e3o para a Ci\u00eancia e a Tecnologia",
        "FernUniversit\u00c3\u00a4t in Hagen": "FernUniversit\u00e4t in Hagen",
        "Hochschule D\u00c3\u00bcsseldorf": "Hochschule D\u00fcsseldorf",
        "HWZ - Hochschule f\u00c3\u00bcr Wirtschaft Z\u00c3\u00bcrich": "HWZ - Hochschule f\u00fcr Wirtschaft Z\u00fcrich",
        "TH K\u00c3\u00b6ln (University of Applied Sciences)": "TH K\u00f6ln (University of Applied Sciences)",
        "Wests\u00c3\u00a4chsische Hochschule Zwickau": "Wests\u00e4chsische Hochschule Zwickau",
        "FHGR - Fachhochschule Graub\u00c3\u00bcnden": "FHGR - Fachhochschule Graub\u00fcnden",
        "St. P\u00c3\u00b6lten University of Applied Sciences": "St. P\u00f6lten University of Applied Sciences",
        "Hochschule W\u00c3\u00bcrzburg-Schweinfurt": "Hochschule W\u00fcrzburg-Schweinfurt",
        "Filmakademie Baden-W\u00c3\u00bcrttemberg GmbH": "Filmakademie Baden-W\u00fcrttemberg GmbH",
        "F\u00c4\u00b1rat University": "F\u0131rat University",
        "Leibniz-Forschungsinstitut f\u00c3\u00bcr Molekulare Pharmakologie (FMP)": "Leibniz-Forschungsinstitut f\u00fcr Molekulare Pharmakologie (FMP)",
        "Fraunhofer-Gesellschaft zur F\u00c3\u00b6rderung der angewandten Forschung e. V.": "Fraunhofer-Gesellschaft zur F\u00f6rderung der angewandten Forschung e. V.",
        "Fatih Sultan Mehmet Vak\u00c4\u00b1f University": "Fatih Sultan Mehmet Vak\u0131f University",
        "Freie Universit\u00c3\u00a4t Berlin": "Freie Universit\u00e4t Berlin",
        "Forschungszentrum J\u00c3\u00bclich GmbH": "Forschungszentrum J\u00fclich GmbH",
        "Leibniz-Institut f\u00c3\u00bcr Bildungsmedien": "Leibniz-Institut f\u00fcr Bildungsmedien",
        "GESIS \u00e2\u0080\u0093 Leibniz-Institute for  the Social Sciences": "GESIS \u2013 Leibniz-Institute for  the Social Sciences",
        "GIMNAZIJA BE\u00c5\u00bdIGRAD LJUBLJANA": "GIMNAZIJA BE\u017dIGRAD LJUBLJANA",
        "GIMNAZIJA JO\u00c5\u00bdETA PLE\u00c4\u008cNIKA LJUBLJANA": "GIMNAZIJA JO\u017dETA PLE\u010cNIKA LJUBLJANA",
        "Glasir T\u00c3\u00b3rshavn College": "Glasir T\u00f3rshavn College",
        "GRNET Virtual Home Organization (VHO) for G\u00c3\u0089ANT": "GRNET Virtual Home Organization (VHO) for G\u00c9ANT",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Architecture de Grenoble": "Ecole Nationale Sup\u00e9rieure d'Architecture de Grenoble",
        "Ecole Sup\u00c3\u00a9rieure d'Agriculture d'Angers": "Ecole Sup\u00e9rieure d'Agriculture d'Angers",
        "GSI Helmholtzzentrum f\u00c3\u00bcr Schwerionenforschung GmbH": "GSI Helmholtzzentrum f\u00fcr Schwerionenforschung GmbH",
        "Glasbena \u00c5\u00a1ola Kamnik": "Glasbena \u0161ola Kamnik",
        "\u00c3\u0085land University of Applied Sciences": "\u00c5land University of Applied Sciences",
        "H\u00c3\u00a4me University of Applied Sciences": "H\u00e4me University of Applied Sciences",
        "University of Bor\u00c3\u00a5s": "University of Bor\u00e5s",
        "HafenCity Universit\u00c3\u00a4t Hamburg": "HafenCity Universit\u00e4t Hamburg",
        "Haute \u00c3\u0089cole Bruxelles-Brabant (HE2B)": "Haute \u00c9cole Bruxelles-Brabant (HE2B)",
        "Etablissement Enseignement Sup\u00c3\u00a9rieur Consulaire HEC Paris": "Etablissement Enseignement Sup\u00e9rieur Consulaire HEC Paris",
        "Duale Hochschule Baden-W\u00c3\u00bcrttemberg Heilbronn": "Duale Hochschule Baden-W\u00fcrttemberg Heilbronn",
        "Helmholtz-Gemeinschaft Deutscher Forschungszentren e.V. (Gesch\u00c3\u00a4ftstelle)": "Helmholtz-Gemeinschaft Deutscher Forschungszentren e.V. (Gesch\u00e4ftstelle)",
        "HEP-BEJUNE - Haute Ecole P\u00c3\u00a9dagogique BEJUNE": "HEP-BEJUNE - Haute Ecole P\u00e9dagogique BEJUNE",
        "HEP Vaud - Haute \u00c3\u00a9cole p\u00c3\u00a9dagogique du canton de Vaud": "HEP Vaud - Haute \u00e9cole p\u00e9dagogique du canton de Vaud",
        "HEP-VS - Haute \u00c3\u00a9cole p\u00c3\u00a9dagogique du Valais": "HEP-VS - Haute \u00e9cole p\u00e9dagogique du Valais",
        "HES-SO - Haute Ecole Sp\u00c3\u00a9cialis\u00c3\u00a9e de Suisse occidentale": "HES-SO - Haute Ecole Sp\u00e9cialis\u00e9e de Suisse occidentale",
        "Hochschule f\u00c3\u00bcr bildende K\u00c3\u00bcnste Hamburg": "Hochschule f\u00fcr bildende K\u00fcnste Hamburg",
        "Hochschule f\u00c3\u00bcr Gestaltung Schw\u00c3\u00a4bisch Gm\u00c3\u00bcnd": "Hochschule f\u00fcr Gestaltung Schw\u00e4bisch Gm\u00fcnd",
        "HfH - Interkantonale Hochschule f\u00c3\u00bcr Heilp\u00c3\u00a4dagogik": "HfH - Interkantonale Hochschule f\u00fcr Heilp\u00e4dagogik",
        "Hochschule f\u00c3\u00bcr Musik Weimar": "Hochschule f\u00fcr Musik Weimar",
        "Julius-Maximilians-Universit\u00c3\u00a4t W\u00c3\u00bcrzburg": "Julius-Maximilians-Universit\u00e4t W\u00fcrzburg",
        "Hochschule f\u00c3\u00bcr Musik Saarbr\u00c3\u00bccken": "Hochschule f\u00fcr Musik Saarbr\u00fccken",
        "Hochschule f\u00c3\u00bcr Musik und Tanz K\u00c3\u00b6ln": "Hochschule f\u00fcr Musik und Tanz K\u00f6ln",
        "Hochschule f\u00c3\u00bcr Technik Stuttgart": "Hochschule f\u00fcr Technik Stuttgart",
        "Hochschule f\u00c3\u00bcr Wirtschaft und Umwelt N\u00c3\u00bcrtingen-Geislingen": "Hochschule f\u00fcr Wirtschaft und Umwelt N\u00fcrtingen-Geislingen",
        "Instituto Hidrogr\u00c3\u00a1fico": "Instituto Hidrogr\u00e1fico",
        "University of G\u00c3\u00a4vle": "University of G\u00e4vle",
        "University of Sk\u00c3\u00b6vde": "University of Sk\u00f6vde",
        "J\u00c3\u00b6nk\u00c3\u00b6ping University": "J\u00f6nk\u00f6ping University",
        "Leibniz Institute for Natural Product Research and Infection Biology Hans Kn\u00c3\u00b6ll Institute (HKI)": "Leibniz Institute for Natural Product Research and Infection Biology Hans Kn\u00f6ll Institute (HKI)",
        "Hochschule M\u00c3\u00bcnchen": "Hochschule M\u00fcnchen",
        'Hochschule f\u00c3\u00bcr Musik und Theater "Felix Mendelssohn Bartholdy" Leipzig': 'Hochschule f\u00fcr Musik und Theater "Felix Mendelssohn Bartholdy" Leipzig',
        "Hochschule f\u00c3\u00bcr Musik und Theater M\u00c3\u00bcnchen": "Hochschule f\u00fcr Musik und Theater M\u00fcnchen",
        "Hochschule f\u00c3\u00bcr Gesundheit": "Hochschule f\u00fcr Gesundheit",
        "Hochschule Osnabr\u00c3\u00bcck": "Hochschule Osnabr\u00fcck",
        "Hochschule f\u00c3\u00bcr Polizei und \u00c3\u00b6ffentliche Verwaltung Nordrhein-Westfalen, Gelsenkirchen": "Hochschule f\u00fcr Polizei und \u00f6ffentliche Verwaltung Nordrhein-Westfalen, Gelsenkirchen",
        "Helmut-Schmidt-Universit\u00c3\u00a4t, Universit\u00c3\u00a4t der Bundeswehr Hamburg": "Helmut-Schmidt-Universit\u00e4t, Universit\u00e4t der Bundeswehr Hamburg",
        "Hochschule Zittau / G\u00c3\u00b6rlitz": "Hochschule Zittau / G\u00f6rlitz",
        "Hochschule f\u00c3\u00bcr Technik, Wirtschaft und Kultur Leipzig": "Hochschule f\u00fcr Technik, Wirtschaft und Kultur Leipzig",
        "J\u00c3\u00a1n Albrecht Music and Art Academy": "J\u00e1n Albrecht Music and Art Academy",
        "Fundaci\u00c3\u00b3 i2CAT, Internet i Innovaci\u00c3\u00b3 Digital a Catalunya": "Fundaci\u00f3 i2CAT, Internet i Innovaci\u00f3 Digital a Catalunya",
        "IAC - Instituto Astrof\u00c3\u00ad\u00c2\u00adsico de Canarias": "IAC - Instituto Astrof\u00ed\u00adsico de Canarias",
        "CGIE - Centre de gestion informatique de l'\u00c3\u00a9ducation": "CGIE - Centre de gestion informatique de l'\u00e9ducation",
        "Instituto da Biologia Experimental e Tecnol\u00c3\u00b3gica": "Instituto da Biologia Experimental e Tecnol\u00f3gica",
        "ICFO \u00e2\u0080\u0093 The Institute of Photonic Sciences": "ICFO \u2013 The Institute of Photonic Sciences",
        "Institut du Cerveau et de la Moelle Epini\u00c3\u00a8re": "Institut du Cerveau et de la Moelle Epini\u00e8re",
        "International Film Studies P\u00c3\u00adsek": "International Film Studies P\u00edsek",
        "Leibniz-Institut f\u00c3\u00bcr Deutsche Sprache (IDS)": "Leibniz-Institut f\u00fcr Deutsche Sprache (IDS)",
        "International Fusion Materials Irradiation Facility\u00e2\u0080\u008b DEMO Oriented Neutron Source": "International Fusion Materials Irradiation Facility\u200b DEMO Oriented Neutron Source",
        "Funda\u00c3\u00a7\u00c3\u00a3o Calouste Gulbenkian": "Funda\u00e7\u00e3o Calouste Gulbenkian",
        "Instituto Geof\u00c3\u00adsico de la Escuela Polit\u00c3\u00a9cnica Nacional - igepn": "Instituto Geof\u00edsico de la Escuela Polit\u00e9cnica Nacional - igepn",
        "In\u00c5\u00a1titut Jo\u00c5\u00beef Stefan (IJS)": "In\u0161titut Jo\u017eef Stefan (IJS)",
        "Universidad regional Amaz\u00c3\u00b3nica - ikiam": "Universidad regional Amaz\u00f3nica - ikiam",
        "\u00c4\u00b0stanbul K\u00c3\u00bclt\u00c3\u00bcr University": "\u0130stanbul K\u00fclt\u00fcr University",
        "Institut Mines-T\u00c3\u00a9l\u00c3\u00a9com Business School et T\u00c3\u00a9l\u00c3\u00a9com SudParis": "Institut Mines-T\u00e9l\u00e9com Business School et T\u00e9l\u00e9com SudParis",
        "Institut National d'Etudes D\u00c3\u00a9mographiques": "Institut National d'Etudes D\u00e9mographiques",
        "Instituto Oceanogr\u00c3\u00a1fico y Ant\u00c3\u00a1rtico de la Armada - inocar": "Instituto Oceanogr\u00e1fico y Ant\u00e1rtico de la Armada - inocar",
        "INRS (Institut National de Recherche et de S\u00c3\u00a9curit\u00c3\u00a9)": "INRS (Institut National de Recherche et de S\u00e9curit\u00e9)",
        "Institut National des Sciences Appliqu\u00c3\u00a9es de Lyon": "Institut National des Sciences Appliqu\u00e9es de Lyon",
        "Institut National des Sciences Appliqu\u00c3\u00a9es de Rennes": "Institut National des Sciences Appliqu\u00e9es de Rennes",
        "Institut National des Sciences Appliqu\u00c3\u00a9es de Rouen": "Institut National des Sciences Appliqu\u00e9es de Rouen",
        "Institut National des Sciences Appliqu\u00c3\u00a9es de Strasbourg": "Institut National des Sciences Appliqu\u00e9es de Strasbourg",
        "Institut National des Sciences Appliqu\u00c3\u00a9es de Toulouse": "Institut National des Sciences Appliqu\u00e9es de Toulouse",
        "Instituto Superior Tecnol\u00c3\u00b3gico Luis Rogelio Gonz\u00c3\u00a1lez - insteclrg": "Instituto Superior Tecnol\u00f3gico Luis Rogelio Gonz\u00e1lez - insteclrg",
        "Instituto Nacional de T\u00c3\u00a9cnica Aeroespacial": "Instituto Nacional de T\u00e9cnica Aeroespacial",
        "Duale Hochschule Baden-W\u00c3\u00bcrttemberg Mosbach": "Duale Hochschule Baden-W\u00fcrttemberg Mosbach",
        "Leibniz-Institut f\u00c3\u00bcr Ostseeforschung Warnem\u00c3\u00bcnde": "Leibniz-Institut f\u00fcr Ostseeforschung Warnem\u00fcnde",
        "Instituto Particular Abd\u00c3\u00b3n Calder\u00c3\u00b3n - ipac": "Instituto Particular Abd\u00f3n Calder\u00f3n - ipac",
        "Instituto Polit\u00c3\u00a9cnico de Bragan\u00c3\u00a7a": "Instituto Polit\u00e9cnico de Bragan\u00e7a",
        "IPC - Servi\u00c3\u00a7os da Presid\u00c3\u00aancia": "IPC - Servi\u00e7os da Presid\u00eancia",
        "Instituto Portugu\u00c3\u00aas do Desporto e da Juventude, I.P.": "Instituto Portugu\u00eas do Desporto e da Juventude, I.P.",
        "Instituto Polit\u00c3\u00a9cnico da Guarda": "Instituto Polit\u00e9cnico da Guarda",
        "Instituto Polit\u00c3\u00a9cnico da Lusofonia": "Instituto Polit\u00e9cnico da Lusofonia",
        "Polytechnic Institute of Santar\u00c3\u00a9m": "Polytechnic Institute of Santar\u00e9m",
        "Instituto Polit\u00c3\u00a9cnico de Tomar": "Instituto Polit\u00e9cnico de Tomar",
        "Instituto Polit\u00c3\u00a9cnico de Viana do Castelo": "Instituto Polit\u00e9cnico de Viana do Castelo",
        "IRAM - Institut de Radioastronomie Millim\u00c3\u00a9trique": "IRAM - Institut de Radioastronomie Millim\u00e9trique",
        "Institut de Recherche pour le D\u00c3\u00a9veloppement": "Institut de Recherche pour le D\u00e9veloppement",
        "Institut Sup\u00c3\u00a9rieur de l'A\u00c3\u00a9ronautique et de l'Espace": "Institut Sup\u00e9rieur de l'A\u00e9ronautique et de l'Espace",
        "Leibniz-Institut f\u00c3\u00bcr Analytische Wissenschaften - ISAS - e.V..": "Leibniz-Institut f\u00fcr Analytische Wissenschaften - ISAS - e.V..",
        "IPC - Instituto Superior de Contabilidade e Administra\u00c3\u00a7\u00c3\u00a3o de Coimbra": "IPC - Instituto Superior de Contabilidade e Administra\u00e7\u00e3o de Coimbra",
        "UNL - Instituto Superior de Estat\u00c3\u00adsticas e Gest\u00c3\u00a3o Informa\u00c3\u00a7\u00c3\u00a3o": "UNL - Instituto Superior de Estat\u00edsticas e Gest\u00e3o Informa\u00e7\u00e3o",
        "ISPA - Instituto Universit\u00c3\u00a1rio de Ci\u00c3\u00aancias Psicol\u00c3\u00b3gicas": "ISPA - Instituto Universit\u00e1rio de Ci\u00eancias Psicol\u00f3gicas",
        "Instituto Tecnol\u00c3\u00b3gico Superior Rumi\u00c3\u00b1ahui - ister": "Instituto Tecnol\u00f3gico Superior Rumi\u00f1ahui - ister",
        "Instituto Superior Tecnol\u00c3\u00b3gico Vida Nueva - istvidanueva": "Instituto Superior Tecnol\u00f3gico Vida Nueva - istvidanueva",
        "Instituto Tecnol\u00c3\u00b3gico Agrario de Castilla y Le\u00c3\u00b3n": "Instituto Tecnol\u00f3gico Agrario de Castilla y Le\u00f3n",
        "Instituto Universit\u00c3\u00a1rio Militar": "Instituto Universit\u00e1rio Militar",
        "In\u00c5\u00a1titut informacijskih znanosti - IZUM": "In\u0161titut informacijskih znanosti - IZUM",
        "Jyv\u00c3\u00a4skyl\u00c3\u00a4 University of Applied Sciences": "Jyv\u00e4skyl\u00e4 University of Applied Sciences",
        "J. Heyrovsk\u00c3\u00bd Institute of Physical Chemistry of the CAS, v.v.i.": "J. Heyrovsk\u00fd Institute of Physical Chemistry of the CAS, v.v.i.",
        "University of Jyv\u00c3\u00a4skyla": "University of Jyv\u00e4skyla",
        "Royal Danish Academy \u00e2\u0080\u0093 Architecture, Design, Conservation": "Royal Danish Academy \u2013 Architecture, Design, Conservation",
        "Kaposv\u00c3\u00a1r University": "Kaposv\u00e1r University",
        "Regional Library Zl\u00c3\u00adn": "Regional Library Zl\u00edn",
        "Katholische Hochschule f\u00c3\u00bcr Sozialwesen Berlin": "Katholische Hochschule f\u00fcr Sozialwesen Berlin",
        "Co\u00c3\u00b6peratie KIEN": "Co\u00f6peratie KIEN",
        "Jan Drda\u00c2\u00b4s Library": "Jan Drda\u00b4s Library",
        "Ji\u00c5\u0099\u00c3\u00ad Mahen Library in Brno": "Ji\u0159\u00ed Mahen Library in Brno",
        "Regional Library Vyso\u00c4\u008dina": "Regional Library Vyso\u010dina",
        "Municipal Library Jind\u00c5\u0099ich\u00c5\u00afv Hradec": "Municipal Library Jind\u0159ich\u016fv Hradec",
        "Municipal Library Bene\u00c5\u00a1ov": "Municipal Library Bene\u0161ov",
        "Municipal Library \u00c4\u008cesk\u00c3\u00a1 L\u00c3\u00adpa": "Municipal Library \u010cesk\u00e1 L\u00edpa",
        "Municipal Library Kutn\u00c3\u00a1 Hora": "Municipal Library Kutn\u00e1 Hora",
        "Municipal Library \u00c3\u009ast\u00c3\u00ad nad Orlic\u00c3\u00ad": "Municipal Library \u00dast\u00ed nad Orlic\u00ed",
        "Municipal Library Hole\u00c5\u00a1ov": "Municipal Library Hole\u0161ov",
        "Municipal Library Choce\u00c5\u0088": "Municipal Library Choce\u0148",
        "Municipal Library Fren\u00c5\u00a1t\u00c3\u00a1t pod Radho\u00c5\u00a1t\u00c4\u009bm": "Municipal Library Fren\u0161t\u00e1t pod Radho\u0161t\u011bm",
        "Municipal Library and Information centre of Hradec nad Moravic\u00c3\u00ad": "Municipal Library and Information centre of Hradec nad Moravic\u00ed",
        "Municipal Library Jarom\u00c4\u009br": "Municipal Library Jarom\u011br",
        "Municipal Library Kol\u00c3\u00adn": "Municipal Library Kol\u00edn",
        "Municipal Library P\u00c5\u0099erov": "Municipal Library P\u0159erov",
        "Municipal Library Prost\u00c4\u009bjov": "Municipal Library Prost\u011bjov",
        "Municipal Library T\u00c3\u00a1bor": "Municipal Library T\u00e1bor",
        "Municipal Library in T\u00c5\u0099eb\u00c3\u00ad\u00c4\u008d": "Municipal Library in T\u0159eb\u00ed\u010d",
        "Library in T\u00c5\u0099inec": "Library in T\u0159inec",
        "Kodol\u00c3\u00a1nyi J\u00c3\u00a1nos University": "Kodol\u00e1nyi J\u00e1nos University",
        "District Library of Petr Bezru\u00c4\u008d in Opava": "District Library of Petr Bezru\u010d in Opava",
        "K\u00c3\u00a1roli G\u00c3\u00a1sp\u00c3\u00a1r University of the Reformed Church in Hungary": "K\u00e1roli G\u00e1sp\u00e1r University of the Reformed Church in Hungary",
        "Franti\u00c5\u00a1ek Krizik Grammar School and Primary School, s.r.o.": "Franti\u0161ek Krizik Grammar School and Primary School, s.r.o.",
        "K\u00c3\u00bctahya Health Sciences University": "K\u00fctahya Health Sciences University",
        "Katholische Stiftungsfachhochschule M\u00c3\u00bcnchen": "Katholische Stiftungsfachhochschule M\u00fcnchen",
        "Catholic University of Eichst\u00c3\u00a4tt-Ingolstadt": "Catholic University of Eichst\u00e4tt-Ingolstadt",
        "Kunstakademie D\u00c3\u00bcsseldorf": "Kunstakademie D\u00fcsseldorf",
        "Kunstakademie M\u00c3\u00bcnster - University of fine arts M\u00c3\u00bcnster": "Kunstakademie M\u00fcnster - University of fine arts M\u00fcnster",
        "Bucerius Law School - Hochschule f\u00c3\u00bcr Rechtswissenschaft gGmbH": "Bucerius Law School - Hochschule f\u00fcr Rechtswissenschaft gGmbH",
        "Universit\u00c3\u00a9 de Bourgogne": "Universit\u00e9 de Bourgogne",
        "Leu\u00c2\u00adpha\u00c2\u00adna Uni\u00c2\u00adver\u00c2\u00adsi\u00c2\u00adty of L\u00c3\u00bcne\u00c2\u00adburg": "Leu\u00adpha\u00adna Uni\u00adver\u00adsi\u00adty of L\u00fcne\u00adburg",
        "Laborat\u00c3\u00b3rio de Instrumenta\u00c3\u00a7\u00c3\u00a3o e F\u00c3\u00adsica Experimental de Part\u00c3\u00adculas": "Laborat\u00f3rio de Instrumenta\u00e7\u00e3o e F\u00edsica Experimental de Part\u00edculas",
        "Link\u00c3\u00b6ping University": "Link\u00f6ping University",
        "General Jonas \u00c5\u00bdemaitis Military Academy of Lithuania": "General Jonas \u017demaitis Military Academy of Lithuania",
        "Laborat\u00c3\u00b3rio Nacional de Engenharia Civil": "Laborat\u00f3rio Nacional de Engenharia Civil",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Architecture de Lyon": "Ecole Nationale Sup\u00e9rieure d'Architecture de Lyon",
        "Malm\u00c3\u00b6 University": "Malm\u00f6 University",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Architecture de Paris-Est": "Ecole Nationale Sup\u00e9rieure d'Architecture de Paris-Est",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Architecture de Marseille": "Ecole Nationale Sup\u00e9rieure d'Architecture de Marseille",
        "Max Delbr\u00c3\u00bcck Center for Molecular Medicine": "Max Delbr\u00fcck Center for Molecular Medicine",
        "M\u00c3\u00a4lardalen University": "M\u00e4lardalen University",
        "Ecole Nationale Sup\u00c3\u00a9rieure des Mines de Paris": "Ecole Nationale Sup\u00e9rieure des Mines de Paris",
        "Max-Planck-Institut f\u00c3\u00bcr Mathematik in den Naturwissenschaften": "Max-Planck-Institut f\u00fcr Mathematik in den Naturwissenschaften",
        "M\u00c3\u00a1xima MC": "M\u00e1xima MC",
        "Mus\u00c3\u00a9um National d'Histoire Naturelle": "Mus\u00e9um National d'Histoire Naturelle",
        "Max-Planck-Gesellschaft zur F\u00c3\u00b6rderung der Wissenschaften e.V., Administrations": "Max-Planck-Gesellschaft zur F\u00f6rderung der Wissenschaften e.V., Administrations",
        "Max-Planck-Institut f\u00c3\u00bcr Kohlenforschung": "Max-Planck-Institut f\u00fcr Kohlenforschung",
        "Ministry of Science, Research and the Arts of Baden-W\u00c3\u00bcrttemberg": "Ministry of Science, Research and the Arts of Baden-W\u00fcrttemberg",
        "Norwich\u00c2\u00a0Bioscience\u00c2\u00a0Institutes\u00c2\u00a0(SSO)": "Norwich\u00a0Bioscience\u00a0Institutes\u00a0(SSO)",
        "T\u00c5\u0099eb\u00c3\u00ad\u00c4\u008d Hospital": "T\u0159eb\u00ed\u010d Hospital",
        "Nemocnice Pardubick\u00c3\u00a9ho kraje": "Nemocnice Pardubick\u00e9ho kraje",
        "Doba Fakulteta za uporabne poslovne in dru\u00c5\u00bebene \u00c5\u00a1tudije Maribor": "Doba Fakulteta za uporabne poslovne in dru\u017ebene \u0161tudije Maribor",
        "Normandie Universit\u00c3\u00a9": "Normandie Universit\u00e9",
        "Observatoire de la C\u00c3\u00b4te d'Azur": "Observatoire de la C\u00f4te d'Azur",
        "Ni\u00c4\u009fde \u00c3\u0096mer Halisdemir University": "Ni\u011fde \u00d6mer Halisdemir University",
        "Ondokuz May\u00c4\u00b1s University": "Ondokuz May\u0131s University",
        "Ecole Nationale V\u00c3\u00a9t\u00c3\u00a9rinaire Agroalimentaire et de l'Alimentation Nantes Atlantique": "Ecole Nationale V\u00e9t\u00e9rinaire Agroalimentaire et de l'Alimentation Nantes Atlantique",
        "Jewish Theological Seminary \u00e2\u0080\u0093 University of Jewish Studies": "Jewish Theological Seminary \u2013 University of Jewish Studies",
        "National Sz\u00c3\u00a9ch\u00c3\u00a9nyi Library": "National Sz\u00e9ch\u00e9nyi Library",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Architecture de Paris - La Villette": "Ecole Nationale Sup\u00e9rieure d'Architecture de Paris - La Villette",
        "Sorbonne Universit\u00c3\u00a9": "Sorbonne Universit\u00e9",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Architecture Paris Val de Seine": "Ecole Nationale Sup\u00e9rieure d'Architecture Paris Val de Seine",
        "Universit\u00c3\u00a9 de Paris": "Universit\u00e9 de Paris",
        "Universit\u00c3\u00a9 de Paris 10 Nanterre": "Universit\u00e9 de Paris 10 Nanterre",
        "Gda\u00c5\u0084sk University of Technology": "Gda\u0144sk University of Technology",
        "P\u00c3\u00a4dagogische Hochschule Freiburg": "P\u00e4dagogische Hochschule Freiburg",
        "University of Education Schw\u00c3\u00a4bisch Gm\u00c3\u00bcnd": "University of Education Schw\u00e4bisch Gm\u00fcnd",
        "PHGR - University of Teacher Education Graub\u00c3\u00bcnden": "PHGR - University of Teacher Education Graub\u00fcnden",
        "P\u00c3\u00a4dagogische Hochschule Heidelberg": "P\u00e4dagogische Hochschule Heidelberg",
        "PHBern - P\u00c3\u00a4dagogische Hochschule Bern": "PHBern - P\u00e4dagogische Hochschule Bern",
        "PHLU - P\u00c3\u00a4dagogische Hochschule Luzern": "PHLU - P\u00e4dagogische Hochschule Luzern",
        "PHSG - P\u00c3\u00a4dagogische Hochschule St.Gallen": "PHSG - P\u00e4dagogische Hochschule St.Gallen",
        "PHSZ - P\u00c3\u00a4dagogische Hochschule Schwyz": "PHSZ - P\u00e4dagogische Hochschule Schwyz",
        "PHTG - P\u00c3\u00a4dagogische Hochschule Thurgau": "PHTG - P\u00e4dagogische Hochschule Thurgau",
        "PH Zug - P\u00c3\u00a4dagogische Hochschule Zug": "PH Zug - P\u00e4dagogische Hochschule Zug",
        "PH Z\u00c3\u00bcrich - P\u00c3\u00a4dagogische Hochschule Z\u00c3\u00bcrich": "PH Z\u00fcrich - P\u00e4dagogische Hochschule Z\u00fcrich",
        "Port d'Informaci\u00c3\u00b3 Cient\u00c3\u00adfica": "Port d'Informaci\u00f3 Cient\u00edfica",
        "Polytechnique Montr\u00c3\u00a9al": "Polytechnique Montr\u00e9al",
        "Episcopal Theological College of P\u00c3\u00a9cs": "Episcopal Theological College of P\u00e9cs",
        "P\u00c3\u00a1zm\u00c3\u00a1ny P\u00c3\u00a9ter Catholic University": "P\u00e1zm\u00e1ny P\u00e9ter Catholic University",
        "IPV - Servi\u00c3\u00a7os da Presid\u00c3\u00aancia": "IPV - Servi\u00e7os da Presid\u00eancia",
        "Universit\u00c3\u00a9 Paris Sciences et Lettres": "Universit\u00e9 Paris Sciences et Lettres",
        "University of P\u00c3\u00a9cs": "University of P\u00e9cs",
        "Pontificia Universidad Cat\u00c3\u00b3lica del Ecuador Quito - puce": "Pontificia Universidad Cat\u00f3lica del Ecuador Quito - puce",
        "Pontificia Universidad Cat\u00c3\u00b3lica del Ecuador Ambato - pucesa": "Pontificia Universidad Cat\u00f3lica del Ecuador Ambato - pucesa",
        "Pontificia Universidad Catolica del Ecuador\u00c2\u00a0 Ibarra - pucesi": "Pontificia Universidad Catolica del Ecuador\u00a0 Ibarra - pucesi",
        "RAE - Real Academia Espa\u00c3\u00b1ola": "RAE - Real Academia Espa\u00f1ola",
        "Alfr\u00c3\u00a9d R\u00c3\u00a9nyi Institute of Mathematics": "Alfr\u00e9d R\u00e9nyi Institute of Mathematics",
        "Rheinische Fachhochschule K\u00c3\u00b6ln gGmbH": "Rheinische Fachhochschule K\u00f6ln gGmbH",
        "Ferenc II. R\u00c3\u00a1k\u00c3\u00b3czi County and City Library": "Ferenc II. R\u00e1k\u00f3czi County and City Library",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Architecture de Normandie": "Ecole Nationale Sup\u00e9rieure d'Architecture de Normandie",
        "Reykjav\u00c3\u00adk University": "Reykjav\u00edk University",
        "Rheinisch-Westf\u00c3\u00a4lische Technische Hochschule Aachen": "Rheinisch-Westf\u00e4lische Technische Hochschule Aachen",
        "Unidad Educativa Salesiana San Jos\u00c3\u00a9 - sanjosemanta": "Unidad Educativa Salesiana San Jos\u00e9 - sanjosemanta",
        "\u00c5\u00a0KODA AUTO University": "\u0160KODA AUTO University",
        "\u00c5\u00a0OLSKI CENTER NOVO MESTO": "\u0160OLSKI CENTER NOVO MESTO",
        "\u00c5\u00a0OLSKI CENTER PTUJ": "\u0160OLSKI CENTER PTUJ",
        "Universit\u00c3\u00a9 de Toulon": "Universit\u00e9 de Toulon",
        "Secretaria Geral da Educa\u00c3\u00a7\u00c3\u00a3o e Ci\u00c3\u00aancia": "Secretaria Geral da Educa\u00e7\u00e3o e Ci\u00eancia",
        "Service Hydrographique et Oc\u00c3\u00a9anographique de la Marine SHOM": "Service Hydrographique et Oc\u00e9anographique de la Marine SHOM",
        "\u00c5\u009ei\u00c5\u009fli Vocational School": "\u015ei\u015fli Vocational School",
        "National Gallery of Denmark \u00e2\u0080\u0093 SMK": "National Gallery of Denmark \u2013 SMK",
        "HTBLVA f\u00c3\u00bcr Textilindustrie und Informatik": "HTBLVA f\u00fcr Textilindustrie und Informatik",
        "S\u00c3\u00a1rospataki Reform\u00c3\u00a1tus Teol\u00c3\u00b3giai Akad\u00c3\u00a9mia": "S\u00e1rospataki Reform\u00e1tus Teol\u00f3giai Akad\u00e9mia",
        "Pontificia Universidad Cat\u00c3\u00b3lica de Chile": "Pontificia Universidad Cat\u00f3lica de Chile",
        "Ecoles de Saint-Cyr Co\u00c3\u00abtquidan": "Ecoles de Saint-Cyr Co\u00ebtquidan",
        "State and University Library \u00e2\u0080\u0093 employees": "State and University Library \u2013 employees",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Architecture de Strasbourg": "Ecole Nationale Sup\u00e9rieure d'Architecture de Strasbourg",
        "Europa-Universit\u00c3\u00a4t Flensburg": "Europa-Universit\u00e4t Flensburg",
        "S\u00c3\u00b6dert\u00c3\u00b6rn University": "S\u00f6dert\u00f6rn University",
        "The Research Library in Hradec Kr\u00c3\u00a1lov\u00c3\u00a9": "The Research Library in Hradec Kr\u00e1lov\u00e9",
        "\u00c3\u009ast\u00c3\u00ad Regional Library": "\u00dast\u00ed Regional Library",
        "Sz\u00c3\u00a9chenyi Istv\u00c3\u00a1n Egyetem": "Sz\u00e9chenyi Istv\u00e1n Egyetem",
        "ULisboa - Instituto Superior T\u00c3\u00a9cnico": "ULisboa - Instituto Superior T\u00e9cnico",
        "Instituto Tecnol\u00c3\u00b3gico Superior Jos\u00c3\u00a9 Chiriboga Grijalva - tecnologicoitca": "Instituto Tecnol\u00f3gico Superior Jos\u00e9 Chiriboga Grijalva - tecnologicoitca",
        "Instituto Superior Tecn\u00c3\u00b3logico  Honorable Consejo Provincial de Pichincha - tecnologicopichincha": "Instituto Superior Tecn\u00f3logico  Honorable Consejo Provincial de Pichincha - tecnologicopichincha",
        "FTL - Facolt\u00c3\u00a0 di Teologia di Lugano": "FTL - Facolt\u00e0 di Teologia di Lugano",
        "Tecnol\u00c3\u00b3gico Esp\u00c3\u00adritu Santo - tes": "Tecnol\u00f3gico Esp\u00edritu Santo - tes",
        "TH L\u00c3\u00bcbeck  - University of Applied Sciences": "TH L\u00fcbeck  - University of Applied Sciences",
        "Technische Hochschule N\u00c3\u00bcrnberg Georg Simon Ohm": "Technische Hochschule N\u00fcrnberg Georg Simon Ohm",
        "Alexander Dub\u00c4\u008dek University of Tren\u00c4\u008d\u00c3\u00adn": "Alexander Dub\u010dek University of Tren\u010d\u00edn",
        "Ecole Nationale Sup\u00c3\u00a9rieure d'Architecture de Toulouse": "Ecole Nationale Sup\u00e9rieure d'Architecture de Toulouse",
        "Technische Universit\u00c3\u00a4t Berlin": "Technische Universit\u00e4t Berlin",
        "Technische Universit\u00c3\u00a4t Braunschweig": "Technische Universit\u00e4t Braunschweig",
        "Technische Universit\u00c3\u00a4t Chemnitz": "Technische Universit\u00e4t Chemnitz",
        "Technische Universit\u00c3\u00a4t Clausthal": "Technische Universit\u00e4t Clausthal",
        "Technische Universit\u00c3\u00a4t Dortmund": "Technische Universit\u00e4t Dortmund",
        "Technische Universit\u00c3\u00a4t Dresden": "Technische Universit\u00e4t Dresden",
        "Technische Universit\u00c3\u00a4t Bergakademie Freiberg": "Technische Universit\u00e4t Bergakademie Freiberg",
        "Technische Universit\u00c3\u00a4t Ilmenau": "Technische Universit\u00e4t Ilmenau",
        "Gheorghe Asachi Technical University of Ia\u00c5\u009fi - TUIASI": "Gheorghe Asachi Technical University of Ia\u015fi - TUIASI",
        "Technical University of Ko\u00c5\u00a1ice": "Technical University of Ko\u0161ice",
        "Universit\u00c3\u00a9 Michel de Montaigne Bordeaux 3": "Universit\u00e9 Michel de Montaigne Bordeaux 3",
        "Universit\u00c3\u00a9 de Bordeaux": "Universit\u00e9 de Bordeaux",
        "Universit\u00c3\u00a9 de Cergy-Pontoise": "Universit\u00e9 de Cergy-Pontoise",
        "Universit\u00c3\u00a9 de Paris 12 - Val-de-Marne": "Universit\u00e9 de Paris 12 - Val-de-Marne",
        "Universit\u00c3\u00a9 de Picardie Jules Verne": "Universit\u00e9 de Picardie Jules Verne",
        "Universit\u00c3\u00a9 Paris Sud 11": "Universit\u00e9 Paris Sud 11",
        "Universitat Aut\u00c3\u00b3noma de Barcelona": "Universitat Aut\u00f3noma de Barcelona",
        "Universidade dos A\u00c3\u00a7ores": "Universidade dos A\u00e7ores",
        "Universidad de Alcal\u00c3\u00a1": "Universidad de Alcal\u00e1",
        "Universidad de Almer\u00c3\u00ada": "Universidad de Almer\u00eda",
        "Universidade Aut\u00c3\u00b3noma de Lisboa": "Universidade Aut\u00f3noma de Lisboa",
        "Universidad Aut\u00c3\u00b3noma de Madrid": "Universidad Aut\u00f3noma de Madrid",
        "Atl\u00c3\u00a2ntica - Instituto Universit\u00c3\u00a1rio": "Atl\u00e2ntica - Instituto Universit\u00e1rio",
        "Universidad de C\u00c3\u00a1diz": "Universidad de C\u00e1diz",
        "Universit\u00c3\u00a9 Clermont Auvergne": "Universit\u00e9 Clermont Auvergne",
        "Universit\u00c3\u00a9 Catholique de Lyon AFPICL | UCLY (Association des Fondateurs et Protecteurs  de l'Institu": "Universit\u00e9 Catholique de Lyon AFPICL | UCLY (Association des Fondateurs et Protecteurs  de l'Institu",
        "Universidad de C\u00c3\u00b3rdoba": "Universidad de C\u00f3rdoba",
        "Universit\u00c3\u00a9 Catholique de l'Ouest": "Universit\u00e9 Catholique de l'Ouest",
        "Universidad Cat\u00c3\u00b3lica de Valencia": "Universidad Cat\u00f3lica de Valencia",
        "Universidade da Coru\u00c3\u00b1a": "Universidade da Coru\u00f1a",
        "Universidad Estatal Amaz\u00c3\u00b3nica - uea": "Universidad Estatal Amaz\u00f3nica - uea",
        "Unidad Educativa Salesiana Mar\u00c3\u00ada Auxiliadora Esmeraldas - uesmae": "Unidad Educativa Salesiana Mar\u00eda Auxiliadora Esmeraldas - uesmae",
        "University of \u00c3\u0089vora": "University of \u00c9vora",
        "University of Gda\u00c5\u0084sk": "University of Gda\u0144sk",
        "Universit\u00c3\u00a9 de Mulhouse - Haute-Alsace": "Universit\u00e9 de Mulhouse - Haute-Alsace",
        "Universit\u00c3\u00a9 Rennes 2": "Universit\u00e9 Rennes 2",
        "Jagiellonian University in Krak\u00c3\u00b3w": "Jagiellonian University in Krak\u00f3w",
        "Universidad de Ja\u00c3\u00a9n": "Universidad de Ja\u00e9n",
        "Universit\u00c3\u00a4tsklinikum W\u00c3\u00bcrzburg": "Universit\u00e4tsklinikum W\u00fcrzburg",
        "Universit\u00c3\u00a9 Laval": "Universit\u00e9 Laval",
        "Universidad Laica Eloy Alfaro de Manab\u00c3\u00ad - uleam": "Universidad Laica Eloy Alfaro de Manab\u00ed - uleam",
        "Universidad Loyola de Andaluc\u00c3\u00ad\u00c2\u00ada": "Universidad Loyola de Andaluc\u00ed\u00ada",
        "Universidade Lus\u00c3\u00adada": "Universidade Lus\u00edada",
        "Universidade Lus\u00c3\u00b3fona": "Universidade Lus\u00f3fona",
        "Universidad Miguel Hern\u00c3\u00a1ndez de Elche": "Universidad Miguel Hern\u00e1ndez de Elche",
        "Universit\u00c3\u00a9 de Moncton": "Universit\u00e9 de Moncton",
        "Universit\u00c3\u00a9 de Montpellier": "Universit\u00e9 de Montpellier",
        "Universit\u00c3\u00a9 de Montr\u00c3\u00a9al": "Universit\u00e9 de Montr\u00e9al",
        "Ume\u00c3\u00a5 University": "Ume\u00e5 University",
        "Rheinische Friedrich-Wilhelms-Universit\u00c3\u00a4t Bonn": "Rheinische Friedrich-Wilhelms-Universit\u00e4t Bonn",
        "Universit\u00c3\u00a4t Duisburg-Essen": "Universit\u00e4t Duisburg-Essen",
        "Eszterh\u00c3\u00a1zy K\u00c3\u00a1roly Catholic University": "Eszterh\u00e1zy K\u00e1roly Catholic University",
        "Johann Wolfgang Goethe-Universit\u00c3\u00a4t Frankfurt am Main": "Johann Wolfgang Goethe-Universit\u00e4t Frankfurt am Main",
        "Albert-Ludwigs-Universit\u00c3\u00a4t Freiburg": "Albert-Ludwigs-Universit\u00e4t Freiburg",
        "Georg-August-Universit\u00c3\u00a4t G\u00c3\u00b6ttingen": "Georg-August-Universit\u00e4t G\u00f6ttingen",
        "Universit\u00c3\u00a4t Greifswald": "Universit\u00e4t Greifswald",
        "Martin-Luther-Universit\u00c3\u00a4t Halle-Wittenberg": "Martin-Luther-Universit\u00e4t Halle-Wittenberg",
        "Stiftung Universit\u00c3\u00a4t Hildesheim": "Stiftung Universit\u00e4t Hildesheim",
        "Universit\u00c3\u00a4t Hohenheim": "Universit\u00e4t Hohenheim",
        "Friedrich-Schiller-Universit\u00c3\u00a4t Jena": "Friedrich-Schiller-Universit\u00e4t Jena",
        "Universit\u00c3\u00a4t Kassel": "Universit\u00e4t Kassel",
        "Christian-Albrechts-Universit\u00c3\u00a4t zu Kiel": "Christian-Albrechts-Universit\u00e4t zu Kiel",
        "Westf\u00c3\u00a4lische Wilhelms-Universit\u00c3\u00a4t M\u00c3\u00bcnster": "Westf\u00e4lische Wilhelms-Universit\u00e4t M\u00fcnster",
        "Carl von Ossietzky Universit\u00c3\u00a4t Oldenburg": "Carl von Ossietzky Universit\u00e4t Oldenburg",
        "Universit\u00c3\u00a4t Osnabr\u00c3\u00bcck": "Universit\u00e4t Osnabr\u00fcck",
        "Universit\u00c3\u00a4t Passau": "Universit\u00e4t Passau",
        "Universit\u00c3\u00a4t Ulm": "Universit\u00e4t Ulm",
        "Bauhaus-Universit\u00c3\u00a4t Weimar": "Bauhaus-Universit\u00e4t Weimar",
        "Universit\u00c3\u00a4t Witten/Herdecke": "Universit\u00e4t Witten/Herdecke",
        "Universit\u00c3\u00a4t Liechtenstein": "Universit\u00e4t Liechtenstein",
        "Evang\u00c3\u00a9likus Hittudom\u00c3\u00a1nyi Egyetem": "Evang\u00e9likus Hittudom\u00e1nyi Egyetem",
        "Universit\u00c3\u00a4t Basel": "Universit\u00e4t Basel",
        "Universit\u00c3\u00a4t Bern": "Universit\u00e4t Bern",
        "Universit\u00c3\u00a9 de Caen Normandie": "Universit\u00e9 de Caen Normandie",
        "Universit\u00c3\u00a9 C\u00c3\u00b4te d'Azur": "Universit\u00e9 C\u00f4te d'Azur",
        "Universit\u00c3\u00a9 de Gen\u00c3\u00a8ve": "Universit\u00e9 de Gen\u00e8ve",
        "Universidad de Le\u00c3\u00b3n": "Universidad de Le\u00f3n",
        "Universit\u00c3\u00a9 de Limoges": "Universit\u00e9 de Limoges",
        "Universit\u00c3\u00a4t Luzern": "Universit\u00e4t Luzern",
        "Universit\u00c3\u00a9 de N\u00c3\u00aemes": "Universit\u00e9 de N\u00eemes",
        "IdP - Universit\u00c3\u00a0 degli studi del Molise": "IdP - Universit\u00e0 degli studi del Molise",
        "Universit\u00c3\u00a9 de Neuch\u00c3\u00a2tel": "Universit\u00e9 de Neuch\u00e2tel",
        "Universit\u00c3\u00a0 degli Studi Internazionali di Roma - UNINT": "Universit\u00e0 degli Studi Internazionali di Roma - UNINT",
        "Universit\u00c3\u00a4t St. Gallen": "Universit\u00e4t St. Gallen",
        "Universit\u00c3\u00a0 della Svizzera italiana": "Universit\u00e0 della Svizzera italiana",
        "Universit\u00c3\u00a0 Vita-Salute San Raffaele": "Universit\u00e0 Vita-Salute San Raffaele",
        "Universit\u00c3\u00a9 de Strasbourg": "Universit\u00e9 de Strasbourg",
        "Szent P\u00c3\u00a1l Akad\u00c3\u00a9mia": "Szent P\u00e1l Akad\u00e9mia",
        "Aix-Marseille Universit\u00c3\u00a9 (AMU)": "Aix-Marseille Universit\u00e9 (AMU)",
        "Universit\u00c3\u00a9 d'Angers": "Universit\u00e9 d'Angers",
        "Universit\u00c3\u00a9 des Antilles - Site Martinique": "Universit\u00e9 des Antilles - Site Martinique",
        "Universit\u00c3\u00a9 d'Artois": "Universit\u00e9 d'Artois",
        "Universit\u00c3\u00a9 d'Avignon et des Pays du Vaucluse": "Universit\u00e9 d'Avignon et des Pays du Vaucluse",
        "Universit\u00c3\u00a9 de Corse": "Universit\u00e9 de Corse",
        "Universit\u00c3\u00a9 de Franche-Comt\u00c3\u00a9 - Besan\u00c3\u00a7on": "Universit\u00e9 de Franche-Comt\u00e9 - Besan\u00e7on",
        "Universit\u00c3\u00a9 Grenoble Alpes": "Universit\u00e9 Grenoble Alpes",
        "Universit\u00c3\u00a9 de Guyane": "Universit\u00e9 de Guyane",
        "Institut National Universitaire Jean-Fran\u00c3\u00a7ois Champollion": "Institut National Universitaire Jean-Fran\u00e7ois Champollion",
        "Universit\u00c3\u00a9 du Havre": "Universit\u00e9 du Havre",
        "Universit\u00c3\u00a9 du Maine": "Universit\u00e9 du Maine",
        "Universit\u00c3\u00a9 de Lille": "Universit\u00e9 de Lille",
        "Universit\u00c3\u00a9 de Lorraine": "Universit\u00e9 de Lorraine",
        "La Rochelle Universit\u00c3\u00a9": "La Rochelle Universit\u00e9",
        "Universit\u00c3\u00a9 Claude Bernard - Lyon 1": "Universit\u00e9 Claude Bernard - Lyon 1",
        "Universit\u00c3\u00a9 Lumi\u00c3\u00a8re Lyon 2": "Universit\u00e9 Lumi\u00e8re Lyon 2",
        "Universit\u00c3\u00a9 Jean Moulin - Lyon 3": "Universit\u00e9 Jean Moulin - Lyon 3",
        "Universit\u00c3\u00a9 de Montpellier 3 - Paul Val\u00c3\u00a9ry": "Universit\u00e9 de Montpellier 3 - Paul Val\u00e9ry",
        "Universit\u00c3\u00a9 de Nantes": "Universit\u00e9 de Nantes",
        "Universit\u00c3\u00a9 d'Orl\u00c3\u00a9ans": "Universit\u00e9 d'Orl\u00e9ans",
        "Universit\u00c3\u00a9 Paris 1 - Panth\u00c3\u00a9on Sorbonne": "Universit\u00e9 Paris 1 - Panth\u00e9on Sorbonne",
        "Universit\u00c3\u00a9 Paris 13": "Universit\u00e9 Paris 13",
        "Universit\u00c3\u00a9 Sorbonne nouvelle Paris III": "Universit\u00e9 Sorbonne nouvelle Paris III",
        "Universit\u00c3\u00a9 de Paris 8": "Universit\u00e9 de Paris 8",
        "Universit\u00c3\u00a9 de Pau et des Pays de l'Adour": "Universit\u00e9 de Pau et des Pays de l'Adour",
        "Universit\u00c3\u00a9 de Perpignan": "Universit\u00e9 de Perpignan",
        "Universit\u00c3\u00a9 de Poitiers": "Universit\u00e9 de Poitiers",
        "Universit\u00c3\u00a9 de Reims - Champagne-Ardenne": "Universit\u00e9 de Reims - Champagne-Ardenne",
        "Universit\u00c3\u00a9 de Rennes": "Universit\u00e9 de Rennes",
        "Universit\u00c3\u00a9 de La R\u00c3\u00a9union": "Universit\u00e9 de La R\u00e9union",
        "Universit\u00c3\u00a9 de Rouen": "Universit\u00e9 de Rouen",
        "Universit\u00c3\u00a9 de Chamb\u00c3\u00a9ry": "Universit\u00e9 de Chamb\u00e9ry",
        "Universit\u00c3\u00a9 Jean Monnet": "Universit\u00e9 Jean Monnet",
        "Universit\u00c3\u00a9 Paul Sabatier - Toulouse III": "Universit\u00e9 Paul Sabatier - Toulouse III",
        "Universit\u00c3\u00a9 de Toulouse": "Universit\u00e9 de Toulouse",
        "Universit\u00c3\u00a9 de Tours": "Universit\u00e9 de Tours",
        "Universit\u00c3\u00a9 de Bretagne Sud": "Universit\u00e9 de Bretagne Sud",
        "Universit\u00c3\u00a9 Polytechnique Hauts-de-France": "Universit\u00e9 Polytechnique Hauts-de-France",
        "Etablissement Public Palais de la D\u00c3\u00a9couverte et Cit\u00c3\u00a9 des Sciences et de l'Industrie": "Etablissement Public Palais de la D\u00e9couverte et Cit\u00e9 des Sciences et de l'Industrie",
        "Universit\u00c3\u00a9 Paris Saclay": "Universit\u00e9 Paris Saclay",
        "Universidad del Pac\u00c3\u00adfico - upacifico": "Universidad del Pac\u00edfico - upacifico",
        "Pavol Jozef Safarik University in Ko\u00c5\u00a1ice": "Pavol Jozef Safarik University in Ko\u0161ice",
        "Universidad Polit\u00c3\u00a9cnica de Madrid": "Universidad Polit\u00e9cnica de Madrid",
        "Universidad Estatal Pen\u00c3\u00adnsula de Santa Elena - upse": "Universidad Estatal Pen\u00ednsula de Santa Elena - upse",
        "UPV - Universitat Polit\u00c3\u00a8cnica de Val\u00c3\u00a8ncia": "UPV - Universitat Polit\u00e8cnica de Val\u00e8ncia",
        "Wroc\u00c5\u0082aw University of Environmental and Life Sciences": "Wroc\u0142aw University of Environmental and Life Sciences",
        "Universit\u00c3\u00a9 du Qu\u00c3\u00a9bec \u00c3\u00a0 Chicoutimi": "Universit\u00e9 du Qu\u00e9bec \u00e0 Chicoutimi",
        "UQAM | Universit\u00c3\u00a9 du Qu\u00c3\u00a9bec \u00c3\u00a0 Montr\u00c3\u00a9al": "UQAM | Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al",
        "Universit\u00c3\u00a9 du Qu\u00c3\u00a9bec \u00c3\u00a0 Rimouski (UQAR)": "Universit\u00e9 du Qu\u00e9bec \u00e0 Rimouski (UQAR)",
        "Universit\u00c3\u00a9 du Qu\u00c3\u00a9bec en Abitibi-T\u00c3\u00a9miscamingue": "Universit\u00e9 du Qu\u00e9bec en Abitibi-T\u00e9miscamingue",
        "Universit\u00c3\u00a9 du Qu\u00c3\u00a9bec en Outaouais": "Universit\u00e9 du Qu\u00e9bec en Outaouais",
        "Universit\u00c3\u00a9 de Sherbrooke": "Universit\u00e9 de Sherbrooke",
        "Universit\u00c3\u00a4tsspital Z\u00c3\u00bcrich": "Universit\u00e4tsspital Z\u00fcrich",
        "Universit\u00c3\u00a9 Toulouse 1 Capitole": "Universit\u00e9 Toulouse 1 Capitole",
        "Universidad T\u00c3\u00a9cnica de Ambato - uta": "Universidad T\u00e9cnica de Ambato - uta",
        "University of Tr\u00c3\u00a1s os Montes e Alto Douro": "University of Tr\u00e1s os Montes e Alto Douro",
        "Tomas Bata University in Zl\u00c3\u00adn": "Tomas Bata University in Zl\u00edn",
        "Universidad T\u00c3\u00a9cnica de Babahoyo - utb": "Universidad T\u00e9cnica de Babahoyo - utb",
        "Universit\u00c3\u00a9 de Technologie de Belfort-Montb\u00c3\u00a9liard": "Universit\u00e9 de Technologie de Belfort-Montb\u00e9liard",
        "Universidad T\u00c3\u00a9cnica de Cotopaxi - utc": "Universidad T\u00e9cnica de Cotopaxi - utc",
        "Universit\u00c3\u00a9 de Technologie de Compi\u00c3\u00a8gne": "Universit\u00e9 de Technologie de Compi\u00e8gne",
        "Universidad Universidad T\u00c3\u00a9cnica Luis Vargas Torres - utelvt": "Universidad Universidad T\u00e9cnica Luis Vargas Torres - utelvt",
        "Kazimierz Pu\u00c5\u0082aski University of Technology and Humanities in Radom": "Kazimierz Pu\u0142aski University of Technology and Humanities in Radom",
        "Universidad T\u00c3\u00a9cnica de Manabi - utm": "Universidad T\u00e9cnica de Manabi - utm",
        "Universidad T\u00c3\u00a9cnica de Machala - utmachala": "Universidad T\u00e9cnica de Machala - utmachala",
        "Technische Universit\u00c3\u00a4t N\u00c3\u00bcrnberg (UTN)": "Technische Universit\u00e4t N\u00fcrnberg (UTN)",
        "Universidad T\u00c3\u00a9cnica del Norte - utn": "Universidad T\u00e9cnica del Norte - utn",
        "Universidad T\u00c3\u00a9cnica Particular de Loja - utpl": "Universidad T\u00e9cnica Particular de Loja - utpl",
        "Universit\u00c3\u00a9 de Technologie de Troyes": "Universit\u00e9 de Technologie de Troyes",
        "Universit\u00c3\u00a9 Virtuelle de C\u00c3\u00b4te d'Ivoire": "Universit\u00e9 Virtuelle de C\u00f4te d'Ivoire",
        "Universit\u00c3\u00a9 de Versailles Saint-Quentin-en-Yvelines": "Universit\u00e9 de Versailles Saint-Quentin-en-Yvelines",
        "Ecole Nationale V\u00c3\u00a9t\u00c3\u00a9rinaire d'Alfort": "Ecole Nationale V\u00e9t\u00e9rinaire d'Alfort",
        "V\u00c5\u00a0B - TU Ostrava": "V\u0160B - TU Ostrava",
        "Institute of Technology and Business in \u00c4\u008cesk\u00c3\u00a9 Bud\u00c4\u009bjovice": "Institute of Technology and Business in \u010cesk\u00e9 Bud\u011bjovice",
        "V\u00c3\u009aMOP, v.v.i.": "V\u00daMOP, v.v.i.",
        "Westf\u00c3\u00a4lische Hochschule, University of Applied Sciences": "Westf\u00e4lische Hochschule, University of Applied Sciences",
        "W\u00c3\u00bcrttembergische Landesbibliothek": "W\u00fcrttembergische Landesbibliothek",
        "WSB University in Wroc\u00c5\u0082aw": "WSB University in Wroc\u0142aw",
        "WSL - Eidg. Forschungsanstalt f\u00c3\u00bcr Wald, Schnee und Landschaft": "WSL - Eidg. Forschungsanstalt f\u00fcr Wald, Schnee und Landschaft",
        "ZBC \u00e2\u0080\u0093 Zealand Business College": "ZBC \u2013 Zealand Business College",
        "ZHAW - Z\u00c3\u00bcrcher Hochschule f\u00c3\u00bcr Angewandte Wissenschaften": "ZHAW - Z\u00fcrcher Hochschule f\u00fcr Angewandte Wissenschaften",
        "ZHdK - Z\u00c3\u00bcrcher Hochschule der K\u00c3\u00bcnste": "ZHdK - Z\u00fcrcher Hochschule der K\u00fcnste",
        "Konrad-Zuse-Zentrum f\u00c3\u00bcr Informationstechnik Berlin": "Konrad-Zuse-Zentrum f\u00fcr Informationstechnik Berlin",
    }
    conn = op.get_bind()
    for old_name, new_name in mappings.items():
        conn.execute(
            sa.text(
                "update contact set organization = :new_name where organization = :old_name"
            ),
            new_name=new_name,
            old_name=old_name,
        )


def downgrade():
    """Don't do anything."""
    pass
