# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add columns for keywords.

Revision ID: 3fc79d899f8b
Revises: bd274b605cae
Create Date: 2023-10-17 07:06:05.086944

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "3fc79d899f8b"
down_revision = "5ada23855e3c"
branch_labels = None
depends_on = None


def upgrade():
    """Run the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("configuration", schema=None) as batch_op:
        batch_op.add_column(sa.Column("keywords", sa.ARRAY(sa.String()), nullable=True))

    with op.batch_alter_table("device", schema=None) as batch_op:
        batch_op.add_column(sa.Column("keywords", sa.ARRAY(sa.String()), nullable=True))

    with op.batch_alter_table("platform", schema=None) as batch_op:
        batch_op.add_column(sa.Column("keywords", sa.ARRAY(sa.String()), nullable=True))

    with op.batch_alter_table("site", schema=None) as batch_op:
        batch_op.add_column(sa.Column("keywords", sa.ARRAY(sa.String()), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    """Undo the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("site", schema=None) as batch_op:
        batch_op.drop_column("keywords")

    with op.batch_alter_table("platform", schema=None) as batch_op:
        batch_op.drop_column("keywords")

    with op.batch_alter_table("device", schema=None) as batch_op:
        batch_op.drop_column("keywords")

    with op.batch_alter_table("configuration", schema=None) as batch_op:
        batch_op.drop_column("keywords")
    # ### end Alembic commands ###
