# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add additional metadata fields to datastream links.

Revision ID: 4b0f4516b818
Revises: 89b77ad855f5
Create Date: 2023-04-14 07:20:23.570784

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "4b0f4516b818"
down_revision = "89b77ad855f5"
branch_labels = None
depends_on = None


def upgrade():
    """Change the database structure."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("datastream_link", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("license_uri", sa.String(length=256), nullable=True)
        )
        batch_op.add_column(
            sa.Column("license_name", sa.String(length=256), nullable=True)
        )
        batch_op.add_column(sa.Column("aggregation_period", sa.Float(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    """Undo the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("datastream_link", schema=None) as batch_op:
        batch_op.drop_column("aggregation_period")
        batch_op.drop_column("license_name")
        batch_op.drop_column("license_uri")
    # ### end Alembic commands ###
