# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add the option to set an outer site.

Revision ID: 59f942848b0e
Revises: 5ada23855e3c
Create Date: 2023-11-08 11:57:50.722538

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "59f942848b0e"
down_revision = "33f521b3e3b2"
branch_labels = None
depends_on = None


def upgrade():
    """Run the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("site", schema=None) as batch_op:
        batch_op.add_column(sa.Column("outer_site_id", sa.Integer(), nullable=True))
        batch_op.create_foreign_key(None, "site", ["outer_site_id"], ["id"])
    # ### end Alembic commands ###


def downgrade():
    """Undo the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("site", schema=None) as batch_op:
        batch_op.drop_constraint(None, type_="foreignkey")
        batch_op.drop_column("outer_site_id")
    # ### end Alembic commands ###
