# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Create the datastream table for device properties used in configurations.

Revision ID: 87b366f51740
Revises: c0d89a7e62cc
Create Date: 2023-01-11 08:24:51.623726

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "87b366f51740"
down_revision = "f2dd1caad2bd"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "datastream_link",
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("updated_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("device_property_id", sa.Integer(), nullable=False),
        sa.Column("device_mount_action_id", sa.Integer(), nullable=False),
        sa.Column("tsm_endpoint", sa.String(length=256), nullable=True),
        sa.Column("datasource_id", sa.String(length=256), nullable=False),
        sa.Column("thing_id", sa.String(length=256), nullable=False),
        sa.Column("datastream_id", sa.String(length=256), nullable=False),
        sa.Column("begin_date", sa.DateTime(timezone=True), nullable=True),
        sa.Column("end_date", sa.DateTime(timezone=True), nullable=True),
        sa.Column("created_by_id", sa.Integer(), nullable=True),
        sa.Column("updated_by_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name="fk_DatastreamLink_created_by_id",
            use_alter=True,
        ),
        sa.ForeignKeyConstraint(
            ["device_mount_action_id"],
            ["device_mount_action.id"],
        ),
        sa.ForeignKeyConstraint(
            ["device_property_id"],
            ["device_property.id"],
        ),
        sa.ForeignKeyConstraint(
            ["updated_by_id"],
            ["user.id"],
            name="fk_DatastreamLink_updated_by_id",
            use_alter=True,
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("datastream_link")
    # ### end Alembic commands ###
