# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add labels for location actions.

Revision ID: 89b77ad855f5
Revises: 968d0a1e0f0f
Create Date: 2023-04-06 10:57:11.899738

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "89b77ad855f5"
down_revision = "968d0a1e0f0f"
branch_labels = None
depends_on = None


def upgrade():
    """Do the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "configuration_dynamic_location_begin_action", schema=None
    ) as batch_op:
        batch_op.add_column(sa.Column("label", sa.String(length=256), nullable=True))

    with op.batch_alter_table(
        "configuration_static_location_begin_action", schema=None
    ) as batch_op:
        batch_op.add_column(sa.Column("label", sa.String(length=256), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    """Undo the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "configuration_static_location_begin_action", schema=None
    ) as batch_op:
        batch_op.drop_column("label")

    with op.batch_alter_table(
        "configuration_dynamic_location_begin_action", schema=None
    ) as batch_op:
        batch_op.drop_column("label")
    # ### end Alembic commands ###
