# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2
"""Add b2inst fields.

Revision ID: 8ee5de834c21
Revises: 3ba235b20231
Create Date: 2023-07-03 07:14:10.867732

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "8ee5de834c21"
down_revision = "37fe18314572"
branch_labels = None
depends_on = None


def upgrade():
    """Run the structural changes on the database."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("configuration", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("b2inst_record_id", sa.String(length=256), nullable=True)
        )

    with op.batch_alter_table("device", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("b2inst_record_id", sa.String(length=256), nullable=True)
        )
        batch_op.drop_column("identifier_type")
        batch_op.drop_column("schema_version")

    with op.batch_alter_table("platform", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("b2inst_record_id", sa.String(length=256), nullable=True)
        )
        batch_op.drop_column("identifier_type")
        batch_op.drop_column("schema_version")
    # ### end Alembic commands ###


def downgrade():
    """Undo the structural changes on the database."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("platform", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "schema_version",
                sa.VARCHAR(length=256),
                autoincrement=False,
                nullable=True,
            )
        )
        batch_op.add_column(
            sa.Column(
                "identifier_type",
                sa.VARCHAR(length=256),
                autoincrement=False,
                nullable=True,
            )
        )
        batch_op.drop_column("b2inst_record_id")

    with op.batch_alter_table("device", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "schema_version",
                sa.VARCHAR(length=256),
                autoincrement=False,
                nullable=True,
            )
        )
        batch_op.add_column(
            sa.Column(
                "identifier_type",
                sa.VARCHAR(length=256),
                autoincrement=False,
                nullable=True,
            )
        )
        batch_op.drop_column("b2inst_record_id")

    with op.batch_alter_table("configuration", schema=None) as batch_op:
        batch_op.drop_column("b2inst_record_id")
    # ### end Alembic commands ###
