# SPDX-FileCopyrightText: 2020
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""empty message

Revision ID: aa525dcbdbeb
Revises: 
Create Date: 2020-09-15 10:34:59.358496

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "aa525dcbdbeb"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "contact",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("given_name", sa.String(length=256), nullable=False),
        sa.Column("family_name", sa.String(length=256), nullable=False),
        sa.Column("website", sa.String(length=1024), nullable=True),
        sa.Column("email", sa.String(length=256), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("email"),
    )
    op.create_table(
        "device",
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("short_name", sa.String(length=256), nullable=False),
        sa.Column("long_name", sa.String(length=256), nullable=True),
        sa.Column("serial_number", sa.String(length=256), nullable=True),
        sa.Column("manufacturer_uri", sa.String(length=256), nullable=True),
        sa.Column("manufacturer_name", sa.String(length=256), nullable=True),
        sa.Column("dual_use", sa.Boolean(), nullable=True),
        sa.Column("model", sa.String(length=256), nullable=True),
        sa.Column("inventory_number", sa.String(length=256), nullable=True),
        sa.Column("persistent_identifier", sa.String(length=256), nullable=True),
        sa.Column("website", sa.String(length=1024), nullable=True),
        sa.Column("device_type_uri", sa.String(length=256), nullable=True),
        sa.Column("device_type_name", sa.String(length=256), nullable=True),
        sa.Column("status_uri", sa.String(length=256), nullable=True),
        sa.Column("status_name", sa.String(length=256), nullable=True),
        sa.Column("created_by_id", sa.Integer(), nullable=True),
        sa.Column("updated_by_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name="fk_Device_created_by_id",
            use_alter=True,
        ),
        sa.ForeignKeyConstraint(
            ["updated_by_id"],
            ["user.id"],
            name="fk_Device_updated_by_id",
            use_alter=True,
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("persistent_identifier"),
    )
    op.create_table(
        "platform",
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("short_name", sa.String(length=256), nullable=False),
        sa.Column("long_name", sa.String(length=256), nullable=True),
        sa.Column("manufacturer_uri", sa.String(length=256), nullable=True),
        sa.Column("manufacturer_name", sa.String(length=256), nullable=True),
        sa.Column("model", sa.String(length=256), nullable=True),
        sa.Column("platform_type_uri", sa.String(length=256), nullable=True),
        sa.Column("platform_type_name", sa.String(length=256), nullable=True),
        sa.Column("status_uri", sa.String(length=256), nullable=True),
        sa.Column("status_name", sa.String(length=256), nullable=True),
        sa.Column("website", sa.String(length=1024), nullable=True),
        sa.Column("inventory_number", sa.String(length=256), nullable=True),
        sa.Column("serial_number", sa.String(length=256), nullable=True),
        sa.Column("persistent_identifier", sa.String(length=256), nullable=True),
        sa.Column("created_by_id", sa.Integer(), nullable=True),
        sa.Column("updated_by_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name="fk_Platform_created_by_id",
            use_alter=True,
        ),
        sa.ForeignKeyConstraint(
            ["updated_by_id"],
            ["user.id"],
            name="fk_Platform_updated_by_id",
            use_alter=True,
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("persistent_identifier"),
    )
    op.create_table(
        "custom_field",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("key", sa.String(length=256), nullable=False),
        sa.Column("value", sa.String(length=1024), nullable=True),
        sa.Column("device_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["device_id"],
            ["device.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "device_attachment",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("label", sa.String(length=256), nullable=True),
        sa.Column("url", sa.String(length=1024), nullable=False),
        sa.Column("device_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["device_id"],
            ["device.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "device_contacts",
        sa.Column("device_id", sa.Integer(), nullable=False),
        sa.Column("contact_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["contact_id"],
            ["contact.id"],
        ),
        sa.ForeignKeyConstraint(
            ["device_id"],
            ["device.id"],
        ),
        sa.PrimaryKeyConstraint("device_id", "contact_id"),
    )
    op.create_table(
        "device_property",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("measuring_range_min", sa.Float(), nullable=True),
        sa.Column("measuring_range_max", sa.Float(), nullable=True),
        sa.Column("failure_value", sa.Float(), nullable=True),
        sa.Column("accuracy", sa.Float(), nullable=True),
        sa.Column("label", sa.String(length=256), nullable=True),
        sa.Column("unit_uri", sa.String(length=256), nullable=True),
        sa.Column("unit_name", sa.String(length=256), nullable=True),
        sa.Column("compartment_uri", sa.String(length=256), nullable=True),
        sa.Column("compartment_name", sa.String(length=256), nullable=True),
        sa.Column("property_uri", sa.String(length=256), nullable=True),
        sa.Column("property_name", sa.String(length=256), nullable=True),
        sa.Column("sampling_media_uri", sa.String(length=256), nullable=True),
        sa.Column("sampling_media_name", sa.String(length=256), nullable=True),
        sa.Column("device_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["device_id"],
            ["device.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "platform_attachment",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("label", sa.String(length=256), nullable=True),
        sa.Column("url", sa.String(length=1024), nullable=False),
        sa.Column("platform_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["platform_id"],
            ["platform.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "platform_contacts",
        sa.Column("platform_id", sa.Integer(), nullable=False),
        sa.Column("contact_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["contact_id"],
            ["contact.id"],
        ),
        sa.ForeignKeyConstraint(
            ["platform_id"],
            ["platform.id"],
        ),
        sa.PrimaryKeyConstraint("platform_id", "contact_id"),
    )
    op.create_table(
        "user",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("subject", sa.String(length=256), nullable=False),
        sa.Column("contact_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["contact_id"],
            ["contact.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("subject"),
    )
    op.create_table(
        "configuration",
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("start_date", sa.DateTime(), nullable=True),
        sa.Column("end_date", sa.DateTime(), nullable=True),
        sa.Column("location_type", sa.String(length=256), nullable=False),
        sa.Column("longitude", sa.Float(), nullable=True),
        sa.Column("latitude", sa.Float(), nullable=True),
        sa.Column("elevation", sa.Float(), nullable=True),
        sa.Column("project_uri", sa.String(length=256), nullable=True),
        sa.Column("project_name", sa.String(length=256), nullable=True),
        sa.Column("longitude_src_device_property_id", sa.Integer(), nullable=True),
        sa.Column("latitude_src_device_property_id", sa.Integer(), nullable=True),
        sa.Column("elevation_src_device_property_id", sa.Integer(), nullable=True),
        sa.Column("created_by_id", sa.Integer(), nullable=True),
        sa.Column("updated_by_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name="fk_Configuration_created_by_id",
            use_alter=True,
        ),
        sa.ForeignKeyConstraint(
            ["elevation_src_device_property_id"],
            ["device_property.id"],
        ),
        sa.ForeignKeyConstraint(
            ["latitude_src_device_property_id"],
            ["device_property.id"],
        ),
        sa.ForeignKeyConstraint(
            ["longitude_src_device_property_id"],
            ["device_property.id"],
        ),
        sa.ForeignKeyConstraint(
            ["updated_by_id"],
            ["user.id"],
            name="fk_Configuration_updated_by_id",
            use_alter=True,
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "event",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("description", sa.Text(), nullable=False),
        sa.Column("timestamp", sa.DateTime(), nullable=True),
        sa.Column("device_id", sa.Integer(), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["device_id"],
            ["device.id"],
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "configuration_contacts",
        sa.Column("configuration_id", sa.Integer(), nullable=False),
        sa.Column("contact_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["configuration_id"],
            ["configuration.id"],
        ),
        sa.ForeignKeyConstraint(
            ["contact_id"],
            ["contact.id"],
        ),
        sa.PrimaryKeyConstraint("configuration_id", "contact_id"),
    )
    op.create_table(
        "configuration_device",
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("offset_x", sa.Float(), nullable=True),
        sa.Column("offset_y", sa.Float(), nullable=True),
        sa.Column("offset_z", sa.Float(), nullable=True),
        sa.Column("calibration_date", sa.DateTime(), nullable=True),
        sa.Column("configuration_id", sa.Integer(), nullable=True),
        sa.Column("device_id", sa.Integer(), nullable=True),
        sa.Column("platform_id", sa.Integer(), nullable=True),
        sa.Column("created_by_id", sa.Integer(), nullable=True),
        sa.Column("updated_by_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["configuration_id"],
            ["configuration.id"],
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name="fk_ConfigurationDevice_created_by_id",
            use_alter=True,
        ),
        sa.ForeignKeyConstraint(
            ["device_id"],
            ["device.id"],
        ),
        sa.ForeignKeyConstraint(
            ["platform_id"],
            ["platform.id"],
        ),
        sa.ForeignKeyConstraint(
            ["updated_by_id"],
            ["user.id"],
            name="fk_ConfigurationDevice_updated_by_id",
            use_alter=True,
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint(
            "device_id", "configuration_id", name="uc_configuration_device"
        ),
    )
    op.create_table(
        "configuration_platform",
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("offset_x", sa.Float(), nullable=True),
        sa.Column("offset_y", sa.Float(), nullable=True),
        sa.Column("offset_z", sa.Float(), nullable=True),
        sa.Column("configuration_id", sa.Integer(), nullable=True),
        sa.Column("parent_platform_id", sa.Integer(), nullable=True),
        sa.Column("platform_id", sa.Integer(), nullable=True),
        sa.Column("created_by_id", sa.Integer(), nullable=True),
        sa.Column("updated_by_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["configuration_id"],
            ["configuration.id"],
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name="fk_ConfigurationPlatform_created_by_id",
            use_alter=True,
        ),
        sa.ForeignKeyConstraint(
            ["parent_platform_id"],
            ["platform.id"],
        ),
        sa.ForeignKeyConstraint(
            ["platform_id"],
            ["platform.id"],
        ),
        sa.ForeignKeyConstraint(
            ["updated_by_id"],
            ["user.id"],
            name="fk_ConfigurationPlatform_updated_by_id",
            use_alter=True,
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("configuration_platform")
    op.drop_table("configuration_device")
    op.drop_table("configuration_contacts")
    op.drop_table("event")
    op.drop_table("configuration")
    op.drop_table("user")
    op.drop_table("platform_contacts")
    op.drop_table("platform_attachment")
    op.drop_table("device_property")
    op.drop_table("device_contacts")
    op.drop_table("device_attachment")
    op.drop_table("custom_field")
    op.drop_table("platform")
    op.drop_table("device")
    op.drop_table("contact")
    # ### end Alembic commands ###
