# SPDX-FileCopyrightText: 2022
# - Kotyba Alhaj Taha <kotyba.alhaj-taha@ufz.de>
# - Helmholtz Centre for Environmental Research GmbH - UFZ (UFZ, https://www.ufz.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""clean up unused tables -> (configuration_device, configuration_platform, event)

Revision ID: aa89a10ad413
Revises: 0139893c4e15
Create Date: 2022-03-23 07:52:38.366130

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "aa89a10ad413"
down_revision = "0139893c4e15"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("configuration_device")
    op.drop_table("event")
    op.drop_table("configuration_platform")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "configuration_platform",
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=True
        ),
        sa.Column(
            "updated_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=True
        ),
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column(
            "offset_x",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "offset_y",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "offset_z",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "configuration_id", sa.INTEGER(), autoincrement=False, nullable=False
        ),
        sa.Column(
            "parent_platform_id", sa.INTEGER(), autoincrement=False, nullable=True
        ),
        sa.Column("platform_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("created_by_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("updated_by_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(
            ["configuration_id"],
            ["configuration.id"],
            name="configuration_platform_configuration_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name="fk_ConfigurationPlatform_created_by_id",
        ),
        sa.ForeignKeyConstraint(
            ["parent_platform_id"],
            ["platform.id"],
            name="configuration_platform_parent_platform_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["platform_id"],
            ["platform.id"],
            name="configuration_platform_platform_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["updated_by_id"],
            ["user.id"],
            name="fk_ConfigurationPlatform_updated_by_id",
        ),
        sa.PrimaryKeyConstraint("id", name="configuration_platform_pkey"),
    )
    op.create_table(
        "event",
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("description", sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column(
            "timestamp", postgresql.TIMESTAMP(), autoincrement=False, nullable=True
        ),
        sa.Column("device_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("user_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(
            ["device_id"], ["device.id"], name="event_device_id_fkey"
        ),
        sa.ForeignKeyConstraint(["user_id"], ["user.id"], name="event_user_id_fkey"),
        sa.PrimaryKeyConstraint("id", name="event_pkey"),
    )
    op.create_table(
        "configuration_device",
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=True
        ),
        sa.Column(
            "updated_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=True
        ),
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column(
            "offset_x",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "offset_y",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "offset_z",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "calibration_date",
            postgresql.TIMESTAMP(),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "configuration_id", sa.INTEGER(), autoincrement=False, nullable=False
        ),
        sa.Column("device_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("created_by_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("updated_by_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column(
            "parent_platform_id", sa.INTEGER(), autoincrement=False, nullable=False
        ),
        sa.Column(
            "firmware_version",
            sa.VARCHAR(length=256),
            autoincrement=False,
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["configuration_id"],
            ["configuration.id"],
            name="configuration_device_configuration_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"], ["user.id"], name="fk_ConfigurationDevice_created_by_id"
        ),
        sa.ForeignKeyConstraint(
            ["device_id"], ["device.id"], name="configuration_device_device_id_fkey"
        ),
        sa.ForeignKeyConstraint(
            ["parent_platform_id"],
            ["platform.id"],
            name="configuration_device_parent_platform_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["updated_by_id"], ["user.id"], name="fk_ConfigurationDevice_updated_by_id"
        ),
        sa.PrimaryKeyConstraint("id", name="configuration_device_pkey"),
        sa.UniqueConstraint(
            "device_id", "configuration_id", name="uc_configuration_device"
        ),
    )
    # ### end Alembic commands ###
