# SPDX-FileCopyrightText: 2020
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""empty message

Revision ID: df868a68fc52
Revises: aa525dcbdbeb
Create Date: 2020-09-17 13:22:39.797081

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "df868a68fc52"
down_revision = "aa525dcbdbeb"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_foreign_key(
        "fk_Configuration_created_by_id",
        "configuration",
        "user",
        ["created_by_id"],
        ["id"],
        use_alter=True,
    )
    op.create_foreign_key(
        "fk_Configuration_updated_by_id",
        "configuration",
        "user",
        ["updated_by_id"],
        ["id"],
        use_alter=True,
    )
    op.create_foreign_key(
        "fk_ConfigurationDevice_updated_by_id",
        "configuration_device",
        "user",
        ["updated_by_id"],
        ["id"],
        use_alter=True,
    )
    op.create_foreign_key(
        "fk_ConfigurationDevice_created_by_id",
        "configuration_device",
        "user",
        ["created_by_id"],
        ["id"],
        use_alter=True,
    )
    op.create_foreign_key(
        "fk_ConfigurationPlatform_updated_by_id",
        "configuration_platform",
        "user",
        ["updated_by_id"],
        ["id"],
        use_alter=True,
    )
    op.create_foreign_key(
        "fk_ConfigurationPlatform_created_by_id",
        "configuration_platform",
        "user",
        ["created_by_id"],
        ["id"],
        use_alter=True,
    )
    op.create_foreign_key(
        "fk_Device_updated_by_id",
        "device",
        "user",
        ["updated_by_id"],
        ["id"],
        use_alter=True,
    )
    op.create_foreign_key(
        "fk_Device_created_by_id",
        "device",
        "user",
        ["created_by_id"],
        ["id"],
        use_alter=True,
    )
    op.create_foreign_key(
        "fk_Platform_created_by_id",
        "platform",
        "user",
        ["created_by_id"],
        ["id"],
        use_alter=True,
    )
    op.create_foreign_key(
        "fk_Platform_updated_by_id",
        "platform",
        "user",
        ["updated_by_id"],
        ["id"],
        use_alter=True,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("fk_Platform_updated_by_id", "platform", type_="foreignkey")
    op.drop_constraint("fk_Platform_created_by_id", "platform", type_="foreignkey")
    op.drop_constraint("fk_Device_created_by_id", "device", type_="foreignkey")
    op.drop_constraint("fk_Device_updated_by_id", "device", type_="foreignkey")
    op.drop_constraint(
        "fk_ConfigurationPlatform_created_by_id",
        "configuration_platform",
        type_="foreignkey",
    )
    op.drop_constraint(
        "fk_ConfigurationPlatform_updated_by_id",
        "configuration_platform",
        type_="foreignkey",
    )
    op.drop_constraint(
        "fk_ConfigurationDevice_created_by_id",
        "configuration_device",
        type_="foreignkey",
    )
    op.drop_constraint(
        "fk_ConfigurationDevice_updated_by_id",
        "configuration_device",
        type_="foreignkey",
    )
    op.drop_constraint(
        "fk_Configuration_updated_by_id", "configuration", type_="foreignkey"
    )
    op.drop_constraint(
        "fk_Configuration_created_by_id", "configuration", type_="foreignkey"
    )
    # ### end Alembic commands ###
