# openapi-client
REST API for managing sensor metadata. This API is based on {json:api} specification see: https://jsonapi.org/

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: develop
- Package version: 1.0.0
- Generator version: 7.18.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://codebase.helmholtz.cloud/hub-terra/sms/orchestration](https://codebase.helmholtz.cloud/hub-terra/sms/orchestration)

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openapi_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationAttachmentsApi(api_client)
    configuration_attachment_id = 'configuration_attachment_id_example' # str | 
    filename = 'file' # str | Filename of the file. Can be arbitrary, it will always return the same file - no matter how this parameter is set. Backend needs this to allow linking of filenames for uploads. (default to 'file')

    try:
        api_instance.configuration_attachments_configuration_attachment_id_file_filename_get(configuration_attachment_id, filename)
    except ApiException as e:
        print("Exception when calling ConfigurationAttachmentsApi->configuration_attachments_configuration_attachment_id_file_filename_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConfigurationAttachmentsApi* | [**configuration_attachments_configuration_attachment_id_file_filename_get**](docs/ConfigurationAttachmentsApi.md#configuration_attachments_configuration_attachment_id_file_filename_get) | **GET** /configuration-attachments/{configuration_attachment_id}/file/{filename} | 
*ConfigurationAttachmentsApi* | [**create_configuration_attachment0**](docs/ConfigurationAttachmentsApi.md#create_configuration_attachment0) | **POST** /configuration-attachments | 
*ConfigurationAttachmentsApi* | [**delete_configuration_attachmentfromconfigurationattachment0**](docs/ConfigurationAttachmentsApi.md#delete_configuration_attachmentfromconfigurationattachment0) | **DELETE** /configuration-attachments/{configuration_attachment_id} | 
*ConfigurationAttachmentsApi* | [**retrieve_configuration_attachmentinstance0**](docs/ConfigurationAttachmentsApi.md#retrieve_configuration_attachmentinstance0) | **GET** /configuration-attachments/{configuration_attachment_id} | 
*ConfigurationAttachmentsApi* | [**retrieveacollectionof_configuration_attachmentobjects0**](docs/ConfigurationAttachmentsApi.md#retrieveacollectionof_configuration_attachmentobjects0) | **GET** /configuration-attachments | 
*ConfigurationAttachmentsApi* | [**update_configuration_attachment0**](docs/ConfigurationAttachmentsApi.md#update_configuration_attachment0) | **PATCH** /configuration-attachments/{configuration_attachment_id} | 
*ConfigurationCustomFieldsApi* | [**create_configuration_custom_field0**](docs/ConfigurationCustomFieldsApi.md#create_configuration_custom_field0) | **POST** /configuration-customfields | 
*ConfigurationCustomFieldsApi* | [**delete_configuration_custom_fieldfromcustomfield0**](docs/ConfigurationCustomFieldsApi.md#delete_configuration_custom_fieldfromcustomfield0) | **DELETE** /configuration-customfields/{configuration_custom_field_id} | 
*ConfigurationCustomFieldsApi* | [**retrieve_configuration_custom_fieldinstance0**](docs/ConfigurationCustomFieldsApi.md#retrieve_configuration_custom_fieldinstance0) | **GET** /configuration-customfields/{configuration_custom_field_id} | 
*ConfigurationCustomFieldsApi* | [**retrieveacollectionof_configuration_custom_fieldobjects0**](docs/ConfigurationCustomFieldsApi.md#retrieveacollectionof_configuration_custom_fieldobjects0) | **GET** /configuration-customfields | 
*ConfigurationCustomFieldsApi* | [**update_configuration_custom_field0**](docs/ConfigurationCustomFieldsApi.md#update_configuration_custom_field0) | **PATCH** /configuration-customfields/{configuration_custom_field_id} | 
*ConfigurationImagesApi* | [**create_configuration_image**](docs/ConfigurationImagesApi.md#create_configuration_image) | **POST** /configuration-images | 
*ConfigurationImagesApi* | [**delete_configuration_image**](docs/ConfigurationImagesApi.md#delete_configuration_image) | **DELETE** /configuration-images/{configuration_image_id} | 
*ConfigurationImagesApi* | [**retrieve_configuration_image_instance**](docs/ConfigurationImagesApi.md#retrieve_configuration_image_instance) | **GET** /configuration-images/{configuration_image_id} | 
*ConfigurationImagesApi* | [**retrievecollectionof_configuration_imageobjects**](docs/ConfigurationImagesApi.md#retrievecollectionof_configuration_imageobjects) | **GET** /configuration-images | 
*ConfigurationImagesApi* | [**update_configuration_image**](docs/ConfigurationImagesApi.md#update_configuration_image) | **PATCH** /configuration-images/{configuration_image_id} | 
*ConfigurationParameterValueChangeActionsApi* | [**create_configuration_parameter_valuechange_action**](docs/ConfigurationParameterValueChangeActionsApi.md#create_configuration_parameter_valuechange_action) | **POST** /configuration-parameter-value-change-actions | 
*ConfigurationParameterValueChangeActionsApi* | [**delete_configuration_parameter_value_change_action**](docs/ConfigurationParameterValueChangeActionsApi.md#delete_configuration_parameter_value_change_action) | **DELETE** /configuration-parameter-value-change-actions/{configuration_parameter_value_change_action_id} | 
*ConfigurationParameterValueChangeActionsApi* | [**retriececollectionof_configuration_parameter_value_change_actionobjects**](docs/ConfigurationParameterValueChangeActionsApi.md#retriececollectionof_configuration_parameter_value_change_actionobjects) | **GET** /configuration-parameter-value-change-actions | 
*ConfigurationParameterValueChangeActionsApi* | [**retrieve_configuration_parameter_value_change_actioninstance**](docs/ConfigurationParameterValueChangeActionsApi.md#retrieve_configuration_parameter_value_change_actioninstance) | **GET** /configuration-parameter-value-change-actions/{configuration_parameter_value_change_action_id} | 
*ConfigurationParameterValueChangeActionsApi* | [**update_configuration_parameter_value_change_action**](docs/ConfigurationParameterValueChangeActionsApi.md#update_configuration_parameter_value_change_action) | **PATCH** /configuration-parameter-value-change-actions/{configuration_parameter_value_change_action_id} | 
*ConfigurationParametersApi* | [**create_configuration_parameter**](docs/ConfigurationParametersApi.md#create_configuration_parameter) | **POST** /configuration-parameters | 
*ConfigurationParametersApi* | [**delete_configuration_parameter**](docs/ConfigurationParametersApi.md#delete_configuration_parameter) | **DELETE** /configuration-parameters/{configuration_parameter_id} | 
*ConfigurationParametersApi* | [**retriececollectionof_configuration_parameterobjects**](docs/ConfigurationParametersApi.md#retriececollectionof_configuration_parameterobjects) | **GET** /configuration-parameters | 
*ConfigurationParametersApi* | [**retrieve_configuration_parameterinstance**](docs/ConfigurationParametersApi.md#retrieve_configuration_parameterinstance) | **GET** /configuration-parameters/{configuration_parameter_id} | 
*ConfigurationParametersApi* | [**update_configuration_parameter**](docs/ConfigurationParametersApi.md#update_configuration_parameter) | **PATCH** /configuration-parameters/{configuration_parameter_id} | 
*ConfigurationsApi* | [**archive_configuration**](docs/ConfigurationsApi.md#archive_configuration) | **POST** /configurations/{configuration_id}/archive | 
*ConfigurationsApi* | [**create_configuration0**](docs/ConfigurationsApi.md#create_configuration0) | **POST** /configurations | 
*ConfigurationsApi* | [**delete_configurationfromconfiguration0**](docs/ConfigurationsApi.md#delete_configurationfromconfiguration0) | **DELETE** /configurations/{configuration_id} | 
*ConfigurationsApi* | [**restore_configuration**](docs/ConfigurationsApi.md#restore_configuration) | **POST** /configurations/{configuration_id}/restore | 
*ConfigurationsApi* | [**retrieve_configuration_sensor_ml**](docs/ConfigurationsApi.md#retrieve_configuration_sensor_ml) | **GET** /configurations/{configuration_id}/sensorml | 
*ConfigurationsApi* | [**retrieve_configurationinstance0**](docs/ConfigurationsApi.md#retrieve_configurationinstance0) | **GET** /configurations/{configuration_id} | 
*ConfigurationsApi* | [**retrieveacollectionof_configurationobjects0**](docs/ConfigurationsApi.md#retrieveacollectionof_configurationobjects0) | **GET** /configurations | 
*ConfigurationsApi* | [**retrieveacollectionof_site0**](docs/ConfigurationsApi.md#retrieveacollectionof_site0) | **GET** /sites/{site_id}/configurations | 
*ConfigurationsApi* | [**update_configuration0**](docs/ConfigurationsApi.md#update_configuration0) | **PATCH** /configurations/{configuration_id} | 
*ContactRolesApi* | [**configuration_contact_roles_configuration_contact_role_id_delete**](docs/ContactRolesApi.md#configuration_contact_roles_configuration_contact_role_id_delete) | **DELETE** /configuration-contact-roles/{configuration_contact_role_id} | 
*ContactRolesApi* | [**configuration_contact_roles_configuration_contact_role_id_get**](docs/ContactRolesApi.md#configuration_contact_roles_configuration_contact_role_id_get) | **GET** /configuration-contact-roles/{configuration_contact_role_id} | 
*ContactRolesApi* | [**configuration_contact_roles_configuration_contact_role_id_patch**](docs/ContactRolesApi.md#configuration_contact_roles_configuration_contact_role_id_patch) | **PATCH** /configuration-contact-roles/{configuration_contact_role_id} | 
*ContactRolesApi* | [**configuration_contact_roles_get**](docs/ContactRolesApi.md#configuration_contact_roles_get) | **GET** /configuration-contact-roles | 
*ContactRolesApi* | [**configuration_contact_roles_post**](docs/ContactRolesApi.md#configuration_contact_roles_post) | **POST** /configuration-contact-roles | 
*ContactRolesApi* | [**device_contact_roles_device_contact_role_id_delete**](docs/ContactRolesApi.md#device_contact_roles_device_contact_role_id_delete) | **DELETE** /device-contact-roles/{device_contact_role_id} | 
*ContactRolesApi* | [**device_contact_roles_device_contact_role_id_get**](docs/ContactRolesApi.md#device_contact_roles_device_contact_role_id_get) | **GET** /device-contact-roles/{device_contact_role_id} | 
*ContactRolesApi* | [**device_contact_roles_device_contact_role_id_patch**](docs/ContactRolesApi.md#device_contact_roles_device_contact_role_id_patch) | **PATCH** /device-contact-roles/{device_contact_role_id} | 
*ContactRolesApi* | [**device_contact_roles_get**](docs/ContactRolesApi.md#device_contact_roles_get) | **GET** /device-contact-roles | 
*ContactRolesApi* | [**device_contact_roles_post**](docs/ContactRolesApi.md#device_contact_roles_post) | **POST** /device-contact-roles | 
*ContactRolesApi* | [**platform_contact_roles_get**](docs/ContactRolesApi.md#platform_contact_roles_get) | **GET** /platform-contact-roles | 
*ContactRolesApi* | [**platform_contact_roles_platform_contact_role_id_delete**](docs/ContactRolesApi.md#platform_contact_roles_platform_contact_role_id_delete) | **DELETE** /platform-contact-roles/{platform_contact_role_id} | 
*ContactRolesApi* | [**platform_contact_roles_platform_contact_role_id_get**](docs/ContactRolesApi.md#platform_contact_roles_platform_contact_role_id_get) | **GET** /platform-contact-roles/{platform_contact_role_id} | 
*ContactRolesApi* | [**platform_contact_roles_platform_contact_role_id_patch**](docs/ContactRolesApi.md#platform_contact_roles_platform_contact_role_id_patch) | **PATCH** /platform-contact-roles/{platform_contact_role_id} | 
*ContactRolesApi* | [**platform_contact_roles_post**](docs/ContactRolesApi.md#platform_contact_roles_post) | **POST** /platform-contact-roles | 
*ContactRolesApi* | [**site_contact_roles_get**](docs/ContactRolesApi.md#site_contact_roles_get) | **GET** /site-contact-roles | 
*ContactRolesApi* | [**site_contact_roles_post**](docs/ContactRolesApi.md#site_contact_roles_post) | **POST** /site-contact-roles | 
*ContactRolesApi* | [**site_contact_roles_site_contact_role_id_delete**](docs/ContactRolesApi.md#site_contact_roles_site_contact_role_id_delete) | **DELETE** /site-contact-roles/{site_contact_role_id} | 
*ContactRolesApi* | [**site_contact_roles_site_contact_role_id_get**](docs/ContactRolesApi.md#site_contact_roles_site_contact_role_id_get) | **GET** /site-contact-roles/{site_contact_role_id} | 
*ContactRolesApi* | [**site_contact_roles_site_contact_role_id_patch**](docs/ContactRolesApi.md#site_contact_roles_site_contact_role_id_patch) | **PATCH** /site-contact-roles/{site_contact_role_id} | 
*ContactsApi* | [**create_contact0**](docs/ContactsApi.md#create_contact0) | **POST** /contacts | 
*ContactsApi* | [**delete_contactfromcontact5**](docs/ContactsApi.md#delete_contactfromcontact5) | **DELETE** /contacts/{contact_id} | 
*ContactsApi* | [**retrieve_contactinstance0**](docs/ContactsApi.md#retrieve_contactinstance0) | **GET** /contacts/{contact_id} | 
*ContactsApi* | [**retrieveacollectionof_contactobjects0**](docs/ContactsApi.md#retrieveacollectionof_contactobjects0) | **GET** /contacts | 
*ContactsApi* | [**update_contact0**](docs/ContactsApi.md#update_contact0) | **PATCH** /contacts/{contact_id} | 
*ControllerApi* | [**controller_attachment_labels**](docs/ControllerApi.md#controller_attachment_labels) | **GET** /controller/attachment-labels | 
*ControllerApi* | [**controller_configuration_attachment_labels**](docs/ControllerApi.md#controller_configuration_attachment_labels) | **GET** /controller/configuration-attachment-labels | 
*ControllerApi* | [**controller_configuration_campaigns**](docs/ControllerApi.md#controller_configuration_campaigns) | **GET** /controller/configuration-campaigns | 
*ControllerApi* | [**controller_configuration_custom_field_keys**](docs/ControllerApi.md#controller_configuration_custom_field_keys) | **GET** /controller/configuration-custom-field-keys | 
*ControllerApi* | [**controller_configuration_custom_field_values**](docs/ControllerApi.md#controller_configuration_custom_field_values) | **GET** /controller/configuration-custom-field-values | 
*ControllerApi* | [**controller_configuration_labels**](docs/ControllerApi.md#controller_configuration_labels) | **GET** /controller/configuration-labels | 
*ControllerApi* | [**controller_configuration_parameter_labels**](docs/ControllerApi.md#controller_configuration_parameter_labels) | **GET** /controller/configuration-parameter-labels | 
*ControllerApi* | [**controller_configuration_projects**](docs/ControllerApi.md#controller_configuration_projects) | **GET** /controller/configuration-projects | 
*ControllerApi* | [**controller_configurations_configuration_id_location_action_timepoints_get**](docs/ControllerApi.md#controller_configurations_configuration_id_location_action_timepoints_get) | **GET** /controller/configurations/{configuration_id}/location-action-timepoints | 
*ControllerApi* | [**controller_configurations_configuration_id_mounting_action_timepoints_get**](docs/ControllerApi.md#controller_configurations_configuration_id_mounting_action_timepoints_get) | **GET** /controller/configurations/{configuration_id}/mounting-action-timepoints | 
*ControllerApi* | [**controller_configurations_configuration_id_mounting_actions_get**](docs/ControllerApi.md#controller_configurations_configuration_id_mounting_actions_get) | **GET** /controller/configurations/{configuration_id}/mounting-actions | 
*ControllerApi* | [**controller_configurations_configuration_id_parameter_values_get**](docs/ControllerApi.md#controller_configurations_configuration_id_parameter_values_get) | **GET** /controller/configurations/{configuration_id}/parameter-values | 
*ControllerApi* | [**controller_contact_organizations**](docs/ControllerApi.md#controller_contact_organizations) | **GET** /controller/contact-organizations | 
*ControllerApi* | [**controller_device_attachment_labels**](docs/ControllerApi.md#controller_device_attachment_labels) | **GET** /controller/device-attachment-labels | 
*ControllerApi* | [**controller_device_availabilities_get**](docs/ControllerApi.md#controller_device_availabilities_get) | **GET** /controller/device-availabilities | 
*ControllerApi* | [**controller_device_calibration_action_descriptions**](docs/ControllerApi.md#controller_device_calibration_action_descriptions) | **GET** /controller/device-calibration-action-descriptions | 
*ControllerApi* | [**controller_device_calibration_action_forumlas**](docs/ControllerApi.md#controller_device_calibration_action_forumlas) | **GET** /controller/device-calibration-action-formulas | 
*ControllerApi* | [**controller_device_custom_field_keys**](docs/ControllerApi.md#controller_device_custom_field_keys) | **GET** /controller/device-custom-field-keys | 
*ControllerApi* | [**controller_device_custom_field_values**](docs/ControllerApi.md#controller_device_custom_field_values) | **GET** /controller/device-custom-field-values | 
*ControllerApi* | [**controller_device_long_names**](docs/ControllerApi.md#controller_device_long_names) | **GET** /controller/device-long-names | 
*ControllerApi* | [**controller_device_manufacturer_names**](docs/ControllerApi.md#controller_device_manufacturer_names) | **GET** /controller/device-manufacturer-names | 
*ControllerApi* | [**controller_device_models**](docs/ControllerApi.md#controller_device_models) | **GET** /controller/device-models | 
*ControllerApi* | [**controller_device_parameter_labels**](docs/ControllerApi.md#controller_device_parameter_labels) | **GET** /controller/device-parameter-labels | 
*ControllerApi* | [**controller_device_property_labels**](docs/ControllerApi.md#controller_device_property_labels) | **GET** /controller/device-property-labels | 
*ControllerApi* | [**controller_device_serial_numbers**](docs/ControllerApi.md#controller_device_serial_numbers) | **GET** /controller/device-serial-numbers | 
*ControllerApi* | [**controller_device_short_names**](docs/ControllerApi.md#controller_device_short_names) | **GET** /controller/device-short-names | 
*ControllerApi* | [**controller_device_software_update_action_descriptions**](docs/ControllerApi.md#controller_device_software_update_action_descriptions) | **GET** /controller/device-software-update-action-descriptions | 
*ControllerApi* | [**controller_device_software_update_action_repository_urls**](docs/ControllerApi.md#controller_device_software_update_action_repository_urls) | **GET** /controller/device-software-update-action-repository-urls | 
*ControllerApi* | [**controller_devices_device_id_parameter_values_get**](docs/ControllerApi.md#controller_devices_device_id_parameter_values_get) | **GET** /controller/devices/{device_id}/parameter-values | 
*ControllerApi* | [**controller_generic_configuration_action_descriptions**](docs/ControllerApi.md#controller_generic_configuration_action_descriptions) | **GET** /controller/generic-configuration-action-descriptions | 
*ControllerApi* | [**controller_generic_device_action_descriptions**](docs/ControllerApi.md#controller_generic_device_action_descriptions) | **GET** /controller/generic-device-action-descriptions | 
*ControllerApi* | [**controller_generic_platform_action_descriptions**](docs/ControllerApi.md#controller_generic_platform_action_descriptions) | **GET** /controller/generic-platform-action-descriptions | 
*ControllerApi* | [**controller_keywords**](docs/ControllerApi.md#controller_keywords) | **GET** /controller/keywords | 
*ControllerApi* | [**controller_platform_attachment_labels**](docs/ControllerApi.md#controller_platform_attachment_labels) | **GET** /controller/platform-attachment-labels | 
*ControllerApi* | [**controller_platform_availabilities_get**](docs/ControllerApi.md#controller_platform_availabilities_get) | **GET** /controller/platform-availabilities | 
*ControllerApi* | [**controller_platform_long_names**](docs/ControllerApi.md#controller_platform_long_names) | **GET** /controller/platform-long-names | 
*ControllerApi* | [**controller_platform_manufacturer_names**](docs/ControllerApi.md#controller_platform_manufacturer_names) | **GET** /controller/platform-manufacturer-names | 
*ControllerApi* | [**controller_platform_models**](docs/ControllerApi.md#controller_platform_models) | **GET** /controller/platform-models | 
*ControllerApi* | [**controller_platform_parameter_labels**](docs/ControllerApi.md#controller_platform_parameter_labels) | **GET** /controller/platform-parameter-labels | 
*ControllerApi* | [**controller_platform_serial_numbers**](docs/ControllerApi.md#controller_platform_serial_numbers) | **GET** /controller/platform-serial-numbers | 
*ControllerApi* | [**controller_platform_short_names**](docs/ControllerApi.md#controller_platform_short_names) | **GET** /controller/platform-short-names | 
*ControllerApi* | [**controller_platform_software_update_action_descriptions**](docs/ControllerApi.md#controller_platform_software_update_action_descriptions) | **GET** /controller/platform-software-update-action-descriptions | 
*ControllerApi* | [**controller_platform_software_update_action_repository_urls**](docs/ControllerApi.md#controller_platform_software_update_action_repository_urls) | **GET** /controller/platform-software-update-action-repository-urls | 
*ControllerApi* | [**controller_platforms_platform_id_parameter_values_get**](docs/ControllerApi.md#controller_platforms_platform_id_parameter_values_get) | **GET** /controller/platforms/{platform_id}/parameter-values | 
*ControllerApi* | [**controller_site_attachment_labels**](docs/ControllerApi.md#controller_site_attachment_labels) | **GET** /controller/site-attachment-labels | 
*ControllerApi* | [**controller_site_buildings**](docs/ControllerApi.md#controller_site_buildings) | **GET** /controller/site-buildings | 
*ControllerApi* | [**controller_site_cities**](docs/ControllerApi.md#controller_site_cities) | **GET** /controller/site-cities | 
*ControllerApi* | [**controller_site_countries**](docs/ControllerApi.md#controller_site_countries) | **GET** /controller/site-countries | 
*ControllerApi* | [**controller_site_labels**](docs/ControllerApi.md#controller_site_labels) | **GET** /controller/site-labels | 
*ControllerApi* | [**controller_site_rooms**](docs/ControllerApi.md#controller_site_rooms) | **GET** /controller/site-rooms | 
*ControllerApi* | [**controller_site_street_numbers**](docs/ControllerApi.md#controller_site_street_numbers) | **GET** /controller/site-street-numbers | 
*ControllerApi* | [**controller_site_streets**](docs/ControllerApi.md#controller_site_streets) | **GET** /controller/site-streets | 
*ControllerApi* | [**controller_site_zip_codes**](docs/ControllerApi.md#controller_site_zip_codes) | **GET** /controller/site-zip-codes | 
*ControllerApi* | [**get_global_activity**](docs/ControllerApi.md#get_global_activity) | **GET** /controller/global-activities | 
*CustomFieldsApi* | [**create_custom_field0**](docs/CustomFieldsApi.md#create_custom_field0) | **POST** /customfields | 
*CustomFieldsApi* | [**delete_custom_fieldfromcustomfield0**](docs/CustomFieldsApi.md#delete_custom_fieldfromcustomfield0) | **DELETE** /customfields/{custom_field_id} | 
*CustomFieldsApi* | [**retrieve_custom_fieldinstance0**](docs/CustomFieldsApi.md#retrieve_custom_fieldinstance0) | **GET** /customfields/{custom_field_id} | 
*CustomFieldsApi* | [**retrieveacollectionof_custom_fieldobjects0**](docs/CustomFieldsApi.md#retrieveacollectionof_custom_fieldobjects0) | **GET** /customfields | 
*CustomFieldsApi* | [**update_custom_field0**](docs/CustomFieldsApi.md#update_custom_field0) | **PATCH** /customfields/{custom_field_id} | 
*DatastreamLinksApi* | [**create_datastream_link**](docs/DatastreamLinksApi.md#create_datastream_link) | **POST** /datastream-links | 
*DatastreamLinksApi* | [**create_involved_device_for_datastream_link**](docs/DatastreamLinksApi.md#create_involved_device_for_datastream_link) | **POST** /involved-devices-for-datastream-links | 
*DatastreamLinksApi* | [**delete_a_datastream_link_object**](docs/DatastreamLinksApi.md#delete_a_datastream_link_object) | **DELETE** /datastream-links/{datastream_link_id} | 
*DatastreamLinksApi* | [**delete_involved_device_for_datastream_link**](docs/DatastreamLinksApi.md#delete_involved_device_for_datastream_link) | **DELETE** /involved-devices-for-datastream-links/{involved_device_for_datastream_link_id} | 
*DatastreamLinksApi* | [**retrieve_involved_device_for_datastream_link_instance**](docs/DatastreamLinksApi.md#retrieve_involved_device_for_datastream_link_instance) | **GET** /involved-devices-for-datastream-links/{involved_device_for_datastream_link_id} | 
*DatastreamLinksApi* | [**retrieveacollectionof_datastream_link_objects**](docs/DatastreamLinksApi.md#retrieveacollectionof_datastream_link_objects) | **GET** /datastream-links | 
*DatastreamLinksApi* | [**retrievecollectionof_involved_devices_for_datastream_link_objects**](docs/DatastreamLinksApi.md#retrievecollectionof_involved_devices_for_datastream_link_objects) | **GET** /involved-devices-for-datastream-links | 
*DatastreamLinksApi* | [**retrieveinstanceof_datastream_link_object**](docs/DatastreamLinksApi.md#retrieveinstanceof_datastream_link_object) | **GET** /datastream-links/{datastream_link_id} | 
*DatastreamLinksApi* | [**update_datastream_link_object**](docs/DatastreamLinksApi.md#update_datastream_link_object) | **PATCH** /datastream-links/{datastream_link_id} | 
*DatastreamLinksApi* | [**update_involved_device_for_datastream_link**](docs/DatastreamLinksApi.md#update_involved_device_for_datastream_link) | **PATCH** /involved-devices-for-datastream-links/{involved_device_for_datastream_link_id} | 
*DeviceAttachmentsApi* | [**create_device_attachment0**](docs/DeviceAttachmentsApi.md#create_device_attachment0) | **POST** /device-attachments | 
*DeviceAttachmentsApi* | [**delete_device_attachmentfromdeviceattachment0**](docs/DeviceAttachmentsApi.md#delete_device_attachmentfromdeviceattachment0) | **DELETE** /device-attachments/{device_attachment_id} | 
*DeviceAttachmentsApi* | [**device_attachments_device_attachment_id_file_filename_get**](docs/DeviceAttachmentsApi.md#device_attachments_device_attachment_id_file_filename_get) | **GET** /device-attachments/{device_attachment_id}/file/{filename} | 
*DeviceAttachmentsApi* | [**retrieve_device_attachmentinstance0**](docs/DeviceAttachmentsApi.md#retrieve_device_attachmentinstance0) | **GET** /device-attachments/{device_attachment_id} | 
*DeviceAttachmentsApi* | [**retrieveacollectionof_device_attachmentobjects0**](docs/DeviceAttachmentsApi.md#retrieveacollectionof_device_attachmentobjects0) | **GET** /device-attachments | 
*DeviceAttachmentsApi* | [**update_device_attachment0**](docs/DeviceAttachmentsApi.md#update_device_attachment0) | **PATCH** /device-attachments/{device_attachment_id} | 
*DeviceCalibrationActionsApi* | [**device_calibration_actions_device_calibration_action_id_delete**](docs/DeviceCalibrationActionsApi.md#device_calibration_actions_device_calibration_action_id_delete) | **DELETE** /device-calibration-actions/{device_calibration_action_id} | 
*DeviceCalibrationActionsApi* | [**device_calibration_actions_device_calibration_action_id_get**](docs/DeviceCalibrationActionsApi.md#device_calibration_actions_device_calibration_action_id_get) | **GET** /device-calibration-actions/{device_calibration_action_id} | 
*DeviceCalibrationActionsApi* | [**device_calibration_actions_device_calibration_action_id_patch**](docs/DeviceCalibrationActionsApi.md#device_calibration_actions_device_calibration_action_id_patch) | **PATCH** /device-calibration-actions/{device_calibration_action_id} | 
*DeviceCalibrationActionsApi* | [**device_calibration_actions_get**](docs/DeviceCalibrationActionsApi.md#device_calibration_actions_get) | **GET** /device-calibration-actions | 
*DeviceCalibrationActionsApi* | [**device_calibration_actions_post**](docs/DeviceCalibrationActionsApi.md#device_calibration_actions_post) | **POST** /device-calibration-actions | 
*DeviceCalibrationAttachmentsApi* | [**device_calibration_attachments_device_calibration_attachment_id_delete**](docs/DeviceCalibrationAttachmentsApi.md#device_calibration_attachments_device_calibration_attachment_id_delete) | **DELETE** /device-calibration-attachments/{device_calibration_attachment_id} | 
*DeviceCalibrationAttachmentsApi* | [**device_calibration_attachments_device_calibration_attachment_id_get**](docs/DeviceCalibrationAttachmentsApi.md#device_calibration_attachments_device_calibration_attachment_id_get) | **GET** /device-calibration-attachments/{device_calibration_attachment_id} | 
*DeviceCalibrationAttachmentsApi* | [**device_calibration_attachments_device_calibration_attachment_id_patch**](docs/DeviceCalibrationAttachmentsApi.md#device_calibration_attachments_device_calibration_attachment_id_patch) | **PATCH** /device-calibration-attachments/{device_calibration_attachment_id} | 
*DeviceCalibrationAttachmentsApi* | [**device_calibration_attachments_get**](docs/DeviceCalibrationAttachmentsApi.md#device_calibration_attachments_get) | **GET** /device-calibration-attachments | 
*DeviceCalibrationAttachmentsApi* | [**device_calibration_attachments_post**](docs/DeviceCalibrationAttachmentsApi.md#device_calibration_attachments_post) | **POST** /device-calibration-attachments | 
*DeviceImagesApi* | [**create_device_image**](docs/DeviceImagesApi.md#create_device_image) | **POST** /device-images | 
*DeviceImagesApi* | [**delete_device_image**](docs/DeviceImagesApi.md#delete_device_image) | **DELETE** /device-images/{device_image_id} | 
*DeviceImagesApi* | [**retrieve_device_image_instance**](docs/DeviceImagesApi.md#retrieve_device_image_instance) | **GET** /device-images/{device_image_id} | 
*DeviceImagesApi* | [**retrievecollectionof_device_imageobjects**](docs/DeviceImagesApi.md#retrievecollectionof_device_imageobjects) | **GET** /device-images | 
*DeviceImagesApi* | [**update_device_image**](docs/DeviceImagesApi.md#update_device_image) | **PATCH** /device-images/{device_image_id} | 
*DeviceMountActionsApi* | [**device_mount_actions_device_mount_action_id_delete**](docs/DeviceMountActionsApi.md#device_mount_actions_device_mount_action_id_delete) | **DELETE** /device-mount-actions/{device_mount_action_id} | 
*DeviceMountActionsApi* | [**device_mount_actions_device_mount_action_id_get**](docs/DeviceMountActionsApi.md#device_mount_actions_device_mount_action_id_get) | **GET** /device-mount-actions/{device_mount_action_id} | 
*DeviceMountActionsApi* | [**device_mount_actions_device_mount_action_id_patch**](docs/DeviceMountActionsApi.md#device_mount_actions_device_mount_action_id_patch) | **PATCH** /device-mount-actions/{device_mount_action_id} | 
*DeviceMountActionsApi* | [**device_mount_actions_get**](docs/DeviceMountActionsApi.md#device_mount_actions_get) | **GET** /device-mount-actions | 
*DeviceMountActionsApi* | [**device_mount_actions_post**](docs/DeviceMountActionsApi.md#device_mount_actions_post) | **POST** /device-mount-actions | 
*DeviceParameterValueChangeActionsApi* | [**create_device_parameter_valuechange_action**](docs/DeviceParameterValueChangeActionsApi.md#create_device_parameter_valuechange_action) | **POST** /device-parameter-value-change-actions | 
*DeviceParameterValueChangeActionsApi* | [**delete_device_parameter_value_change_action**](docs/DeviceParameterValueChangeActionsApi.md#delete_device_parameter_value_change_action) | **DELETE** /device-parameter-value-change-actions/{device_parameter_value_change_action_id} | 
*DeviceParameterValueChangeActionsApi* | [**retriececollectionof_device_parameter_value_change_actionobjects**](docs/DeviceParameterValueChangeActionsApi.md#retriececollectionof_device_parameter_value_change_actionobjects) | **GET** /device-parameter-value-change-actions | 
*DeviceParameterValueChangeActionsApi* | [**retrieve_device_parameter_value_change_actioninstance**](docs/DeviceParameterValueChangeActionsApi.md#retrieve_device_parameter_value_change_actioninstance) | **GET** /device-parameter-value-change-actions/{device_parameter_value_change_action_id} | 
*DeviceParameterValueChangeActionsApi* | [**update_device_parameter_value_change_action**](docs/DeviceParameterValueChangeActionsApi.md#update_device_parameter_value_change_action) | **PATCH** /device-parameter-value-change-actions/{device_parameter_value_change_action_id} | 
*DeviceParametersApi* | [**create_device_parameter**](docs/DeviceParametersApi.md#create_device_parameter) | **POST** /device-parameters | 
*DeviceParametersApi* | [**delete_device_parameter**](docs/DeviceParametersApi.md#delete_device_parameter) | **DELETE** /device-parameters/{device_parameter_id} | 
*DeviceParametersApi* | [**retriececollectionof_device_parameterobjects**](docs/DeviceParametersApi.md#retriececollectionof_device_parameterobjects) | **GET** /device-parameters | 
*DeviceParametersApi* | [**retrieve_device_parameterinstance**](docs/DeviceParametersApi.md#retrieve_device_parameterinstance) | **GET** /device-parameters/{device_parameter_id} | 
*DeviceParametersApi* | [**update_device_parameter**](docs/DeviceParametersApi.md#update_device_parameter) | **PATCH** /device-parameters/{device_parameter_id} | 
*DevicePropertiesApi* | [**create_device_property0**](docs/DevicePropertiesApi.md#create_device_property0) | **POST** /device-properties | 
*DevicePropertiesApi* | [**delete_device_propertyfromdeviceproperty1**](docs/DevicePropertiesApi.md#delete_device_propertyfromdeviceproperty1) | **DELETE** /device-properties/{device_property_id} | 
*DevicePropertiesApi* | [**retrieve_device_propertyinstance0**](docs/DevicePropertiesApi.md#retrieve_device_propertyinstance0) | **GET** /device-properties/{device_property_id} | 
*DevicePropertiesApi* | [**retrieveacollectionof_device_propertyobjects0**](docs/DevicePropertiesApi.md#retrieveacollectionof_device_propertyobjects0) | **GET** /device-properties | 
*DevicePropertiesApi* | [**update_device_property0**](docs/DevicePropertiesApi.md#update_device_property0) | **PATCH** /device-properties/{device_property_id} | 
*DevicePropertyCalibrationsApi* | [**device_property_calibrations_device_property_calibration_id_delete**](docs/DevicePropertyCalibrationsApi.md#device_property_calibrations_device_property_calibration_id_delete) | **DELETE** /device-property-calibrations/{device_property_calibration_id} | 
*DevicePropertyCalibrationsApi* | [**device_property_calibrations_device_property_calibration_id_get**](docs/DevicePropertyCalibrationsApi.md#device_property_calibrations_device_property_calibration_id_get) | **GET** /device-property-calibrations/{device_property_calibration_id} | 
*DevicePropertyCalibrationsApi* | [**device_property_calibrations_device_property_calibration_id_patch**](docs/DevicePropertyCalibrationsApi.md#device_property_calibrations_device_property_calibration_id_patch) | **PATCH** /device-property-calibrations/{device_property_calibration_id} | 
*DevicePropertyCalibrationsApi* | [**device_property_calibrations_get**](docs/DevicePropertyCalibrationsApi.md#device_property_calibrations_get) | **GET** /device-property-calibrations | 
*DevicePropertyCalibrationsApi* | [**device_property_calibrations_post**](docs/DevicePropertyCalibrationsApi.md#device_property_calibrations_post) | **POST** /device-property-calibrations | 
*DeviceSoftwareUpdateActionAttachmentsApi* | [**device_software_update_action_attachments_device_software_update_action_attachment_id_delete**](docs/DeviceSoftwareUpdateActionAttachmentsApi.md#device_software_update_action_attachments_device_software_update_action_attachment_id_delete) | **DELETE** /device-software-update-action-attachments/{device_software_update_action_attachment_id} | 
*DeviceSoftwareUpdateActionAttachmentsApi* | [**device_software_update_action_attachments_device_software_update_action_attachment_id_get**](docs/DeviceSoftwareUpdateActionAttachmentsApi.md#device_software_update_action_attachments_device_software_update_action_attachment_id_get) | **GET** /device-software-update-action-attachments/{device_software_update_action_attachment_id} | 
*DeviceSoftwareUpdateActionAttachmentsApi* | [**device_software_update_action_attachments_device_software_update_action_attachment_id_patch**](docs/DeviceSoftwareUpdateActionAttachmentsApi.md#device_software_update_action_attachments_device_software_update_action_attachment_id_patch) | **PATCH** /device-software-update-action-attachments/{device_software_update_action_attachment_id} | 
*DeviceSoftwareUpdateActionAttachmentsApi* | [**device_software_update_action_attachments_get**](docs/DeviceSoftwareUpdateActionAttachmentsApi.md#device_software_update_action_attachments_get) | **GET** /device-software-update-action-attachments | 
*DeviceSoftwareUpdateActionAttachmentsApi* | [**device_software_update_action_attachments_post**](docs/DeviceSoftwareUpdateActionAttachmentsApi.md#device_software_update_action_attachments_post) | **POST** /device-software-update-action-attachments | 
*DeviceSoftwareUpdateActionsApi* | [**device_software_update_actions_device_software_update_action_id_delete**](docs/DeviceSoftwareUpdateActionsApi.md#device_software_update_actions_device_software_update_action_id_delete) | **DELETE** /device-software-update-actions/{device_software_update_action_id} | 
*DeviceSoftwareUpdateActionsApi* | [**device_software_update_actions_device_software_update_action_id_get**](docs/DeviceSoftwareUpdateActionsApi.md#device_software_update_actions_device_software_update_action_id_get) | **GET** /device-software-update-actions/{device_software_update_action_id} | 
*DeviceSoftwareUpdateActionsApi* | [**device_software_update_actions_device_software_update_action_id_patch**](docs/DeviceSoftwareUpdateActionsApi.md#device_software_update_actions_device_software_update_action_id_patch) | **PATCH** /device-software-update-actions/{device_software_update_action_id} | 
*DeviceSoftwareUpdateActionsApi* | [**device_software_update_actions_get**](docs/DeviceSoftwareUpdateActionsApi.md#device_software_update_actions_get) | **GET** /device-software-update-actions | 
*DeviceSoftwareUpdateActionsApi* | [**device_software_update_actions_post**](docs/DeviceSoftwareUpdateActionsApi.md#device_software_update_actions_post) | **POST** /device-software-update-actions | 
*DevicesApi* | [**archive_device**](docs/DevicesApi.md#archive_device) | **POST** /devices/{device_id}/archive | 
*DevicesApi* | [**create_device0**](docs/DevicesApi.md#create_device0) | **POST** /devices | 
*DevicesApi* | [**delete_devicefromdevice3**](docs/DevicesApi.md#delete_devicefromdevice3) | **DELETE** /devices/{device_id} | 
*DevicesApi* | [**restore_device**](docs/DevicesApi.md#restore_device) | **POST** /devices/{device_id}/restore | 
*DevicesApi* | [**retrieve_device_sensor_ml**](docs/DevicesApi.md#retrieve_device_sensor_ml) | **GET** /devices/{device_id}/sensorml | 
*DevicesApi* | [**retrieve_deviceinstance0**](docs/DevicesApi.md#retrieve_deviceinstance0) | **GET** /devices/{device_id} | 
*DevicesApi* | [**retrieveacollectionof_deviceobjects0**](docs/DevicesApi.md#retrieveacollectionof_deviceobjects0) | **GET** /devices | 
*DevicesApi* | [**update_device0**](docs/DevicesApi.md#update_device0) | **PATCH** /devices/{device_id} | 
*DynamicLocationActionsApi* | [**dynamic_location_actions_dynamic_location_action_id_delete**](docs/DynamicLocationActionsApi.md#dynamic_location_actions_dynamic_location_action_id_delete) | **DELETE** /dynamic-location-actions/{dynamic_location_action_id} | 
*DynamicLocationActionsApi* | [**dynamic_location_actions_dynamic_location_action_id_get**](docs/DynamicLocationActionsApi.md#dynamic_location_actions_dynamic_location_action_id_get) | **GET** /dynamic-location-actions/{dynamic_location_action_id} | 
*DynamicLocationActionsApi* | [**dynamic_location_actions_dynamic_location_action_id_patch**](docs/DynamicLocationActionsApi.md#dynamic_location_actions_dynamic_location_action_id_patch) | **PATCH** /dynamic-location-actions/{dynamic_location_action_id} | 
*DynamicLocationActionsApi* | [**dynamic_location_actions_get**](docs/DynamicLocationActionsApi.md#dynamic_location_actions_get) | **GET** /dynamic-location-actions | 
*DynamicLocationActionsApi* | [**dynamic_location_actions_post**](docs/DynamicLocationActionsApi.md#dynamic_location_actions_post) | **POST** /dynamic-location-actions | 
*ExportControlApi* | [**create_export_control**](docs/ExportControlApi.md#create_export_control) | **POST** /export-control | 
*ExportControlApi* | [**delete_export_control**](docs/ExportControlApi.md#delete_export_control) | **DELETE** /export-control/{export_control_id} | 
*ExportControlApi* | [**retrieve_export_control_instance**](docs/ExportControlApi.md#retrieve_export_control_instance) | **GET** /export-control/{export_control_id} | 
*ExportControlApi* | [**retrievecollectionof_export_controlobjects**](docs/ExportControlApi.md#retrievecollectionof_export_controlobjects) | **GET** /export-control | 
*ExportControlApi* | [**update_export_control**](docs/ExportControlApi.md#update_export_control) | **PATCH** /export-control/{export_control_id} | 
*ExportControlAttachmentsApi* | [**create_export_control_attachment**](docs/ExportControlAttachmentsApi.md#create_export_control_attachment) | **POST** /export-control-attachments | 
*ExportControlAttachmentsApi* | [**delete_export_control_attachment**](docs/ExportControlAttachmentsApi.md#delete_export_control_attachment) | **DELETE** /export-control-attachments/{export_control_attachment_id} | 
*ExportControlAttachmentsApi* | [**export_control_attachments_export_control_attachment_id_file_filename_get**](docs/ExportControlAttachmentsApi.md#export_control_attachments_export_control_attachment_id_file_filename_get) | **GET** /export-control-attachments/{export_control_attachment_id}/file/{filename} | 
*ExportControlAttachmentsApi* | [**retrieve_export_control_attachment_instance**](docs/ExportControlAttachmentsApi.md#retrieve_export_control_attachment_instance) | **GET** /export-control-attachments/{export_control_attachment_id} | 
*ExportControlAttachmentsApi* | [**retrievecollectionof_export_control_attachmentobjects**](docs/ExportControlAttachmentsApi.md#retrievecollectionof_export_control_attachmentobjects) | **GET** /export-control-attachments | 
*ExportControlAttachmentsApi* | [**update_export_control_attachment**](docs/ExportControlAttachmentsApi.md#update_export_control_attachment) | **PATCH** /export-control-attachments/{export_control_attachment_id} | 
*GenericConfigurationActionAttachmentsApi* | [**generic_configuration_action_attachments_generic_configuration_action_attachment_id_delete**](docs/GenericConfigurationActionAttachmentsApi.md#generic_configuration_action_attachments_generic_configuration_action_attachment_id_delete) | **DELETE** /generic-configuration-action-attachments/{generic_configuration_action_attachment_id} | 
*GenericConfigurationActionAttachmentsApi* | [**generic_configuration_action_attachments_generic_configuration_action_attachment_id_get**](docs/GenericConfigurationActionAttachmentsApi.md#generic_configuration_action_attachments_generic_configuration_action_attachment_id_get) | **GET** /generic-configuration-action-attachments/{generic_configuration_action_attachment_id} | 
*GenericConfigurationActionAttachmentsApi* | [**generic_configuration_action_attachments_generic_configuration_action_attachment_id_patch**](docs/GenericConfigurationActionAttachmentsApi.md#generic_configuration_action_attachments_generic_configuration_action_attachment_id_patch) | **PATCH** /generic-configuration-action-attachments/{generic_configuration_action_attachment_id} | 
*GenericConfigurationActionAttachmentsApi* | [**generic_configuration_action_attachments_get**](docs/GenericConfigurationActionAttachmentsApi.md#generic_configuration_action_attachments_get) | **GET** /generic-configuration-action-attachments | 
*GenericConfigurationActionAttachmentsApi* | [**generic_configuration_action_attachments_post**](docs/GenericConfigurationActionAttachmentsApi.md#generic_configuration_action_attachments_post) | **POST** /generic-configuration-action-attachments | 
*GenericConfigurationActionsApi* | [**generic_configuration_actions_generic_configuration_action_id_delete**](docs/GenericConfigurationActionsApi.md#generic_configuration_actions_generic_configuration_action_id_delete) | **DELETE** /generic-configuration-actions/{generic_configuration_action_id} | 
*GenericConfigurationActionsApi* | [**generic_configuration_actions_generic_configuration_action_id_get**](docs/GenericConfigurationActionsApi.md#generic_configuration_actions_generic_configuration_action_id_get) | **GET** /generic-configuration-actions/{generic_configuration_action_id} | 
*GenericConfigurationActionsApi* | [**generic_configuration_actions_generic_configuration_action_id_patch**](docs/GenericConfigurationActionsApi.md#generic_configuration_actions_generic_configuration_action_id_patch) | **PATCH** /generic-configuration-actions/{generic_configuration_action_id} | 
*GenericConfigurationActionsApi* | [**generic_configuration_actions_get**](docs/GenericConfigurationActionsApi.md#generic_configuration_actions_get) | **GET** /generic-configuration-actions | 
*GenericConfigurationActionsApi* | [**generic_configuration_actions_post**](docs/GenericConfigurationActionsApi.md#generic_configuration_actions_post) | **POST** /generic-configuration-actions | 
*GenericDeviceActionAttachmentsApi* | [**generic_device_action_attachments_generic_device_action_attachment_id_delete**](docs/GenericDeviceActionAttachmentsApi.md#generic_device_action_attachments_generic_device_action_attachment_id_delete) | **DELETE** /generic-device-action-attachments/{generic_device_action_attachment_id} | 
*GenericDeviceActionAttachmentsApi* | [**generic_device_action_attachments_generic_device_action_attachment_id_get**](docs/GenericDeviceActionAttachmentsApi.md#generic_device_action_attachments_generic_device_action_attachment_id_get) | **GET** /generic-device-action-attachments/{generic_device_action_attachment_id} | 
*GenericDeviceActionAttachmentsApi* | [**generic_device_action_attachments_generic_device_action_attachment_id_patch**](docs/GenericDeviceActionAttachmentsApi.md#generic_device_action_attachments_generic_device_action_attachment_id_patch) | **PATCH** /generic-device-action-attachments/{generic_device_action_attachment_id} | 
*GenericDeviceActionAttachmentsApi* | [**generic_device_action_attachments_get**](docs/GenericDeviceActionAttachmentsApi.md#generic_device_action_attachments_get) | **GET** /generic-device-action-attachments | 
*GenericDeviceActionAttachmentsApi* | [**generic_device_action_attachments_post**](docs/GenericDeviceActionAttachmentsApi.md#generic_device_action_attachments_post) | **POST** /generic-device-action-attachments | 
*GenericDeviceActionsApi* | [**generic_device_actions_generic_device_action_id_delete**](docs/GenericDeviceActionsApi.md#generic_device_actions_generic_device_action_id_delete) | **DELETE** /generic-device-actions/{generic_device_action_id} | 
*GenericDeviceActionsApi* | [**generic_device_actions_generic_device_action_id_get**](docs/GenericDeviceActionsApi.md#generic_device_actions_generic_device_action_id_get) | **GET** /generic-device-actions/{generic_device_action_id} | 
*GenericDeviceActionsApi* | [**generic_device_actions_generic_device_action_id_patch**](docs/GenericDeviceActionsApi.md#generic_device_actions_generic_device_action_id_patch) | **PATCH** /generic-device-actions/{generic_device_action_id} | 
*GenericDeviceActionsApi* | [**generic_device_actions_get**](docs/GenericDeviceActionsApi.md#generic_device_actions_get) | **GET** /generic-device-actions | 
*GenericDeviceActionsApi* | [**generic_device_actions_post**](docs/GenericDeviceActionsApi.md#generic_device_actions_post) | **POST** /generic-device-actions | 
*GenericPlatformActionAttachmentsApi* | [**generic_platform_action_attachments_generic_platform_action_attachment_id_delete**](docs/GenericPlatformActionAttachmentsApi.md#generic_platform_action_attachments_generic_platform_action_attachment_id_delete) | **DELETE** /generic-platform-action-attachments/{generic_platform_action_attachment_id} | 
*GenericPlatformActionAttachmentsApi* | [**generic_platform_action_attachments_generic_platform_action_attachment_id_get**](docs/GenericPlatformActionAttachmentsApi.md#generic_platform_action_attachments_generic_platform_action_attachment_id_get) | **GET** /generic-platform-action-attachments/{generic_platform_action_attachment_id} | 
*GenericPlatformActionAttachmentsApi* | [**generic_platform_action_attachments_generic_platform_action_attachment_id_patch**](docs/GenericPlatformActionAttachmentsApi.md#generic_platform_action_attachments_generic_platform_action_attachment_id_patch) | **PATCH** /generic-platform-action-attachments/{generic_platform_action_attachment_id} | 
*GenericPlatformActionAttachmentsApi* | [**generic_platform_action_attachments_get**](docs/GenericPlatformActionAttachmentsApi.md#generic_platform_action_attachments_get) | **GET** /generic-platform-action-attachments | 
*GenericPlatformActionAttachmentsApi* | [**generic_platform_action_attachments_post**](docs/GenericPlatformActionAttachmentsApi.md#generic_platform_action_attachments_post) | **POST** /generic-platform-action-attachments | 
*GenericPlatformActionsApi* | [**generic_platform_actions_generic_platform_action_id_delete**](docs/GenericPlatformActionsApi.md#generic_platform_actions_generic_platform_action_id_delete) | **DELETE** /generic-platform-actions/{generic_platform_action_id} | 
*GenericPlatformActionsApi* | [**generic_platform_actions_generic_platform_action_id_get**](docs/GenericPlatformActionsApi.md#generic_platform_actions_generic_platform_action_id_get) | **GET** /generic-platform-actions/{generic_platform_action_id} | 
*GenericPlatformActionsApi* | [**generic_platform_actions_generic_platform_action_id_patch**](docs/GenericPlatformActionsApi.md#generic_platform_actions_generic_platform_action_id_patch) | **PATCH** /generic-platform-actions/{generic_platform_action_id} | 
*GenericPlatformActionsApi* | [**generic_platform_actions_get**](docs/GenericPlatformActionsApi.md#generic_platform_actions_get) | **GET** /generic-platform-actions | 
*GenericPlatformActionsApi* | [**generic_platform_actions_post**](docs/GenericPlatformActionsApi.md#generic_platform_actions_post) | **POST** /generic-platform-actions | 
*ManufacturerModelsApi* | [**retrieve_manufacturer_modelinstance0**](docs/ManufacturerModelsApi.md#retrieve_manufacturer_modelinstance0) | **GET** /manufacturer-models/{manufacturer_model_id} | 
*ManufacturerModelsApi* | [**retrieveacollectionof_manufacturer_modelobjects0**](docs/ManufacturerModelsApi.md#retrieveacollectionof_manufacturer_modelobjects0) | **GET** /manufacturer-models | 
*PermissionGroupsApi* | [**get_permission_groups**](docs/PermissionGroupsApi.md#get_permission_groups) | **GET** /permission-groups | 
*PidsApi* | [**create_pid**](docs/PidsApi.md#create_pid) | **POST** /pids | 
*PlatformAttachmentsApi* | [**create_platform_attachment0**](docs/PlatformAttachmentsApi.md#create_platform_attachment0) | **POST** /platform-attachments | 
*PlatformAttachmentsApi* | [**delete_platform_attachmentfromplatformattachment0**](docs/PlatformAttachmentsApi.md#delete_platform_attachmentfromplatformattachment0) | **DELETE** /platform-attachments/{platform_attachment_id} | 
*PlatformAttachmentsApi* | [**platform_attachments_platform_attachment_id_file_filename_get**](docs/PlatformAttachmentsApi.md#platform_attachments_platform_attachment_id_file_filename_get) | **GET** /platform-attachments/{platform_attachment_id}/file/{filename} | 
*PlatformAttachmentsApi* | [**retrieve_platform_attachmentinstance0**](docs/PlatformAttachmentsApi.md#retrieve_platform_attachmentinstance0) | **GET** /platform-attachments/{platform_attachment_id} | 
*PlatformAttachmentsApi* | [**retrieveacollectionof_platform_attachmentobjects0**](docs/PlatformAttachmentsApi.md#retrieveacollectionof_platform_attachmentobjects0) | **GET** /platform-attachments | 
*PlatformAttachmentsApi* | [**update_platform_attachment0**](docs/PlatformAttachmentsApi.md#update_platform_attachment0) | **PATCH** /platform-attachments/{platform_attachment_id} | 
*PlatformImagesApi* | [**create_platform_image**](docs/PlatformImagesApi.md#create_platform_image) | **POST** /platform-images | 
*PlatformImagesApi* | [**delete_platform_image**](docs/PlatformImagesApi.md#delete_platform_image) | **DELETE** /platform-images/{platform_image_id} | 
*PlatformImagesApi* | [**retrieve_platform_image_instance**](docs/PlatformImagesApi.md#retrieve_platform_image_instance) | **GET** /platform-images/{platform_image_id} | 
*PlatformImagesApi* | [**retrievecollectionof_platform_imageobjects**](docs/PlatformImagesApi.md#retrievecollectionof_platform_imageobjects) | **GET** /platform-images | 
*PlatformImagesApi* | [**update_platform_image**](docs/PlatformImagesApi.md#update_platform_image) | **PATCH** /platform-images/{platform_image_id} | 
*PlatformMountActionsApi* | [**platform_mount_actions_get**](docs/PlatformMountActionsApi.md#platform_mount_actions_get) | **GET** /platform-mount-actions | 
*PlatformMountActionsApi* | [**platform_mount_actions_platform_mount_action_id_delete**](docs/PlatformMountActionsApi.md#platform_mount_actions_platform_mount_action_id_delete) | **DELETE** /platform-mount-actions/{platform_mount_action_id} | 
*PlatformMountActionsApi* | [**platform_mount_actions_platform_mount_action_id_get**](docs/PlatformMountActionsApi.md#platform_mount_actions_platform_mount_action_id_get) | **GET** /platform-mount-actions/{platform_mount_action_id} | 
*PlatformMountActionsApi* | [**platform_mount_actions_platform_mount_action_id_patch**](docs/PlatformMountActionsApi.md#platform_mount_actions_platform_mount_action_id_patch) | **PATCH** /platform-mount-actions/{platform_mount_action_id} | 
*PlatformMountActionsApi* | [**platform_mount_actions_post**](docs/PlatformMountActionsApi.md#platform_mount_actions_post) | **POST** /platform-mount-actions | 
*PlatformParameterValueChangeActionsApi* | [**create_platform_parameter_valuechange_action**](docs/PlatformParameterValueChangeActionsApi.md#create_platform_parameter_valuechange_action) | **POST** /platform-parameter-value-change-actions | 
*PlatformParameterValueChangeActionsApi* | [**delete_platform_parameter_value_change_action**](docs/PlatformParameterValueChangeActionsApi.md#delete_platform_parameter_value_change_action) | **DELETE** /platform-parameter-value-change-actions/{platform_parameter_value_change_action_id} | 
*PlatformParameterValueChangeActionsApi* | [**retriececollectionof_platform_parameter_value_change_actionobjects**](docs/PlatformParameterValueChangeActionsApi.md#retriececollectionof_platform_parameter_value_change_actionobjects) | **GET** /platform-parameter-value-change-actions | 
*PlatformParameterValueChangeActionsApi* | [**retrieve_platform_parameter_value_change_actioninstance**](docs/PlatformParameterValueChangeActionsApi.md#retrieve_platform_parameter_value_change_actioninstance) | **GET** /platform-parameter-value-change-actions/{platform_parameter_value_change_action_id} | 
*PlatformParameterValueChangeActionsApi* | [**update_platform_parameter_value_change_action**](docs/PlatformParameterValueChangeActionsApi.md#update_platform_parameter_value_change_action) | **PATCH** /platform-parameter-value-change-actions/{platform_parameter_value_change_action_id} | 
*PlatformParametersApi* | [**create_platform_parameter**](docs/PlatformParametersApi.md#create_platform_parameter) | **POST** /platform-parameters | 
*PlatformParametersApi* | [**delete_platform_parameter**](docs/PlatformParametersApi.md#delete_platform_parameter) | **DELETE** /platform-parameters/{platform_parameter_id} | 
*PlatformParametersApi* | [**retriececollectionof_platform_parameterobjects**](docs/PlatformParametersApi.md#retriececollectionof_platform_parameterobjects) | **GET** /platform-parameters | 
*PlatformParametersApi* | [**retrieve_platform_parameterinstance**](docs/PlatformParametersApi.md#retrieve_platform_parameterinstance) | **GET** /platform-parameters/{platform_parameter_id} | 
*PlatformParametersApi* | [**update_platform_parameter**](docs/PlatformParametersApi.md#update_platform_parameter) | **PATCH** /platform-parameters/{platform_parameter_id} | 
*PlatformSoftwareUpdateActionAttachmentsApi* | [**platform_software_update_action_attachments_get**](docs/PlatformSoftwareUpdateActionAttachmentsApi.md#platform_software_update_action_attachments_get) | **GET** /platform-software-update-action-attachments | 
*PlatformSoftwareUpdateActionAttachmentsApi* | [**platform_software_update_action_attachments_platform_software_update_action_attachment_id_delete**](docs/PlatformSoftwareUpdateActionAttachmentsApi.md#platform_software_update_action_attachments_platform_software_update_action_attachment_id_delete) | **DELETE** /platform-software-update-action-attachments/{platform_software_update_action_attachment_id} | 
*PlatformSoftwareUpdateActionAttachmentsApi* | [**platform_software_update_action_attachments_platform_software_update_action_attachment_id_get**](docs/PlatformSoftwareUpdateActionAttachmentsApi.md#platform_software_update_action_attachments_platform_software_update_action_attachment_id_get) | **GET** /platform-software-update-action-attachments/{platform_software_update_action_attachment_id} | 
*PlatformSoftwareUpdateActionAttachmentsApi* | [**platform_software_update_action_attachments_platform_software_update_action_attachment_id_patch**](docs/PlatformSoftwareUpdateActionAttachmentsApi.md#platform_software_update_action_attachments_platform_software_update_action_attachment_id_patch) | **PATCH** /platform-software-update-action-attachments/{platform_software_update_action_attachment_id} | 
*PlatformSoftwareUpdateActionAttachmentsApi* | [**platform_software_update_action_attachments_post**](docs/PlatformSoftwareUpdateActionAttachmentsApi.md#platform_software_update_action_attachments_post) | **POST** /platform-software-update-action-attachments | 
*PlatformSoftwareUpdateActionsApi* | [**platform_software_update_actions_get**](docs/PlatformSoftwareUpdateActionsApi.md#platform_software_update_actions_get) | **GET** /platform-software-update-actions | 
*PlatformSoftwareUpdateActionsApi* | [**platform_software_update_actions_platform_software_update_action_id_delete**](docs/PlatformSoftwareUpdateActionsApi.md#platform_software_update_actions_platform_software_update_action_id_delete) | **DELETE** /platform-software-update-actions/{platform_software_update_action_id} | 
*PlatformSoftwareUpdateActionsApi* | [**platform_software_update_actions_platform_software_update_action_id_get**](docs/PlatformSoftwareUpdateActionsApi.md#platform_software_update_actions_platform_software_update_action_id_get) | **GET** /platform-software-update-actions/{platform_software_update_action_id} | 
*PlatformSoftwareUpdateActionsApi* | [**platform_software_update_actions_platform_software_update_action_id_patch**](docs/PlatformSoftwareUpdateActionsApi.md#platform_software_update_actions_platform_software_update_action_id_patch) | **PATCH** /platform-software-update-actions/{platform_software_update_action_id} | 
*PlatformSoftwareUpdateActionsApi* | [**platform_software_update_actions_post**](docs/PlatformSoftwareUpdateActionsApi.md#platform_software_update_actions_post) | **POST** /platform-software-update-actions | 
*PlatformsApi* | [**archive_platform**](docs/PlatformsApi.md#archive_platform) | **POST** /platforms/{platform_id}/archive | 
*PlatformsApi* | [**create_platform0**](docs/PlatformsApi.md#create_platform0) | **POST** /platforms | 
*PlatformsApi* | [**delete_platformfromplatform3**](docs/PlatformsApi.md#delete_platformfromplatform3) | **DELETE** /platforms/{platform_id} | 
*PlatformsApi* | [**restore_platform**](docs/PlatformsApi.md#restore_platform) | **POST** /platforms/{platform_id}/restore | 
*PlatformsApi* | [**retrieve_platform_sensor_ml**](docs/PlatformsApi.md#retrieve_platform_sensor_ml) | **GET** /platforms/{platform_id}/sensorml | 
*PlatformsApi* | [**retrieve_platforminstance0**](docs/PlatformsApi.md#retrieve_platforminstance0) | **GET** /platforms/{platform_id} | 
*PlatformsApi* | [**retrieveacollectionof_platformobjects0**](docs/PlatformsApi.md#retrieveacollectionof_platformobjects0) | **GET** /platforms | 
*PlatformsApi* | [**update_platform0**](docs/PlatformsApi.md#update_platform0) | **PATCH** /platforms/{platform_id} | 
*SiteAttachmentsApi* | [**create_site_attachment0**](docs/SiteAttachmentsApi.md#create_site_attachment0) | **POST** /site-attachments | 
*SiteAttachmentsApi* | [**delete_site_attachmentfromsiteattachment0**](docs/SiteAttachmentsApi.md#delete_site_attachmentfromsiteattachment0) | **DELETE** /site-attachments/{site_attachment_id} | 
*SiteAttachmentsApi* | [**retrieve_site_attachmentinstance0**](docs/SiteAttachmentsApi.md#retrieve_site_attachmentinstance0) | **GET** /site-attachments/{site_attachment_id} | 
*SiteAttachmentsApi* | [**retrieveacollectionof_site_attachmentobjects0**](docs/SiteAttachmentsApi.md#retrieveacollectionof_site_attachmentobjects0) | **GET** /site-attachments | 
*SiteAttachmentsApi* | [**site_attachments_site_attachment_id_file_filename_get**](docs/SiteAttachmentsApi.md#site_attachments_site_attachment_id_file_filename_get) | **GET** /site-attachments/{site_attachment_id}/file/{filename} | 
*SiteAttachmentsApi* | [**update_site_attachment0**](docs/SiteAttachmentsApi.md#update_site_attachment0) | **PATCH** /site-attachments/{site_attachment_id} | 
*SiteImagesApi* | [**create_site_image**](docs/SiteImagesApi.md#create_site_image) | **POST** /site-images | 
*SiteImagesApi* | [**delete_site_image**](docs/SiteImagesApi.md#delete_site_image) | **DELETE** /site-images/{site_image_id} | 
*SiteImagesApi* | [**retrieve_site_image_instance**](docs/SiteImagesApi.md#retrieve_site_image_instance) | **GET** /site-images/{site_image_id} | 
*SiteImagesApi* | [**retrievecollectionof_site_imageobjects**](docs/SiteImagesApi.md#retrievecollectionof_site_imageobjects) | **GET** /site-images | 
*SiteImagesApi* | [**update_site_image**](docs/SiteImagesApi.md#update_site_image) | **PATCH** /site-images/{site_image_id} | 
*SitesApi* | [**archive_site**](docs/SitesApi.md#archive_site) | **POST** /sites/{site_id}/archive | 
*SitesApi* | [**create_site0**](docs/SitesApi.md#create_site0) | **POST** /sites | 
*SitesApi* | [**delete_sitefromsite0**](docs/SitesApi.md#delete_sitefromsite0) | **DELETE** /sites/{site_id} | 
*SitesApi* | [**restore_site**](docs/SitesApi.md#restore_site) | **POST** /sites/{site_id}/restore | 
*SitesApi* | [**retrieve_site_sensor_ml**](docs/SitesApi.md#retrieve_site_sensor_ml) | **GET** /sites/{site_id}/sensorml | 
*SitesApi* | [**retrieve_siteinstance0**](docs/SitesApi.md#retrieve_siteinstance0) | **GET** /sites/{site_id} | 
*SitesApi* | [**retrieveacollectionof_siteobjects0**](docs/SitesApi.md#retrieveacollectionof_siteobjects0) | **GET** /sites | 
*SitesApi* | [**update_site0**](docs/SitesApi.md#update_site0) | **PATCH** /sites/{site_id} | 
*StaticLocationActionsApi* | [**static_location_actions_get**](docs/StaticLocationActionsApi.md#static_location_actions_get) | **GET** /static-location-actions | 
*StaticLocationActionsApi* | [**static_location_actions_post**](docs/StaticLocationActionsApi.md#static_location_actions_post) | **POST** /static-location-actions | 
*StaticLocationActionsApi* | [**static_location_actions_static_location_action_id_delete**](docs/StaticLocationActionsApi.md#static_location_actions_static_location_action_id_delete) | **DELETE** /static-location-actions/{static_location_action_id} | 
*StaticLocationActionsApi* | [**static_location_actions_static_location_action_id_get**](docs/StaticLocationActionsApi.md#static_location_actions_static_location_action_id_get) | **GET** /static-location-actions/{static_location_action_id} | 
*StaticLocationActionsApi* | [**static_location_actions_static_location_action_id_patch**](docs/StaticLocationActionsApi.md#static_location_actions_static_location_action_id_patch) | **PATCH** /static-location-actions/{static_location_action_id} | 
*TsmEndpointsApi* | [**retrieveacollectionof_tsm_endpoint_objects**](docs/TsmEndpointsApi.md#retrieveacollectionof_tsm_endpoint_objects) | **GET** /tsm-endpoints | 
*TsmEndpointsApi* | [**retrieveinstanceof_tsm_endpoint_object**](docs/TsmEndpointsApi.md#retrieveinstanceof_tsm_endpoint_object) | **GET** /tsm-endpoints/{tsm_endpoint_id} | 
*UploadApi* | [**upload_attachment0**](docs/UploadApi.md#upload_attachment0) | **POST** /upload | 
*UsageStatisticsApi* | [**get_usage_statistics**](docs/UsageStatisticsApi.md#get_usage_statistics) | **GET** /usage-statistics | 
*UserApi* | [**accept_terms_of_use_post**](docs/UserApi.md#accept_terms_of_use_post) | **POST** /accept-terms-of-use | 
*UserApi* | [**get_user_info**](docs/UserApi.md#get_user_info) | **GET** /user-info | 
*UserApi* | [**revoke_apikey_post**](docs/UserApi.md#revoke_apikey_post) | **POST** /revoke-apikey | 


## Documentation For Models

 - [AcceptTermsOfUsePost200Response](docs/AcceptTermsOfUsePost200Response.md)
 - [AcceptTermsOfUsePost200ResponseData](docs/AcceptTermsOfUsePost200ResponseData.md)
 - [AcceptTermsOfUsePost200ResponseDataAttributes](docs/AcceptTermsOfUsePost200ResponseDataAttributes.md)
 - [ArchiveConfiguration403Response](docs/ArchiveConfiguration403Response.md)
 - [AuthentificationRequired](docs/AuthentificationRequired.md)
 - [ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response](docs/ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response.md)
 - [ConfigurationContactRolesConfigurationContactRoleIdPatchRequest](docs/ConfigurationContactRolesConfigurationContactRoleIdPatchRequest.md)
 - [ConfigurationContactRolesGet200Response](docs/ConfigurationContactRolesGet200Response.md)
 - [ConfigurationContactRolesGet200ResponseDataInner](docs/ConfigurationContactRolesGet200ResponseDataInner.md)
 - [ConfigurationContactRolesGet200ResponseDataInnerAttributes](docs/ConfigurationContactRolesGet200ResponseDataInnerAttributes.md)
 - [ConfigurationContactRolesGet200ResponseDataInnerRelationships](docs/ConfigurationContactRolesGet200ResponseDataInnerRelationships.md)
 - [ConfigurationContactRolesGet200ResponseDataInnerRelationshipsContact](docs/ConfigurationContactRolesGet200ResponseDataInnerRelationshipsContact.md)
 - [ConfigurationContactRolesGet200ResponseDataInnerRelationshipsContactData](docs/ConfigurationContactRolesGet200ResponseDataInnerRelationshipsContactData.md)
 - [ConfigurationContactRolesPost201Response](docs/ConfigurationContactRolesPost201Response.md)
 - [ConfigurationContactRolesPostRequest](docs/ConfigurationContactRolesPostRequest.md)
 - [ConfigurationContactRolesPostRequestData](docs/ConfigurationContactRolesPostRequestData.md)
 - [ConfigurationContactRolesPostRequestDataAttributes](docs/ConfigurationContactRolesPostRequestDataAttributes.md)
 - [Conflict](docs/Conflict.md)
 - [ConflictErrorsInner](docs/ConflictErrorsInner.md)
 - [ControllerConfigurationsConfigurationIdLocationActionTimepointsGet200Response](docs/ControllerConfigurationsConfigurationIdLocationActionTimepointsGet200Response.md)
 - [ControllerConfigurationsConfigurationIdLocationActionTimepointsGet200ResponseDataInner](docs/ControllerConfigurationsConfigurationIdLocationActionTimepointsGet200ResponseDataInner.md)
 - [ControllerConfigurationsConfigurationIdMountingActionTimepointsGet200Response](docs/ControllerConfigurationsConfigurationIdMountingActionTimepointsGet200Response.md)
 - [ControllerConfigurationsConfigurationIdMountingActionsGet200Response](docs/ControllerConfigurationsConfigurationIdMountingActionsGet200Response.md)
 - [ControllerConfigurationsConfigurationIdParameterValuesGet200Response](docs/ControllerConfigurationsConfigurationIdParameterValuesGet200Response.md)
 - [ControllerConfigurationsConfigurationIdParameterValuesGet200ResponseDataInner](docs/ControllerConfigurationsConfigurationIdParameterValuesGet200ResponseDataInner.md)
 - [ControllerConfigurationsConfigurationIdParameterValuesGet200ResponseDataInnerAttributes](docs/ControllerConfigurationsConfigurationIdParameterValuesGet200ResponseDataInnerAttributes.md)
 - [ControllerDeviceAvailabilitiesGet200Response](docs/ControllerDeviceAvailabilitiesGet200Response.md)
 - [ControllerPlatformAvailabilitiesGet200Response](docs/ControllerPlatformAvailabilitiesGet200Response.md)
 - [ControllerPlatformSerialNumbers200Response](docs/ControllerPlatformSerialNumbers200Response.md)
 - [CreateConfiguration0201Response](docs/CreateConfiguration0201Response.md)
 - [CreateConfiguration0Request](docs/CreateConfiguration0Request.md)
 - [CreateConfiguration0RequestData](docs/CreateConfiguration0RequestData.md)
 - [CreateConfiguration0RequestDataAttributes](docs/CreateConfiguration0RequestDataAttributes.md)
 - [CreateConfiguration0RequestDataRelationships](docs/CreateConfiguration0RequestDataRelationships.md)
 - [CreateConfigurationAttachment0201Response](docs/CreateConfigurationAttachment0201Response.md)
 - [CreateConfigurationAttachment0Request](docs/CreateConfigurationAttachment0Request.md)
 - [CreateConfigurationAttachment0RequestData](docs/CreateConfigurationAttachment0RequestData.md)
 - [CreateConfigurationAttachment0RequestDataAttributes](docs/CreateConfigurationAttachment0RequestDataAttributes.md)
 - [CreateConfigurationAttachment0RequestDataRelationships](docs/CreateConfigurationAttachment0RequestDataRelationships.md)
 - [CreateConfigurationCustomField0201Response](docs/CreateConfigurationCustomField0201Response.md)
 - [CreateConfigurationCustomField0Request](docs/CreateConfigurationCustomField0Request.md)
 - [CreateConfigurationCustomField0RequestData](docs/CreateConfigurationCustomField0RequestData.md)
 - [CreateConfigurationCustomField0RequestDataAttributes](docs/CreateConfigurationCustomField0RequestDataAttributes.md)
 - [CreateConfigurationImage201Response](docs/CreateConfigurationImage201Response.md)
 - [CreateConfigurationImageRequest](docs/CreateConfigurationImageRequest.md)
 - [CreateConfigurationImageRequestData](docs/CreateConfigurationImageRequestData.md)
 - [CreateConfigurationImageRequestDataAttributes](docs/CreateConfigurationImageRequestDataAttributes.md)
 - [CreateConfigurationImageRequestDataRelationships](docs/CreateConfigurationImageRequestDataRelationships.md)
 - [CreateConfigurationParameter201Response](docs/CreateConfigurationParameter201Response.md)
 - [CreateConfigurationParameterRequest](docs/CreateConfigurationParameterRequest.md)
 - [CreateConfigurationParameterRequestData](docs/CreateConfigurationParameterRequestData.md)
 - [CreateConfigurationParameterRequestDataAttributes](docs/CreateConfigurationParameterRequestDataAttributes.md)
 - [CreateConfigurationParameterRequestDataRelationships](docs/CreateConfigurationParameterRequestDataRelationships.md)
 - [CreateConfigurationParameterValuechangeAction201Response](docs/CreateConfigurationParameterValuechangeAction201Response.md)
 - [CreateConfigurationParameterValuechangeActionRequest](docs/CreateConfigurationParameterValuechangeActionRequest.md)
 - [CreateConfigurationParameterValuechangeActionRequestData](docs/CreateConfigurationParameterValuechangeActionRequestData.md)
 - [CreateConfigurationParameterValuechangeActionRequestDataAttributes](docs/CreateConfigurationParameterValuechangeActionRequestDataAttributes.md)
 - [CreateConfigurationParameterValuechangeActionRequestDataRelationships](docs/CreateConfigurationParameterValuechangeActionRequestDataRelationships.md)
 - [CreateContact0201Response](docs/CreateContact0201Response.md)
 - [CreateContact0Request](docs/CreateContact0Request.md)
 - [CreateContact0RequestData](docs/CreateContact0RequestData.md)
 - [CreateContact0RequestDataAttributes](docs/CreateContact0RequestDataAttributes.md)
 - [CreateCustomField0201Response](docs/CreateCustomField0201Response.md)
 - [CreateCustomField0Request](docs/CreateCustomField0Request.md)
 - [CreateCustomField0RequestData](docs/CreateCustomField0RequestData.md)
 - [CreateDatastreamLink201Response](docs/CreateDatastreamLink201Response.md)
 - [CreateDatastreamLinkRequest](docs/CreateDatastreamLinkRequest.md)
 - [CreateDatastreamLinkRequestData](docs/CreateDatastreamLinkRequestData.md)
 - [CreateDatastreamLinkRequestDataAttributes](docs/CreateDatastreamLinkRequestDataAttributes.md)
 - [CreateDatastreamLinkRequestDataRelationships](docs/CreateDatastreamLinkRequestDataRelationships.md)
 - [CreateDevice0201Response](docs/CreateDevice0201Response.md)
 - [CreateDevice0Request](docs/CreateDevice0Request.md)
 - [CreateDevice0RequestData](docs/CreateDevice0RequestData.md)
 - [CreateDevice0RequestDataAttributes](docs/CreateDevice0RequestDataAttributes.md)
 - [CreateDevice0RequestDataRelationships](docs/CreateDevice0RequestDataRelationships.md)
 - [CreateDeviceAttachment0201Response](docs/CreateDeviceAttachment0201Response.md)
 - [CreateDeviceAttachment0Request](docs/CreateDeviceAttachment0Request.md)
 - [CreateDeviceAttachment0RequestData](docs/CreateDeviceAttachment0RequestData.md)
 - [CreateDeviceAttachment0RequestDataRelationships](docs/CreateDeviceAttachment0RequestDataRelationships.md)
 - [CreateDeviceImage201Response](docs/CreateDeviceImage201Response.md)
 - [CreateDeviceImageRequest](docs/CreateDeviceImageRequest.md)
 - [CreateDeviceImageRequestData](docs/CreateDeviceImageRequestData.md)
 - [CreateDeviceImageRequestDataRelationships](docs/CreateDeviceImageRequestDataRelationships.md)
 - [CreateDeviceParameter201Response](docs/CreateDeviceParameter201Response.md)
 - [CreateDeviceParameterRequest](docs/CreateDeviceParameterRequest.md)
 - [CreateDeviceParameterRequestData](docs/CreateDeviceParameterRequestData.md)
 - [CreateDeviceParameterRequestDataRelationships](docs/CreateDeviceParameterRequestDataRelationships.md)
 - [CreateDeviceParameterValuechangeAction201Response](docs/CreateDeviceParameterValuechangeAction201Response.md)
 - [CreateDeviceParameterValuechangeActionRequest](docs/CreateDeviceParameterValuechangeActionRequest.md)
 - [CreateDeviceParameterValuechangeActionRequestData](docs/CreateDeviceParameterValuechangeActionRequestData.md)
 - [CreateDeviceParameterValuechangeActionRequestDataRelationships](docs/CreateDeviceParameterValuechangeActionRequestDataRelationships.md)
 - [CreateDeviceProperty0201Response](docs/CreateDeviceProperty0201Response.md)
 - [CreateDeviceProperty0Request](docs/CreateDeviceProperty0Request.md)
 - [CreateDeviceProperty0RequestData](docs/CreateDeviceProperty0RequestData.md)
 - [CreateDeviceProperty0RequestDataAttributes](docs/CreateDeviceProperty0RequestDataAttributes.md)
 - [CreateExportControl201Response](docs/CreateExportControl201Response.md)
 - [CreateExportControlAttachment201Response](docs/CreateExportControlAttachment201Response.md)
 - [CreateExportControlAttachmentRequest](docs/CreateExportControlAttachmentRequest.md)
 - [CreateExportControlAttachmentRequestData](docs/CreateExportControlAttachmentRequestData.md)
 - [CreateExportControlAttachmentRequestDataAttributes](docs/CreateExportControlAttachmentRequestDataAttributes.md)
 - [CreateExportControlRequest](docs/CreateExportControlRequest.md)
 - [CreateExportControlRequestData](docs/CreateExportControlRequestData.md)
 - [CreateExportControlRequestDataAttributes](docs/CreateExportControlRequestDataAttributes.md)
 - [CreateExportControlRequestDataRelationships](docs/CreateExportControlRequestDataRelationships.md)
 - [CreateInvolvedDeviceForDatastreamLink201Response](docs/CreateInvolvedDeviceForDatastreamLink201Response.md)
 - [CreateInvolvedDeviceForDatastreamLinkRequest](docs/CreateInvolvedDeviceForDatastreamLinkRequest.md)
 - [CreateInvolvedDeviceForDatastreamLinkRequestData](docs/CreateInvolvedDeviceForDatastreamLinkRequestData.md)
 - [CreatePid201Response](docs/CreatePid201Response.md)
 - [CreatePidRequest](docs/CreatePidRequest.md)
 - [CreatePidRequestInstrumentInstance](docs/CreatePidRequestInstrumentInstance.md)
 - [CreatePlatform0201Response](docs/CreatePlatform0201Response.md)
 - [CreatePlatform0Request](docs/CreatePlatform0Request.md)
 - [CreatePlatform0RequestData](docs/CreatePlatform0RequestData.md)
 - [CreatePlatform0RequestDataAttributes](docs/CreatePlatform0RequestDataAttributes.md)
 - [CreatePlatform0RequestDataRelationships](docs/CreatePlatform0RequestDataRelationships.md)
 - [CreatePlatformAttachment0201Response](docs/CreatePlatformAttachment0201Response.md)
 - [CreatePlatformAttachment0Request](docs/CreatePlatformAttachment0Request.md)
 - [CreatePlatformAttachment0RequestData](docs/CreatePlatformAttachment0RequestData.md)
 - [CreatePlatformAttachment0RequestDataRelationships](docs/CreatePlatformAttachment0RequestDataRelationships.md)
 - [CreatePlatformImage201Response](docs/CreatePlatformImage201Response.md)
 - [CreatePlatformImageRequest](docs/CreatePlatformImageRequest.md)
 - [CreatePlatformImageRequestData](docs/CreatePlatformImageRequestData.md)
 - [CreatePlatformImageRequestDataRelationships](docs/CreatePlatformImageRequestDataRelationships.md)
 - [CreatePlatformParameter201Response](docs/CreatePlatformParameter201Response.md)
 - [CreatePlatformParameterRequest](docs/CreatePlatformParameterRequest.md)
 - [CreatePlatformParameterRequestData](docs/CreatePlatformParameterRequestData.md)
 - [CreatePlatformParameterRequestDataRelationships](docs/CreatePlatformParameterRequestDataRelationships.md)
 - [CreatePlatformParameterValuechangeAction201Response](docs/CreatePlatformParameterValuechangeAction201Response.md)
 - [CreatePlatformParameterValuechangeActionRequest](docs/CreatePlatformParameterValuechangeActionRequest.md)
 - [CreatePlatformParameterValuechangeActionRequestData](docs/CreatePlatformParameterValuechangeActionRequestData.md)
 - [CreatePlatformParameterValuechangeActionRequestDataRelationships](docs/CreatePlatformParameterValuechangeActionRequestDataRelationships.md)
 - [CreateSite0201Response](docs/CreateSite0201Response.md)
 - [CreateSite0Request](docs/CreateSite0Request.md)
 - [CreateSite0RequestData](docs/CreateSite0RequestData.md)
 - [CreateSite0RequestDataAttributes](docs/CreateSite0RequestDataAttributes.md)
 - [CreateSite0RequestDataRelationships](docs/CreateSite0RequestDataRelationships.md)
 - [CreateSiteAttachment0201Response](docs/CreateSiteAttachment0201Response.md)
 - [CreateSiteAttachment0Request](docs/CreateSiteAttachment0Request.md)
 - [CreateSiteAttachment0RequestData](docs/CreateSiteAttachment0RequestData.md)
 - [CreateSiteAttachment0RequestDataRelationships](docs/CreateSiteAttachment0RequestDataRelationships.md)
 - [CreateSiteImage201Response](docs/CreateSiteImage201Response.md)
 - [CreateSiteImageRequest](docs/CreateSiteImageRequest.md)
 - [CreateSiteImageRequestData](docs/CreateSiteImageRequestData.md)
 - [CreateSiteImageRequestDataRelationships](docs/CreateSiteImageRequestDataRelationships.md)
 - [DeleteConfigurationAttachmentfromconfigurationattachment0200Response](docs/DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)
 - [DeviceCalibrationActionsDeviceCalibrationActionIdPatchRequest](docs/DeviceCalibrationActionsDeviceCalibrationActionIdPatchRequest.md)
 - [DeviceCalibrationActionsGet200Response](docs/DeviceCalibrationActionsGet200Response.md)
 - [DeviceCalibrationActionsGet200ResponseDataInner](docs/DeviceCalibrationActionsGet200ResponseDataInner.md)
 - [DeviceCalibrationActionsGet200ResponseDataInnerAttributes](docs/DeviceCalibrationActionsGet200ResponseDataInnerAttributes.md)
 - [DeviceCalibrationActionsGet200ResponseDataInnerRelationships](docs/DeviceCalibrationActionsGet200ResponseDataInnerRelationships.md)
 - [DeviceCalibrationActionsGet200ResponseDataInnerRelationshipsDeviceCalibrationAttachments](docs/DeviceCalibrationActionsGet200ResponseDataInnerRelationshipsDeviceCalibrationAttachments.md)
 - [DeviceCalibrationActionsGet200ResponseDataInnerRelationshipsDeviceCalibrationAttachmentsDataInner](docs/DeviceCalibrationActionsGet200ResponseDataInnerRelationshipsDeviceCalibrationAttachmentsDataInner.md)
 - [DeviceCalibrationActionsGet200ResponseDataInnerRelationshipsDevicePropertyCalibrations](docs/DeviceCalibrationActionsGet200ResponseDataInnerRelationshipsDevicePropertyCalibrations.md)
 - [DeviceCalibrationActionsGet200ResponseDataInnerRelationshipsDevicePropertyCalibrationsDataInner](docs/DeviceCalibrationActionsGet200ResponseDataInnerRelationshipsDevicePropertyCalibrationsDataInner.md)
 - [DeviceCalibrationActionsPost201Response](docs/DeviceCalibrationActionsPost201Response.md)
 - [DeviceCalibrationActionsPostRequest](docs/DeviceCalibrationActionsPostRequest.md)
 - [DeviceCalibrationActionsPostRequestData](docs/DeviceCalibrationActionsPostRequestData.md)
 - [DeviceCalibrationActionsPostRequestDataAttributes](docs/DeviceCalibrationActionsPostRequestDataAttributes.md)
 - [DeviceCalibrationAttachmentsDeviceCalibrationAttachmentIdPatchRequest](docs/DeviceCalibrationAttachmentsDeviceCalibrationAttachmentIdPatchRequest.md)
 - [DeviceCalibrationAttachmentsGet200Response](docs/DeviceCalibrationAttachmentsGet200Response.md)
 - [DeviceCalibrationAttachmentsGet200ResponseDataInner](docs/DeviceCalibrationAttachmentsGet200ResponseDataInner.md)
 - [DeviceCalibrationAttachmentsGet200ResponseDataInnerRelationships](docs/DeviceCalibrationAttachmentsGet200ResponseDataInnerRelationships.md)
 - [DeviceCalibrationAttachmentsGet200ResponseDataInnerRelationshipsAction](docs/DeviceCalibrationAttachmentsGet200ResponseDataInnerRelationshipsAction.md)
 - [DeviceCalibrationAttachmentsGet200ResponseDataInnerRelationshipsActionData](docs/DeviceCalibrationAttachmentsGet200ResponseDataInnerRelationshipsActionData.md)
 - [DeviceCalibrationAttachmentsGet200ResponseDataInnerRelationshipsAttachment](docs/DeviceCalibrationAttachmentsGet200ResponseDataInnerRelationshipsAttachment.md)
 - [DeviceCalibrationAttachmentsGet200ResponseDataInnerRelationshipsAttachmentData](docs/DeviceCalibrationAttachmentsGet200ResponseDataInnerRelationshipsAttachmentData.md)
 - [DeviceCalibrationAttachmentsPost201Response](docs/DeviceCalibrationAttachmentsPost201Response.md)
 - [DeviceCalibrationAttachmentsPostRequest](docs/DeviceCalibrationAttachmentsPostRequest.md)
 - [DeviceCalibrationAttachmentsPostRequestData](docs/DeviceCalibrationAttachmentsPostRequestData.md)
 - [DeviceContactRolesDeviceContactRoleIdPatchRequest](docs/DeviceContactRolesDeviceContactRoleIdPatchRequest.md)
 - [DeviceContactRolesGet200Response](docs/DeviceContactRolesGet200Response.md)
 - [DeviceContactRolesGet200ResponseDataInner](docs/DeviceContactRolesGet200ResponseDataInner.md)
 - [DeviceContactRolesGet200ResponseDataInnerRelationships](docs/DeviceContactRolesGet200ResponseDataInnerRelationships.md)
 - [DeviceContactRolesPost201Response](docs/DeviceContactRolesPost201Response.md)
 - [DeviceContactRolesPostRequest](docs/DeviceContactRolesPostRequest.md)
 - [DeviceContactRolesPostRequestData](docs/DeviceContactRolesPostRequestData.md)
 - [DeviceMountActionsDeviceMountActionIdPatchRequest](docs/DeviceMountActionsDeviceMountActionIdPatchRequest.md)
 - [DeviceMountActionsDeviceMountActionIdPatchRequestData](docs/DeviceMountActionsDeviceMountActionIdPatchRequestData.md)
 - [DeviceMountActionsDeviceMountActionIdPatchRequestDataAttributes](docs/DeviceMountActionsDeviceMountActionIdPatchRequestDataAttributes.md)
 - [DeviceMountActionsGet200Response](docs/DeviceMountActionsGet200Response.md)
 - [DeviceMountActionsGet200ResponseDataInner](docs/DeviceMountActionsGet200ResponseDataInner.md)
 - [DeviceMountActionsGet200ResponseDataInnerAttributes](docs/DeviceMountActionsGet200ResponseDataInnerAttributes.md)
 - [DeviceMountActionsGet200ResponseDataInnerRelationships](docs/DeviceMountActionsGet200ResponseDataInnerRelationships.md)
 - [DeviceMountActionsGet200ResponseDataInnerRelationshipsParentPlatform](docs/DeviceMountActionsGet200ResponseDataInnerRelationshipsParentPlatform.md)
 - [DeviceMountActionsGet200ResponseDataInnerRelationshipsParentPlatformData](docs/DeviceMountActionsGet200ResponseDataInnerRelationshipsParentPlatformData.md)
 - [DeviceMountActionsPost201Response](docs/DeviceMountActionsPost201Response.md)
 - [DeviceMountActionsPostRequest](docs/DeviceMountActionsPostRequest.md)
 - [DeviceMountActionsPostRequestData](docs/DeviceMountActionsPostRequestData.md)
 - [DeviceMountActionsPostRequestDataAttributes](docs/DeviceMountActionsPostRequestDataAttributes.md)
 - [DeviceMountActionsPostRequestDataRelationships](docs/DeviceMountActionsPostRequestDataRelationships.md)
 - [DevicePropertyCalibrationsDevicePropertyCalibrationIdPatchRequest](docs/DevicePropertyCalibrationsDevicePropertyCalibrationIdPatchRequest.md)
 - [DevicePropertyCalibrationsGet200Response](docs/DevicePropertyCalibrationsGet200Response.md)
 - [DevicePropertyCalibrationsGet200ResponseDataInner](docs/DevicePropertyCalibrationsGet200ResponseDataInner.md)
 - [DevicePropertyCalibrationsGet200ResponseDataInnerRelationships](docs/DevicePropertyCalibrationsGet200ResponseDataInnerRelationships.md)
 - [DevicePropertyCalibrationsPost201Response](docs/DevicePropertyCalibrationsPost201Response.md)
 - [DevicePropertyCalibrationsPostRequest](docs/DevicePropertyCalibrationsPostRequest.md)
 - [DevicePropertyCalibrationsPostRequestData](docs/DevicePropertyCalibrationsPostRequestData.md)
 - [DeviceSoftwareUpdateActionAttachmentsDeviceSoftwareUpdateActionAttachmentIdPatchRequest](docs/DeviceSoftwareUpdateActionAttachmentsDeviceSoftwareUpdateActionAttachmentIdPatchRequest.md)
 - [DeviceSoftwareUpdateActionAttachmentsGet200Response](docs/DeviceSoftwareUpdateActionAttachmentsGet200Response.md)
 - [DeviceSoftwareUpdateActionAttachmentsGet200ResponseDataInner](docs/DeviceSoftwareUpdateActionAttachmentsGet200ResponseDataInner.md)
 - [DeviceSoftwareUpdateActionAttachmentsGet200ResponseDataInnerRelationships](docs/DeviceSoftwareUpdateActionAttachmentsGet200ResponseDataInnerRelationships.md)
 - [DeviceSoftwareUpdateActionAttachmentsGet200ResponseDataInnerRelationshipsAction](docs/DeviceSoftwareUpdateActionAttachmentsGet200ResponseDataInnerRelationshipsAction.md)
 - [DeviceSoftwareUpdateActionAttachmentsGet200ResponseDataInnerRelationshipsActionData](docs/DeviceSoftwareUpdateActionAttachmentsGet200ResponseDataInnerRelationshipsActionData.md)
 - [DeviceSoftwareUpdateActionAttachmentsPost201Response](docs/DeviceSoftwareUpdateActionAttachmentsPost201Response.md)
 - [DeviceSoftwareUpdateActionAttachmentsPostRequest](docs/DeviceSoftwareUpdateActionAttachmentsPostRequest.md)
 - [DeviceSoftwareUpdateActionAttachmentsPostRequestData](docs/DeviceSoftwareUpdateActionAttachmentsPostRequestData.md)
 - [DeviceSoftwareUpdateActionsDeviceSoftwareUpdateActionIdPatchRequest](docs/DeviceSoftwareUpdateActionsDeviceSoftwareUpdateActionIdPatchRequest.md)
 - [DeviceSoftwareUpdateActionsDeviceSoftwareUpdateActionIdPatchRequestData](docs/DeviceSoftwareUpdateActionsDeviceSoftwareUpdateActionIdPatchRequestData.md)
 - [DeviceSoftwareUpdateActionsDeviceSoftwareUpdateActionIdPatchRequestDataAttributes](docs/DeviceSoftwareUpdateActionsDeviceSoftwareUpdateActionIdPatchRequestDataAttributes.md)
 - [DeviceSoftwareUpdateActionsGet200Response](docs/DeviceSoftwareUpdateActionsGet200Response.md)
 - [DeviceSoftwareUpdateActionsGet200ResponseDataInner](docs/DeviceSoftwareUpdateActionsGet200ResponseDataInner.md)
 - [DeviceSoftwareUpdateActionsGet200ResponseDataInnerAttributes](docs/DeviceSoftwareUpdateActionsGet200ResponseDataInnerAttributes.md)
 - [DeviceSoftwareUpdateActionsGet200ResponseDataInnerRelationships](docs/DeviceSoftwareUpdateActionsGet200ResponseDataInnerRelationships.md)
 - [DeviceSoftwareUpdateActionsGet200ResponseDataInnerRelationshipsDeviceSoftwareUpdateActionAttachments](docs/DeviceSoftwareUpdateActionsGet200ResponseDataInnerRelationshipsDeviceSoftwareUpdateActionAttachments.md)
 - [DeviceSoftwareUpdateActionsGet200ResponseDataInnerRelationshipsDeviceSoftwareUpdateActionAttachmentsDataInner](docs/DeviceSoftwareUpdateActionsGet200ResponseDataInnerRelationshipsDeviceSoftwareUpdateActionAttachmentsDataInner.md)
 - [DeviceSoftwareUpdateActionsPost201Response](docs/DeviceSoftwareUpdateActionsPost201Response.md)
 - [DeviceSoftwareUpdateActionsPostRequest](docs/DeviceSoftwareUpdateActionsPostRequest.md)
 - [DeviceSoftwareUpdateActionsPostRequestData](docs/DeviceSoftwareUpdateActionsPostRequestData.md)
 - [DeviceSoftwareUpdateActionsPostRequestDataAttributes](docs/DeviceSoftwareUpdateActionsPostRequestDataAttributes.md)
 - [DeviceSoftwareUpdateActionsPostRequestDataRelationships](docs/DeviceSoftwareUpdateActionsPostRequestDataRelationships.md)
 - [DynamicLocationActionsDynamicLocationActionIdPatchRequest](docs/DynamicLocationActionsDynamicLocationActionIdPatchRequest.md)
 - [DynamicLocationActionsGet200Response](docs/DynamicLocationActionsGet200Response.md)
 - [DynamicLocationActionsGet200ResponseDataInner](docs/DynamicLocationActionsGet200ResponseDataInner.md)
 - [DynamicLocationActionsGet200ResponseDataInnerAttributes](docs/DynamicLocationActionsGet200ResponseDataInnerAttributes.md)
 - [DynamicLocationActionsGet200ResponseDataInnerRelationships](docs/DynamicLocationActionsGet200ResponseDataInnerRelationships.md)
 - [DynamicLocationActionsPost201Response](docs/DynamicLocationActionsPost201Response.md)
 - [DynamicLocationActionsPostRequest](docs/DynamicLocationActionsPostRequest.md)
 - [DynamicLocationActionsPostRequestData](docs/DynamicLocationActionsPostRequestData.md)
 - [DynamicLocationActionsPostRequestDataAttributes](docs/DynamicLocationActionsPostRequestDataAttributes.md)
 - [GenericConfigurationActionAttachmentsGenericConfigurationActionAttachmentIdPatchRequest](docs/GenericConfigurationActionAttachmentsGenericConfigurationActionAttachmentIdPatchRequest.md)
 - [GenericConfigurationActionAttachmentsGet200Response](docs/GenericConfigurationActionAttachmentsGet200Response.md)
 - [GenericConfigurationActionAttachmentsGet200ResponseDataInner](docs/GenericConfigurationActionAttachmentsGet200ResponseDataInner.md)
 - [GenericConfigurationActionAttachmentsGet200ResponseDataInnerRelationships](docs/GenericConfigurationActionAttachmentsGet200ResponseDataInnerRelationships.md)
 - [GenericConfigurationActionAttachmentsGet200ResponseDataInnerRelationshipsAction](docs/GenericConfigurationActionAttachmentsGet200ResponseDataInnerRelationshipsAction.md)
 - [GenericConfigurationActionAttachmentsPost201Response](docs/GenericConfigurationActionAttachmentsPost201Response.md)
 - [GenericConfigurationActionAttachmentsPostRequest](docs/GenericConfigurationActionAttachmentsPostRequest.md)
 - [GenericConfigurationActionAttachmentsPostRequestData](docs/GenericConfigurationActionAttachmentsPostRequestData.md)
 - [GenericConfigurationActionsGenericConfigurationActionIdPatchRequest](docs/GenericConfigurationActionsGenericConfigurationActionIdPatchRequest.md)
 - [GenericConfigurationActionsGenericConfigurationActionIdPatchRequestData](docs/GenericConfigurationActionsGenericConfigurationActionIdPatchRequestData.md)
 - [GenericConfigurationActionsGenericConfigurationActionIdPatchRequestDataAttributes](docs/GenericConfigurationActionsGenericConfigurationActionIdPatchRequestDataAttributes.md)
 - [GenericConfigurationActionsGet200Response](docs/GenericConfigurationActionsGet200Response.md)
 - [GenericConfigurationActionsGet200ResponseDataInner](docs/GenericConfigurationActionsGet200ResponseDataInner.md)
 - [GenericConfigurationActionsGet200ResponseDataInnerAttributes](docs/GenericConfigurationActionsGet200ResponseDataInnerAttributes.md)
 - [GenericConfigurationActionsGet200ResponseDataInnerRelationships](docs/GenericConfigurationActionsGet200ResponseDataInnerRelationships.md)
 - [GenericConfigurationActionsGet200ResponseDataInnerRelationshipsGenericConfigurationActionAttachments](docs/GenericConfigurationActionsGet200ResponseDataInnerRelationshipsGenericConfigurationActionAttachments.md)
 - [GenericConfigurationActionsGet200ResponseDataInnerRelationshipsGenericConfigurationActionAttachmentsDataInner](docs/GenericConfigurationActionsGet200ResponseDataInnerRelationshipsGenericConfigurationActionAttachmentsDataInner.md)
 - [GenericConfigurationActionsPost201Response](docs/GenericConfigurationActionsPost201Response.md)
 - [GenericConfigurationActionsPostRequest](docs/GenericConfigurationActionsPostRequest.md)
 - [GenericConfigurationActionsPostRequestData](docs/GenericConfigurationActionsPostRequestData.md)
 - [GenericConfigurationActionsPostRequestDataAttributes](docs/GenericConfigurationActionsPostRequestDataAttributes.md)
 - [GenericConfigurationActionsPostRequestDataRelationships](docs/GenericConfigurationActionsPostRequestDataRelationships.md)
 - [GenericDeviceActionsGenericDeviceActionIdPatchRequest](docs/GenericDeviceActionsGenericDeviceActionIdPatchRequest.md)
 - [GenericDeviceActionsGenericDeviceActionIdPatchRequestData](docs/GenericDeviceActionsGenericDeviceActionIdPatchRequestData.md)
 - [GenericDeviceActionsGet200Response](docs/GenericDeviceActionsGet200Response.md)
 - [GenericDeviceActionsGet200ResponseDataInner](docs/GenericDeviceActionsGet200ResponseDataInner.md)
 - [GenericDeviceActionsGet200ResponseDataInnerRelationships](docs/GenericDeviceActionsGet200ResponseDataInnerRelationships.md)
 - [GenericDeviceActionsGet200ResponseDataInnerRelationshipsGenericDeviceActionAttachments](docs/GenericDeviceActionsGet200ResponseDataInnerRelationshipsGenericDeviceActionAttachments.md)
 - [GenericDeviceActionsGet200ResponseDataInnerRelationshipsGenericDeviceActionAttachmentsDataInner](docs/GenericDeviceActionsGet200ResponseDataInnerRelationshipsGenericDeviceActionAttachmentsDataInner.md)
 - [GenericDeviceActionsPost201Response](docs/GenericDeviceActionsPost201Response.md)
 - [GenericDeviceActionsPostRequest](docs/GenericDeviceActionsPostRequest.md)
 - [GenericDeviceActionsPostRequestData](docs/GenericDeviceActionsPostRequestData.md)
 - [GenericDeviceActionsPostRequestDataRelationships](docs/GenericDeviceActionsPostRequestDataRelationships.md)
 - [GenericPlatformActionsGenericPlatformActionIdPatchRequest](docs/GenericPlatformActionsGenericPlatformActionIdPatchRequest.md)
 - [GenericPlatformActionsGenericPlatformActionIdPatchRequestData](docs/GenericPlatformActionsGenericPlatformActionIdPatchRequestData.md)
 - [GenericPlatformActionsGet200Response](docs/GenericPlatformActionsGet200Response.md)
 - [GenericPlatformActionsGet200ResponseDataInner](docs/GenericPlatformActionsGet200ResponseDataInner.md)
 - [GenericPlatformActionsGet200ResponseDataInnerRelationships](docs/GenericPlatformActionsGet200ResponseDataInnerRelationships.md)
 - [GenericPlatformActionsGet200ResponseDataInnerRelationshipsGenericPlatformActionAttachments](docs/GenericPlatformActionsGet200ResponseDataInnerRelationshipsGenericPlatformActionAttachments.md)
 - [GenericPlatformActionsGet200ResponseDataInnerRelationshipsGenericPlatformActionAttachmentsDataInner](docs/GenericPlatformActionsGet200ResponseDataInnerRelationshipsGenericPlatformActionAttachmentsDataInner.md)
 - [GenericPlatformActionsPost201Response](docs/GenericPlatformActionsPost201Response.md)
 - [GenericPlatformActionsPostRequest](docs/GenericPlatformActionsPostRequest.md)
 - [GenericPlatformActionsPostRequestData](docs/GenericPlatformActionsPostRequestData.md)
 - [GenericPlatformActionsPostRequestDataRelationships](docs/GenericPlatformActionsPostRequestDataRelationships.md)
 - [GetGlobalActivity200Response](docs/GetGlobalActivity200Response.md)
 - [GetGlobalActivity200ResponseDataInner](docs/GetGlobalActivity200ResponseDataInner.md)
 - [GetPermissionGroups200Response](docs/GetPermissionGroups200Response.md)
 - [GetPermissionGroups200ResponseDataInner](docs/GetPermissionGroups200ResponseDataInner.md)
 - [GetPermissionGroups200ResponseDataInnerAttributes](docs/GetPermissionGroups200ResponseDataInnerAttributes.md)
 - [GetPermissionGroups200ResponseJsonapi](docs/GetPermissionGroups200ResponseJsonapi.md)
 - [GetPermissionGroups200ResponseMeta](docs/GetPermissionGroups200ResponseMeta.md)
 - [GetUsageStatistics200Response](docs/GetUsageStatistics200Response.md)
 - [GetUsageStatistics200ResponseCounts](docs/GetUsageStatistics200ResponseCounts.md)
 - [GetUserInfo200Response](docs/GetUserInfo200Response.md)
 - [GetUserInfo200ResponseData](docs/GetUserInfo200ResponseData.md)
 - [GetUserInfo200ResponseDataAttributes](docs/GetUserInfo200ResponseDataAttributes.md)
 - [GetUserInfo200ResponseDataRelationships](docs/GetUserInfo200ResponseDataRelationships.md)
 - [GetUserInfo200ResponseDataRelationshipsContact](docs/GetUserInfo200ResponseDataRelationshipsContact.md)
 - [GetUserInfo200ResponseDataRelationshipsContactData](docs/GetUserInfo200ResponseDataRelationshipsContactData.md)
 - [InlineObject](docs/InlineObject.md)
 - [InlineObject1](docs/InlineObject1.md)
 - [InlineObject2](docs/InlineObject2.md)
 - [InlineObject3](docs/InlineObject3.md)
 - [InlineObject4](docs/InlineObject4.md)
 - [InvalidFilters](docs/InvalidFilters.md)
 - [InvalidFiltersErrorsInner](docs/InvalidFiltersErrorsInner.md)
 - [PlatformContactRolesGet200Response](docs/PlatformContactRolesGet200Response.md)
 - [PlatformContactRolesGet200ResponseDataInner](docs/PlatformContactRolesGet200ResponseDataInner.md)
 - [PlatformContactRolesGet200ResponseDataInnerRelationships](docs/PlatformContactRolesGet200ResponseDataInnerRelationships.md)
 - [PlatformContactRolesPlatformContactRoleIdPatchRequest](docs/PlatformContactRolesPlatformContactRoleIdPatchRequest.md)
 - [PlatformContactRolesPost201Response](docs/PlatformContactRolesPost201Response.md)
 - [PlatformContactRolesPostRequest](docs/PlatformContactRolesPostRequest.md)
 - [PlatformContactRolesPostRequestData](docs/PlatformContactRolesPostRequestData.md)
 - [PlatformMountActionsGet200Response](docs/PlatformMountActionsGet200Response.md)
 - [PlatformMountActionsGet200ResponseDataInner](docs/PlatformMountActionsGet200ResponseDataInner.md)
 - [PlatformMountActionsGet200ResponseDataInnerRelationships](docs/PlatformMountActionsGet200ResponseDataInnerRelationships.md)
 - [PlatformMountActionsPlatformMountActionIdPatchRequest](docs/PlatformMountActionsPlatformMountActionIdPatchRequest.md)
 - [PlatformMountActionsPlatformMountActionIdPatchRequestData](docs/PlatformMountActionsPlatformMountActionIdPatchRequestData.md)
 - [PlatformMountActionsPost201Response](docs/PlatformMountActionsPost201Response.md)
 - [PlatformMountActionsPostRequest](docs/PlatformMountActionsPostRequest.md)
 - [PlatformMountActionsPostRequestData](docs/PlatformMountActionsPostRequestData.md)
 - [PlatformMountActionsPostRequestDataRelationships](docs/PlatformMountActionsPostRequestDataRelationships.md)
 - [PlatformSoftwareUpdateActionAttachmentsGet200Response](docs/PlatformSoftwareUpdateActionAttachmentsGet200Response.md)
 - [PlatformSoftwareUpdateActionAttachmentsGet200ResponseDataInner](docs/PlatformSoftwareUpdateActionAttachmentsGet200ResponseDataInner.md)
 - [PlatformSoftwareUpdateActionAttachmentsGet200ResponseDataInnerRelationships](docs/PlatformSoftwareUpdateActionAttachmentsGet200ResponseDataInnerRelationships.md)
 - [PlatformSoftwareUpdateActionAttachmentsGet200ResponseDataInnerRelationshipsAction](docs/PlatformSoftwareUpdateActionAttachmentsGet200ResponseDataInnerRelationshipsAction.md)
 - [PlatformSoftwareUpdateActionAttachmentsGet200ResponseDataInnerRelationshipsActionData](docs/PlatformSoftwareUpdateActionAttachmentsGet200ResponseDataInnerRelationshipsActionData.md)
 - [PlatformSoftwareUpdateActionAttachmentsPlatformSoftwareUpdateActionAttachmentIdPatchRequest](docs/PlatformSoftwareUpdateActionAttachmentsPlatformSoftwareUpdateActionAttachmentIdPatchRequest.md)
 - [PlatformSoftwareUpdateActionAttachmentsPost201Response](docs/PlatformSoftwareUpdateActionAttachmentsPost201Response.md)
 - [PlatformSoftwareUpdateActionAttachmentsPostRequest](docs/PlatformSoftwareUpdateActionAttachmentsPostRequest.md)
 - [PlatformSoftwareUpdateActionAttachmentsPostRequestData](docs/PlatformSoftwareUpdateActionAttachmentsPostRequestData.md)
 - [PlatformSoftwareUpdateActionsGet200Response](docs/PlatformSoftwareUpdateActionsGet200Response.md)
 - [PlatformSoftwareUpdateActionsGet200ResponseDataInner](docs/PlatformSoftwareUpdateActionsGet200ResponseDataInner.md)
 - [PlatformSoftwareUpdateActionsGet200ResponseDataInnerRelationships](docs/PlatformSoftwareUpdateActionsGet200ResponseDataInnerRelationships.md)
 - [PlatformSoftwareUpdateActionsGet200ResponseDataInnerRelationshipsPlatformSoftwareUpdateActionAttachments](docs/PlatformSoftwareUpdateActionsGet200ResponseDataInnerRelationshipsPlatformSoftwareUpdateActionAttachments.md)
 - [PlatformSoftwareUpdateActionsGet200ResponseDataInnerRelationshipsPlatformSoftwareUpdateActionAttachmentsDataInner](docs/PlatformSoftwareUpdateActionsGet200ResponseDataInnerRelationshipsPlatformSoftwareUpdateActionAttachmentsDataInner.md)
 - [PlatformSoftwareUpdateActionsPlatformSoftwareUpdateActionIdPatchRequest](docs/PlatformSoftwareUpdateActionsPlatformSoftwareUpdateActionIdPatchRequest.md)
 - [PlatformSoftwareUpdateActionsPlatformSoftwareUpdateActionIdPatchRequestData](docs/PlatformSoftwareUpdateActionsPlatformSoftwareUpdateActionIdPatchRequestData.md)
 - [PlatformSoftwareUpdateActionsPost201Response](docs/PlatformSoftwareUpdateActionsPost201Response.md)
 - [PlatformSoftwareUpdateActionsPostRequest](docs/PlatformSoftwareUpdateActionsPostRequest.md)
 - [PlatformSoftwareUpdateActionsPostRequestData](docs/PlatformSoftwareUpdateActionsPostRequestData.md)
 - [PlatformSoftwareUpdateActionsPostRequestDataRelationships](docs/PlatformSoftwareUpdateActionsPostRequestDataRelationships.md)
 - [RetriececollectionofConfigurationParameterValueChangeActionobjects200Response](docs/RetriececollectionofConfigurationParameterValueChangeActionobjects200Response.md)
 - [RetriececollectionofConfigurationParameterValueChangeActionobjects200ResponseDataInner](docs/RetriececollectionofConfigurationParameterValueChangeActionobjects200ResponseDataInner.md)
 - [RetriececollectionofConfigurationParameterValueChangeActionobjects200ResponseDataInnerAttributes](docs/RetriececollectionofConfigurationParameterValueChangeActionobjects200ResponseDataInnerAttributes.md)
 - [RetriececollectionofConfigurationParameterValueChangeActionobjects200ResponseDataInnerRelationships](docs/RetriececollectionofConfigurationParameterValueChangeActionobjects200ResponseDataInnerRelationships.md)
 - [RetriececollectionofConfigurationParameterValueChangeActionobjects200ResponseDataInnerRelationshipsConfigurationParameter](docs/RetriececollectionofConfigurationParameterValueChangeActionobjects200ResponseDataInnerRelationshipsConfigurationParameter.md)
 - [RetriececollectionofConfigurationParameterValueChangeActionobjects200ResponseDataInnerRelationshipsConfigurationParameterData](docs/RetriececollectionofConfigurationParameterValueChangeActionobjects200ResponseDataInnerRelationshipsConfigurationParameterData.md)
 - [RetriececollectionofConfigurationParameterobjects200Response](docs/RetriececollectionofConfigurationParameterobjects200Response.md)
 - [RetriececollectionofConfigurationParameterobjects200ResponseDataInner](docs/RetriececollectionofConfigurationParameterobjects200ResponseDataInner.md)
 - [RetriececollectionofConfigurationParameterobjects200ResponseDataInnerAttributes](docs/RetriececollectionofConfigurationParameterobjects200ResponseDataInnerAttributes.md)
 - [RetriececollectionofConfigurationParameterobjects200ResponseDataInnerRelationships](docs/RetriececollectionofConfigurationParameterobjects200ResponseDataInnerRelationships.md)
 - [RetriececollectionofConfigurationParameterobjects200ResponseDataInnerRelationshipsConfigurationParameterValueChangeActions](docs/RetriececollectionofConfigurationParameterobjects200ResponseDataInnerRelationshipsConfigurationParameterValueChangeActions.md)
 - [RetriececollectionofConfigurationParameterobjects200ResponseDataInnerRelationshipsConfigurationParameterValueChangeActionsDataInner](docs/RetriececollectionofConfigurationParameterobjects200ResponseDataInnerRelationshipsConfigurationParameterValueChangeActionsDataInner.md)
 - [RetriececollectionofDeviceParameterValueChangeActionobjects200Response](docs/RetriececollectionofDeviceParameterValueChangeActionobjects200Response.md)
 - [RetriececollectionofDeviceParameterValueChangeActionobjects200ResponseDataInner](docs/RetriececollectionofDeviceParameterValueChangeActionobjects200ResponseDataInner.md)
 - [RetriececollectionofDeviceParameterValueChangeActionobjects200ResponseDataInnerRelationships](docs/RetriececollectionofDeviceParameterValueChangeActionobjects200ResponseDataInnerRelationships.md)
 - [RetriececollectionofDeviceParameterValueChangeActionobjects200ResponseDataInnerRelationshipsDeviceParameter](docs/RetriececollectionofDeviceParameterValueChangeActionobjects200ResponseDataInnerRelationshipsDeviceParameter.md)
 - [RetriececollectionofDeviceParameterValueChangeActionobjects200ResponseDataInnerRelationshipsDeviceParameterData](docs/RetriececollectionofDeviceParameterValueChangeActionobjects200ResponseDataInnerRelationshipsDeviceParameterData.md)
 - [RetriececollectionofDeviceParameterobjects200Response](docs/RetriececollectionofDeviceParameterobjects200Response.md)
 - [RetriececollectionofDeviceParameterobjects200ResponseDataInner](docs/RetriececollectionofDeviceParameterobjects200ResponseDataInner.md)
 - [RetriececollectionofDeviceParameterobjects200ResponseDataInnerRelationships](docs/RetriececollectionofDeviceParameterobjects200ResponseDataInnerRelationships.md)
 - [RetriececollectionofDeviceParameterobjects200ResponseDataInnerRelationshipsDeviceParameterValueChangeActions](docs/RetriececollectionofDeviceParameterobjects200ResponseDataInnerRelationshipsDeviceParameterValueChangeActions.md)
 - [RetriececollectionofDeviceParameterobjects200ResponseDataInnerRelationshipsDeviceParameterValueChangeActionsDataInner](docs/RetriececollectionofDeviceParameterobjects200ResponseDataInnerRelationshipsDeviceParameterValueChangeActionsDataInner.md)
 - [RetriececollectionofPlatformParameterValueChangeActionobjects200Response](docs/RetriececollectionofPlatformParameterValueChangeActionobjects200Response.md)
 - [RetriececollectionofPlatformParameterValueChangeActionobjects200ResponseDataInner](docs/RetriececollectionofPlatformParameterValueChangeActionobjects200ResponseDataInner.md)
 - [RetriececollectionofPlatformParameterValueChangeActionobjects200ResponseDataInnerRelationships](docs/RetriececollectionofPlatformParameterValueChangeActionobjects200ResponseDataInnerRelationships.md)
 - [RetriececollectionofPlatformParameterValueChangeActionobjects200ResponseDataInnerRelationshipsPlatformParameter](docs/RetriececollectionofPlatformParameterValueChangeActionobjects200ResponseDataInnerRelationshipsPlatformParameter.md)
 - [RetriececollectionofPlatformParameterValueChangeActionobjects200ResponseDataInnerRelationshipsPlatformParameterData](docs/RetriececollectionofPlatformParameterValueChangeActionobjects200ResponseDataInnerRelationshipsPlatformParameterData.md)
 - [RetriececollectionofPlatformParameterobjects200Response](docs/RetriececollectionofPlatformParameterobjects200Response.md)
 - [RetriececollectionofPlatformParameterobjects200ResponseDataInner](docs/RetriececollectionofPlatformParameterobjects200ResponseDataInner.md)
 - [RetriececollectionofPlatformParameterobjects200ResponseDataInnerRelationships](docs/RetriececollectionofPlatformParameterobjects200ResponseDataInnerRelationships.md)
 - [RetriececollectionofPlatformParameterobjects200ResponseDataInnerRelationshipsPlatformParameterValueChangeActions](docs/RetriececollectionofPlatformParameterobjects200ResponseDataInnerRelationshipsPlatformParameterValueChangeActions.md)
 - [RetriececollectionofPlatformParameterobjects200ResponseDataInnerRelationshipsPlatformParameterValueChangeActionsDataInner](docs/RetriececollectionofPlatformParameterobjects200ResponseDataInnerRelationshipsPlatformParameterValueChangeActionsDataInner.md)
 - [RetrieveManufacturerModelinstance0200Response](docs/RetrieveManufacturerModelinstance0200Response.md)
 - [RetrieveacollectionofConfigurationAttachmentobjects0200Response](docs/RetrieveacollectionofConfigurationAttachmentobjects0200Response.md)
 - [RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInner](docs/RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerAttributes](docs/RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerAttributes.md)
 - [RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsConfiguration](docs/RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsConfiguration.md)
 - [RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsConfigurationData](docs/RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsConfigurationData.md)
 - [RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsConfigurationImages](docs/RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsConfigurationImages.md)
 - [RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsConfigurationImagesDataInner](docs/RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsConfigurationImagesDataInner.md)
 - [RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsCreatedBy](docs/RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsCreatedBy.md)
 - [RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsCreatedByData](docs/RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsCreatedByData.md)
 - [RetrieveacollectionofConfigurationAttachmentobjects0200ResponseJsonapi](docs/RetrieveacollectionofConfigurationAttachmentobjects0200ResponseJsonapi.md)
 - [RetrieveacollectionofConfigurationAttachmentobjects0200ResponseMeta](docs/RetrieveacollectionofConfigurationAttachmentobjects0200ResponseMeta.md)
 - [RetrieveacollectionofConfigurationCustomFieldobjects0200Response](docs/RetrieveacollectionofConfigurationCustomFieldobjects0200Response.md)
 - [RetrieveacollectionofConfigurationCustomFieldobjects0200ResponseDataInner](docs/RetrieveacollectionofConfigurationCustomFieldobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofConfigurationCustomFieldobjects0200ResponseDataInnerAttributes](docs/RetrieveacollectionofConfigurationCustomFieldobjects0200ResponseDataInnerAttributes.md)
 - [RetrieveacollectionofConfigurationCustomFieldobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofConfigurationCustomFieldobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofConfigurationobjects0200Response](docs/RetrieveacollectionofConfigurationobjects0200Response.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInner](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerAttributes](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerAttributes.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationAttachments](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationAttachments.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationCustomfields](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationCustomfields.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationCustomfieldsDataInner](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationCustomfieldsDataInner.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationDynamicLocationActions](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationDynamicLocationActions.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationDynamicLocationActionsDataInner](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationDynamicLocationActionsDataInner.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationParameters](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationParameters.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationStaticLocationActions](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationStaticLocationActions.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationStaticLocationActionsDataInner](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsConfigurationStaticLocationActionsDataInner.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsContacts](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsContacts.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsDeviceMountActions](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsDeviceMountActions.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsDeviceMountActionsDataInner](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsDeviceMountActionsDataInner.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsGenericConfigurationActions](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsGenericConfigurationActions.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsGenericConfigurationActionsDataInner](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsGenericConfigurationActionsDataInner.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsPlatformMountActions](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsPlatformMountActions.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsPlatformMountActionsDataInner](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsPlatformMountActionsDataInner.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsSite](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsSite.md)
 - [RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsSiteData](docs/RetrieveacollectionofConfigurationobjects0200ResponseDataInnerRelationshipsSiteData.md)
 - [RetrieveacollectionofContactobjects0200Response](docs/RetrieveacollectionofContactobjects0200Response.md)
 - [RetrieveacollectionofContactobjects0200ResponseDataInner](docs/RetrieveacollectionofContactobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofContactobjects0200ResponseDataInnerAttributes](docs/RetrieveacollectionofContactobjects0200ResponseDataInnerAttributes.md)
 - [RetrieveacollectionofContactobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofContactobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofCustomFieldobjects0200Response](docs/RetrieveacollectionofCustomFieldobjects0200Response.md)
 - [RetrieveacollectionofCustomFieldobjects0200ResponseDataInner](docs/RetrieveacollectionofCustomFieldobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofCustomFieldobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofCustomFieldobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofCustomFieldobjects0200ResponseDataInnerRelationshipsDevice](docs/RetrieveacollectionofCustomFieldobjects0200ResponseDataInnerRelationshipsDevice.md)
 - [RetrieveacollectionofCustomFieldobjects0200ResponseDataInnerRelationshipsDeviceData](docs/RetrieveacollectionofCustomFieldobjects0200ResponseDataInnerRelationshipsDeviceData.md)
 - [RetrieveacollectionofDatastreamLinkObjects200Response](docs/RetrieveacollectionofDatastreamLinkObjects200Response.md)
 - [RetrieveacollectionofDatastreamLinkObjects200ResponseDataInner](docs/RetrieveacollectionofDatastreamLinkObjects200ResponseDataInner.md)
 - [RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerAttributes](docs/RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerAttributes.md)
 - [RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationships](docs/RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsDeviceMountAction](docs/RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsDeviceMountAction.md)
 - [RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsDeviceProperty](docs/RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsDeviceProperty.md)
 - [RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsDevicePropertyData](docs/RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsDevicePropertyData.md)
 - [RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsInvolvedDevices](docs/RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsInvolvedDevices.md)
 - [RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsInvolvedDevicesDataInner](docs/RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsInvolvedDevicesDataInner.md)
 - [RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsTsmEndpoint](docs/RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsTsmEndpoint.md)
 - [RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsTsmEndpointData](docs/RetrieveacollectionofDatastreamLinkObjects200ResponseDataInnerRelationshipsTsmEndpointData.md)
 - [RetrieveacollectionofDeviceAttachmentobjects0200Response](docs/RetrieveacollectionofDeviceAttachmentobjects0200Response.md)
 - [RetrieveacollectionofDeviceAttachmentobjects0200ResponseDataInner](docs/RetrieveacollectionofDeviceAttachmentobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofDeviceAttachmentobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofDeviceAttachmentobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofDeviceAttachmentobjects0200ResponseDataInnerRelationshipsDeviceImages](docs/RetrieveacollectionofDeviceAttachmentobjects0200ResponseDataInnerRelationshipsDeviceImages.md)
 - [RetrieveacollectionofDeviceAttachmentobjects0200ResponseDataInnerRelationshipsDeviceImagesDataInner](docs/RetrieveacollectionofDeviceAttachmentobjects0200ResponseDataInnerRelationshipsDeviceImagesDataInner.md)
 - [RetrieveacollectionofDevicePropertyobjects0200Response](docs/RetrieveacollectionofDevicePropertyobjects0200Response.md)
 - [RetrieveacollectionofDevicePropertyobjects0200ResponseDataInner](docs/RetrieveacollectionofDevicePropertyobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofDevicePropertyobjects0200ResponseDataInnerAttributes](docs/RetrieveacollectionofDevicePropertyobjects0200ResponseDataInnerAttributes.md)
 - [RetrieveacollectionofDevicePropertyobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofDevicePropertyobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofDeviceobjects0200Response](docs/RetrieveacollectionofDeviceobjects0200Response.md)
 - [RetrieveacollectionofDeviceobjects0200ResponseDataInner](docs/RetrieveacollectionofDeviceobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofDeviceobjects0200ResponseDataInnerAttributes](docs/RetrieveacollectionofDeviceobjects0200ResponseDataInnerAttributes.md)
 - [RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsCustomfields](docs/RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsCustomfields.md)
 - [RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsCustomfieldsDataInner](docs/RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsCustomfieldsDataInner.md)
 - [RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsDeviceAttachments](docs/RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsDeviceAttachments.md)
 - [RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsDeviceCalibrationActions](docs/RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsDeviceCalibrationActions.md)
 - [RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsDeviceParameters](docs/RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsDeviceParameters.md)
 - [RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsDeviceProperties](docs/RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsDeviceProperties.md)
 - [RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsDeviceSoftwareUpdateActions](docs/RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsDeviceSoftwareUpdateActions.md)
 - [RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsGenericDeviceActions](docs/RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsGenericDeviceActions.md)
 - [RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsGenericDeviceActionsDataInner](docs/RetrieveacollectionofDeviceobjects0200ResponseDataInnerRelationshipsGenericDeviceActionsDataInner.md)
 - [RetrieveacollectionofManufacturerModelobjects0200Response](docs/RetrieveacollectionofManufacturerModelobjects0200Response.md)
 - [RetrieveacollectionofManufacturerModelobjects0200ResponseDataInner](docs/RetrieveacollectionofManufacturerModelobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofManufacturerModelobjects0200ResponseDataInnerAttributes](docs/RetrieveacollectionofManufacturerModelobjects0200ResponseDataInnerAttributes.md)
 - [RetrieveacollectionofManufacturerModelobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofManufacturerModelobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofManufacturerModelobjects0200ResponseDataInnerRelationshipsExportControl](docs/RetrieveacollectionofManufacturerModelobjects0200ResponseDataInnerRelationshipsExportControl.md)
 - [RetrieveacollectionofManufacturerModelobjects0200ResponseDataInnerRelationshipsExportControlData](docs/RetrieveacollectionofManufacturerModelobjects0200ResponseDataInnerRelationshipsExportControlData.md)
 - [RetrieveacollectionofPlatformAttachmentobjects0200Response](docs/RetrieveacollectionofPlatformAttachmentobjects0200Response.md)
 - [RetrieveacollectionofPlatformAttachmentobjects0200ResponseDataInner](docs/RetrieveacollectionofPlatformAttachmentobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofPlatformAttachmentobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofPlatformAttachmentobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofPlatformAttachmentobjects0200ResponseDataInnerRelationshipsPlatformImages](docs/RetrieveacollectionofPlatformAttachmentobjects0200ResponseDataInnerRelationshipsPlatformImages.md)
 - [RetrieveacollectionofPlatformAttachmentobjects0200ResponseDataInnerRelationshipsPlatformImagesDataInner](docs/RetrieveacollectionofPlatformAttachmentobjects0200ResponseDataInnerRelationshipsPlatformImagesDataInner.md)
 - [RetrieveacollectionofPlatformobjects0200Response](docs/RetrieveacollectionofPlatformobjects0200Response.md)
 - [RetrieveacollectionofPlatformobjects0200ResponseDataInner](docs/RetrieveacollectionofPlatformobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofPlatformobjects0200ResponseDataInnerAttributes](docs/RetrieveacollectionofPlatformobjects0200ResponseDataInnerAttributes.md)
 - [RetrieveacollectionofPlatformobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofPlatformobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofPlatformobjects0200ResponseDataInnerRelationshipsGenericPlatformActions](docs/RetrieveacollectionofPlatformobjects0200ResponseDataInnerRelationshipsGenericPlatformActions.md)
 - [RetrieveacollectionofPlatformobjects0200ResponseDataInnerRelationshipsGenericPlatformActionsDataInner](docs/RetrieveacollectionofPlatformobjects0200ResponseDataInnerRelationshipsGenericPlatformActionsDataInner.md)
 - [RetrieveacollectionofPlatformobjects0200ResponseDataInnerRelationshipsPlatformAttachments](docs/RetrieveacollectionofPlatformobjects0200ResponseDataInnerRelationshipsPlatformAttachments.md)
 - [RetrieveacollectionofPlatformobjects0200ResponseDataInnerRelationshipsPlatformParameters](docs/RetrieveacollectionofPlatformobjects0200ResponseDataInnerRelationshipsPlatformParameters.md)
 - [RetrieveacollectionofPlatformobjects0200ResponseDataInnerRelationshipsPlatformSoftwareUpdateActions](docs/RetrieveacollectionofPlatformobjects0200ResponseDataInnerRelationshipsPlatformSoftwareUpdateActions.md)
 - [RetrieveacollectionofSiteAttachmentobjects0200Response](docs/RetrieveacollectionofSiteAttachmentobjects0200Response.md)
 - [RetrieveacollectionofSiteAttachmentobjects0200ResponseDataInner](docs/RetrieveacollectionofSiteAttachmentobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofSiteAttachmentobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofSiteAttachmentobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofSiteAttachmentobjects0200ResponseDataInnerRelationshipsSiteImages](docs/RetrieveacollectionofSiteAttachmentobjects0200ResponseDataInnerRelationshipsSiteImages.md)
 - [RetrieveacollectionofSiteAttachmentobjects0200ResponseDataInnerRelationshipsSiteImagesDataInner](docs/RetrieveacollectionofSiteAttachmentobjects0200ResponseDataInnerRelationshipsSiteImagesDataInner.md)
 - [RetrieveacollectionofSiteobjects0200Response](docs/RetrieveacollectionofSiteobjects0200Response.md)
 - [RetrieveacollectionofSiteobjects0200ResponseDataInner](docs/RetrieveacollectionofSiteobjects0200ResponseDataInner.md)
 - [RetrieveacollectionofSiteobjects0200ResponseDataInnerAttributes](docs/RetrieveacollectionofSiteobjects0200ResponseDataInnerAttributes.md)
 - [RetrieveacollectionofSiteobjects0200ResponseDataInnerRelationships](docs/RetrieveacollectionofSiteobjects0200ResponseDataInnerRelationships.md)
 - [RetrieveacollectionofSiteobjects0200ResponseDataInnerRelationshipsSiteAttachments](docs/RetrieveacollectionofSiteobjects0200ResponseDataInnerRelationshipsSiteAttachments.md)
 - [RetrieveacollectionofTsmEndpointObjects200Response](docs/RetrieveacollectionofTsmEndpointObjects200Response.md)
 - [RetrieveacollectionofTsmEndpointObjects200ResponseDataInner](docs/RetrieveacollectionofTsmEndpointObjects200ResponseDataInner.md)
 - [RetrieveacollectionofTsmEndpointObjects200ResponseDataInnerAttributes](docs/RetrieveacollectionofTsmEndpointObjects200ResponseDataInnerAttributes.md)
 - [RetrievecollectionofConfigurationImageobjects200Response](docs/RetrievecollectionofConfigurationImageobjects200Response.md)
 - [RetrievecollectionofConfigurationImageobjects200ResponseDataInner](docs/RetrievecollectionofConfigurationImageobjects200ResponseDataInner.md)
 - [RetrievecollectionofConfigurationImageobjects200ResponseDataInnerAttributes](docs/RetrievecollectionofConfigurationImageobjects200ResponseDataInnerAttributes.md)
 - [RetrievecollectionofConfigurationImageobjects200ResponseDataInnerRelationships](docs/RetrievecollectionofConfigurationImageobjects200ResponseDataInnerRelationships.md)
 - [RetrievecollectionofConfigurationImageobjects200ResponseDataInnerRelationshipsAttachment](docs/RetrievecollectionofConfigurationImageobjects200ResponseDataInnerRelationshipsAttachment.md)
 - [RetrievecollectionofConfigurationImageobjects200ResponseDataInnerRelationshipsAttachmentData](docs/RetrievecollectionofConfigurationImageobjects200ResponseDataInnerRelationshipsAttachmentData.md)
 - [RetrievecollectionofDeviceImageobjects200Response](docs/RetrievecollectionofDeviceImageobjects200Response.md)
 - [RetrievecollectionofDeviceImageobjects200ResponseDataInner](docs/RetrievecollectionofDeviceImageobjects200ResponseDataInner.md)
 - [RetrievecollectionofDeviceImageobjects200ResponseDataInnerRelationships](docs/RetrievecollectionofDeviceImageobjects200ResponseDataInnerRelationships.md)
 - [RetrievecollectionofExportControlAttachmentobjects200Response](docs/RetrievecollectionofExportControlAttachmentobjects200Response.md)
 - [RetrievecollectionofExportControlAttachmentobjects200ResponseDataInner](docs/RetrievecollectionofExportControlAttachmentobjects200ResponseDataInner.md)
 - [RetrievecollectionofExportControlAttachmentobjects200ResponseDataInnerAttributes](docs/RetrievecollectionofExportControlAttachmentobjects200ResponseDataInnerAttributes.md)
 - [RetrievecollectionofExportControlobjects200Response](docs/RetrievecollectionofExportControlobjects200Response.md)
 - [RetrievecollectionofExportControlobjects200ResponseDataInner](docs/RetrievecollectionofExportControlobjects200ResponseDataInner.md)
 - [RetrievecollectionofExportControlobjects200ResponseDataInnerAttributes](docs/RetrievecollectionofExportControlobjects200ResponseDataInnerAttributes.md)
 - [RetrievecollectionofExportControlobjects200ResponseDataInnerRelationships](docs/RetrievecollectionofExportControlobjects200ResponseDataInnerRelationships.md)
 - [RetrievecollectionofExportControlobjects200ResponseDataInnerRelationshipsManufacturerModel](docs/RetrievecollectionofExportControlobjects200ResponseDataInnerRelationshipsManufacturerModel.md)
 - [RetrievecollectionofExportControlobjects200ResponseDataInnerRelationshipsManufacturerModelData](docs/RetrievecollectionofExportControlobjects200ResponseDataInnerRelationshipsManufacturerModelData.md)
 - [RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200Response](docs/RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200Response.md)
 - [RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200ResponseDataInner](docs/RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200ResponseDataInner.md)
 - [RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200ResponseDataInnerRelationships](docs/RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200ResponseDataInnerRelationships.md)
 - [RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200ResponseDataInnerRelationshipsDatastreamLink](docs/RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200ResponseDataInnerRelationshipsDatastreamLink.md)
 - [RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200ResponseDataInnerRelationshipsDatastreamLinkData](docs/RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200ResponseDataInnerRelationshipsDatastreamLinkData.md)
 - [RetrievecollectionofPlatformImageobjects200Response](docs/RetrievecollectionofPlatformImageobjects200Response.md)
 - [RetrievecollectionofPlatformImageobjects200ResponseDataInner](docs/RetrievecollectionofPlatformImageobjects200ResponseDataInner.md)
 - [RetrievecollectionofPlatformImageobjects200ResponseDataInnerRelationships](docs/RetrievecollectionofPlatformImageobjects200ResponseDataInnerRelationships.md)
 - [RetrievecollectionofPlatformImageobjects200ResponseDataInnerRelationshipsAttachment](docs/RetrievecollectionofPlatformImageobjects200ResponseDataInnerRelationshipsAttachment.md)
 - [RetrievecollectionofPlatformImageobjects200ResponseDataInnerRelationshipsAttachmentData](docs/RetrievecollectionofPlatformImageobjects200ResponseDataInnerRelationshipsAttachmentData.md)
 - [RetrievecollectionofSiteImageobjects200Response](docs/RetrievecollectionofSiteImageobjects200Response.md)
 - [RetrievecollectionofSiteImageobjects200ResponseDataInner](docs/RetrievecollectionofSiteImageobjects200ResponseDataInner.md)
 - [RetrievecollectionofSiteImageobjects200ResponseDataInnerRelationships](docs/RetrievecollectionofSiteImageobjects200ResponseDataInnerRelationships.md)
 - [RetrievecollectionofSiteImageobjects200ResponseDataInnerRelationshipsAttachment](docs/RetrievecollectionofSiteImageobjects200ResponseDataInnerRelationshipsAttachment.md)
 - [RetrievecollectionofSiteImageobjects200ResponseDataInnerRelationshipsAttachmentData](docs/RetrievecollectionofSiteImageobjects200ResponseDataInnerRelationshipsAttachmentData.md)
 - [RetrieveinstanceofTsmEndpointObject200Response](docs/RetrieveinstanceofTsmEndpointObject200Response.md)
 - [RevokeApikeyPost200Response](docs/RevokeApikeyPost200Response.md)
 - [RevokeApikeyPost200ResponseData](docs/RevokeApikeyPost200ResponseData.md)
 - [RevokeApikeyPost200ResponseDataAttributes](docs/RevokeApikeyPost200ResponseDataAttributes.md)
 - [SiteContactRolesGet200Response](docs/SiteContactRolesGet200Response.md)
 - [SiteContactRolesGet200ResponseDataInner](docs/SiteContactRolesGet200ResponseDataInner.md)
 - [SiteContactRolesGet200ResponseDataInnerRelationships](docs/SiteContactRolesGet200ResponseDataInnerRelationships.md)
 - [SiteContactRolesPost201Response](docs/SiteContactRolesPost201Response.md)
 - [SiteContactRolesPostRequest](docs/SiteContactRolesPostRequest.md)
 - [SiteContactRolesPostRequestData](docs/SiteContactRolesPostRequestData.md)
 - [SiteContactRolesSiteContactRoleIdPatchRequest](docs/SiteContactRolesSiteContactRoleIdPatchRequest.md)
 - [StaticLocationActionsGet200Response](docs/StaticLocationActionsGet200Response.md)
 - [StaticLocationActionsGet200ResponseDataInner](docs/StaticLocationActionsGet200ResponseDataInner.md)
 - [StaticLocationActionsGet200ResponseDataInnerAttributes](docs/StaticLocationActionsGet200ResponseDataInnerAttributes.md)
 - [StaticLocationActionsGet200ResponseDataInnerRelationships](docs/StaticLocationActionsGet200ResponseDataInnerRelationships.md)
 - [StaticLocationActionsPost201Response](docs/StaticLocationActionsPost201Response.md)
 - [StaticLocationActionsPostRequest](docs/StaticLocationActionsPostRequest.md)
 - [StaticLocationActionsPostRequestData](docs/StaticLocationActionsPostRequestData.md)
 - [StaticLocationActionsPostRequestDataAttributes](docs/StaticLocationActionsPostRequestDataAttributes.md)
 - [StaticLocationActionsStaticLocationActionIdPatchRequest](docs/StaticLocationActionsStaticLocationActionIdPatchRequest.md)
 - [UpdateConfiguration0Request](docs/UpdateConfiguration0Request.md)
 - [UpdateConfiguration0RequestData](docs/UpdateConfiguration0RequestData.md)
 - [UpdateConfiguration0RequestDataAttributes](docs/UpdateConfiguration0RequestDataAttributes.md)
 - [UpdateConfigurationAttachment0Request](docs/UpdateConfigurationAttachment0Request.md)
 - [UpdateConfigurationAttachment0RequestData](docs/UpdateConfigurationAttachment0RequestData.md)
 - [UpdateConfigurationAttachment0RequestDataAttributes](docs/UpdateConfigurationAttachment0RequestDataAttributes.md)
 - [UpdateConfigurationCustomField0Request](docs/UpdateConfigurationCustomField0Request.md)
 - [UpdateConfigurationImageRequest](docs/UpdateConfigurationImageRequest.md)
 - [UpdateConfigurationImageRequestData](docs/UpdateConfigurationImageRequestData.md)
 - [UpdateConfigurationParameterRequest](docs/UpdateConfigurationParameterRequest.md)
 - [UpdateConfigurationParameterRequestData](docs/UpdateConfigurationParameterRequestData.md)
 - [UpdateConfigurationParameterRequestDataAttributes](docs/UpdateConfigurationParameterRequestDataAttributes.md)
 - [UpdateConfigurationParameterValueChangeActionRequest](docs/UpdateConfigurationParameterValueChangeActionRequest.md)
 - [UpdateConfigurationParameterValueChangeActionRequestData](docs/UpdateConfigurationParameterValueChangeActionRequestData.md)
 - [UpdateConfigurationParameterValueChangeActionRequestDataAttributes](docs/UpdateConfigurationParameterValueChangeActionRequestDataAttributes.md)
 - [UpdateContact0Request](docs/UpdateContact0Request.md)
 - [UpdateContact0RequestData](docs/UpdateContact0RequestData.md)
 - [UpdateContact0RequestDataAttributes](docs/UpdateContact0RequestDataAttributes.md)
 - [UpdateCustomField0Request](docs/UpdateCustomField0Request.md)
 - [UpdateDatastreamLinkObjectRequest](docs/UpdateDatastreamLinkObjectRequest.md)
 - [UpdateDatastreamLinkObjectRequestData](docs/UpdateDatastreamLinkObjectRequestData.md)
 - [UpdateDatastreamLinkObjectRequestDataAttributes](docs/UpdateDatastreamLinkObjectRequestDataAttributes.md)
 - [UpdateDevice0Request](docs/UpdateDevice0Request.md)
 - [UpdateDevice0RequestData](docs/UpdateDevice0RequestData.md)
 - [UpdateDevice0RequestDataAttributes](docs/UpdateDevice0RequestDataAttributes.md)
 - [UpdateDeviceAttachment0Request](docs/UpdateDeviceAttachment0Request.md)
 - [UpdateDeviceAttachment0RequestData](docs/UpdateDeviceAttachment0RequestData.md)
 - [UpdateDeviceImageRequest](docs/UpdateDeviceImageRequest.md)
 - [UpdateDeviceImageRequestData](docs/UpdateDeviceImageRequestData.md)
 - [UpdateDeviceParameterRequest](docs/UpdateDeviceParameterRequest.md)
 - [UpdateDeviceParameterRequestData](docs/UpdateDeviceParameterRequestData.md)
 - [UpdateDeviceParameterValueChangeActionRequest](docs/UpdateDeviceParameterValueChangeActionRequest.md)
 - [UpdateDeviceParameterValueChangeActionRequestData](docs/UpdateDeviceParameterValueChangeActionRequestData.md)
 - [UpdateDeviceProperty0Request](docs/UpdateDeviceProperty0Request.md)
 - [UpdateDeviceProperty0RequestData](docs/UpdateDeviceProperty0RequestData.md)
 - [UpdateExportControlAttachmentRequest](docs/UpdateExportControlAttachmentRequest.md)
 - [UpdateExportControlAttachmentRequestData](docs/UpdateExportControlAttachmentRequestData.md)
 - [UpdateExportControlAttachmentRequestDataAttributes](docs/UpdateExportControlAttachmentRequestDataAttributes.md)
 - [UpdateExportControlRequest](docs/UpdateExportControlRequest.md)
 - [UpdateExportControlRequestData](docs/UpdateExportControlRequestData.md)
 - [UpdateInvolvedDeviceForDatastreamLinkRequest](docs/UpdateInvolvedDeviceForDatastreamLinkRequest.md)
 - [UpdatePlatform0Request](docs/UpdatePlatform0Request.md)
 - [UpdatePlatform0RequestData](docs/UpdatePlatform0RequestData.md)
 - [UpdatePlatform0RequestDataAttributes](docs/UpdatePlatform0RequestDataAttributes.md)
 - [UpdatePlatformAttachment0Request](docs/UpdatePlatformAttachment0Request.md)
 - [UpdatePlatformAttachment0RequestData](docs/UpdatePlatformAttachment0RequestData.md)
 - [UpdatePlatformImageRequest](docs/UpdatePlatformImageRequest.md)
 - [UpdatePlatformImageRequestData](docs/UpdatePlatformImageRequestData.md)
 - [UpdatePlatformParameterRequest](docs/UpdatePlatformParameterRequest.md)
 - [UpdatePlatformParameterRequestData](docs/UpdatePlatformParameterRequestData.md)
 - [UpdatePlatformParameterValueChangeActionRequest](docs/UpdatePlatformParameterValueChangeActionRequest.md)
 - [UpdatePlatformParameterValueChangeActionRequestData](docs/UpdatePlatformParameterValueChangeActionRequestData.md)
 - [UpdateSite0Request](docs/UpdateSite0Request.md)
 - [UpdateSite0RequestData](docs/UpdateSite0RequestData.md)
 - [UpdateSiteAttachment0Request](docs/UpdateSiteAttachment0Request.md)
 - [UpdateSiteAttachment0RequestData](docs/UpdateSiteAttachment0RequestData.md)
 - [UpdateSiteImageRequest](docs/UpdateSiteImageRequest.md)
 - [UpdateSiteImageRequestData](docs/UpdateSiteImageRequestData.md)
 - [UploadAttachment0201Response](docs/UploadAttachment0201Response.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="ApiKeyAuth"></a>
### ApiKeyAuth

- **Type**: API key
- **API key parameter name**: X-APIKEY
- **Location**: HTTP header


## Author

gitlab-incoming+hub-terra-sms-orchestration-3268-issue-@hzdr.de


