# openapi_client.ConfigurationCustomFieldsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_configuration_custom_field0**](ConfigurationCustomFieldsApi.md#create_configuration_custom_field0) | **POST** /configuration-customfields | 
[**delete_configuration_custom_fieldfromcustomfield0**](ConfigurationCustomFieldsApi.md#delete_configuration_custom_fieldfromcustomfield0) | **DELETE** /configuration-customfields/{configuration_custom_field_id} | 
[**retrieve_configuration_custom_fieldinstance0**](ConfigurationCustomFieldsApi.md#retrieve_configuration_custom_fieldinstance0) | **GET** /configuration-customfields/{configuration_custom_field_id} | 
[**retrieveacollectionof_configuration_custom_fieldobjects0**](ConfigurationCustomFieldsApi.md#retrieveacollectionof_configuration_custom_fieldobjects0) | **GET** /configuration-customfields | 
[**update_configuration_custom_field0**](ConfigurationCustomFieldsApi.md#update_configuration_custom_field0) | **PATCH** /configuration-customfields/{configuration_custom_field_id} | 


# **create_configuration_custom_field0**
> CreateConfigurationCustomField0201Response create_configuration_custom_field0(create_configuration_custom_field0_request=create_configuration_custom_field0_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_configuration_custom_field0201_response import CreateConfigurationCustomField0201Response
from openapi_client.models.create_configuration_custom_field0_request import CreateConfigurationCustomField0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationCustomFieldsApi(api_client)
    create_configuration_custom_field0_request = openapi_client.CreateConfigurationCustomField0Request() # CreateConfigurationCustomField0Request |  (optional)

    try:
        api_response = api_instance.create_configuration_custom_field0(create_configuration_custom_field0_request=create_configuration_custom_field0_request)
        print("The response of ConfigurationCustomFieldsApi->create_configuration_custom_field0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationCustomFieldsApi->create_configuration_custom_field0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_configuration_custom_field0_request** | [**CreateConfigurationCustomField0Request**](CreateConfigurationCustomField0Request.md)|  | [optional] 

### Return type

[**CreateConfigurationCustomField0201Response**](CreateConfigurationCustomField0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created configuration custom field |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_configuration_custom_fieldfromcustomfield0**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_configuration_custom_fieldfromcustomfield0(configuration_custom_field_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationCustomFieldsApi(api_client)
    configuration_custom_field_id = 'configuration_custom_field_id_example' # str | 

    try:
        api_response = api_instance.delete_configuration_custom_fieldfromcustomfield0(configuration_custom_field_id)
        print("The response of ConfigurationCustomFieldsApi->delete_configuration_custom_fieldfromcustomfield0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationCustomFieldsApi->delete_configuration_custom_fieldfromcustomfield0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_custom_field_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_configuration_custom_fieldinstance0**
> CreateConfigurationCustomField0201Response retrieve_configuration_custom_fieldinstance0(configuration_custom_field_id, include=include)

Retrieve a configuration custom field

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_configuration_custom_field0201_response import CreateConfigurationCustomField0201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationCustomFieldsApi(api_client)
    configuration_custom_field_id = 'configuration_custom_field_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_configuration_custom_fieldinstance0(configuration_custom_field_id, include=include)
        print("The response of ConfigurationCustomFieldsApi->retrieve_configuration_custom_fieldinstance0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationCustomFieldsApi->retrieve_configuration_custom_fieldinstance0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_custom_field_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateConfigurationCustomField0201Response**](CreateConfigurationCustomField0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Request fulfilled, document follows |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_configuration_custom_fieldobjects0**
> RetrieveacollectionofConfigurationCustomFieldobjects0200Response retrieveacollectionof_configuration_custom_fieldobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_key=filter_key, filter_value=filter_value, filter_description=filter_description, filter_configuration_id=filter_configuration_id, filter=filter)

Retrieve a list of configuration custom fields

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_configuration_custom_fieldobjects0200_response import RetrieveacollectionofConfigurationCustomFieldobjects0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationCustomFieldsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_key = 'filter_key_example' # str |  (optional)
    filter_value = 'filter_value_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_configuration_id = 'filter_configuration_id_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.retrieveacollectionof_configuration_custom_fieldobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_key=filter_key, filter_value=filter_value, filter_description=filter_description, filter_configuration_id=filter_configuration_id, filter=filter)
        print("The response of ConfigurationCustomFieldsApi->retrieveacollectionof_configuration_custom_fieldobjects0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationCustomFieldsApi->retrieveacollectionof_configuration_custom_fieldobjects0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_key** | **str**|  | [optional] 
 **filter_value** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_configuration_id** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**RetrieveacollectionofConfigurationCustomFieldobjects0200Response**](RetrieveacollectionofConfigurationCustomFieldobjects0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of configuration custom fields |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_configuration_custom_field0**
> CreateConfigurationCustomField0201Response update_configuration_custom_field0(configuration_custom_field_id, update_configuration_custom_field0_request)

Update ConfigurationCustomField attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_configuration_custom_field0201_response import CreateConfigurationCustomField0201Response
from openapi_client.models.update_configuration_custom_field0_request import UpdateConfigurationCustomField0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationCustomFieldsApi(api_client)
    configuration_custom_field_id = 'configuration_custom_field_id_example' # str | 
    update_configuration_custom_field0_request = openapi_client.UpdateConfigurationCustomField0Request() # UpdateConfigurationCustomField0Request | ConfigurationCustomField update payload

    try:
        api_response = api_instance.update_configuration_custom_field0(configuration_custom_field_id, update_configuration_custom_field0_request)
        print("The response of ConfigurationCustomFieldsApi->update_configuration_custom_field0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationCustomFieldsApi->update_configuration_custom_field0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_custom_field_id** | **str**|  | 
 **update_configuration_custom_field0_request** | [**UpdateConfigurationCustomField0Request**](UpdateConfigurationCustomField0Request.md)| ConfigurationCustomField update payload | 

### Return type

[**CreateConfigurationCustomField0201Response**](CreateConfigurationCustomField0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated configuration custom field |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

