# openapi_client.ConfigurationImagesApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_configuration_image**](ConfigurationImagesApi.md#create_configuration_image) | **POST** /configuration-images | 
[**delete_configuration_image**](ConfigurationImagesApi.md#delete_configuration_image) | **DELETE** /configuration-images/{configuration_image_id} | 
[**retrieve_configuration_image_instance**](ConfigurationImagesApi.md#retrieve_configuration_image_instance) | **GET** /configuration-images/{configuration_image_id} | 
[**retrievecollectionof_configuration_imageobjects**](ConfigurationImagesApi.md#retrievecollectionof_configuration_imageobjects) | **GET** /configuration-images | 
[**update_configuration_image**](ConfigurationImagesApi.md#update_configuration_image) | **PATCH** /configuration-images/{configuration_image_id} | 


# **create_configuration_image**
> CreateConfigurationImage201Response create_configuration_image(create_configuration_image_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_configuration_image201_response import CreateConfigurationImage201Response
from openapi_client.models.create_configuration_image_request import CreateConfigurationImageRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationImagesApi(api_client)
    create_configuration_image_request = openapi_client.CreateConfigurationImageRequest() # CreateConfigurationImageRequest | 

    try:
        api_response = api_instance.create_configuration_image(create_configuration_image_request)
        print("The response of ConfigurationImagesApi->create_configuration_image:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationImagesApi->create_configuration_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_configuration_image_request** | [**CreateConfigurationImageRequest**](CreateConfigurationImageRequest.md)|  | 

### Return type

[**CreateConfigurationImage201Response**](CreateConfigurationImage201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created configuration image |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_configuration_image**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_configuration_image(configuration_image_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationImagesApi(api_client)
    configuration_image_id = 'configuration_image_id_example' # str | 

    try:
        api_response = api_instance.delete_configuration_image(configuration_image_id)
        print("The response of ConfigurationImagesApi->delete_configuration_image:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationImagesApi->delete_configuration_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_image_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_configuration_image_instance**
> CreateConfigurationImage201Response retrieve_configuration_image_instance(configuration_image_id, include=include)

Retrieve a single configuration image

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_configuration_image201_response import CreateConfigurationImage201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationImagesApi(api_client)
    configuration_image_id = 'configuration_image_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_configuration_image_instance(configuration_image_id, include=include)
        print("The response of ConfigurationImagesApi->retrieve_configuration_image_instance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationImagesApi->retrieve_configuration_image_instance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_image_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateConfigurationImage201Response**](CreateConfigurationImage201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a configuration image |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrievecollectionof_configuration_imageobjects**
> RetrievecollectionofConfigurationImageobjects200Response retrievecollectionof_configuration_imageobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_order_index=filter_order_index, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_configuration_id=filter_configuration_id, filter_attachment_id=filter_attachment_id)

Retrieve a list of configuration images

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrievecollectionof_configuration_imageobjects200_response import RetrievecollectionofConfigurationImageobjects200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationImagesApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_order_index = 3.4 # float |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_configuration_id = 'filter_configuration_id_example' # str |  (optional)
    filter_attachment_id = 'filter_attachment_id_example' # str |  (optional)

    try:
        api_response = api_instance.retrievecollectionof_configuration_imageobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_order_index=filter_order_index, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_configuration_id=filter_configuration_id, filter_attachment_id=filter_attachment_id)
        print("The response of ConfigurationImagesApi->retrievecollectionof_configuration_imageobjects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationImagesApi->retrievecollectionof_configuration_imageobjects: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_order_index** | **float**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_configuration_id** | **str**|  | [optional] 
 **filter_attachment_id** | **str**|  | [optional] 

### Return type

[**RetrievecollectionofConfigurationImageobjects200Response**](RetrievecollectionofConfigurationImageobjects200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of configuration images |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_configuration_image**
> CreateConfigurationImage201Response update_configuration_image(configuration_image_id, update_configuration_image_request)

Update ConfigurationImage attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_configuration_image201_response import CreateConfigurationImage201Response
from openapi_client.models.update_configuration_image_request import UpdateConfigurationImageRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationImagesApi(api_client)
    configuration_image_id = 'configuration_image_id_example' # str | 
    update_configuration_image_request = openapi_client.UpdateConfigurationImageRequest() # UpdateConfigurationImageRequest | ConfigurationImage attributes

    try:
        api_response = api_instance.update_configuration_image(configuration_image_id, update_configuration_image_request)
        print("The response of ConfigurationImagesApi->update_configuration_image:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationImagesApi->update_configuration_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_image_id** | **str**|  | 
 **update_configuration_image_request** | [**UpdateConfigurationImageRequest**](UpdateConfigurationImageRequest.md)| ConfigurationImage attributes | 

### Return type

[**CreateConfigurationImage201Response**](CreateConfigurationImage201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated configuration image |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

