# openapi_client.ConfigurationParametersApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_configuration_parameter**](ConfigurationParametersApi.md#create_configuration_parameter) | **POST** /configuration-parameters | 
[**delete_configuration_parameter**](ConfigurationParametersApi.md#delete_configuration_parameter) | **DELETE** /configuration-parameters/{configuration_parameter_id} | 
[**retriececollectionof_configuration_parameterobjects**](ConfigurationParametersApi.md#retriececollectionof_configuration_parameterobjects) | **GET** /configuration-parameters | 
[**retrieve_configuration_parameterinstance**](ConfigurationParametersApi.md#retrieve_configuration_parameterinstance) | **GET** /configuration-parameters/{configuration_parameter_id} | 
[**update_configuration_parameter**](ConfigurationParametersApi.md#update_configuration_parameter) | **PATCH** /configuration-parameters/{configuration_parameter_id} | 


# **create_configuration_parameter**
> CreateConfigurationParameter201Response create_configuration_parameter(create_configuration_parameter_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_configuration_parameter201_response import CreateConfigurationParameter201Response
from openapi_client.models.create_configuration_parameter_request import CreateConfigurationParameterRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationParametersApi(api_client)
    create_configuration_parameter_request = openapi_client.CreateConfigurationParameterRequest() # CreateConfigurationParameterRequest | 

    try:
        api_response = api_instance.create_configuration_parameter(create_configuration_parameter_request)
        print("The response of ConfigurationParametersApi->create_configuration_parameter:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationParametersApi->create_configuration_parameter: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_configuration_parameter_request** | [**CreateConfigurationParameterRequest**](CreateConfigurationParameterRequest.md)|  | 

### Return type

[**CreateConfigurationParameter201Response**](CreateConfigurationParameter201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created configuration parameter |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_configuration_parameter**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_configuration_parameter(configuration_parameter_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationParametersApi(api_client)
    configuration_parameter_id = 'configuration_parameter_id_example' # str | 

    try:
        api_response = api_instance.delete_configuration_parameter(configuration_parameter_id)
        print("The response of ConfigurationParametersApi->delete_configuration_parameter:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationParametersApi->delete_configuration_parameter: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_parameter_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retriececollectionof_configuration_parameterobjects**
> RetriececollectionofConfigurationParameterobjects200Response retriececollectionof_configuration_parameterobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_label=filter_label, filter_description=filter_description, filter_unit_uri=filter_unit_uri, filter_unit_name=filter_unit_name, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_configuration_id=filter_configuration_id)

Retrieve the list of configuration parameters

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retriececollectionof_configuration_parameterobjects200_response import RetriececollectionofConfigurationParameterobjects200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationParametersApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_unit_uri = 'filter_unit_uri_example' # str |  (optional)
    filter_unit_name = 'filter_unit_name_example' # str |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_configuration_id = 'filter_configuration_id_example' # str |  (optional)

    try:
        api_response = api_instance.retriececollectionof_configuration_parameterobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_label=filter_label, filter_description=filter_description, filter_unit_uri=filter_unit_uri, filter_unit_name=filter_unit_name, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_configuration_id=filter_configuration_id)
        print("The response of ConfigurationParametersApi->retriececollectionof_configuration_parameterobjects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationParametersApi->retriececollectionof_configuration_parameterobjects: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_unit_uri** | **str**|  | [optional] 
 **filter_unit_name** | **str**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_configuration_id** | **str**|  | [optional] 

### Return type

[**RetriececollectionofConfigurationParameterobjects200Response**](RetriececollectionofConfigurationParameterobjects200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of configuration parameters |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_configuration_parameterinstance**
> CreateConfigurationParameter201Response retrieve_configuration_parameterinstance(configuration_parameter_id, include=include)

Retrieve a single configuration parameter

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_configuration_parameter201_response import CreateConfigurationParameter201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationParametersApi(api_client)
    configuration_parameter_id = 'configuration_parameter_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_configuration_parameterinstance(configuration_parameter_id, include=include)
        print("The response of ConfigurationParametersApi->retrieve_configuration_parameterinstance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationParametersApi->retrieve_configuration_parameterinstance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_parameter_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateConfigurationParameter201Response**](CreateConfigurationParameter201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a configuration parameter |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_configuration_parameter**
> CreateConfigurationParameter201Response update_configuration_parameter(configuration_parameter_id, update_configuration_parameter_request)

Update ConfigurationParameter attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_configuration_parameter201_response import CreateConfigurationParameter201Response
from openapi_client.models.update_configuration_parameter_request import UpdateConfigurationParameterRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationParametersApi(api_client)
    configuration_parameter_id = 'configuration_parameter_id_example' # str | 
    update_configuration_parameter_request = openapi_client.UpdateConfigurationParameterRequest() # UpdateConfigurationParameterRequest | ConfigurationParameter attributes

    try:
        api_response = api_instance.update_configuration_parameter(configuration_parameter_id, update_configuration_parameter_request)
        print("The response of ConfigurationParametersApi->update_configuration_parameter:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationParametersApi->update_configuration_parameter: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_parameter_id** | **str**|  | 
 **update_configuration_parameter_request** | [**UpdateConfigurationParameterRequest**](UpdateConfigurationParameterRequest.md)| ConfigurationParameter attributes | 

### Return type

[**CreateConfigurationParameter201Response**](CreateConfigurationParameter201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated configuration parameter |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

