# openapi_client.ConfigurationsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**archive_configuration**](ConfigurationsApi.md#archive_configuration) | **POST** /configurations/{configuration_id}/archive | 
[**create_configuration0**](ConfigurationsApi.md#create_configuration0) | **POST** /configurations | 
[**delete_configurationfromconfiguration0**](ConfigurationsApi.md#delete_configurationfromconfiguration0) | **DELETE** /configurations/{configuration_id} | 
[**restore_configuration**](ConfigurationsApi.md#restore_configuration) | **POST** /configurations/{configuration_id}/restore | 
[**retrieve_configuration_sensor_ml**](ConfigurationsApi.md#retrieve_configuration_sensor_ml) | **GET** /configurations/{configuration_id}/sensorml | 
[**retrieve_configurationinstance0**](ConfigurationsApi.md#retrieve_configurationinstance0) | **GET** /configurations/{configuration_id} | 
[**retrieveacollectionof_configurationobjects0**](ConfigurationsApi.md#retrieveacollectionof_configurationobjects0) | **GET** /configurations | 
[**retrieveacollectionof_site0**](ConfigurationsApi.md#retrieveacollectionof_site0) | **GET** /sites/{site_id}/configurations | 
[**update_configuration0**](ConfigurationsApi.md#update_configuration0) | **PATCH** /configurations/{configuration_id} | 


# **archive_configuration**
> archive_configuration(configuration_id)

Archive a configuration.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationsApi(api_client)
    configuration_id = 'configuration_id_example' # str | 

    try:
        api_instance.archive_configuration(configuration_id)
    except Exception as e:
        print("Exception when calling ConfigurationsApi->archive_configuration: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Configuration was archived succesfully. |  -  |
**401** | Authentification required. |  -  |
**403** | 403 Error |  -  |
**404** |  |  -  |
**409** | Conflict on performing the operation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_configuration0**
> CreateConfiguration0201Response create_configuration0(create_configuration0_request)

create a Configuration

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_configuration0201_response import CreateConfiguration0201Response
from openapi_client.models.create_configuration0_request import CreateConfiguration0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationsApi(api_client)
    create_configuration0_request = openapi_client.CreateConfiguration0Request() # CreateConfiguration0Request | 

    try:
        api_response = api_instance.create_configuration0(create_configuration0_request)
        print("The response of ConfigurationsApi->create_configuration0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationsApi->create_configuration0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_configuration0_request** | [**CreateConfiguration0Request**](CreateConfiguration0Request.md)|  | 

### Return type

[**CreateConfiguration0201Response**](CreateConfiguration0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created configuration |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_configurationfromconfiguration0**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_configurationfromconfiguration0(configuration_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationsApi(api_client)
    configuration_id = 'configuration_id_example' # str | 

    try:
        api_response = api_instance.delete_configurationfromconfiguration0(configuration_id)
        print("The response of ConfigurationsApi->delete_configurationfromconfiguration0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationsApi->delete_configurationfromconfiguration0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **restore_configuration**
> restore_configuration(configuration_id)

Restore an archived configuration.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationsApi(api_client)
    configuration_id = 'configuration_id_example' # str | 

    try:
        api_instance.restore_configuration(configuration_id)
    except Exception as e:
        print("Exception when calling ConfigurationsApi->restore_configuration: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Restoring of the configuration was succesful. |  -  |
**401** | Authentification required. |  -  |
**403** | 403 Error |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_configuration_sensor_ml**
> retrieve_configuration_sensor_ml(configuration_id)

Retrieve Configuration sensorML

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationsApi(api_client)
    configuration_id = 'configuration_id_example' # str | 

    try:
        api_instance.retrieve_configuration_sensor_ml(configuration_id)
    except Exception as e:
        print("Exception when calling ConfigurationsApi->retrieve_configuration_sensor_ml: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/xml, application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | SensorML response for the configuration |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_configurationinstance0**
> CreateConfiguration0201Response retrieve_configurationinstance0(configuration_id, include=include)

Retrieve Configuration from configuration

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_configuration0201_response import CreateConfiguration0201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationsApi(api_client)
    configuration_id = 'configuration_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_configurationinstance0(configuration_id, include=include)
        print("The response of ConfigurationsApi->retrieve_configurationinstance0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationsApi->retrieve_configurationinstance0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateConfiguration0201Response**](CreateConfiguration0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api.json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a configuration |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_configurationobjects0**
> RetrieveacollectionofConfigurationobjects0200Response retrieveacollectionof_configurationobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_start_date=filter_start_date, filter_end_date=filter_end_date, filter_label=filter_label, filter_project=filter_project, filter_campaign=filter_campaign, filter_description=filter_description, filter_status=filter_status, filter_cfg_permission_group=filter_cfg_permission_group, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_is_internal=filter_is_internal, filter_is_public=filter_is_public, filter_archived=filter_archived, filter_update_description=filter_update_description, filter_persistent_identifier=filter_persistent_identifier, filter=filter, hide_archived=hide_archived)

Retrieve Configuration from configuration

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_configurationobjects0200_response import RetrieveacollectionofConfigurationobjects0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_project = 'filter_project_example' # str |  (optional)
    filter_campaign = 'filter_campaign_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_status = 'filter_status_example' # str |  (optional)
    filter_cfg_permission_group = 'filter_cfg_permission_group_example' # str |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_is_internal = True # bool |  (optional)
    filter_is_public = True # bool |  (optional)
    filter_archived = True # bool |  (optional)
    filter_update_description = 'filter_update_description_example' # str |  (optional)
    filter_persistent_identifier = 'filter_persistent_identifier_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)
    hide_archived = True # bool | In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones. (optional) (default to True)

    try:
        api_response = api_instance.retrieveacollectionof_configurationobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_start_date=filter_start_date, filter_end_date=filter_end_date, filter_label=filter_label, filter_project=filter_project, filter_campaign=filter_campaign, filter_description=filter_description, filter_status=filter_status, filter_cfg_permission_group=filter_cfg_permission_group, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_is_internal=filter_is_internal, filter_is_public=filter_is_public, filter_archived=filter_archived, filter_update_description=filter_update_description, filter_persistent_identifier=filter_persistent_identifier, filter=filter, hide_archived=hide_archived)
        print("The response of ConfigurationsApi->retrieveacollectionof_configurationobjects0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationsApi->retrieveacollectionof_configurationobjects0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_start_date** | **datetime**|  | [optional] 
 **filter_end_date** | **datetime**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_project** | **str**|  | [optional] 
 **filter_campaign** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_status** | **str**|  | [optional] 
 **filter_cfg_permission_group** | **str**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_is_internal** | **bool**|  | [optional] 
 **filter_is_public** | **bool**|  | [optional] 
 **filter_archived** | **bool**|  | [optional] 
 **filter_update_description** | **str**|  | [optional] 
 **filter_persistent_identifier** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 
 **hide_archived** | **bool**| In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones. | [optional] [default to True]

### Return type

[**RetrieveacollectionofConfigurationobjects0200Response**](RetrieveacollectionofConfigurationobjects0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of configurations |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_site0**
> RetrieveacollectionofConfigurationobjects0200Response retrieveacollectionof_site0(site_id, include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_start_date=filter_start_date, filter_end_date=filter_end_date, filter_label=filter_label, filter_project=filter_project, filter_campaign=filter_campaign, filter_description=filter_description, filter_status=filter_status, filter_cfg_permission_group=filter_cfg_permission_group, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_is_internal=filter_is_internal, filter_is_public=filter_is_public, filter_archived=filter_archived, filter_update_description=filter_update_description, filter_persistent_identifier=filter_persistent_identifier, filter=filter, hide_archived=hide_archived)

Retrieve the configurations for a specific site.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_configurationobjects0200_response import RetrieveacollectionofConfigurationobjects0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationsApi(api_client)
    site_id = 'site_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_project = 'filter_project_example' # str |  (optional)
    filter_campaign = 'filter_campaign_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_status = 'filter_status_example' # str |  (optional)
    filter_cfg_permission_group = 'filter_cfg_permission_group_example' # str |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_is_internal = True # bool |  (optional)
    filter_is_public = True # bool |  (optional)
    filter_archived = True # bool |  (optional)
    filter_update_description = 'filter_update_description_example' # str |  (optional)
    filter_persistent_identifier = 'filter_persistent_identifier_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)
    hide_archived = True # bool | In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones. (optional) (default to True)

    try:
        api_response = api_instance.retrieveacollectionof_site0(site_id, include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_start_date=filter_start_date, filter_end_date=filter_end_date, filter_label=filter_label, filter_project=filter_project, filter_campaign=filter_campaign, filter_description=filter_description, filter_status=filter_status, filter_cfg_permission_group=filter_cfg_permission_group, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_is_internal=filter_is_internal, filter_is_public=filter_is_public, filter_archived=filter_archived, filter_update_description=filter_update_description, filter_persistent_identifier=filter_persistent_identifier, filter=filter, hide_archived=hide_archived)
        print("The response of ConfigurationsApi->retrieveacollectionof_site0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationsApi->retrieveacollectionof_site0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_start_date** | **datetime**|  | [optional] 
 **filter_end_date** | **datetime**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_project** | **str**|  | [optional] 
 **filter_campaign** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_status** | **str**|  | [optional] 
 **filter_cfg_permission_group** | **str**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_is_internal** | **bool**|  | [optional] 
 **filter_is_public** | **bool**|  | [optional] 
 **filter_archived** | **bool**|  | [optional] 
 **filter_update_description** | **str**|  | [optional] 
 **filter_persistent_identifier** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 
 **hide_archived** | **bool**| In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones. | [optional] [default to True]

### Return type

[**RetrieveacollectionofConfigurationobjects0200Response**](RetrieveacollectionofConfigurationobjects0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of configurations for the given site |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_configuration0**
> CreateConfiguration0201Response update_configuration0(configuration_id, update_configuration0_request)

Update Configuration attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_configuration0201_response import CreateConfiguration0201Response
from openapi_client.models.update_configuration0_request import UpdateConfiguration0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ConfigurationsApi(api_client)
    configuration_id = 'configuration_id_example' # str | 
    update_configuration0_request = openapi_client.UpdateConfiguration0Request() # UpdateConfiguration0Request | Configuration attributes

    try:
        api_response = api_instance.update_configuration0(configuration_id, update_configuration0_request)
        print("The response of ConfigurationsApi->update_configuration0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ConfigurationsApi->update_configuration0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_id** | **str**|  | 
 **update_configuration0_request** | [**UpdateConfiguration0Request**](UpdateConfiguration0Request.md)| Configuration attributes | 

### Return type

[**CreateConfiguration0201Response**](CreateConfiguration0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated configuration |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

