# openapi_client.ContactRolesApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**configuration_contact_roles_configuration_contact_role_id_delete**](ContactRolesApi.md#configuration_contact_roles_configuration_contact_role_id_delete) | **DELETE** /configuration-contact-roles/{configuration_contact_role_id} | 
[**configuration_contact_roles_configuration_contact_role_id_get**](ContactRolesApi.md#configuration_contact_roles_configuration_contact_role_id_get) | **GET** /configuration-contact-roles/{configuration_contact_role_id} | 
[**configuration_contact_roles_configuration_contact_role_id_patch**](ContactRolesApi.md#configuration_contact_roles_configuration_contact_role_id_patch) | **PATCH** /configuration-contact-roles/{configuration_contact_role_id} | 
[**configuration_contact_roles_get**](ContactRolesApi.md#configuration_contact_roles_get) | **GET** /configuration-contact-roles | 
[**configuration_contact_roles_post**](ContactRolesApi.md#configuration_contact_roles_post) | **POST** /configuration-contact-roles | 
[**device_contact_roles_device_contact_role_id_delete**](ContactRolesApi.md#device_contact_roles_device_contact_role_id_delete) | **DELETE** /device-contact-roles/{device_contact_role_id} | 
[**device_contact_roles_device_contact_role_id_get**](ContactRolesApi.md#device_contact_roles_device_contact_role_id_get) | **GET** /device-contact-roles/{device_contact_role_id} | 
[**device_contact_roles_device_contact_role_id_patch**](ContactRolesApi.md#device_contact_roles_device_contact_role_id_patch) | **PATCH** /device-contact-roles/{device_contact_role_id} | 
[**device_contact_roles_get**](ContactRolesApi.md#device_contact_roles_get) | **GET** /device-contact-roles | 
[**device_contact_roles_post**](ContactRolesApi.md#device_contact_roles_post) | **POST** /device-contact-roles | 
[**platform_contact_roles_get**](ContactRolesApi.md#platform_contact_roles_get) | **GET** /platform-contact-roles | 
[**platform_contact_roles_platform_contact_role_id_delete**](ContactRolesApi.md#platform_contact_roles_platform_contact_role_id_delete) | **DELETE** /platform-contact-roles/{platform_contact_role_id} | 
[**platform_contact_roles_platform_contact_role_id_get**](ContactRolesApi.md#platform_contact_roles_platform_contact_role_id_get) | **GET** /platform-contact-roles/{platform_contact_role_id} | 
[**platform_contact_roles_platform_contact_role_id_patch**](ContactRolesApi.md#platform_contact_roles_platform_contact_role_id_patch) | **PATCH** /platform-contact-roles/{platform_contact_role_id} | 
[**platform_contact_roles_post**](ContactRolesApi.md#platform_contact_roles_post) | **POST** /platform-contact-roles | 
[**site_contact_roles_get**](ContactRolesApi.md#site_contact_roles_get) | **GET** /site-contact-roles | 
[**site_contact_roles_post**](ContactRolesApi.md#site_contact_roles_post) | **POST** /site-contact-roles | 
[**site_contact_roles_site_contact_role_id_delete**](ContactRolesApi.md#site_contact_roles_site_contact_role_id_delete) | **DELETE** /site-contact-roles/{site_contact_role_id} | 
[**site_contact_roles_site_contact_role_id_get**](ContactRolesApi.md#site_contact_roles_site_contact_role_id_get) | **GET** /site-contact-roles/{site_contact_role_id} | 
[**site_contact_roles_site_contact_role_id_patch**](ContactRolesApi.md#site_contact_roles_site_contact_role_id_patch) | **PATCH** /site-contact-roles/{site_contact_role_id} | 


# **configuration_contact_roles_configuration_contact_role_id_delete**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response configuration_contact_roles_configuration_contact_role_id_delete(configuration_contact_role_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    configuration_contact_role_id = 'configuration_contact_role_id_example' # str | 

    try:
        api_response = api_instance.configuration_contact_roles_configuration_contact_role_id_delete(configuration_contact_role_id)
        print("The response of ContactRolesApi->configuration_contact_roles_configuration_contact_role_id_delete:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->configuration_contact_roles_configuration_contact_role_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_contact_role_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **configuration_contact_roles_configuration_contact_role_id_get**
> ConfigurationContactRolesPost201Response configuration_contact_roles_configuration_contact_role_id_get(configuration_contact_role_id, include=include)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.configuration_contact_roles_post201_response import ConfigurationContactRolesPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    configuration_contact_role_id = 'configuration_contact_role_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.configuration_contact_roles_configuration_contact_role_id_get(configuration_contact_role_id, include=include)
        print("The response of ContactRolesApi->configuration_contact_roles_configuration_contact_role_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->configuration_contact_roles_configuration_contact_role_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_contact_role_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**ConfigurationContactRolesPost201Response**](ConfigurationContactRolesPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a configuration contct role |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **configuration_contact_roles_configuration_contact_role_id_patch**
> ConfigurationContactRolesPost201Response configuration_contact_roles_configuration_contact_role_id_patch(configuration_contact_role_id, configuration_contact_roles_configuration_contact_role_id_patch_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.configuration_contact_roles_configuration_contact_role_id_patch_request import ConfigurationContactRolesConfigurationContactRoleIdPatchRequest
from openapi_client.models.configuration_contact_roles_post201_response import ConfigurationContactRolesPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    configuration_contact_role_id = 'configuration_contact_role_id_example' # str | 
    configuration_contact_roles_configuration_contact_role_id_patch_request = openapi_client.ConfigurationContactRolesConfigurationContactRoleIdPatchRequest() # ConfigurationContactRolesConfigurationContactRoleIdPatchRequest | Configuration contact role attributes

    try:
        api_response = api_instance.configuration_contact_roles_configuration_contact_role_id_patch(configuration_contact_role_id, configuration_contact_roles_configuration_contact_role_id_patch_request)
        print("The response of ContactRolesApi->configuration_contact_roles_configuration_contact_role_id_patch:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->configuration_contact_roles_configuration_contact_role_id_patch: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_contact_role_id** | **str**|  | 
 **configuration_contact_roles_configuration_contact_role_id_patch_request** | [**ConfigurationContactRolesConfigurationContactRoleIdPatchRequest**](ConfigurationContactRolesConfigurationContactRoleIdPatchRequest.md)| Configuration contact role attributes | 

### Return type

[**ConfigurationContactRolesPost201Response**](ConfigurationContactRolesPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the udpated configuration contact role |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **configuration_contact_roles_get**
> ConfigurationContactRolesGet200Response configuration_contact_roles_get(page_number=page_number, page_size=page_size, filter_id=filter_id, filter_role_name=filter_role_name, filter_role_uri=filter_role_uri, filter_configuration_id=filter_configuration_id, filter_contact_id=filter_contact_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.configuration_contact_roles_get200_response import ConfigurationContactRolesGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    filter_id = 'filter_id_example' # str |  (optional)
    filter_role_name = 'filter_role_name_example' # str |  (optional)
    filter_role_uri = 'filter_role_uri_example' # str |  (optional)
    filter_configuration_id = 'filter_configuration_id_example' # str |  (optional)
    filter_contact_id = 'filter_contact_id_example' # str |  (optional)

    try:
        api_response = api_instance.configuration_contact_roles_get(page_number=page_number, page_size=page_size, filter_id=filter_id, filter_role_name=filter_role_name, filter_role_uri=filter_role_uri, filter_configuration_id=filter_configuration_id, filter_contact_id=filter_contact_id)
        print("The response of ContactRolesApi->configuration_contact_roles_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->configuration_contact_roles_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **filter_id** | **str**|  | [optional] 
 **filter_role_name** | **str**|  | [optional] 
 **filter_role_uri** | **str**|  | [optional] 
 **filter_configuration_id** | **str**|  | [optional] 
 **filter_contact_id** | **str**|  | [optional] 

### Return type

[**ConfigurationContactRolesGet200Response**](ConfigurationContactRolesGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of configuration contact roles |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **configuration_contact_roles_post**
> ConfigurationContactRolesPost201Response configuration_contact_roles_post(configuration_contact_roles_post_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.configuration_contact_roles_post201_response import ConfigurationContactRolesPost201Response
from openapi_client.models.configuration_contact_roles_post_request import ConfigurationContactRolesPostRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    configuration_contact_roles_post_request = openapi_client.ConfigurationContactRolesPostRequest() # ConfigurationContactRolesPostRequest | 

    try:
        api_response = api_instance.configuration_contact_roles_post(configuration_contact_roles_post_request)
        print("The response of ContactRolesApi->configuration_contact_roles_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->configuration_contact_roles_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_contact_roles_post_request** | [**ConfigurationContactRolesPostRequest**](ConfigurationContactRolesPostRequest.md)|  | 

### Return type

[**ConfigurationContactRolesPost201Response**](ConfigurationContactRolesPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created configuration contact role |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_contact_roles_device_contact_role_id_delete**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response device_contact_roles_device_contact_role_id_delete(device_contact_role_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    device_contact_role_id = 'device_contact_role_id_example' # str | 

    try:
        api_response = api_instance.device_contact_roles_device_contact_role_id_delete(device_contact_role_id)
        print("The response of ContactRolesApi->device_contact_roles_device_contact_role_id_delete:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->device_contact_roles_device_contact_role_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_contact_role_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_contact_roles_device_contact_role_id_get**
> DeviceContactRolesPost201Response device_contact_roles_device_contact_role_id_get(device_contact_role_id, include=include)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.device_contact_roles_post201_response import DeviceContactRolesPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    device_contact_role_id = 'device_contact_role_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.device_contact_roles_device_contact_role_id_get(device_contact_role_id, include=include)
        print("The response of ContactRolesApi->device_contact_roles_device_contact_role_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->device_contact_roles_device_contact_role_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_contact_role_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**DeviceContactRolesPost201Response**](DeviceContactRolesPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a device contct role |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_contact_roles_device_contact_role_id_patch**
> DeviceContactRolesPost201Response device_contact_roles_device_contact_role_id_patch(device_contact_role_id, device_contact_roles_device_contact_role_id_patch_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.device_contact_roles_device_contact_role_id_patch_request import DeviceContactRolesDeviceContactRoleIdPatchRequest
from openapi_client.models.device_contact_roles_post201_response import DeviceContactRolesPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    device_contact_role_id = 'device_contact_role_id_example' # str | 
    device_contact_roles_device_contact_role_id_patch_request = openapi_client.DeviceContactRolesDeviceContactRoleIdPatchRequest() # DeviceContactRolesDeviceContactRoleIdPatchRequest | Device contact role attributes

    try:
        api_response = api_instance.device_contact_roles_device_contact_role_id_patch(device_contact_role_id, device_contact_roles_device_contact_role_id_patch_request)
        print("The response of ContactRolesApi->device_contact_roles_device_contact_role_id_patch:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->device_contact_roles_device_contact_role_id_patch: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_contact_role_id** | **str**|  | 
 **device_contact_roles_device_contact_role_id_patch_request** | [**DeviceContactRolesDeviceContactRoleIdPatchRequest**](DeviceContactRolesDeviceContactRoleIdPatchRequest.md)| Device contact role attributes | 

### Return type

[**DeviceContactRolesPost201Response**](DeviceContactRolesPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the udpated device contact role |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_contact_roles_get**
> DeviceContactRolesGet200Response device_contact_roles_get(page_number=page_number, page_size=page_size, filter_id=filter_id, filter_role_name=filter_role_name, filter_role_uri=filter_role_uri, filter_device_id=filter_device_id, filter_contact_id=filter_contact_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.device_contact_roles_get200_response import DeviceContactRolesGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    filter_id = 'filter_id_example' # str |  (optional)
    filter_role_name = 'filter_role_name_example' # str |  (optional)
    filter_role_uri = 'filter_role_uri_example' # str |  (optional)
    filter_device_id = 'filter_device_id_example' # str |  (optional)
    filter_contact_id = 'filter_contact_id_example' # str |  (optional)

    try:
        api_response = api_instance.device_contact_roles_get(page_number=page_number, page_size=page_size, filter_id=filter_id, filter_role_name=filter_role_name, filter_role_uri=filter_role_uri, filter_device_id=filter_device_id, filter_contact_id=filter_contact_id)
        print("The response of ContactRolesApi->device_contact_roles_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->device_contact_roles_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **filter_id** | **str**|  | [optional] 
 **filter_role_name** | **str**|  | [optional] 
 **filter_role_uri** | **str**|  | [optional] 
 **filter_device_id** | **str**|  | [optional] 
 **filter_contact_id** | **str**|  | [optional] 

### Return type

[**DeviceContactRolesGet200Response**](DeviceContactRolesGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of device contact roles |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_contact_roles_post**
> DeviceContactRolesPost201Response device_contact_roles_post(device_contact_roles_post_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.device_contact_roles_post201_response import DeviceContactRolesPost201Response
from openapi_client.models.device_contact_roles_post_request import DeviceContactRolesPostRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    device_contact_roles_post_request = openapi_client.DeviceContactRolesPostRequest() # DeviceContactRolesPostRequest | 

    try:
        api_response = api_instance.device_contact_roles_post(device_contact_roles_post_request)
        print("The response of ContactRolesApi->device_contact_roles_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->device_contact_roles_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_contact_roles_post_request** | [**DeviceContactRolesPostRequest**](DeviceContactRolesPostRequest.md)|  | 

### Return type

[**DeviceContactRolesPost201Response**](DeviceContactRolesPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created device contact role |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_contact_roles_get**
> PlatformContactRolesGet200Response platform_contact_roles_get(page_number=page_number, page_size=page_size, filter_id=filter_id, filter_role_name=filter_role_name, filter_role_uri=filter_role_uri, filter_platform_id=filter_platform_id, filter_contact_id=filter_contact_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.platform_contact_roles_get200_response import PlatformContactRolesGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    filter_id = 'filter_id_example' # str |  (optional)
    filter_role_name = 'filter_role_name_example' # str |  (optional)
    filter_role_uri = 'filter_role_uri_example' # str |  (optional)
    filter_platform_id = 'filter_platform_id_example' # str |  (optional)
    filter_contact_id = 'filter_contact_id_example' # str |  (optional)

    try:
        api_response = api_instance.platform_contact_roles_get(page_number=page_number, page_size=page_size, filter_id=filter_id, filter_role_name=filter_role_name, filter_role_uri=filter_role_uri, filter_platform_id=filter_platform_id, filter_contact_id=filter_contact_id)
        print("The response of ContactRolesApi->platform_contact_roles_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->platform_contact_roles_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **filter_id** | **str**|  | [optional] 
 **filter_role_name** | **str**|  | [optional] 
 **filter_role_uri** | **str**|  | [optional] 
 **filter_platform_id** | **str**|  | [optional] 
 **filter_contact_id** | **str**|  | [optional] 

### Return type

[**PlatformContactRolesGet200Response**](PlatformContactRolesGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of platform contact roles |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_contact_roles_platform_contact_role_id_delete**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response platform_contact_roles_platform_contact_role_id_delete(platform_contact_role_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    platform_contact_role_id = 'platform_contact_role_id_example' # str | 

    try:
        api_response = api_instance.platform_contact_roles_platform_contact_role_id_delete(platform_contact_role_id)
        print("The response of ContactRolesApi->platform_contact_roles_platform_contact_role_id_delete:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->platform_contact_roles_platform_contact_role_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_contact_role_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_contact_roles_platform_contact_role_id_get**
> PlatformContactRolesPost201Response platform_contact_roles_platform_contact_role_id_get(platform_contact_role_id, include=include)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.platform_contact_roles_post201_response import PlatformContactRolesPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    platform_contact_role_id = 'platform_contact_role_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.platform_contact_roles_platform_contact_role_id_get(platform_contact_role_id, include=include)
        print("The response of ContactRolesApi->platform_contact_roles_platform_contact_role_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->platform_contact_roles_platform_contact_role_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_contact_role_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**PlatformContactRolesPost201Response**](PlatformContactRolesPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a platform contct role |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_contact_roles_platform_contact_role_id_patch**
> PlatformContactRolesPost201Response platform_contact_roles_platform_contact_role_id_patch(platform_contact_role_id, platform_contact_roles_platform_contact_role_id_patch_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.platform_contact_roles_platform_contact_role_id_patch_request import PlatformContactRolesPlatformContactRoleIdPatchRequest
from openapi_client.models.platform_contact_roles_post201_response import PlatformContactRolesPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    platform_contact_role_id = 'platform_contact_role_id_example' # str | 
    platform_contact_roles_platform_contact_role_id_patch_request = openapi_client.PlatformContactRolesPlatformContactRoleIdPatchRequest() # PlatformContactRolesPlatformContactRoleIdPatchRequest | Platform contact role attributes

    try:
        api_response = api_instance.platform_contact_roles_platform_contact_role_id_patch(platform_contact_role_id, platform_contact_roles_platform_contact_role_id_patch_request)
        print("The response of ContactRolesApi->platform_contact_roles_platform_contact_role_id_patch:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->platform_contact_roles_platform_contact_role_id_patch: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_contact_role_id** | **str**|  | 
 **platform_contact_roles_platform_contact_role_id_patch_request** | [**PlatformContactRolesPlatformContactRoleIdPatchRequest**](PlatformContactRolesPlatformContactRoleIdPatchRequest.md)| Platform contact role attributes | 

### Return type

[**PlatformContactRolesPost201Response**](PlatformContactRolesPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the udpated platform contact role |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_contact_roles_post**
> PlatformContactRolesPost201Response platform_contact_roles_post(platform_contact_roles_post_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.platform_contact_roles_post201_response import PlatformContactRolesPost201Response
from openapi_client.models.platform_contact_roles_post_request import PlatformContactRolesPostRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    platform_contact_roles_post_request = openapi_client.PlatformContactRolesPostRequest() # PlatformContactRolesPostRequest | 

    try:
        api_response = api_instance.platform_contact_roles_post(platform_contact_roles_post_request)
        print("The response of ContactRolesApi->platform_contact_roles_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->platform_contact_roles_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_contact_roles_post_request** | [**PlatformContactRolesPostRequest**](PlatformContactRolesPostRequest.md)|  | 

### Return type

[**PlatformContactRolesPost201Response**](PlatformContactRolesPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created platform contact role |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **site_contact_roles_get**
> SiteContactRolesGet200Response site_contact_roles_get(page_number=page_number, page_size=page_size, filter_id=filter_id, filter_role_name=filter_role_name, filter_role_uri=filter_role_uri, filter_site_id=filter_site_id, filter_contact_id=filter_contact_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.site_contact_roles_get200_response import SiteContactRolesGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    filter_id = 'filter_id_example' # str |  (optional)
    filter_role_name = 'filter_role_name_example' # str |  (optional)
    filter_role_uri = 'filter_role_uri_example' # str |  (optional)
    filter_site_id = 'filter_site_id_example' # str |  (optional)
    filter_contact_id = 'filter_contact_id_example' # str |  (optional)

    try:
        api_response = api_instance.site_contact_roles_get(page_number=page_number, page_size=page_size, filter_id=filter_id, filter_role_name=filter_role_name, filter_role_uri=filter_role_uri, filter_site_id=filter_site_id, filter_contact_id=filter_contact_id)
        print("The response of ContactRolesApi->site_contact_roles_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->site_contact_roles_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **filter_id** | **str**|  | [optional] 
 **filter_role_name** | **str**|  | [optional] 
 **filter_role_uri** | **str**|  | [optional] 
 **filter_site_id** | **str**|  | [optional] 
 **filter_contact_id** | **str**|  | [optional] 

### Return type

[**SiteContactRolesGet200Response**](SiteContactRolesGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of site contact roles |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **site_contact_roles_post**
> SiteContactRolesPost201Response site_contact_roles_post(site_contact_roles_post_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.site_contact_roles_post201_response import SiteContactRolesPost201Response
from openapi_client.models.site_contact_roles_post_request import SiteContactRolesPostRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    site_contact_roles_post_request = openapi_client.SiteContactRolesPostRequest() # SiteContactRolesPostRequest | 

    try:
        api_response = api_instance.site_contact_roles_post(site_contact_roles_post_request)
        print("The response of ContactRolesApi->site_contact_roles_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->site_contact_roles_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_contact_roles_post_request** | [**SiteContactRolesPostRequest**](SiteContactRolesPostRequest.md)|  | 

### Return type

[**SiteContactRolesPost201Response**](SiteContactRolesPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created site contact role |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **site_contact_roles_site_contact_role_id_delete**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response site_contact_roles_site_contact_role_id_delete(site_contact_role_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    site_contact_role_id = 'site_contact_role_id_example' # str | 

    try:
        api_response = api_instance.site_contact_roles_site_contact_role_id_delete(site_contact_role_id)
        print("The response of ContactRolesApi->site_contact_roles_site_contact_role_id_delete:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->site_contact_roles_site_contact_role_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_contact_role_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **site_contact_roles_site_contact_role_id_get**
> SiteContactRolesPost201Response site_contact_roles_site_contact_role_id_get(site_contact_role_id, include=include)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.site_contact_roles_post201_response import SiteContactRolesPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    site_contact_role_id = 'site_contact_role_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.site_contact_roles_site_contact_role_id_get(site_contact_role_id, include=include)
        print("The response of ContactRolesApi->site_contact_roles_site_contact_role_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->site_contact_roles_site_contact_role_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_contact_role_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**SiteContactRolesPost201Response**](SiteContactRolesPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a site contct role |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **site_contact_roles_site_contact_role_id_patch**
> SiteContactRolesPost201Response site_contact_roles_site_contact_role_id_patch(site_contact_role_id, site_contact_roles_site_contact_role_id_patch_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.site_contact_roles_post201_response import SiteContactRolesPost201Response
from openapi_client.models.site_contact_roles_site_contact_role_id_patch_request import SiteContactRolesSiteContactRoleIdPatchRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactRolesApi(api_client)
    site_contact_role_id = 'site_contact_role_id_example' # str | 
    site_contact_roles_site_contact_role_id_patch_request = openapi_client.SiteContactRolesSiteContactRoleIdPatchRequest() # SiteContactRolesSiteContactRoleIdPatchRequest | Site contact role attributes

    try:
        api_response = api_instance.site_contact_roles_site_contact_role_id_patch(site_contact_role_id, site_contact_roles_site_contact_role_id_patch_request)
        print("The response of ContactRolesApi->site_contact_roles_site_contact_role_id_patch:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactRolesApi->site_contact_roles_site_contact_role_id_patch: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_contact_role_id** | **str**|  | 
 **site_contact_roles_site_contact_role_id_patch_request** | [**SiteContactRolesSiteContactRoleIdPatchRequest**](SiteContactRolesSiteContactRoleIdPatchRequest.md)| Site contact role attributes | 

### Return type

[**SiteContactRolesPost201Response**](SiteContactRolesPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the udpated site contact role |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

