# openapi_client.ContactsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_contact0**](ContactsApi.md#create_contact0) | **POST** /contacts | 
[**delete_contactfromcontact5**](ContactsApi.md#delete_contactfromcontact5) | **DELETE** /contacts/{contact_id} | 
[**retrieve_contactinstance0**](ContactsApi.md#retrieve_contactinstance0) | **GET** /contacts/{contact_id} | 
[**retrieveacollectionof_contactobjects0**](ContactsApi.md#retrieveacollectionof_contactobjects0) | **GET** /contacts | 
[**update_contact0**](ContactsApi.md#update_contact0) | **PATCH** /contacts/{contact_id} | 


# **create_contact0**
> CreateContact0201Response create_contact0(create_contact0_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_contact0201_response import CreateContact0201Response
from openapi_client.models.create_contact0_request import CreateContact0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactsApi(api_client)
    create_contact0_request = openapi_client.CreateContact0Request() # CreateContact0Request | 

    try:
        api_response = api_instance.create_contact0(create_contact0_request)
        print("The response of ContactsApi->create_contact0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactsApi->create_contact0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_contact0_request** | [**CreateContact0Request**](CreateContact0Request.md)|  | 

### Return type

[**CreateContact0201Response**](CreateContact0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created contact |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_contactfromcontact5**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_contactfromcontact5(contact_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactsApi(api_client)
    contact_id = 'contact_id_example' # str | 

    try:
        api_response = api_instance.delete_contactfromcontact5(contact_id)
        print("The response of ContactsApi->delete_contactfromcontact5:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactsApi->delete_contactfromcontact5: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_contactinstance0**
> CreateContact0201Response retrieve_contactinstance0(contact_id, include=include)

Retrieve Contact from contact

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_contact0201_response import CreateContact0201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactsApi(api_client)
    contact_id = 'contact_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_contactinstance0(contact_id, include=include)
        print("The response of ContactsApi->retrieve_contactinstance0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactsApi->retrieve_contactinstance0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateContact0201Response**](CreateContact0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a contact |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_contactobjects0**
> RetrieveacollectionofContactobjects0200Response retrieveacollectionof_contactobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_given_name=filter_given_name, filter_family_name=filter_family_name, filter_website=filter_website, filter_organization=filter_organization, filter_orcid=filter_orcid, filter_email=filter_email, filter_active=filter_active, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter=filter)

Retrieve Contact from contact

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_contactobjects0200_response import RetrieveacollectionofContactobjects0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_given_name = 'filter_given_name_example' # str |  (optional)
    filter_family_name = 'filter_family_name_example' # str |  (optional)
    filter_website = 'filter_website_example' # str |  (optional)
    filter_organization = 'filter_organization_example' # str |  (optional)
    filter_orcid = 'filter_orcid_example' # str |  (optional)
    filter_email = 'filter_email_example' # str |  (optional)
    filter_active = True # bool |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.retrieveacollectionof_contactobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_given_name=filter_given_name, filter_family_name=filter_family_name, filter_website=filter_website, filter_organization=filter_organization, filter_orcid=filter_orcid, filter_email=filter_email, filter_active=filter_active, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter=filter)
        print("The response of ContactsApi->retrieveacollectionof_contactobjects0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactsApi->retrieveacollectionof_contactobjects0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_given_name** | **str**|  | [optional] 
 **filter_family_name** | **str**|  | [optional] 
 **filter_website** | **str**|  | [optional] 
 **filter_organization** | **str**|  | [optional] 
 **filter_orcid** | **str**|  | [optional] 
 **filter_email** | **str**|  | [optional] 
 **filter_active** | **bool**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**RetrieveacollectionofContactobjects0200Response**](RetrieveacollectionofContactobjects0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of contacts |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_contact0**
> CreateContact0201Response update_contact0(contact_id, update_contact0_request)

Update Contact attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_contact0201_response import CreateContact0201Response
from openapi_client.models.update_contact0_request import UpdateContact0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactsApi(api_client)
    contact_id = 'contact_id_example' # str | 
    update_contact0_request = openapi_client.UpdateContact0Request() # UpdateContact0Request | Contact attributes

    try:
        api_response = api_instance.update_contact0(contact_id, update_contact0_request)
        print("The response of ContactsApi->update_contact0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContactsApi->update_contact0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_id** | **str**|  | 
 **update_contact0_request** | [**UpdateContact0Request**](UpdateContact0Request.md)| Contact attributes | 

### Return type

[**CreateContact0201Response**](CreateContact0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated contact |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

