# openapi_client.ControllerApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**controller_attachment_labels**](ControllerApi.md#controller_attachment_labels) | **GET** /controller/attachment-labels | 
[**controller_configuration_attachment_labels**](ControllerApi.md#controller_configuration_attachment_labels) | **GET** /controller/configuration-attachment-labels | 
[**controller_configuration_campaigns**](ControllerApi.md#controller_configuration_campaigns) | **GET** /controller/configuration-campaigns | 
[**controller_configuration_custom_field_keys**](ControllerApi.md#controller_configuration_custom_field_keys) | **GET** /controller/configuration-custom-field-keys | 
[**controller_configuration_custom_field_values**](ControllerApi.md#controller_configuration_custom_field_values) | **GET** /controller/configuration-custom-field-values | 
[**controller_configuration_labels**](ControllerApi.md#controller_configuration_labels) | **GET** /controller/configuration-labels | 
[**controller_configuration_parameter_labels**](ControllerApi.md#controller_configuration_parameter_labels) | **GET** /controller/configuration-parameter-labels | 
[**controller_configuration_projects**](ControllerApi.md#controller_configuration_projects) | **GET** /controller/configuration-projects | 
[**controller_configurations_configuration_id_location_action_timepoints_get**](ControllerApi.md#controller_configurations_configuration_id_location_action_timepoints_get) | **GET** /controller/configurations/{configuration_id}/location-action-timepoints | 
[**controller_configurations_configuration_id_mounting_action_timepoints_get**](ControllerApi.md#controller_configurations_configuration_id_mounting_action_timepoints_get) | **GET** /controller/configurations/{configuration_id}/mounting-action-timepoints | 
[**controller_configurations_configuration_id_mounting_actions_get**](ControllerApi.md#controller_configurations_configuration_id_mounting_actions_get) | **GET** /controller/configurations/{configuration_id}/mounting-actions | 
[**controller_configurations_configuration_id_parameter_values_get**](ControllerApi.md#controller_configurations_configuration_id_parameter_values_get) | **GET** /controller/configurations/{configuration_id}/parameter-values | 
[**controller_contact_organizations**](ControllerApi.md#controller_contact_organizations) | **GET** /controller/contact-organizations | 
[**controller_device_attachment_labels**](ControllerApi.md#controller_device_attachment_labels) | **GET** /controller/device-attachment-labels | 
[**controller_device_availabilities_get**](ControllerApi.md#controller_device_availabilities_get) | **GET** /controller/device-availabilities | 
[**controller_device_calibration_action_descriptions**](ControllerApi.md#controller_device_calibration_action_descriptions) | **GET** /controller/device-calibration-action-descriptions | 
[**controller_device_calibration_action_forumlas**](ControllerApi.md#controller_device_calibration_action_forumlas) | **GET** /controller/device-calibration-action-formulas | 
[**controller_device_custom_field_keys**](ControllerApi.md#controller_device_custom_field_keys) | **GET** /controller/device-custom-field-keys | 
[**controller_device_custom_field_values**](ControllerApi.md#controller_device_custom_field_values) | **GET** /controller/device-custom-field-values | 
[**controller_device_long_names**](ControllerApi.md#controller_device_long_names) | **GET** /controller/device-long-names | 
[**controller_device_manufacturer_names**](ControllerApi.md#controller_device_manufacturer_names) | **GET** /controller/device-manufacturer-names | 
[**controller_device_models**](ControllerApi.md#controller_device_models) | **GET** /controller/device-models | 
[**controller_device_parameter_labels**](ControllerApi.md#controller_device_parameter_labels) | **GET** /controller/device-parameter-labels | 
[**controller_device_property_labels**](ControllerApi.md#controller_device_property_labels) | **GET** /controller/device-property-labels | 
[**controller_device_serial_numbers**](ControllerApi.md#controller_device_serial_numbers) | **GET** /controller/device-serial-numbers | 
[**controller_device_short_names**](ControllerApi.md#controller_device_short_names) | **GET** /controller/device-short-names | 
[**controller_device_software_update_action_descriptions**](ControllerApi.md#controller_device_software_update_action_descriptions) | **GET** /controller/device-software-update-action-descriptions | 
[**controller_device_software_update_action_repository_urls**](ControllerApi.md#controller_device_software_update_action_repository_urls) | **GET** /controller/device-software-update-action-repository-urls | 
[**controller_devices_device_id_parameter_values_get**](ControllerApi.md#controller_devices_device_id_parameter_values_get) | **GET** /controller/devices/{device_id}/parameter-values | 
[**controller_generic_configuration_action_descriptions**](ControllerApi.md#controller_generic_configuration_action_descriptions) | **GET** /controller/generic-configuration-action-descriptions | 
[**controller_generic_device_action_descriptions**](ControllerApi.md#controller_generic_device_action_descriptions) | **GET** /controller/generic-device-action-descriptions | 
[**controller_generic_platform_action_descriptions**](ControllerApi.md#controller_generic_platform_action_descriptions) | **GET** /controller/generic-platform-action-descriptions | 
[**controller_keywords**](ControllerApi.md#controller_keywords) | **GET** /controller/keywords | 
[**controller_platform_attachment_labels**](ControllerApi.md#controller_platform_attachment_labels) | **GET** /controller/platform-attachment-labels | 
[**controller_platform_availabilities_get**](ControllerApi.md#controller_platform_availabilities_get) | **GET** /controller/platform-availabilities | 
[**controller_platform_long_names**](ControllerApi.md#controller_platform_long_names) | **GET** /controller/platform-long-names | 
[**controller_platform_manufacturer_names**](ControllerApi.md#controller_platform_manufacturer_names) | **GET** /controller/platform-manufacturer-names | 
[**controller_platform_models**](ControllerApi.md#controller_platform_models) | **GET** /controller/platform-models | 
[**controller_platform_parameter_labels**](ControllerApi.md#controller_platform_parameter_labels) | **GET** /controller/platform-parameter-labels | 
[**controller_platform_serial_numbers**](ControllerApi.md#controller_platform_serial_numbers) | **GET** /controller/platform-serial-numbers | 
[**controller_platform_short_names**](ControllerApi.md#controller_platform_short_names) | **GET** /controller/platform-short-names | 
[**controller_platform_software_update_action_descriptions**](ControllerApi.md#controller_platform_software_update_action_descriptions) | **GET** /controller/platform-software-update-action-descriptions | 
[**controller_platform_software_update_action_repository_urls**](ControllerApi.md#controller_platform_software_update_action_repository_urls) | **GET** /controller/platform-software-update-action-repository-urls | 
[**controller_platforms_platform_id_parameter_values_get**](ControllerApi.md#controller_platforms_platform_id_parameter_values_get) | **GET** /controller/platforms/{platform_id}/parameter-values | 
[**controller_site_attachment_labels**](ControllerApi.md#controller_site_attachment_labels) | **GET** /controller/site-attachment-labels | 
[**controller_site_buildings**](ControllerApi.md#controller_site_buildings) | **GET** /controller/site-buildings | 
[**controller_site_cities**](ControllerApi.md#controller_site_cities) | **GET** /controller/site-cities | 
[**controller_site_countries**](ControllerApi.md#controller_site_countries) | **GET** /controller/site-countries | 
[**controller_site_labels**](ControllerApi.md#controller_site_labels) | **GET** /controller/site-labels | 
[**controller_site_rooms**](ControllerApi.md#controller_site_rooms) | **GET** /controller/site-rooms | 
[**controller_site_street_numbers**](ControllerApi.md#controller_site_street_numbers) | **GET** /controller/site-street-numbers | 
[**controller_site_streets**](ControllerApi.md#controller_site_streets) | **GET** /controller/site-streets | 
[**controller_site_zip_codes**](ControllerApi.md#controller_site_zip_codes) | **GET** /controller/site-zip-codes | 
[**get_global_activity**](ControllerApi.md#get_global_activity) | **GET** /controller/global-activities | 


# **controller_attachment_labels**
> ControllerPlatformSerialNumbers200Response controller_attachment_labels()

Get the list of distinct labels of all attachments.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_attachment_labels()
        print("The response of ControllerApi->controller_attachment_labels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_attachment_labels: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct attachment labels. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_configuration_attachment_labels**
> ControllerPlatformSerialNumbers200Response controller_configuration_attachment_labels()

Get the list of distinct labels of all configuration attachments.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_configuration_attachment_labels()
        print("The response of ControllerApi->controller_configuration_attachment_labels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_configuration_attachment_labels: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct configuration attachment labels. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_configuration_campaigns**
> ControllerPlatformSerialNumbers200Response controller_configuration_campaigns(project=project)

Get the list of distinct campaigns of all configurations.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    project = 'project_example' # str | Parameter to filter for a given project. (optional)

    try:
        api_response = api_instance.controller_configuration_campaigns(project=project)
        print("The response of ControllerApi->controller_configuration_campaigns:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_configuration_campaigns: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project** | **str**| Parameter to filter for a given project. | [optional] 

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct campaigns for configurations. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_configuration_custom_field_keys**
> ControllerPlatformSerialNumbers200Response controller_configuration_custom_field_keys()

Get the list of distinct configuration custom field keys of all devices.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_configuration_custom_field_keys()
        print("The response of ControllerApi->controller_configuration_custom_field_keys:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_configuration_custom_field_keys: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct custom field keys for configurations. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_configuration_custom_field_values**
> ControllerPlatformSerialNumbers200Response controller_configuration_custom_field_values()

Get the list of distinct configuration custom field values of all devices.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_configuration_custom_field_values()
        print("The response of ControllerApi->controller_configuration_custom_field_values:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_configuration_custom_field_values: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct custom field values for configurations. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_configuration_labels**
> ControllerPlatformSerialNumbers200Response controller_configuration_labels()

Get the list of distinct labels of all configurations.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_configuration_labels()
        print("The response of ControllerApi->controller_configuration_labels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_configuration_labels: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct labels for configurations. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_configuration_parameter_labels**
> ControllerPlatformSerialNumbers200Response controller_configuration_parameter_labels()

Get the list of distinct labels of all configuration parameters.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_configuration_parameter_labels()
        print("The response of ControllerApi->controller_configuration_parameter_labels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_configuration_parameter_labels: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct labels for configuation parameters. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_configuration_projects**
> ControllerPlatformSerialNumbers200Response controller_configuration_projects()

Get the list of distinct projects of all configurations.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_configuration_projects()
        print("The response of ControllerApi->controller_configuration_projects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_configuration_projects: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct projects for configurations. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_configurations_configuration_id_location_action_timepoints_get**
> ControllerConfigurationsConfigurationIdLocationActionTimepointsGet200Response controller_configurations_configuration_id_location_action_timepoints_get(configuration_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_configurations_configuration_id_location_action_timepoints_get200_response import ControllerConfigurationsConfigurationIdLocationActionTimepointsGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    configuration_id = 'configuration_id_example' # str | 

    try:
        api_response = api_instance.controller_configurations_configuration_id_location_action_timepoints_get(configuration_id)
        print("The response of ControllerApi->controller_configurations_configuration_id_location_action_timepoints_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_configurations_configuration_id_location_action_timepoints_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_id** | **str**|  | 

### Return type

[**ControllerConfigurationsConfigurationIdLocationActionTimepointsGet200Response**](ControllerConfigurationsConfigurationIdLocationActionTimepointsGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_configurations_configuration_id_mounting_action_timepoints_get**
> ControllerConfigurationsConfigurationIdMountingActionTimepointsGet200Response controller_configurations_configuration_id_mounting_action_timepoints_get(configuration_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_configurations_configuration_id_mounting_action_timepoints_get200_response import ControllerConfigurationsConfigurationIdMountingActionTimepointsGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    configuration_id = 'configuration_id_example' # str | 

    try:
        api_response = api_instance.controller_configurations_configuration_id_mounting_action_timepoints_get(configuration_id)
        print("The response of ControllerApi->controller_configurations_configuration_id_mounting_action_timepoints_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_configurations_configuration_id_mounting_action_timepoints_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_id** | **str**|  | 

### Return type

[**ControllerConfigurationsConfigurationIdMountingActionTimepointsGet200Response**](ControllerConfigurationsConfigurationIdMountingActionTimepointsGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_configurations_configuration_id_mounting_actions_get**
> ControllerConfigurationsConfigurationIdMountingActionsGet200Response controller_configurations_configuration_id_mounting_actions_get(timepoint, configuration_id)

Returns information of the platforms & devices that are mounted on the configuration to the given timepoint. Platforms and devices are sorted by short name.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_configurations_configuration_id_mounting_actions_get200_response import ControllerConfigurationsConfigurationIdMountingActionsGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    timepoint = 'timepoint_example' # str | 
    configuration_id = 'configuration_id_example' # str | 

    try:
        api_response = api_instance.controller_configurations_configuration_id_mounting_actions_get(timepoint, configuration_id)
        print("The response of ControllerApi->controller_configurations_configuration_id_mounting_actions_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_configurations_configuration_id_mounting_actions_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **timepoint** | **str**|  | 
 **configuration_id** | **str**|  | 

### Return type

[**ControllerConfigurationsConfigurationIdMountingActionsGet200Response**](ControllerConfigurationsConfigurationIdMountingActionsGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_configurations_configuration_id_parameter_values_get**
> ControllerConfigurationsConfigurationIdParameterValuesGet200Response controller_configurations_configuration_id_parameter_values_get(configuration_id, timepoint)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_configurations_configuration_id_parameter_values_get200_response import ControllerConfigurationsConfigurationIdParameterValuesGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    configuration_id = 'configuration_id_example' # str | 
    timepoint = '2013-10-20T19:20:30+01:00' # datetime | 

    try:
        api_response = api_instance.controller_configurations_configuration_id_parameter_values_get(configuration_id, timepoint)
        print("The response of ControllerApi->controller_configurations_configuration_id_parameter_values_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_configurations_configuration_id_parameter_values_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configuration_id** | **str**|  | 
 **timepoint** | **datetime**|  | 

### Return type

[**ControllerConfigurationsConfigurationIdParameterValuesGet200Response**](ControllerConfigurationsConfigurationIdParameterValuesGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of configuration parameter values to a specific timepoint. Includes platform &amp; device parameters - depending on mount dates. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_contact_organizations**
> ControllerPlatformSerialNumbers200Response controller_contact_organizations()

Get the list of distinct organization field values of all contacts.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_contact_organizations()
        print("The response of ControllerApi->controller_contact_organizations:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_contact_organizations: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct organizations. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_attachment_labels**
> ControllerPlatformSerialNumbers200Response controller_device_attachment_labels()

Get the list of distinct labels of all device attachments.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_device_attachment_labels()
        print("The response of ControllerApi->controller_device_attachment_labels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_attachment_labels: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct device attachment labels. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_availabilities_get**
> ControllerDeviceAvailabilitiesGet200Response controller_device_availabilities_get(ids, var_from, to)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_device_availabilities_get200_response import ControllerDeviceAvailabilitiesGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    ids = [] # List[int] |  (default to [])
    var_from = '' # str |  (default to '')
    to = '' # str |  (default to '')

    try:
        api_response = api_instance.controller_device_availabilities_get(ids, var_from, to)
        print("The response of ControllerApi->controller_device_availabilities_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_availabilities_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ids** | [**List[int]**](int.md)|  | [default to []]
 **var_from** | **str**|  | [default to &#39;&#39;]
 **to** | **str**|  | [default to &#39;&#39;]

### Return type

[**ControllerDeviceAvailabilitiesGet200Response**](ControllerDeviceAvailabilitiesGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_calibration_action_descriptions**
> ControllerPlatformSerialNumbers200Response controller_device_calibration_action_descriptions()

Get the list of distinct descriptions of all device calibration actions.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_device_calibration_action_descriptions()
        print("The response of ControllerApi->controller_device_calibration_action_descriptions:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_calibration_action_descriptions: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct device calibration action descriptions. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_calibration_action_forumlas**
> ControllerPlatformSerialNumbers200Response controller_device_calibration_action_forumlas()

Get the list of distinct formulas of all device calibration actions.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_device_calibration_action_forumlas()
        print("The response of ControllerApi->controller_device_calibration_action_forumlas:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_calibration_action_forumlas: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct device calibration action formulas. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_custom_field_keys**
> ControllerPlatformSerialNumbers200Response controller_device_custom_field_keys()

Get the list of distinct custom field keys of all devices.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_device_custom_field_keys()
        print("The response of ControllerApi->controller_device_custom_field_keys:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_custom_field_keys: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct custom field keys for devices. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_custom_field_values**
> ControllerPlatformSerialNumbers200Response controller_device_custom_field_values()

Get the list of distinct custom field values of all devices.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_device_custom_field_values()
        print("The response of ControllerApi->controller_device_custom_field_values:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_custom_field_values: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct custom field values for devices. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_long_names**
> ControllerPlatformSerialNumbers200Response controller_device_long_names()

Get the list of distinct long names of all devices.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_device_long_names()
        print("The response of ControllerApi->controller_device_long_names:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_long_names: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct long names for devices. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_manufacturer_names**
> ControllerPlatformSerialNumbers200Response controller_device_manufacturer_names()

Get the list of distinct manufacturer names of all devices.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_device_manufacturer_names()
        print("The response of ControllerApi->controller_device_manufacturer_names:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_manufacturer_names: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct manufacturer names for devices. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_models**
> ControllerPlatformSerialNumbers200Response controller_device_models(manufacturer_name=manufacturer_name, manufacturer_uri=manufacturer_uri)

Get the list of distinct models of all devices.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    manufacturer_name = 'manufacturer_name_example' # str | Parameter to filter for a given manufacturer name. (optional)
    manufacturer_uri = 'manufacturer_uri_example' # str | Parameter to filter for a given manufacturer uri. (optional)

    try:
        api_response = api_instance.controller_device_models(manufacturer_name=manufacturer_name, manufacturer_uri=manufacturer_uri)
        print("The response of ControllerApi->controller_device_models:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_models: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **manufacturer_name** | **str**| Parameter to filter for a given manufacturer name. | [optional] 
 **manufacturer_uri** | **str**| Parameter to filter for a given manufacturer uri. | [optional] 

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct models for devices. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_parameter_labels**
> ControllerPlatformSerialNumbers200Response controller_device_parameter_labels()

Get the list of distinct labels of all device parameters.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_device_parameter_labels()
        print("The response of ControllerApi->controller_device_parameter_labels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_parameter_labels: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct labels for device parameters. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_property_labels**
> ControllerPlatformSerialNumbers200Response controller_device_property_labels()

Get the list of distinct labels of all device properties.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_device_property_labels()
        print("The response of ControllerApi->controller_device_property_labels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_property_labels: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct device property labels. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_serial_numbers**
> ControllerPlatformSerialNumbers200Response controller_device_serial_numbers(ignore=ignore, short_name=short_name, manufacturer_name=manufacturer_name, manufacturer_uri=manufacturer_uri, model=model)

Get the list of distinct serial numbers of all devices.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    ignore = 'ignore_example' # str | Parameter to ignore certain device ids (given as comma seperated numbers) when extracting the set of serial numbers. (optional)
    short_name = 'short_name_example' # str | Parameter to filter for a given short name. (optional)
    manufacturer_name = 'manufacturer_name_example' # str | Parameter to filter for a given manufacturer name. (optional)
    manufacturer_uri = 'manufacturer_uri_example' # str | Parameter to filter for a given manufacturer uri. (optional)
    model = 'model_example' # str | Parameter to filter for a given model. (optional)

    try:
        api_response = api_instance.controller_device_serial_numbers(ignore=ignore, short_name=short_name, manufacturer_name=manufacturer_name, manufacturer_uri=manufacturer_uri, model=model)
        print("The response of ControllerApi->controller_device_serial_numbers:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_serial_numbers: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ignore** | **str**| Parameter to ignore certain device ids (given as comma seperated numbers) when extracting the set of serial numbers. | [optional] 
 **short_name** | **str**| Parameter to filter for a given short name. | [optional] 
 **manufacturer_name** | **str**| Parameter to filter for a given manufacturer name. | [optional] 
 **manufacturer_uri** | **str**| Parameter to filter for a given manufacturer uri. | [optional] 
 **model** | **str**| Parameter to filter for a given model. | [optional] 

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct serial numbers for devices. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_short_names**
> ControllerPlatformSerialNumbers200Response controller_device_short_names()

Get the list of distinct short names of all devices.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_device_short_names()
        print("The response of ControllerApi->controller_device_short_names:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_short_names: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct short names for devices. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_software_update_action_descriptions**
> ControllerPlatformSerialNumbers200Response controller_device_software_update_action_descriptions()

Get the list of distinct descriptions of all device software update actions.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_device_software_update_action_descriptions()
        print("The response of ControllerApi->controller_device_software_update_action_descriptions:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_software_update_action_descriptions: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct software update action descriptions for devices. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_device_software_update_action_repository_urls**
> ControllerPlatformSerialNumbers200Response controller_device_software_update_action_repository_urls()

Get the list of distinct repository urls of all device software update actions.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_device_software_update_action_repository_urls()
        print("The response of ControllerApi->controller_device_software_update_action_repository_urls:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_device_software_update_action_repository_urls: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct software update action repository urls for devices. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_devices_device_id_parameter_values_get**
> ControllerConfigurationsConfigurationIdParameterValuesGet200Response controller_devices_device_id_parameter_values_get(device_id, timepoint)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_configurations_configuration_id_parameter_values_get200_response import ControllerConfigurationsConfigurationIdParameterValuesGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    device_id = '0' # str |  (default to '0')
    timepoint = '2013-10-20T19:20:30+01:00' # datetime | 

    try:
        api_response = api_instance.controller_devices_device_id_parameter_values_get(device_id, timepoint)
        print("The response of ControllerApi->controller_devices_device_id_parameter_values_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_devices_device_id_parameter_values_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_id** | **str**|  | [default to &#39;0&#39;]
 **timepoint** | **datetime**|  | 

### Return type

[**ControllerConfigurationsConfigurationIdParameterValuesGet200Response**](ControllerConfigurationsConfigurationIdParameterValuesGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of device parameter values to a specific timepoint. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_generic_configuration_action_descriptions**
> ControllerPlatformSerialNumbers200Response controller_generic_configuration_action_descriptions()

Get the list of distinct descriptions of all generic configuration actions.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_generic_configuration_action_descriptions()
        print("The response of ControllerApi->controller_generic_configuration_action_descriptions:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_generic_configuration_action_descriptions: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct configuration action descriptions. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_generic_device_action_descriptions**
> ControllerPlatformSerialNumbers200Response controller_generic_device_action_descriptions()

Get the list of distinct descriptions of all generic device actions.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_generic_device_action_descriptions()
        print("The response of ControllerApi->controller_generic_device_action_descriptions:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_generic_device_action_descriptions: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct device action descriptions. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_generic_platform_action_descriptions**
> ControllerPlatformSerialNumbers200Response controller_generic_platform_action_descriptions()

Get the list of distinct descriptions of all generic platform actions.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_generic_platform_action_descriptions()
        print("The response of ControllerApi->controller_generic_platform_action_descriptions:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_generic_platform_action_descriptions: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct platform action descriptions. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_keywords**
> ControllerPlatformSerialNumbers200Response controller_keywords()

Get the list of distinct keywords of all devices, platforms, configurations and sites.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_keywords()
        print("The response of ControllerApi->controller_keywords:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_keywords: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct keywords. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_platform_attachment_labels**
> ControllerPlatformSerialNumbers200Response controller_platform_attachment_labels()

Get the list of distinct labels of all platform attachments.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_platform_attachment_labels()
        print("The response of ControllerApi->controller_platform_attachment_labels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_platform_attachment_labels: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct platform attachment labels. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_platform_availabilities_get**
> ControllerPlatformAvailabilitiesGet200Response controller_platform_availabilities_get(ids, var_from, to)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_availabilities_get200_response import ControllerPlatformAvailabilitiesGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    ids = [] # List[int] |  (default to [])
    var_from = '' # str |  (default to '')
    to = '' # str |  (default to '')

    try:
        api_response = api_instance.controller_platform_availabilities_get(ids, var_from, to)
        print("The response of ControllerApi->controller_platform_availabilities_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_platform_availabilities_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ids** | [**List[int]**](int.md)|  | [default to []]
 **var_from** | **str**|  | [default to &#39;&#39;]
 **to** | **str**|  | [default to &#39;&#39;]

### Return type

[**ControllerPlatformAvailabilitiesGet200Response**](ControllerPlatformAvailabilitiesGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_platform_long_names**
> ControllerPlatformSerialNumbers200Response controller_platform_long_names()

Get the list of distinct long names of all platforms.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_platform_long_names()
        print("The response of ControllerApi->controller_platform_long_names:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_platform_long_names: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct long names for platforms. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_platform_manufacturer_names**
> ControllerPlatformSerialNumbers200Response controller_platform_manufacturer_names()

Get the list of distinct manufacturer names of all platforms.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_platform_manufacturer_names()
        print("The response of ControllerApi->controller_platform_manufacturer_names:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_platform_manufacturer_names: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct manufacturer names for platforms. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_platform_models**
> ControllerPlatformSerialNumbers200Response controller_platform_models(manufacturer_name=manufacturer_name, manufacturer_uri=manufacturer_uri)

Get the list of distinct models of all platforms.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    manufacturer_name = 'manufacturer_name_example' # str | Parameter to filter for a given manufacturer name. (optional)
    manufacturer_uri = 'manufacturer_uri_example' # str | Parameter to filter for a given manufacturer uri. (optional)

    try:
        api_response = api_instance.controller_platform_models(manufacturer_name=manufacturer_name, manufacturer_uri=manufacturer_uri)
        print("The response of ControllerApi->controller_platform_models:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_platform_models: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **manufacturer_name** | **str**| Parameter to filter for a given manufacturer name. | [optional] 
 **manufacturer_uri** | **str**| Parameter to filter for a given manufacturer uri. | [optional] 

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct models for platforms. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_platform_parameter_labels**
> ControllerPlatformSerialNumbers200Response controller_platform_parameter_labels()

Get the list of distinct labels of all platform parameters.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_platform_parameter_labels()
        print("The response of ControllerApi->controller_platform_parameter_labels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_platform_parameter_labels: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct labels for platform parameters. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_platform_serial_numbers**
> ControllerPlatformSerialNumbers200Response controller_platform_serial_numbers(ignore=ignore, short_name=short_name, manufacturer_name=manufacturer_name, manufacturer_uri=manufacturer_uri, model=model)

Get the list of distinct serial numbers of all platforms.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    ignore = 'ignore_example' # str | Parameter to ignore certain platform ids (given as comma seperated numbers) when extracting the set of serial numbers. (optional)
    short_name = 'short_name_example' # str | Parameter to filter for a given short name. (optional)
    manufacturer_name = 'manufacturer_name_example' # str | Parameter to filter for a given manufacturer name. (optional)
    manufacturer_uri = 'manufacturer_uri_example' # str | Parameter to filter for a given manufacturer uri. (optional)
    model = 'model_example' # str | Parameter to filter for a given model. (optional)

    try:
        api_response = api_instance.controller_platform_serial_numbers(ignore=ignore, short_name=short_name, manufacturer_name=manufacturer_name, manufacturer_uri=manufacturer_uri, model=model)
        print("The response of ControllerApi->controller_platform_serial_numbers:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_platform_serial_numbers: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ignore** | **str**| Parameter to ignore certain platform ids (given as comma seperated numbers) when extracting the set of serial numbers. | [optional] 
 **short_name** | **str**| Parameter to filter for a given short name. | [optional] 
 **manufacturer_name** | **str**| Parameter to filter for a given manufacturer name. | [optional] 
 **manufacturer_uri** | **str**| Parameter to filter for a given manufacturer uri. | [optional] 
 **model** | **str**| Parameter to filter for a given model. | [optional] 

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Distinct list of serial numbers. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_platform_short_names**
> ControllerPlatformSerialNumbers200Response controller_platform_short_names()

Get the list of distinct short names of all platforms.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_platform_short_names()
        print("The response of ControllerApi->controller_platform_short_names:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_platform_short_names: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct short names for platforms. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_platform_software_update_action_descriptions**
> ControllerPlatformSerialNumbers200Response controller_platform_software_update_action_descriptions()

Get the list of distinct descriptions of all platform software update actions.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_platform_software_update_action_descriptions()
        print("The response of ControllerApi->controller_platform_software_update_action_descriptions:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_platform_software_update_action_descriptions: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct software update action descriptions for platforms. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_platform_software_update_action_repository_urls**
> ControllerPlatformSerialNumbers200Response controller_platform_software_update_action_repository_urls()

Get the list of distinct repository urls of all platform software update actions.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_platform_software_update_action_repository_urls()
        print("The response of ControllerApi->controller_platform_software_update_action_repository_urls:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_platform_software_update_action_repository_urls: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct software update action repository urls for platforms. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_platforms_platform_id_parameter_values_get**
> ControllerConfigurationsConfigurationIdParameterValuesGet200Response controller_platforms_platform_id_parameter_values_get(platform_id, timepoint)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_configurations_configuration_id_parameter_values_get200_response import ControllerConfigurationsConfigurationIdParameterValuesGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    platform_id = 'platform_id_example' # str | 
    timepoint = '2013-10-20T19:20:30+01:00' # datetime | 

    try:
        api_response = api_instance.controller_platforms_platform_id_parameter_values_get(platform_id, timepoint)
        print("The response of ControllerApi->controller_platforms_platform_id_parameter_values_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_platforms_platform_id_parameter_values_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_id** | **str**|  | 
 **timepoint** | **datetime**|  | 

### Return type

[**ControllerConfigurationsConfigurationIdParameterValuesGet200Response**](ControllerConfigurationsConfigurationIdParameterValuesGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of platform parameter values to a specific timepoint. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_site_attachment_labels**
> ControllerPlatformSerialNumbers200Response controller_site_attachment_labels()

Get the list of distinct labels of all site attachments.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_site_attachment_labels()
        print("The response of ControllerApi->controller_site_attachment_labels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_site_attachment_labels: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct site attachment labels. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_site_buildings**
> ControllerPlatformSerialNumbers200Response controller_site_buildings()

Get the list of distinct buildings of all sites

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_site_buildings()
        print("The response of ControllerApi->controller_site_buildings:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_site_buildings: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct buildings for sites. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_site_cities**
> ControllerPlatformSerialNumbers200Response controller_site_cities()

Get the list of distinct cities of all sites

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_site_cities()
        print("The response of ControllerApi->controller_site_cities:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_site_cities: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct cities for sites. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_site_countries**
> ControllerPlatformSerialNumbers200Response controller_site_countries()

Get the list of distinct countries of all sites

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_site_countries()
        print("The response of ControllerApi->controller_site_countries:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_site_countries: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct countries for sites. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_site_labels**
> ControllerPlatformSerialNumbers200Response controller_site_labels()

Get the list of distinct labels of all sites

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_site_labels()
        print("The response of ControllerApi->controller_site_labels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_site_labels: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct labels for sites. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_site_rooms**
> ControllerPlatformSerialNumbers200Response controller_site_rooms()

Get the list of distinct rooms of all sites

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_site_rooms()
        print("The response of ControllerApi->controller_site_rooms:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_site_rooms: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct rooms for sites. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_site_street_numbers**
> ControllerPlatformSerialNumbers200Response controller_site_street_numbers()

Get the list of distinct street numbers of all sites

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_site_street_numbers()
        print("The response of ControllerApi->controller_site_street_numbers:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_site_street_numbers: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct street numbers for sites. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_site_streets**
> ControllerPlatformSerialNumbers200Response controller_site_streets()

Get the list of distinct streets of all sites

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_site_streets()
        print("The response of ControllerApi->controller_site_streets:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_site_streets: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct streets for sites. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **controller_site_zip_codes**
> ControllerPlatformSerialNumbers200Response controller_site_zip_codes()

Get the list of distinct zip codes of all sites

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.controller_platform_serial_numbers200_response import ControllerPlatformSerialNumbers200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)

    try:
        api_response = api_instance.controller_site_zip_codes()
        print("The response of ControllerApi->controller_site_zip_codes:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->controller_site_zip_codes: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ControllerPlatformSerialNumbers200Response**](ControllerPlatformSerialNumbers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of distinct zip codes for sites. |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_global_activity**
> GetGlobalActivity200Response get_global_activity(earliest, latest)

Information about the activity in the SMS.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.get_global_activity200_response import GetGlobalActivity200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ControllerApi(api_client)
    earliest = '2013-10-20T19:20:30+01:00' # datetime | 
    latest = '2013-10-20T19:20:30+01:00' # datetime | 

    try:
        api_response = api_instance.get_global_activity(earliest, latest)
        print("The response of ControllerApi->get_global_activity:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ControllerApi->get_global_activity: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **earliest** | **datetime**|  | 
 **latest** | **datetime**|  | 

### Return type

[**GetGlobalActivity200Response**](GetGlobalActivity200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Global activity information |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

