# openapi_client.CustomFieldsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_custom_field0**](CustomFieldsApi.md#create_custom_field0) | **POST** /customfields | 
[**delete_custom_fieldfromcustomfield0**](CustomFieldsApi.md#delete_custom_fieldfromcustomfield0) | **DELETE** /customfields/{custom_field_id} | 
[**retrieve_custom_fieldinstance0**](CustomFieldsApi.md#retrieve_custom_fieldinstance0) | **GET** /customfields/{custom_field_id} | 
[**retrieveacollectionof_custom_fieldobjects0**](CustomFieldsApi.md#retrieveacollectionof_custom_fieldobjects0) | **GET** /customfields | 
[**update_custom_field0**](CustomFieldsApi.md#update_custom_field0) | **PATCH** /customfields/{custom_field_id} | 


# **create_custom_field0**
> CreateCustomField0201Response create_custom_field0(create_custom_field0_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_custom_field0201_response import CreateCustomField0201Response
from openapi_client.models.create_custom_field0_request import CreateCustomField0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomFieldsApi(api_client)
    create_custom_field0_request = openapi_client.CreateCustomField0Request() # CreateCustomField0Request | 

    try:
        api_response = api_instance.create_custom_field0(create_custom_field0_request)
        print("The response of CustomFieldsApi->create_custom_field0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomFieldsApi->create_custom_field0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_custom_field0_request** | [**CreateCustomField0Request**](CreateCustomField0Request.md)|  | 

### Return type

[**CreateCustomField0201Response**](CreateCustomField0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created customfield |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_custom_fieldfromcustomfield0**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_custom_fieldfromcustomfield0(custom_field_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomFieldsApi(api_client)
    custom_field_id = 'custom_field_id_example' # str | 

    try:
        api_response = api_instance.delete_custom_fieldfromcustomfield0(custom_field_id)
        print("The response of CustomFieldsApi->delete_custom_fieldfromcustomfield0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomFieldsApi->delete_custom_fieldfromcustomfield0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **custom_field_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_custom_fieldinstance0**
> CreateCustomField0201Response retrieve_custom_fieldinstance0(custom_field_id, include=include)

Retrieve CustomField from custom_field

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_custom_field0201_response import CreateCustomField0201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomFieldsApi(api_client)
    custom_field_id = 'custom_field_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_custom_fieldinstance0(custom_field_id, include=include)
        print("The response of CustomFieldsApi->retrieve_custom_fieldinstance0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomFieldsApi->retrieve_custom_fieldinstance0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **custom_field_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateCustomField0201Response**](CreateCustomField0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Request fulfilled, document follows |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_custom_fieldobjects0**
> RetrieveacollectionofCustomFieldobjects0200Response retrieveacollectionof_custom_fieldobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_key=filter_key, filter_value=filter_value, filter_description=filter_description, filter_device_id=filter_device_id, filter=filter)

Retrieve CustomField from custom_field

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_custom_fieldobjects0200_response import RetrieveacollectionofCustomFieldobjects0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomFieldsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_key = 'filter_key_example' # str |  (optional)
    filter_value = 'filter_value_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_device_id = 'filter_device_id_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.retrieveacollectionof_custom_fieldobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_key=filter_key, filter_value=filter_value, filter_description=filter_description, filter_device_id=filter_device_id, filter=filter)
        print("The response of CustomFieldsApi->retrieveacollectionof_custom_fieldobjects0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomFieldsApi->retrieveacollectionof_custom_fieldobjects0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_key** | **str**|  | [optional] 
 **filter_value** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_device_id** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**RetrieveacollectionofCustomFieldobjects0200Response**](RetrieveacollectionofCustomFieldobjects0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of customfields |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_custom_field0**
> CreateCustomField0201Response update_custom_field0(custom_field_id, update_custom_field0_request)

Update CustomField attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_custom_field0201_response import CreateCustomField0201Response
from openapi_client.models.update_custom_field0_request import UpdateCustomField0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomFieldsApi(api_client)
    custom_field_id = 'custom_field_id_example' # str | 
    update_custom_field0_request = openapi_client.UpdateCustomField0Request() # UpdateCustomField0Request | CustomField attributes

    try:
        api_response = api_instance.update_custom_field0(custom_field_id, update_custom_field0_request)
        print("The response of CustomFieldsApi->update_custom_field0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomFieldsApi->update_custom_field0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **custom_field_id** | **str**|  | 
 **update_custom_field0_request** | [**UpdateCustomField0Request**](UpdateCustomField0Request.md)| CustomField attributes | 

### Return type

[**CreateCustomField0201Response**](CreateCustomField0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated customfield |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

