# openapi_client.DatastreamLinksApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_datastream_link**](DatastreamLinksApi.md#create_datastream_link) | **POST** /datastream-links | 
[**create_involved_device_for_datastream_link**](DatastreamLinksApi.md#create_involved_device_for_datastream_link) | **POST** /involved-devices-for-datastream-links | 
[**delete_a_datastream_link_object**](DatastreamLinksApi.md#delete_a_datastream_link_object) | **DELETE** /datastream-links/{datastream_link_id} | 
[**delete_involved_device_for_datastream_link**](DatastreamLinksApi.md#delete_involved_device_for_datastream_link) | **DELETE** /involved-devices-for-datastream-links/{involved_device_for_datastream_link_id} | 
[**retrieve_involved_device_for_datastream_link_instance**](DatastreamLinksApi.md#retrieve_involved_device_for_datastream_link_instance) | **GET** /involved-devices-for-datastream-links/{involved_device_for_datastream_link_id} | 
[**retrieveacollectionof_datastream_link_objects**](DatastreamLinksApi.md#retrieveacollectionof_datastream_link_objects) | **GET** /datastream-links | 
[**retrievecollectionof_involved_devices_for_datastream_link_objects**](DatastreamLinksApi.md#retrievecollectionof_involved_devices_for_datastream_link_objects) | **GET** /involved-devices-for-datastream-links | 
[**retrieveinstanceof_datastream_link_object**](DatastreamLinksApi.md#retrieveinstanceof_datastream_link_object) | **GET** /datastream-links/{datastream_link_id} | 
[**update_datastream_link_object**](DatastreamLinksApi.md#update_datastream_link_object) | **PATCH** /datastream-links/{datastream_link_id} | 
[**update_involved_device_for_datastream_link**](DatastreamLinksApi.md#update_involved_device_for_datastream_link) | **PATCH** /involved-devices-for-datastream-links/{involved_device_for_datastream_link_id} | 


# **create_datastream_link**
> CreateDatastreamLink201Response create_datastream_link(create_datastream_link_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_datastream_link201_response import CreateDatastreamLink201Response
from openapi_client.models.create_datastream_link_request import CreateDatastreamLinkRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DatastreamLinksApi(api_client)
    create_datastream_link_request = openapi_client.CreateDatastreamLinkRequest() # CreateDatastreamLinkRequest | 

    try:
        api_response = api_instance.create_datastream_link(create_datastream_link_request)
        print("The response of DatastreamLinksApi->create_datastream_link:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DatastreamLinksApi->create_datastream_link: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_datastream_link_request** | [**CreateDatastreamLinkRequest**](CreateDatastreamLinkRequest.md)|  | 

### Return type

[**CreateDatastreamLink201Response**](CreateDatastreamLink201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created datastream link |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_involved_device_for_datastream_link**
> CreateInvolvedDeviceForDatastreamLink201Response create_involved_device_for_datastream_link(create_involved_device_for_datastream_link_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_involved_device_for_datastream_link201_response import CreateInvolvedDeviceForDatastreamLink201Response
from openapi_client.models.create_involved_device_for_datastream_link_request import CreateInvolvedDeviceForDatastreamLinkRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DatastreamLinksApi(api_client)
    create_involved_device_for_datastream_link_request = openapi_client.CreateInvolvedDeviceForDatastreamLinkRequest() # CreateInvolvedDeviceForDatastreamLinkRequest | 

    try:
        api_response = api_instance.create_involved_device_for_datastream_link(create_involved_device_for_datastream_link_request)
        print("The response of DatastreamLinksApi->create_involved_device_for_datastream_link:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DatastreamLinksApi->create_involved_device_for_datastream_link: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_involved_device_for_datastream_link_request** | [**CreateInvolvedDeviceForDatastreamLinkRequest**](CreateInvolvedDeviceForDatastreamLinkRequest.md)|  | 

### Return type

[**CreateInvolvedDeviceForDatastreamLink201Response**](CreateInvolvedDeviceForDatastreamLink201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created relationship of a device for a datastream link |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_a_datastream_link_object**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_a_datastream_link_object(datastream_link_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DatastreamLinksApi(api_client)
    datastream_link_id = 'datastream_link_id_example' # str | 

    try:
        api_response = api_instance.delete_a_datastream_link_object(datastream_link_id)
        print("The response of DatastreamLinksApi->delete_a_datastream_link_object:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DatastreamLinksApi->delete_a_datastream_link_object: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **datastream_link_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_involved_device_for_datastream_link**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_involved_device_for_datastream_link(involved_device_for_datastream_link_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DatastreamLinksApi(api_client)
    involved_device_for_datastream_link_id = 'involved_device_for_datastream_link_id_example' # str | 

    try:
        api_response = api_instance.delete_involved_device_for_datastream_link(involved_device_for_datastream_link_id)
        print("The response of DatastreamLinksApi->delete_involved_device_for_datastream_link:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DatastreamLinksApi->delete_involved_device_for_datastream_link: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **involved_device_for_datastream_link_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_involved_device_for_datastream_link_instance**
> CreateInvolvedDeviceForDatastreamLink201Response retrieve_involved_device_for_datastream_link_instance(involved_device_for_datastream_link_id, include=include)

Retrieve a single involved device for a datastream link

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_involved_device_for_datastream_link201_response import CreateInvolvedDeviceForDatastreamLink201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DatastreamLinksApi(api_client)
    involved_device_for_datastream_link_id = 'involved_device_for_datastream_link_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_involved_device_for_datastream_link_instance(involved_device_for_datastream_link_id, include=include)
        print("The response of DatastreamLinksApi->retrieve_involved_device_for_datastream_link_instance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DatastreamLinksApi->retrieve_involved_device_for_datastream_link_instance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **involved_device_for_datastream_link_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateInvolvedDeviceForDatastreamLink201Response**](CreateInvolvedDeviceForDatastreamLink201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of an involved device for datastream link |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_datastream_link_objects**
> RetrieveacollectionofDatastreamLinkObjects200Response retrieveacollectionof_datastream_link_objects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_begin_date=filter_begin_date, filter_end_date=filter_end_date, filter_datasource_id=filter_datasource_id, filter_datasource_name=filter_datasource_name, filter_thing_id=filter_thing_id, filter_thing_name=filter_thing_name, filter_datastream_id=filter_datastream_id, filter_datastream_name=filter_datastream_name, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_license_uri=filter_license_uri, filter_license_name=filter_license_name, filter_aggregation_period=filter_aggregation_period, filter_label=filter_label, filter_tsm_endpoint_id=filter_tsm_endpoint_id, filter_device_property_id=filter_device_property_id, filter_device_mount_action_id=filter_device_mount_action_id, filter=filter)

Retrieve a collection of datastream link objects

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_datastream_link_objects200_response import RetrieveacollectionofDatastreamLinkObjects200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DatastreamLinksApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_begin_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_datasource_id = 'filter_datasource_id_example' # str |  (optional)
    filter_datasource_name = 'filter_datasource_name_example' # str |  (optional)
    filter_thing_id = 'filter_thing_id_example' # str |  (optional)
    filter_thing_name = 'filter_thing_name_example' # str |  (optional)
    filter_datastream_id = 'filter_datastream_id_example' # str |  (optional)
    filter_datastream_name = 'filter_datastream_name_example' # str |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_license_uri = 'filter_license_uri_example' # str |  (optional)
    filter_license_name = 'filter_license_name_example' # str |  (optional)
    filter_aggregation_period = 3.4 # float |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_tsm_endpoint_id = 'filter_tsm_endpoint_id_example' # str |  (optional)
    filter_device_property_id = 'filter_device_property_id_example' # str |  (optional)
    filter_device_mount_action_id = 'filter_device_mount_action_id_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.retrieveacollectionof_datastream_link_objects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_begin_date=filter_begin_date, filter_end_date=filter_end_date, filter_datasource_id=filter_datasource_id, filter_datasource_name=filter_datasource_name, filter_thing_id=filter_thing_id, filter_thing_name=filter_thing_name, filter_datastream_id=filter_datastream_id, filter_datastream_name=filter_datastream_name, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_license_uri=filter_license_uri, filter_license_name=filter_license_name, filter_aggregation_period=filter_aggregation_period, filter_label=filter_label, filter_tsm_endpoint_id=filter_tsm_endpoint_id, filter_device_property_id=filter_device_property_id, filter_device_mount_action_id=filter_device_mount_action_id, filter=filter)
        print("The response of DatastreamLinksApi->retrieveacollectionof_datastream_link_objects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DatastreamLinksApi->retrieveacollectionof_datastream_link_objects: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_begin_date** | **datetime**|  | [optional] 
 **filter_end_date** | **datetime**|  | [optional] 
 **filter_datasource_id** | **str**|  | [optional] 
 **filter_datasource_name** | **str**|  | [optional] 
 **filter_thing_id** | **str**|  | [optional] 
 **filter_thing_name** | **str**|  | [optional] 
 **filter_datastream_id** | **str**|  | [optional] 
 **filter_datastream_name** | **str**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_license_uri** | **str**|  | [optional] 
 **filter_license_name** | **str**|  | [optional] 
 **filter_aggregation_period** | **float**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_tsm_endpoint_id** | **str**|  | [optional] 
 **filter_device_property_id** | **str**|  | [optional] 
 **filter_device_mount_action_id** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**RetrieveacollectionofDatastreamLinkObjects200Response**](RetrieveacollectionofDatastreamLinkObjects200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of datastream links |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrievecollectionof_involved_devices_for_datastream_link_objects**
> RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200Response retrievecollectionof_involved_devices_for_datastream_link_objects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_order_index=filter_order_index, filter_device_id=filter_device_id, filter_datastream_link_id=filter_datastream_link_id)

Retrieve a list of involved devices for datastream links

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrievecollectionof_involved_devices_for_datastream_link_objects200_response import RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DatastreamLinksApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_order_index = 3.4 # float |  (optional)
    filter_device_id = 'filter_device_id_example' # str |  (optional)
    filter_datastream_link_id = 'filter_datastream_link_id_example' # str |  (optional)

    try:
        api_response = api_instance.retrievecollectionof_involved_devices_for_datastream_link_objects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_order_index=filter_order_index, filter_device_id=filter_device_id, filter_datastream_link_id=filter_datastream_link_id)
        print("The response of DatastreamLinksApi->retrievecollectionof_involved_devices_for_datastream_link_objects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DatastreamLinksApi->retrievecollectionof_involved_devices_for_datastream_link_objects: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_order_index** | **float**|  | [optional] 
 **filter_device_id** | **str**|  | [optional] 
 **filter_datastream_link_id** | **str**|  | [optional] 

### Return type

[**RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200Response**](RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of involved devices in datastream links |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveinstanceof_datastream_link_object**
> CreateDatastreamLink201Response retrieveinstanceof_datastream_link_object(datastream_link_id, include=include)

Retrieve a single datastream link object

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_datastream_link201_response import CreateDatastreamLink201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DatastreamLinksApi(api_client)
    datastream_link_id = 'datastream_link_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieveinstanceof_datastream_link_object(datastream_link_id, include=include)
        print("The response of DatastreamLinksApi->retrieveinstanceof_datastream_link_object:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DatastreamLinksApi->retrieveinstanceof_datastream_link_object: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **datastream_link_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateDatastreamLink201Response**](CreateDatastreamLink201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a datastream link |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_datastream_link_object**
> CreateDatastreamLink201Response update_datastream_link_object(datastream_link_id, update_datastream_link_object_request)

Update a datastream link object

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_datastream_link201_response import CreateDatastreamLink201Response
from openapi_client.models.update_datastream_link_object_request import UpdateDatastreamLinkObjectRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DatastreamLinksApi(api_client)
    datastream_link_id = 'datastream_link_id_example' # str | 
    update_datastream_link_object_request = openapi_client.UpdateDatastreamLinkObjectRequest() # UpdateDatastreamLinkObjectRequest | Datastream link attributes

    try:
        api_response = api_instance.update_datastream_link_object(datastream_link_id, update_datastream_link_object_request)
        print("The response of DatastreamLinksApi->update_datastream_link_object:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DatastreamLinksApi->update_datastream_link_object: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **datastream_link_id** | **str**|  | 
 **update_datastream_link_object_request** | [**UpdateDatastreamLinkObjectRequest**](UpdateDatastreamLinkObjectRequest.md)| Datastream link attributes | 

### Return type

[**CreateDatastreamLink201Response**](CreateDatastreamLink201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated datastream link |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_involved_device_for_datastream_link**
> CreateInvolvedDeviceForDatastreamLink201Response update_involved_device_for_datastream_link(involved_device_for_datastream_link_id, update_involved_device_for_datastream_link_request)

Update InvolvedDeviceForDatastreamLink attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_involved_device_for_datastream_link201_response import CreateInvolvedDeviceForDatastreamLink201Response
from openapi_client.models.update_involved_device_for_datastream_link_request import UpdateInvolvedDeviceForDatastreamLinkRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DatastreamLinksApi(api_client)
    involved_device_for_datastream_link_id = 'involved_device_for_datastream_link_id_example' # str | 
    update_involved_device_for_datastream_link_request = openapi_client.UpdateInvolvedDeviceForDatastreamLinkRequest() # UpdateInvolvedDeviceForDatastreamLinkRequest | InvolvedDeviceForDatastream attributes

    try:
        api_response = api_instance.update_involved_device_for_datastream_link(involved_device_for_datastream_link_id, update_involved_device_for_datastream_link_request)
        print("The response of DatastreamLinksApi->update_involved_device_for_datastream_link:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DatastreamLinksApi->update_involved_device_for_datastream_link: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **involved_device_for_datastream_link_id** | **str**|  | 
 **update_involved_device_for_datastream_link_request** | [**UpdateInvolvedDeviceForDatastreamLinkRequest**](UpdateInvolvedDeviceForDatastreamLinkRequest.md)| InvolvedDeviceForDatastream attributes | 

### Return type

[**CreateInvolvedDeviceForDatastreamLink201Response**](CreateInvolvedDeviceForDatastreamLink201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated involved device for datastream link |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

