# openapi_client.DeviceCalibrationActionsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**device_calibration_actions_device_calibration_action_id_delete**](DeviceCalibrationActionsApi.md#device_calibration_actions_device_calibration_action_id_delete) | **DELETE** /device-calibration-actions/{device_calibration_action_id} | 
[**device_calibration_actions_device_calibration_action_id_get**](DeviceCalibrationActionsApi.md#device_calibration_actions_device_calibration_action_id_get) | **GET** /device-calibration-actions/{device_calibration_action_id} | 
[**device_calibration_actions_device_calibration_action_id_patch**](DeviceCalibrationActionsApi.md#device_calibration_actions_device_calibration_action_id_patch) | **PATCH** /device-calibration-actions/{device_calibration_action_id} | 
[**device_calibration_actions_get**](DeviceCalibrationActionsApi.md#device_calibration_actions_get) | **GET** /device-calibration-actions | 
[**device_calibration_actions_post**](DeviceCalibrationActionsApi.md#device_calibration_actions_post) | **POST** /device-calibration-actions | 


# **device_calibration_actions_device_calibration_action_id_delete**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response device_calibration_actions_device_calibration_action_id_delete(device_calibration_action_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceCalibrationActionsApi(api_client)
    device_calibration_action_id = 'device_calibration_action_id_example' # str | 

    try:
        api_response = api_instance.device_calibration_actions_device_calibration_action_id_delete(device_calibration_action_id)
        print("The response of DeviceCalibrationActionsApi->device_calibration_actions_device_calibration_action_id_delete:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceCalibrationActionsApi->device_calibration_actions_device_calibration_action_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_calibration_action_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_calibration_actions_device_calibration_action_id_get**
> DeviceCalibrationActionsPost201Response device_calibration_actions_device_calibration_action_id_get(device_calibration_action_id, include=include)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.device_calibration_actions_post201_response import DeviceCalibrationActionsPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceCalibrationActionsApi(api_client)
    device_calibration_action_id = 'device_calibration_action_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.device_calibration_actions_device_calibration_action_id_get(device_calibration_action_id, include=include)
        print("The response of DeviceCalibrationActionsApi->device_calibration_actions_device_calibration_action_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceCalibrationActionsApi->device_calibration_actions_device_calibration_action_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_calibration_action_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**DeviceCalibrationActionsPost201Response**](DeviceCalibrationActionsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a device calibration action |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_calibration_actions_device_calibration_action_id_patch**
> DeviceCalibrationActionsPost201Response device_calibration_actions_device_calibration_action_id_patch(device_calibration_action_id, device_calibration_actions_device_calibration_action_id_patch_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.device_calibration_actions_device_calibration_action_id_patch_request import DeviceCalibrationActionsDeviceCalibrationActionIdPatchRequest
from openapi_client.models.device_calibration_actions_post201_response import DeviceCalibrationActionsPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceCalibrationActionsApi(api_client)
    device_calibration_action_id = 'device_calibration_action_id_example' # str | 
    device_calibration_actions_device_calibration_action_id_patch_request = openapi_client.DeviceCalibrationActionsDeviceCalibrationActionIdPatchRequest() # DeviceCalibrationActionsDeviceCalibrationActionIdPatchRequest | Device calibration action attributes

    try:
        api_response = api_instance.device_calibration_actions_device_calibration_action_id_patch(device_calibration_action_id, device_calibration_actions_device_calibration_action_id_patch_request)
        print("The response of DeviceCalibrationActionsApi->device_calibration_actions_device_calibration_action_id_patch:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceCalibrationActionsApi->device_calibration_actions_device_calibration_action_id_patch: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_calibration_action_id** | **str**|  | 
 **device_calibration_actions_device_calibration_action_id_patch_request** | [**DeviceCalibrationActionsDeviceCalibrationActionIdPatchRequest**](DeviceCalibrationActionsDeviceCalibrationActionIdPatchRequest.md)| Device calibration action attributes | 

### Return type

[**DeviceCalibrationActionsPost201Response**](DeviceCalibrationActionsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated device calibration action |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_calibration_actions_get**
> DeviceCalibrationActionsGet200Response device_calibration_actions_get(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_current_calibration_date=filter_current_calibration_date, filter_next_calibration_date=filter_next_calibration_date, filter_description=filter_description, filter_formula=filter_formula, filter_value=filter_value, filter_device_id=filter_device_id, filter=filter)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.device_calibration_actions_get200_response import DeviceCalibrationActionsGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceCalibrationActionsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_current_calibration_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_next_calibration_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_formula = 'filter_formula_example' # str |  (optional)
    filter_value = 3.4 # float |  (optional)
    filter_device_id = 'filter_device_id_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.device_calibration_actions_get(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_current_calibration_date=filter_current_calibration_date, filter_next_calibration_date=filter_next_calibration_date, filter_description=filter_description, filter_formula=filter_formula, filter_value=filter_value, filter_device_id=filter_device_id, filter=filter)
        print("The response of DeviceCalibrationActionsApi->device_calibration_actions_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceCalibrationActionsApi->device_calibration_actions_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_current_calibration_date** | **datetime**|  | [optional] 
 **filter_next_calibration_date** | **datetime**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_formula** | **str**|  | [optional] 
 **filter_value** | **float**|  | [optional] 
 **filter_device_id** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**DeviceCalibrationActionsGet200Response**](DeviceCalibrationActionsGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of device calibrations |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_calibration_actions_post**
> DeviceCalibrationActionsPost201Response device_calibration_actions_post(device_calibration_actions_post_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.device_calibration_actions_post201_response import DeviceCalibrationActionsPost201Response
from openapi_client.models.device_calibration_actions_post_request import DeviceCalibrationActionsPostRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceCalibrationActionsApi(api_client)
    device_calibration_actions_post_request = openapi_client.DeviceCalibrationActionsPostRequest() # DeviceCalibrationActionsPostRequest | 

    try:
        api_response = api_instance.device_calibration_actions_post(device_calibration_actions_post_request)
        print("The response of DeviceCalibrationActionsApi->device_calibration_actions_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceCalibrationActionsApi->device_calibration_actions_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_calibration_actions_post_request** | [**DeviceCalibrationActionsPostRequest**](DeviceCalibrationActionsPostRequest.md)|  | 

### Return type

[**DeviceCalibrationActionsPost201Response**](DeviceCalibrationActionsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created device calibration action |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

