# openapi_client.DeviceImagesApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_device_image**](DeviceImagesApi.md#create_device_image) | **POST** /device-images | 
[**delete_device_image**](DeviceImagesApi.md#delete_device_image) | **DELETE** /device-images/{device_image_id} | 
[**retrieve_device_image_instance**](DeviceImagesApi.md#retrieve_device_image_instance) | **GET** /device-images/{device_image_id} | 
[**retrievecollectionof_device_imageobjects**](DeviceImagesApi.md#retrievecollectionof_device_imageobjects) | **GET** /device-images | 
[**update_device_image**](DeviceImagesApi.md#update_device_image) | **PATCH** /device-images/{device_image_id} | 


# **create_device_image**
> CreateDeviceImage201Response create_device_image(create_device_image_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_device_image201_response import CreateDeviceImage201Response
from openapi_client.models.create_device_image_request import CreateDeviceImageRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceImagesApi(api_client)
    create_device_image_request = openapi_client.CreateDeviceImageRequest() # CreateDeviceImageRequest | 

    try:
        api_response = api_instance.create_device_image(create_device_image_request)
        print("The response of DeviceImagesApi->create_device_image:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceImagesApi->create_device_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_device_image_request** | [**CreateDeviceImageRequest**](CreateDeviceImageRequest.md)|  | 

### Return type

[**CreateDeviceImage201Response**](CreateDeviceImage201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created device image |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_device_image**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_device_image(device_image_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceImagesApi(api_client)
    device_image_id = 'device_image_id_example' # str | 

    try:
        api_response = api_instance.delete_device_image(device_image_id)
        print("The response of DeviceImagesApi->delete_device_image:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceImagesApi->delete_device_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_image_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_device_image_instance**
> CreateDeviceImage201Response retrieve_device_image_instance(device_image_id, include=include)

Retrieve a single device image

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_device_image201_response import CreateDeviceImage201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceImagesApi(api_client)
    device_image_id = 'device_image_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_device_image_instance(device_image_id, include=include)
        print("The response of DeviceImagesApi->retrieve_device_image_instance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceImagesApi->retrieve_device_image_instance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_image_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateDeviceImage201Response**](CreateDeviceImage201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a device image |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrievecollectionof_device_imageobjects**
> RetrievecollectionofDeviceImageobjects200Response retrievecollectionof_device_imageobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_order_index=filter_order_index, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_device_id=filter_device_id, filter_attachment_id=filter_attachment_id)

Retrieve a list of device images

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrievecollectionof_device_imageobjects200_response import RetrievecollectionofDeviceImageobjects200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceImagesApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_order_index = 3.4 # float |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_device_id = 'filter_device_id_example' # str |  (optional)
    filter_attachment_id = 'filter_attachment_id_example' # str |  (optional)

    try:
        api_response = api_instance.retrievecollectionof_device_imageobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_order_index=filter_order_index, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_device_id=filter_device_id, filter_attachment_id=filter_attachment_id)
        print("The response of DeviceImagesApi->retrievecollectionof_device_imageobjects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceImagesApi->retrievecollectionof_device_imageobjects: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_order_index** | **float**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_device_id** | **str**|  | [optional] 
 **filter_attachment_id** | **str**|  | [optional] 

### Return type

[**RetrievecollectionofDeviceImageobjects200Response**](RetrievecollectionofDeviceImageobjects200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of device images |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_device_image**
> CreateDeviceImage201Response update_device_image(device_image_id, update_device_image_request)

Update DeviceImage attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_device_image201_response import CreateDeviceImage201Response
from openapi_client.models.update_device_image_request import UpdateDeviceImageRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceImagesApi(api_client)
    device_image_id = 'device_image_id_example' # str | 
    update_device_image_request = openapi_client.UpdateDeviceImageRequest() # UpdateDeviceImageRequest | DeviceImage attributes

    try:
        api_response = api_instance.update_device_image(device_image_id, update_device_image_request)
        print("The response of DeviceImagesApi->update_device_image:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceImagesApi->update_device_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_image_id** | **str**|  | 
 **update_device_image_request** | [**UpdateDeviceImageRequest**](UpdateDeviceImageRequest.md)| DeviceImage attributes | 

### Return type

[**CreateDeviceImage201Response**](CreateDeviceImage201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated device image |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

