# openapi_client.DeviceParametersApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_device_parameter**](DeviceParametersApi.md#create_device_parameter) | **POST** /device-parameters | 
[**delete_device_parameter**](DeviceParametersApi.md#delete_device_parameter) | **DELETE** /device-parameters/{device_parameter_id} | 
[**retriececollectionof_device_parameterobjects**](DeviceParametersApi.md#retriececollectionof_device_parameterobjects) | **GET** /device-parameters | 
[**retrieve_device_parameterinstance**](DeviceParametersApi.md#retrieve_device_parameterinstance) | **GET** /device-parameters/{device_parameter_id} | 
[**update_device_parameter**](DeviceParametersApi.md#update_device_parameter) | **PATCH** /device-parameters/{device_parameter_id} | 


# **create_device_parameter**
> CreateDeviceParameter201Response create_device_parameter(create_device_parameter_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_device_parameter201_response import CreateDeviceParameter201Response
from openapi_client.models.create_device_parameter_request import CreateDeviceParameterRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceParametersApi(api_client)
    create_device_parameter_request = openapi_client.CreateDeviceParameterRequest() # CreateDeviceParameterRequest | 

    try:
        api_response = api_instance.create_device_parameter(create_device_parameter_request)
        print("The response of DeviceParametersApi->create_device_parameter:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceParametersApi->create_device_parameter: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_device_parameter_request** | [**CreateDeviceParameterRequest**](CreateDeviceParameterRequest.md)|  | 

### Return type

[**CreateDeviceParameter201Response**](CreateDeviceParameter201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created device parameter |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_device_parameter**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_device_parameter(device_parameter_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceParametersApi(api_client)
    device_parameter_id = 'device_parameter_id_example' # str | 

    try:
        api_response = api_instance.delete_device_parameter(device_parameter_id)
        print("The response of DeviceParametersApi->delete_device_parameter:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceParametersApi->delete_device_parameter: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_parameter_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retriececollectionof_device_parameterobjects**
> RetriececollectionofDeviceParameterobjects200Response retriececollectionof_device_parameterobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_label=filter_label, filter_description=filter_description, filter_unit_uri=filter_unit_uri, filter_unit_name=filter_unit_name, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_device_id=filter_device_id)

Retrieve the list of device parameters

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retriececollectionof_device_parameterobjects200_response import RetriececollectionofDeviceParameterobjects200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceParametersApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_unit_uri = 'filter_unit_uri_example' # str |  (optional)
    filter_unit_name = 'filter_unit_name_example' # str |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_device_id = 'filter_device_id_example' # str |  (optional)

    try:
        api_response = api_instance.retriececollectionof_device_parameterobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_label=filter_label, filter_description=filter_description, filter_unit_uri=filter_unit_uri, filter_unit_name=filter_unit_name, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_device_id=filter_device_id)
        print("The response of DeviceParametersApi->retriececollectionof_device_parameterobjects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceParametersApi->retriececollectionof_device_parameterobjects: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_unit_uri** | **str**|  | [optional] 
 **filter_unit_name** | **str**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_device_id** | **str**|  | [optional] 

### Return type

[**RetriececollectionofDeviceParameterobjects200Response**](RetriececollectionofDeviceParameterobjects200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of device parameters |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_device_parameterinstance**
> CreateDeviceParameter201Response retrieve_device_parameterinstance(device_parameter_id, include=include)

Retrieve a single device parameter

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_device_parameter201_response import CreateDeviceParameter201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceParametersApi(api_client)
    device_parameter_id = 'device_parameter_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_device_parameterinstance(device_parameter_id, include=include)
        print("The response of DeviceParametersApi->retrieve_device_parameterinstance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceParametersApi->retrieve_device_parameterinstance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_parameter_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateDeviceParameter201Response**](CreateDeviceParameter201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a device parameter |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_device_parameter**
> CreateDeviceParameter201Response update_device_parameter(device_parameter_id, update_device_parameter_request)

Update DeviceParameter attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_device_parameter201_response import CreateDeviceParameter201Response
from openapi_client.models.update_device_parameter_request import UpdateDeviceParameterRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DeviceParametersApi(api_client)
    device_parameter_id = 'device_parameter_id_example' # str | 
    update_device_parameter_request = openapi_client.UpdateDeviceParameterRequest() # UpdateDeviceParameterRequest | DeviceParameter attributes

    try:
        api_response = api_instance.update_device_parameter(device_parameter_id, update_device_parameter_request)
        print("The response of DeviceParametersApi->update_device_parameter:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DeviceParametersApi->update_device_parameter: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_parameter_id** | **str**|  | 
 **update_device_parameter_request** | [**UpdateDeviceParameterRequest**](UpdateDeviceParameterRequest.md)| DeviceParameter attributes | 

### Return type

[**CreateDeviceParameter201Response**](CreateDeviceParameter201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated device parameter |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

