# openapi_client.DevicePropertiesApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_device_property0**](DevicePropertiesApi.md#create_device_property0) | **POST** /device-properties | 
[**delete_device_propertyfromdeviceproperty1**](DevicePropertiesApi.md#delete_device_propertyfromdeviceproperty1) | **DELETE** /device-properties/{device_property_id} | 
[**retrieve_device_propertyinstance0**](DevicePropertiesApi.md#retrieve_device_propertyinstance0) | **GET** /device-properties/{device_property_id} | 
[**retrieveacollectionof_device_propertyobjects0**](DevicePropertiesApi.md#retrieveacollectionof_device_propertyobjects0) | **GET** /device-properties | 
[**update_device_property0**](DevicePropertiesApi.md#update_device_property0) | **PATCH** /device-properties/{device_property_id} | 


# **create_device_property0**
> CreateDeviceProperty0201Response create_device_property0(create_device_property0_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_device_property0201_response import CreateDeviceProperty0201Response
from openapi_client.models.create_device_property0_request import CreateDeviceProperty0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicePropertiesApi(api_client)
    create_device_property0_request = openapi_client.CreateDeviceProperty0Request() # CreateDeviceProperty0Request | 

    try:
        api_response = api_instance.create_device_property0(create_device_property0_request)
        print("The response of DevicePropertiesApi->create_device_property0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicePropertiesApi->create_device_property0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_device_property0_request** | [**CreateDeviceProperty0Request**](CreateDeviceProperty0Request.md)|  | 

### Return type

[**CreateDeviceProperty0201Response**](CreateDeviceProperty0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created device property |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_device_propertyfromdeviceproperty1**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_device_propertyfromdeviceproperty1(device_property_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicePropertiesApi(api_client)
    device_property_id = 'device_property_id_example' # str | 

    try:
        api_response = api_instance.delete_device_propertyfromdeviceproperty1(device_property_id)
        print("The response of DevicePropertiesApi->delete_device_propertyfromdeviceproperty1:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicePropertiesApi->delete_device_propertyfromdeviceproperty1: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_property_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_device_propertyinstance0**
> CreateDeviceProperty0201Response retrieve_device_propertyinstance0(device_property_id, include=include)

Retrieve DeviceProperty from device_property

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_device_property0201_response import CreateDeviceProperty0201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicePropertiesApi(api_client)
    device_property_id = 'device_property_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_device_propertyinstance0(device_property_id, include=include)
        print("The response of DevicePropertiesApi->retrieve_device_propertyinstance0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicePropertiesApi->retrieve_device_propertyinstance0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_property_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateDeviceProperty0201Response**](CreateDeviceProperty0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of device property |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_device_propertyobjects0**
> RetrieveacollectionofDevicePropertyobjects0200Response retrieveacollectionof_device_propertyobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_measuring_range_min=filter_measuring_range_min, filter_measuring_range_max=filter_measuring_range_max, filter_failure_value=filter_failure_value, filter_accuracy=filter_accuracy, filter_label=filter_label, filter_accuracy_unit_uri=filter_accuracy_unit_uri, filter_accuracy_unit_name=filter_accuracy_unit_name, filter_unit_uri=filter_unit_uri, filter_unit_name=filter_unit_name, filter_compartment_uri=filter_compartment_uri, filter_compartment_name=filter_compartment_name, filter_property_uri=filter_property_uri, filter_property_name=filter_property_name, filter_sampling_media_uri=filter_sampling_media_uri, filter_sampling_media_name=filter_sampling_media_name, filter_resolution=filter_resolution, filter_resolution_unit_uri=filter_resolution_unit_uri, filter_resolution_unit_name=filter_resolution_unit_name, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_aggregation_type_uri=filter_aggregation_type_uri, filter_aggregation_type_name=filter_aggregation_type_name, filter_description=filter_description, filter_device_id=filter_device_id, filter=filter)

Retrieve DeviceProperty from device_property

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_device_propertyobjects0200_response import RetrieveacollectionofDevicePropertyobjects0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicePropertiesApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_measuring_range_min = 3.4 # float |  (optional)
    filter_measuring_range_max = 3.4 # float |  (optional)
    filter_failure_value = 3.4 # float |  (optional)
    filter_accuracy = 3.4 # float |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_accuracy_unit_uri = 'filter_accuracy_unit_uri_example' # str |  (optional)
    filter_accuracy_unit_name = 'filter_accuracy_unit_name_example' # str |  (optional)
    filter_unit_uri = 'filter_unit_uri_example' # str |  (optional)
    filter_unit_name = 'filter_unit_name_example' # str |  (optional)
    filter_compartment_uri = 'filter_compartment_uri_example' # str |  (optional)
    filter_compartment_name = 'filter_compartment_name_example' # str |  (optional)
    filter_property_uri = 'filter_property_uri_example' # str |  (optional)
    filter_property_name = 'filter_property_name_example' # str |  (optional)
    filter_sampling_media_uri = 'filter_sampling_media_uri_example' # str |  (optional)
    filter_sampling_media_name = 'filter_sampling_media_name_example' # str |  (optional)
    filter_resolution = 3.4 # float |  (optional)
    filter_resolution_unit_uri = 'filter_resolution_unit_uri_example' # str |  (optional)
    filter_resolution_unit_name = 'filter_resolution_unit_name_example' # str |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_aggregation_type_uri = 'filter_aggregation_type_uri_example' # str |  (optional)
    filter_aggregation_type_name = 'filter_aggregation_type_name_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_device_id = 'filter_device_id_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.retrieveacollectionof_device_propertyobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_measuring_range_min=filter_measuring_range_min, filter_measuring_range_max=filter_measuring_range_max, filter_failure_value=filter_failure_value, filter_accuracy=filter_accuracy, filter_label=filter_label, filter_accuracy_unit_uri=filter_accuracy_unit_uri, filter_accuracy_unit_name=filter_accuracy_unit_name, filter_unit_uri=filter_unit_uri, filter_unit_name=filter_unit_name, filter_compartment_uri=filter_compartment_uri, filter_compartment_name=filter_compartment_name, filter_property_uri=filter_property_uri, filter_property_name=filter_property_name, filter_sampling_media_uri=filter_sampling_media_uri, filter_sampling_media_name=filter_sampling_media_name, filter_resolution=filter_resolution, filter_resolution_unit_uri=filter_resolution_unit_uri, filter_resolution_unit_name=filter_resolution_unit_name, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_aggregation_type_uri=filter_aggregation_type_uri, filter_aggregation_type_name=filter_aggregation_type_name, filter_description=filter_description, filter_device_id=filter_device_id, filter=filter)
        print("The response of DevicePropertiesApi->retrieveacollectionof_device_propertyobjects0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicePropertiesApi->retrieveacollectionof_device_propertyobjects0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_measuring_range_min** | **float**|  | [optional] 
 **filter_measuring_range_max** | **float**|  | [optional] 
 **filter_failure_value** | **float**|  | [optional] 
 **filter_accuracy** | **float**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_accuracy_unit_uri** | **str**|  | [optional] 
 **filter_accuracy_unit_name** | **str**|  | [optional] 
 **filter_unit_uri** | **str**|  | [optional] 
 **filter_unit_name** | **str**|  | [optional] 
 **filter_compartment_uri** | **str**|  | [optional] 
 **filter_compartment_name** | **str**|  | [optional] 
 **filter_property_uri** | **str**|  | [optional] 
 **filter_property_name** | **str**|  | [optional] 
 **filter_sampling_media_uri** | **str**|  | [optional] 
 **filter_sampling_media_name** | **str**|  | [optional] 
 **filter_resolution** | **float**|  | [optional] 
 **filter_resolution_unit_uri** | **str**|  | [optional] 
 **filter_resolution_unit_name** | **str**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_aggregation_type_uri** | **str**|  | [optional] 
 **filter_aggregation_type_name** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_device_id** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**RetrieveacollectionofDevicePropertyobjects0200Response**](RetrieveacollectionofDevicePropertyobjects0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of device properties |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_device_property0**
> CreateDeviceProperty0201Response update_device_property0(device_property_id, update_device_property0_request)

Update DeviceProperty attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_device_property0201_response import CreateDeviceProperty0201Response
from openapi_client.models.update_device_property0_request import UpdateDeviceProperty0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicePropertiesApi(api_client)
    device_property_id = 'device_property_id_example' # str | 
    update_device_property0_request = openapi_client.UpdateDeviceProperty0Request() # UpdateDeviceProperty0Request | DeviceProperty attributes

    try:
        api_response = api_instance.update_device_property0(device_property_id, update_device_property0_request)
        print("The response of DevicePropertiesApi->update_device_property0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicePropertiesApi->update_device_property0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_property_id** | **str**|  | 
 **update_device_property0_request** | [**UpdateDeviceProperty0Request**](UpdateDeviceProperty0Request.md)| DeviceProperty attributes | 

### Return type

[**CreateDeviceProperty0201Response**](CreateDeviceProperty0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated device property |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

