# openapi_client.DevicePropertyCalibrationsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**device_property_calibrations_device_property_calibration_id_delete**](DevicePropertyCalibrationsApi.md#device_property_calibrations_device_property_calibration_id_delete) | **DELETE** /device-property-calibrations/{device_property_calibration_id} | 
[**device_property_calibrations_device_property_calibration_id_get**](DevicePropertyCalibrationsApi.md#device_property_calibrations_device_property_calibration_id_get) | **GET** /device-property-calibrations/{device_property_calibration_id} | 
[**device_property_calibrations_device_property_calibration_id_patch**](DevicePropertyCalibrationsApi.md#device_property_calibrations_device_property_calibration_id_patch) | **PATCH** /device-property-calibrations/{device_property_calibration_id} | 
[**device_property_calibrations_get**](DevicePropertyCalibrationsApi.md#device_property_calibrations_get) | **GET** /device-property-calibrations | 
[**device_property_calibrations_post**](DevicePropertyCalibrationsApi.md#device_property_calibrations_post) | **POST** /device-property-calibrations | 


# **device_property_calibrations_device_property_calibration_id_delete**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response device_property_calibrations_device_property_calibration_id_delete(device_property_calibration_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicePropertyCalibrationsApi(api_client)
    device_property_calibration_id = 'device_property_calibration_id_example' # str | 

    try:
        api_response = api_instance.device_property_calibrations_device_property_calibration_id_delete(device_property_calibration_id)
        print("The response of DevicePropertyCalibrationsApi->device_property_calibrations_device_property_calibration_id_delete:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicePropertyCalibrationsApi->device_property_calibrations_device_property_calibration_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_property_calibration_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_property_calibrations_device_property_calibration_id_get**
> DevicePropertyCalibrationsPost201Response device_property_calibrations_device_property_calibration_id_get(device_property_calibration_id, include=include)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.device_property_calibrations_post201_response import DevicePropertyCalibrationsPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicePropertyCalibrationsApi(api_client)
    device_property_calibration_id = 'device_property_calibration_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.device_property_calibrations_device_property_calibration_id_get(device_property_calibration_id, include=include)
        print("The response of DevicePropertyCalibrationsApi->device_property_calibrations_device_property_calibration_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicePropertyCalibrationsApi->device_property_calibrations_device_property_calibration_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_property_calibration_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**DevicePropertyCalibrationsPost201Response**](DevicePropertyCalibrationsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a device property calibration |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_property_calibrations_device_property_calibration_id_patch**
> DevicePropertyCalibrationsPost201Response device_property_calibrations_device_property_calibration_id_patch(device_property_calibration_id, device_property_calibrations_device_property_calibration_id_patch_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.device_property_calibrations_device_property_calibration_id_patch_request import DevicePropertyCalibrationsDevicePropertyCalibrationIdPatchRequest
from openapi_client.models.device_property_calibrations_post201_response import DevicePropertyCalibrationsPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicePropertyCalibrationsApi(api_client)
    device_property_calibration_id = 'device_property_calibration_id_example' # str | 
    device_property_calibrations_device_property_calibration_id_patch_request = openapi_client.DevicePropertyCalibrationsDevicePropertyCalibrationIdPatchRequest() # DevicePropertyCalibrationsDevicePropertyCalibrationIdPatchRequest | Device property calibration attributes

    try:
        api_response = api_instance.device_property_calibrations_device_property_calibration_id_patch(device_property_calibration_id, device_property_calibrations_device_property_calibration_id_patch_request)
        print("The response of DevicePropertyCalibrationsApi->device_property_calibrations_device_property_calibration_id_patch:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicePropertyCalibrationsApi->device_property_calibrations_device_property_calibration_id_patch: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_property_calibration_id** | **str**|  | 
 **device_property_calibrations_device_property_calibration_id_patch_request** | [**DevicePropertyCalibrationsDevicePropertyCalibrationIdPatchRequest**](DevicePropertyCalibrationsDevicePropertyCalibrationIdPatchRequest.md)| Device property calibration attributes | 

### Return type

[**DevicePropertyCalibrationsPost201Response**](DevicePropertyCalibrationsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated device property calibration |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_property_calibrations_get**
> DevicePropertyCalibrationsGet200Response device_property_calibrations_get(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_device_property_id=filter_device_property_id, filter_calibration_action_id=filter_calibration_action_id, filter=filter)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.device_property_calibrations_get200_response import DevicePropertyCalibrationsGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicePropertyCalibrationsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_device_property_id = 'filter_device_property_id_example' # str |  (optional)
    filter_calibration_action_id = 'filter_calibration_action_id_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.device_property_calibrations_get(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_device_property_id=filter_device_property_id, filter_calibration_action_id=filter_calibration_action_id, filter=filter)
        print("The response of DevicePropertyCalibrationsApi->device_property_calibrations_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicePropertyCalibrationsApi->device_property_calibrations_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_device_property_id** | **str**|  | [optional] 
 **filter_calibration_action_id** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**DevicePropertyCalibrationsGet200Response**](DevicePropertyCalibrationsGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of device property calibrations |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **device_property_calibrations_post**
> DevicePropertyCalibrationsPost201Response device_property_calibrations_post(device_property_calibrations_post_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.device_property_calibrations_post201_response import DevicePropertyCalibrationsPost201Response
from openapi_client.models.device_property_calibrations_post_request import DevicePropertyCalibrationsPostRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicePropertyCalibrationsApi(api_client)
    device_property_calibrations_post_request = openapi_client.DevicePropertyCalibrationsPostRequest() # DevicePropertyCalibrationsPostRequest | 

    try:
        api_response = api_instance.device_property_calibrations_post(device_property_calibrations_post_request)
        print("The response of DevicePropertyCalibrationsApi->device_property_calibrations_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicePropertyCalibrationsApi->device_property_calibrations_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_property_calibrations_post_request** | [**DevicePropertyCalibrationsPostRequest**](DevicePropertyCalibrationsPostRequest.md)|  | 

### Return type

[**DevicePropertyCalibrationsPost201Response**](DevicePropertyCalibrationsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created device property calibration |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

