# openapi_client.DevicesApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**archive_device**](DevicesApi.md#archive_device) | **POST** /devices/{device_id}/archive | 
[**create_device0**](DevicesApi.md#create_device0) | **POST** /devices | 
[**delete_devicefromdevice3**](DevicesApi.md#delete_devicefromdevice3) | **DELETE** /devices/{device_id} | 
[**restore_device**](DevicesApi.md#restore_device) | **POST** /devices/{device_id}/restore | 
[**retrieve_device_sensor_ml**](DevicesApi.md#retrieve_device_sensor_ml) | **GET** /devices/{device_id}/sensorml | 
[**retrieve_deviceinstance0**](DevicesApi.md#retrieve_deviceinstance0) | **GET** /devices/{device_id} | 
[**retrieveacollectionof_deviceobjects0**](DevicesApi.md#retrieveacollectionof_deviceobjects0) | **GET** /devices | 
[**update_device0**](DevicesApi.md#update_device0) | **PATCH** /devices/{device_id} | 


# **archive_device**
> archive_device(device_id)

Archive a device.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicesApi(api_client)
    device_id = '0' # str |  (default to '0')

    try:
        api_instance.archive_device(device_id)
    except Exception as e:
        print("Exception when calling DevicesApi->archive_device: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_id** | **str**|  | [default to &#39;0&#39;]

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Device was archived succesfully. |  -  |
**401** | Authentification required. |  -  |
**403** | 403 Error |  -  |
**404** |  |  -  |
**409** | Conflict on performing the operation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_device0**
> CreateDevice0201Response create_device0(create_device0_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_device0201_response import CreateDevice0201Response
from openapi_client.models.create_device0_request import CreateDevice0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicesApi(api_client)
    create_device0_request = openapi_client.CreateDevice0Request() # CreateDevice0Request | 

    try:
        api_response = api_instance.create_device0(create_device0_request)
        print("The response of DevicesApi->create_device0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicesApi->create_device0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_device0_request** | [**CreateDevice0Request**](CreateDevice0Request.md)|  | 

### Return type

[**CreateDevice0201Response**](CreateDevice0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created device |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_devicefromdevice3**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_devicefromdevice3(device_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicesApi(api_client)
    device_id = '0' # str |  (default to '0')

    try:
        api_response = api_instance.delete_devicefromdevice3(device_id)
        print("The response of DevicesApi->delete_devicefromdevice3:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicesApi->delete_devicefromdevice3: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_id** | **str**|  | [default to &#39;0&#39;]

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **restore_device**
> restore_device(device_id)

Restore an archived device.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicesApi(api_client)
    device_id = '0' # str |  (default to '0')

    try:
        api_instance.restore_device(device_id)
    except Exception as e:
        print("Exception when calling DevicesApi->restore_device: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_id** | **str**|  | [default to &#39;0&#39;]

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Restoring of the device was succesful. |  -  |
**401** | Authentification required. |  -  |
**403** | 403 Error |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_device_sensor_ml**
> retrieve_device_sensor_ml(device_id)

Retrieve Device sensorML

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicesApi(api_client)
    device_id = '0' # str |  (default to '0')

    try:
        api_instance.retrieve_device_sensor_ml(device_id)
    except Exception as e:
        print("Exception when calling DevicesApi->retrieve_device_sensor_ml: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_id** | **str**|  | [default to &#39;0&#39;]

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/xml, application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | SensorML response for the device |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_deviceinstance0**
> CreateDevice0201Response retrieve_deviceinstance0(device_id, include=include)

Retrieve Device from device

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_device0201_response import CreateDevice0201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicesApi(api_client)
    device_id = '0' # str |  (default to '0')
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_deviceinstance0(device_id, include=include)
        print("The response of DevicesApi->retrieve_deviceinstance0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicesApi->retrieve_deviceinstance0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_id** | **str**|  | [default to &#39;0&#39;]
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateDevice0201Response**](CreateDevice0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api.json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a device |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_deviceobjects0**
> RetrieveacollectionofDeviceobjects0200Response retrieveacollectionof_deviceobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_description=filter_description, filter_short_name=filter_short_name, filter_long_name=filter_long_name, filter_serial_number=filter_serial_number, filter_manufacturer_uri=filter_manufacturer_uri, filter_manufacturer_name=filter_manufacturer_name, filter_device_type_uri=filter_device_type_uri, filter_device_type_name=filter_device_type_name, filter_status_uri=filter_status_uri, filter_status_name=filter_status_name, filter_model=filter_model, filter_inventory_number=filter_inventory_number, filter_persistent_identifier=filter_persistent_identifier, filter_schema_version=filter_schema_version, filter_identifier_type=filter_identifier_type, filter_website=filter_website, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_is_private=filter_is_private, filter_is_internal=filter_is_internal, filter_is_public=filter_is_public, filter_archived=filter_archived, filter_update_description=filter_update_description, filter_country=filter_country, filter=filter, hide_archived=hide_archived)

Retrieve Device from device

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_deviceobjects0200_response import RetrieveacollectionofDeviceobjects0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicesApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_short_name = 'filter_short_name_example' # str |  (optional)
    filter_long_name = 'filter_long_name_example' # str |  (optional)
    filter_serial_number = 'filter_serial_number_example' # str |  (optional)
    filter_manufacturer_uri = 'filter_manufacturer_uri_example' # str |  (optional)
    filter_manufacturer_name = 'filter_manufacturer_name_example' # str |  (optional)
    filter_device_type_uri = 'filter_device_type_uri_example' # str |  (optional)
    filter_device_type_name = 'filter_device_type_name_example' # str |  (optional)
    filter_status_uri = 'filter_status_uri_example' # str |  (optional)
    filter_status_name = 'filter_status_name_example' # str |  (optional)
    filter_model = 'filter_model_example' # str |  (optional)
    filter_inventory_number = 'filter_inventory_number_example' # str |  (optional)
    filter_persistent_identifier = 'filter_persistent_identifier_example' # str |  (optional)
    filter_schema_version = 'filter_schema_version_example' # str |  (optional)
    filter_identifier_type = 'filter_identifier_type_example' # str |  (optional)
    filter_website = 'filter_website_example' # str |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_is_private = True # bool |  (optional)
    filter_is_internal = True # bool |  (optional)
    filter_is_public = True # bool |  (optional)
    filter_archived = True # bool |  (optional)
    filter_update_description = 'filter_update_description_example' # str |  (optional)
    filter_country = 'filter_country_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)
    hide_archived = True # bool | In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones. (optional) (default to True)

    try:
        api_response = api_instance.retrieveacollectionof_deviceobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_description=filter_description, filter_short_name=filter_short_name, filter_long_name=filter_long_name, filter_serial_number=filter_serial_number, filter_manufacturer_uri=filter_manufacturer_uri, filter_manufacturer_name=filter_manufacturer_name, filter_device_type_uri=filter_device_type_uri, filter_device_type_name=filter_device_type_name, filter_status_uri=filter_status_uri, filter_status_name=filter_status_name, filter_model=filter_model, filter_inventory_number=filter_inventory_number, filter_persistent_identifier=filter_persistent_identifier, filter_schema_version=filter_schema_version, filter_identifier_type=filter_identifier_type, filter_website=filter_website, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_is_private=filter_is_private, filter_is_internal=filter_is_internal, filter_is_public=filter_is_public, filter_archived=filter_archived, filter_update_description=filter_update_description, filter_country=filter_country, filter=filter, hide_archived=hide_archived)
        print("The response of DevicesApi->retrieveacollectionof_deviceobjects0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicesApi->retrieveacollectionof_deviceobjects0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_short_name** | **str**|  | [optional] 
 **filter_long_name** | **str**|  | [optional] 
 **filter_serial_number** | **str**|  | [optional] 
 **filter_manufacturer_uri** | **str**|  | [optional] 
 **filter_manufacturer_name** | **str**|  | [optional] 
 **filter_device_type_uri** | **str**|  | [optional] 
 **filter_device_type_name** | **str**|  | [optional] 
 **filter_status_uri** | **str**|  | [optional] 
 **filter_status_name** | **str**|  | [optional] 
 **filter_model** | **str**|  | [optional] 
 **filter_inventory_number** | **str**|  | [optional] 
 **filter_persistent_identifier** | **str**|  | [optional] 
 **filter_schema_version** | **str**|  | [optional] 
 **filter_identifier_type** | **str**|  | [optional] 
 **filter_website** | **str**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_is_private** | **bool**|  | [optional] 
 **filter_is_internal** | **bool**|  | [optional] 
 **filter_is_public** | **bool**|  | [optional] 
 **filter_archived** | **bool**|  | [optional] 
 **filter_update_description** | **str**|  | [optional] 
 **filter_country** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 
 **hide_archived** | **bool**| In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones. | [optional] [default to True]

### Return type

[**RetrieveacollectionofDeviceobjects0200Response**](RetrieveacollectionofDeviceobjects0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of devices |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_device0**
> CreateDevice0201Response update_device0(device_id, update_device0_request)

Update Device attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_device0201_response import CreateDevice0201Response
from openapi_client.models.update_device0_request import UpdateDevice0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DevicesApi(api_client)
    device_id = '0' # str |  (default to '0')
    update_device0_request = openapi_client.UpdateDevice0Request() # UpdateDevice0Request | Device attributes

    try:
        api_response = api_instance.update_device0(device_id, update_device0_request)
        print("The response of DevicesApi->update_device0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DevicesApi->update_device0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_id** | **str**|  | [default to &#39;0&#39;]
 **update_device0_request** | [**UpdateDevice0Request**](UpdateDevice0Request.md)| Device attributes | 

### Return type

[**CreateDevice0201Response**](CreateDevice0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated device |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

